/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Enumeration;
import java.util.List;
import org.mortbay.http.EOFException;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpInputStream;
import org.mortbay.http.HttpListener;
import org.mortbay.http.HttpOutputStream;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.HttpServer;
import org.mortbay.http.HttpTunnel;
import org.mortbay.http.Version;
import org.mortbay.util.Code;
import org.mortbay.util.LineInput;
import org.mortbay.util.OutputObserver;
import org.mortbay.util.StringUtil;

public class HttpConnection
implements OutputObserver {
    private static ThreadLocal __threadConnection = new ThreadLocal();
    private static boolean __2068_Continues = Boolean.getBoolean("org.mortbay.http.HttpConnection.2068Continue");
    protected HttpRequest _request;
    protected HttpResponse _response;
    protected boolean _persistent;
    protected boolean _keepAlive;
    private HttpListener _listener;
    private HttpInputStream _inputStream;
    private HttpOutputStream _outputStream;
    private boolean _close;
    private int _dotVersion;
    private boolean _firstWrite;
    private Thread _handlingThread;
    private InetAddress _remoteInetAddress;
    private String _remoteAddr;
    private String _remoteHost;
    private HttpServer _httpServer;
    private Object _connection;
    private boolean _throttled;
    private boolean _statsOn;
    private long _tmpTime;
    private long _openTime;
    private long _reqTime;
    private int _requests;
    private Object _object;
    private HttpTunnel _tunnel;
    private boolean _resolveRemoteHost;

    public HttpConnection(HttpListener listener, InetAddress remoteAddr, InputStream in, OutputStream out, Object connection) {
        Code.debug((Object)"new HttpConnection: ", connection);
        this._listener = listener;
        this._remoteInetAddress = remoteAddr;
        int bufferSize = listener == null ? 4096 : listener.getBufferSize();
        int reserveSize = listener == null ? 512 : listener.getBufferReserve();
        this._inputStream = new HttpInputStream(in, bufferSize);
        this._outputStream = new HttpOutputStream(out, bufferSize, reserveSize);
        this._outputStream.addObserver(this);
        this._firstWrite = false;
        if (this._listener != null) {
            this._httpServer = this._listener.getHttpServer();
        }
        this._connection = connection;
        boolean bl = this._statsOn = this._httpServer != null && this._httpServer.getStatsOn();
        if (this._statsOn) {
            this._openTime = System.currentTimeMillis();
            this._httpServer.statsOpenConnection();
        }
        this._reqTime = 0L;
        this._requests = 0;
        this._request = new HttpRequest(this);
        this._response = new HttpResponse(this);
        this._resolveRemoteHost = this._listener != null && this._listener.getHttpServer().getResolveRemoteHost();
    }

    static HttpConnection getHttpConnection() {
        return (HttpConnection)__threadConnection.get();
    }

    public InetAddress getRemoteInetAddress() {
        return this._remoteInetAddress;
    }

    public String getRemoteAddr() {
        if (this._remoteAddr == null) {
            if (this._remoteInetAddress == null) {
                return "127.0.0.1";
            }
            this._remoteAddr = this._remoteInetAddress.getHostAddress();
        }
        return this._remoteAddr;
    }

    public String getRemoteHost() {
        if (this._remoteHost == null) {
            if (this._resolveRemoteHost) {
                if (this._remoteInetAddress == null) {
                    return "localhost";
                }
                this._remoteHost = this._remoteInetAddress.getHostName();
            } else {
                if (this._remoteInetAddress == null) {
                    return "127.0.0.1";
                }
                this._remoteHost = this.getRemoteAddr();
            }
        }
        return this._remoteHost;
    }

    public HttpInputStream getInputStream() {
        return this._inputStream;
    }

    public HttpOutputStream getOutputStream() {
        return this._outputStream;
    }

    public Object getConnection() {
        return this._connection;
    }

    public HttpRequest getRequest() {
        return this._request;
    }

    public HttpResponse getResponse() {
        return this._response;
    }

    public void forceClose() {
        this._persistent = false;
        this._close = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this._outputStream.close();
            this._inputStream.close();
        }
        finally {
            if (this._handlingThread != null && Thread.currentThread() != this._handlingThread) {
                this._handlingThread.interrupt();
            }
        }
    }

    public HttpListener getListener() {
        return this._listener;
    }

    public HttpServer getHttpServer() {
        return this._httpServer;
    }

    public String getDefaultScheme() {
        return this._listener.getDefaultScheme();
    }

    public String getServerName() {
        String host = this._listener.getHost();
        if ("0.0.0.0".equals(host) && this._connection instanceof Socket) {
            host = ((Socket)this._connection).getLocalAddress().getHostName();
        }
        return host;
    }

    public String getServerAddr() {
        if (this._connection instanceof Socket) {
            return ((Socket)this._connection).getLocalAddress().getHostAddress();
        }
        return this._listener.getHost();
    }

    public int getServerPort() {
        return this._listener.getPort();
    }

    public int getRemotePort() {
        if (this._connection instanceof Socket) {
            return ((Socket)this._connection).getPort();
        }
        return 0;
    }

    public boolean isThrottled() {
        return this._throttled;
    }

    public void setThrottled(boolean throttled) {
        this._throttled = throttled;
    }

    public Object getObject() {
        return this._object;
    }

    public void setObject(Object o) {
        this._object = o;
    }

    public HttpTunnel getHttpTunnel() {
        return this._tunnel;
    }

    public void setHttpTunnel(HttpTunnel tunnel) {
        this._tunnel = tunnel;
    }

    private void verifyHTTP_1_0() {
        int content_length = this._request.getIntField("Content-Length");
        if (content_length >= 0) {
            this._inputStream.setContentLength(content_length);
        } else if (content_length < 0) {
            this._inputStream.setContentLength(0);
        }
        if (!this._keepAlive && "keep-alive".equalsIgnoreCase(this._request.getField("Proxy-Connection"))) {
            this._keepAlive = true;
        }
        this._persistent = this._keepAlive;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void verifyHTTP_1_1() throws HttpException, IOException {
        String expect;
        String host = this._request.getField("Host");
        if (host == null) {
            throw new HttpException(400);
        }
        String transfer_coding = this._request.getField("Transfer-Encoding");
        if (transfer_coding != null && transfer_coding.length() > 0) {
            if (transfer_coding.equalsIgnoreCase("chunked") || StringUtil.endsWithIgnoreCase(transfer_coding, "chunked")) {
                this._inputStream.setChunking();
            } else if (StringUtil.asciiToLowerCase(transfer_coding).indexOf("chunked") >= 0) {
                throw new HttpException(400);
            }
        }
        int content_length = this._request.getIntField("Content-Length");
        String content_type = this._request.getField("Content-Type");
        if (!this._inputStream.isChunking()) {
            if (content_length >= 0) {
                this._inputStream.setContentLength(content_length);
            } else if (content_type == null || content_type.length() == 0) {
                this._inputStream.setContentLength(0);
            } else {
                this._inputStream.setContentLength(0);
            }
        }
        if ((expect = this._request.getField("Expect")) != null && expect.length() > 0) {
            if (!StringUtil.asciiToLowerCase(expect).equals("100-continue")) throw new HttpException(417);
            if (this._inputStream.available() <= 0) {
                OutputStream real_out = this._outputStream.getOutputStream();
                real_out.write(HttpResponse.__Continue);
                real_out.flush();
            }
        } else if (__2068_Continues && this._inputStream.available() <= 0 && ("PUT".equals(this._request.getMethod()) || "POST".equals(this._request.getMethod()))) {
            OutputStream real_out = this._outputStream.getOutputStream();
            real_out.write(HttpResponse.__Continue);
            real_out.flush();
        }
        this._persistent = !this._close;
    }

    public void outputNotify(OutputStream out, int action, Object ignoredData) throws IOException {
        if (this._response == null) {
            return;
        }
        switch (action) {
            case 0: {
                if (this._firstWrite) break;
                this.firstWrite();
                this._firstWrite = true;
                break;
            }
            case 1: {
                this._firstWrite = false;
                break;
            }
            case 2: {
                this.commit();
                break;
            }
            case 4: {
                if (this._response == null || this._response.isCommitted() || this._request.getState() != 2) break;
                this.commit();
                break;
            }
        }
    }

    protected void firstWrite() throws IOException {
        block14: {
            String transfer_coding;
            block13: {
                if (this._response.isCommitted()) {
                    return;
                }
                transfer_coding = this._response.getField("Transfer-Encoding");
                if (transfer_coding != null && transfer_coding.length() != 0 && !"identity".equalsIgnoreCase(transfer_coding)) break block13;
                switch (this._dotVersion) {
                    case 1: {
                        if (!"close".equals(this._response.getField("Connection")) && this._response.getField("Content-Length") == null) {
                            this._response.setField("Transfer-Encoding", "chunked");
                            this._outputStream.setChunking();
                            break;
                        }
                        break block14;
                    }
                    case 0: {
                        if (!this._keepAlive || !this._persistent || 304 != this._response.getStatus() && this._response.getField("Content-Length") == null || "close".equals(this._response.getField("Connection"))) {
                            this._persistent = false;
                            if (this._keepAlive) {
                                this._response.setField("Connection", "close");
                            }
                            this._keepAlive = false;
                            break;
                        }
                        if (this._keepAlive) {
                            this._response.setField("Connection", "keep-alive");
                            break;
                        }
                        break block14;
                    }
                    default: {
                        this._keepAlive = false;
                        this._persistent = false;
                        break;
                    }
                }
                break block14;
            }
            if (this._dotVersion < 1) {
                this._response.removeField("Transfer-Encoding");
                throw new HttpException(501, "Transfer-Encoding not supported in HTTP/1.0");
            }
            this._response.removeField("Content-Length");
            this._outputStream.setChunking();
            if (!"chunked".equalsIgnoreCase(transfer_coding)) {
                List te = this._request.getAcceptableTransferCodings();
                Enumeration enumeration = this._response.getFieldValues("Transfer-Encoding", ", \t");
                while (enumeration.hasMoreElements()) {
                    String coding = (String)enumeration.nextElement();
                    if ("identity".equalsIgnoreCase(coding) || "chunked".equalsIgnoreCase(coding) || te != null && te.contains(coding)) continue;
                    throw new HttpException(501, coding);
                }
            }
        }
        if ("HEAD".equals(this._request.getMethod())) {
            this._outputStream.nullOutput();
        }
    }

    protected void commit() throws IOException {
        if (this._response.isCommitted()) {
            return;
        }
        this._request.setHandled(true);
        this._close = "close".equals(this._response.getField("Connection"));
        if (!(this._close || this._listener.isStarted() && !this._listener.isOutOfResources())) {
            this._close = true;
            this._response.setField("Connection", "close");
        }
        if (this._close) {
            this._persistent = false;
        }
        int status = this._response.getStatus();
        if (!(this._outputStream.isWritten() || this._response.containsField("Content-Length") || this._response.containsField("Transfer-Encoding"))) {
            if (status == 304 || status == 204) {
                if (this._persistent && this._keepAlive && this._dotVersion == 0) {
                    this._response.setField("Connection", "keep-alive");
                }
            } else if (this._persistent) {
                switch (this._dotVersion) {
                    case 0: {
                        this._close = true;
                        this._persistent = false;
                        this._response.setField("Connection", "close");
                        break;
                    }
                    case 1: {
                        this._response.setField("Transfer-Encoding", "chunked");
                        this._outputStream.setChunking();
                        break;
                    }
                    default: {
                        this._close = true;
                        this._response.setField("Connection", "close");
                        break;
                    }
                }
            } else {
                this._close = true;
                this._response.setField("Connection", "close");
            }
        }
        this._outputStream.writeHeader(this._response);
    }

    private void exception(Throwable e) {
        try {
            this._persistent = false;
            int error_code = 500;
            if (e instanceof HttpException) {
                error_code = ((HttpException)e).getCode();
                if (this._request == null) {
                    Code.warning(e.toString());
                } else {
                    Code.warning(this._request.getRequestLine() + " " + e.toString());
                }
                Code.debug(e);
            } else {
                if (e instanceof EOFException) {
                    Code.ignore(e);
                    return;
                }
                this._request.setAttribute("javax.servlet.error.exception_type", e.getClass());
                this._request.setAttribute("javax.servlet.error.exception", e);
                if (this._request == null) {
                    Code.warning(e);
                } else {
                    Code.warning(this._request.getRequestLine(), e);
                }
            }
            if (this._response != null && !this._response.isCommitted()) {
                this._response.reset();
                this._response.removeField("Transfer-Encoding");
                this._response.setField("Connection", "close");
                this._response.sendError(error_code);
            }
        }
        catch (Exception ex) {
            Code.ignore(ex);
        }
    }

    protected HttpContext service(HttpRequest request, HttpResponse response) throws HttpException, IOException {
        if (this._httpServer == null) {
            throw new HttpException(503);
        }
        return this._httpServer.service(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void handle() {
        try {
            this.associateThread();
            while (true) {
                block6: {
                    block5: {
                        if (!this._listener.isStarted()) break block5;
                        if (this.handleNext()) break block6;
                    }
                    Object var2_1 = null;
                    this.disassociateThread();
                    this.destroy();
                    return;
                }
                this.recycle();
            }
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.disassociateThread();
            this.destroy();
            throw throwable;
        }
    }

    protected void associateThread() {
        __threadConnection.set(this);
        this._handlingThread = Thread.currentThread();
    }

    protected void disassociateThread() {
        this._handlingThread = null;
        __threadConnection.set(null);
    }

    protected void readRequest() throws IOException {
        Code.debug("readRequest() ...");
        this._request.readHeader((LineInput)this._inputStream.getInputStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean handleNext() {
        block154: {
            int content_length;
            int bytes_written;
            Throwable throwable222222;
            HttpContext context;
            block156: {
                block155: {
                    int content_length2;
                    int bytes_written2;
                    if (this._tunnel != null) {
                        Code.debug((Object)"Tunnel: ", (Object)this._tunnel);
                        this._outputStream.resetObservers();
                        this._tunnel.handle(this._inputStream.getInputStream(), this._outputStream.getOutputStream());
                        return false;
                    }
                    context = null;
                    try {
                        this._persistent = false;
                        this._close = false;
                        this._keepAlive = false;
                        this._firstWrite = false;
                        this._dotVersion = 0;
                        this.readRequest();
                        this._listener.customizeRequest(this, this._request);
                        if (this._request.getState() != 2) {
                            throw new HttpException(400);
                        }
                        this.statsRequestStart();
                        if (Code.debug()) {
                            this._response.setField("Jetty-Request", this._request.getRequestLine());
                            Code.debug((Object)"REQUEST:\n", (Object)this._request);
                        }
                        this._dotVersion = this._request.getDotVersion();
                        if (this._dotVersion > 1) {
                            this._dotVersion = 1;
                        }
                        this._response.setVersion("HTTP/1.1");
                        this._response.setField("Date", this._request.getTimeStampStr());
                        this._response.setField("Server", Version.__VersionDetail);
                        Enumeration connectionValues = this._request.getFieldValues("Connection", ", \t");
                        if (connectionValues != null) {
                            while (connectionValues.hasMoreElements()) {
                                String token = connectionValues.nextElement().toString();
                                if (token.equalsIgnoreCase("close")) {
                                    this._close = true;
                                    this._response.setField("Connection", "close");
                                } else if (token.equalsIgnoreCase("keep-alive") && this._dotVersion == 0) {
                                    this._keepAlive = true;
                                }
                                if (this._dotVersion != 0) continue;
                                this._request.forceRemoveField(token);
                            }
                        }
                        if (this._dotVersion == 1) {
                            this.verifyHTTP_1_1();
                        } else if (this._dotVersion == 0) {
                            this.verifyHTTP_1_0();
                        } else if (this._dotVersion != -1) {
                            throw new HttpException(505);
                        }
                        if (Code.verbose(99)) {
                            Code.debug("IN is " + (this._inputStream.isChunking() ? "chunked" : "not chunked") + " Content-Length=" + this._inputStream.getContentLength());
                        }
                        if (!this._request.isHandled()) {
                            context = this.service(this._request, this._response);
                        }
                        bytes_written2 = 0;
                        int n = content_length2 = this._response == null ? -1 : this._response.getIntField("Content-Length");
                    }
                    catch (HttpException e) {
                        int content_length3;
                        this.exception(e);
                        int bytes_written3 = 0;
                        int n = content_length3 = this._response == null ? -1 : this._response.getIntField("Content-Length");
                        if (this._persistent) {
                            try {
                                while (this._inputStream.skip(4096L) > 0L || this._inputStream.read() >= 0) {
                                }
                            }
                            catch (IOException e2) {
                                if (this._inputStream.getContentLength() > 0) {
                                    this._inputStream.setContentLength(0);
                                }
                                this._persistent = false;
                                Code.ignore(e2);
                                this.exception(new HttpException(400, "Missing Content"));
                            }
                            if (this._inputStream.getContentLength() > 0) {
                                this._inputStream.setContentLength(0);
                                this._persistent = false;
                                this.exception(new HttpException(400, "Missing Content"));
                            }
                            try {
                                this._outputStream.close();
                                bytes_written3 = this._outputStream.getBytesWritten();
                                this._outputStream.resetStream();
                                this._outputStream.addObserver(this);
                                this._inputStream.resetStream();
                            }
                            catch (IOException e3) {
                                this.exception(e3);
                            }
                        } else if (this._response != null) {
                            try {
                                if (this._inputStream.getContentLength() > 0) {
                                    while (this._inputStream.skip(4096L) > 0L || this._inputStream.read() >= 0) {
                                    }
                                }
                                this._inputStream.resetStream();
                            }
                            catch (IOException e4) {
                                Code.ignore(e4);
                            }
                            try {
                                this._outputStream.flush();
                                this._response.commit();
                                bytes_written3 = this._outputStream.getBytesWritten();
                                this._outputStream.close();
                                this._outputStream.resetStream();
                            }
                            catch (IOException e5) {
                                this.exception(e5);
                            }
                        }
                        if (this._response != null) {
                            Code.debug((Object)"RESPONSE:\n", (Object)this._response);
                            if (this._persistent && content_length3 >= 0 && bytes_written3 > 0 && content_length3 != bytes_written3) {
                                Code.warning("Invalid length: Content-Length=" + content_length3 + " written=" + bytes_written3 + " for " + this._request.getRequestURL());
                                this._persistent = false;
                                try {
                                    this._outputStream.close();
                                }
                                catch (IOException e6) {
                                    Code.warning(e6);
                                }
                            }
                        }
                        this.statsRequestEnd();
                        if (context != null) {
                            context.log(this._request, this._response, bytes_written3);
                        }
                        break block154;
                        catch (IOException e7) {
                            int content_length4;
                            if (this._request.getState() != 2) {
                                if (Code.debug()) {
                                    if (Code.verbose()) {
                                        Code.debug(e7);
                                    } else {
                                        Code.debug(e7.toString());
                                    }
                                }
                                this._response.destroy();
                                this._response = null;
                            } else {
                                this.exception(e7);
                            }
                            int bytes_written4 = 0;
                            int n2 = content_length4 = this._response == null ? -1 : this._response.getIntField("Content-Length");
                            if (this._persistent) {
                                try {
                                    while (this._inputStream.skip(4096L) > 0L || this._inputStream.read() >= 0) {
                                    }
                                }
                                catch (IOException e8) {
                                    if (this._inputStream.getContentLength() > 0) {
                                        this._inputStream.setContentLength(0);
                                    }
                                    this._persistent = false;
                                    Code.ignore(e8);
                                    this.exception(new HttpException(400, "Missing Content"));
                                }
                                if (this._inputStream.getContentLength() > 0) {
                                    this._inputStream.setContentLength(0);
                                    this._persistent = false;
                                    this.exception(new HttpException(400, "Missing Content"));
                                }
                                try {
                                    this._outputStream.close();
                                    bytes_written4 = this._outputStream.getBytesWritten();
                                    this._outputStream.resetStream();
                                    this._outputStream.addObserver(this);
                                    this._inputStream.resetStream();
                                }
                                catch (IOException e9) {
                                    this.exception(e9);
                                }
                            } else if (this._response != null) {
                                try {
                                    if (this._inputStream.getContentLength() > 0) {
                                        while (this._inputStream.skip(4096L) > 0L || this._inputStream.read() >= 0) {
                                        }
                                    }
                                    this._inputStream.resetStream();
                                }
                                catch (IOException e10) {
                                    Code.ignore(e10);
                                }
                                try {
                                    this._outputStream.flush();
                                    this._response.commit();
                                    bytes_written4 = this._outputStream.getBytesWritten();
                                    this._outputStream.close();
                                    this._outputStream.resetStream();
                                }
                                catch (IOException e11) {
                                    this.exception(e11);
                                }
                            }
                            if (this._response != null) {
                                Code.debug((Object)"RESPONSE:\n", (Object)this._response);
                                if (this._persistent && content_length4 >= 0 && bytes_written4 > 0 && content_length4 != bytes_written4) {
                                    Code.warning("Invalid length: Content-Length=" + content_length4 + " written=" + bytes_written4 + " for " + this._request.getRequestURL());
                                    this._persistent = false;
                                    try {
                                        this._outputStream.close();
                                    }
                                    catch (IOException e12) {
                                        Code.warning(e12);
                                    }
                                }
                            }
                            this.statsRequestEnd();
                            if (context != null) {
                                context.log(this._request, this._response, bytes_written4);
                            }
                            break block154;
                            catch (Exception e13) {
                                int content_length5;
                                this.exception(e13);
                                int bytes_written5 = 0;
                                int n3 = content_length5 = this._response == null ? -1 : this._response.getIntField("Content-Length");
                                if (this._persistent) {
                                    try {
                                        while (this._inputStream.skip(4096L) > 0L || this._inputStream.read() >= 0) {
                                        }
                                    }
                                    catch (IOException e14) {
                                        if (this._inputStream.getContentLength() > 0) {
                                            this._inputStream.setContentLength(0);
                                        }
                                        this._persistent = false;
                                        Code.ignore(e14);
                                        this.exception(new HttpException(400, "Missing Content"));
                                    }
                                    if (this._inputStream.getContentLength() > 0) {
                                        this._inputStream.setContentLength(0);
                                        this._persistent = false;
                                        this.exception(new HttpException(400, "Missing Content"));
                                    }
                                    try {
                                        this._outputStream.close();
                                        bytes_written5 = this._outputStream.getBytesWritten();
                                        this._outputStream.resetStream();
                                        this._outputStream.addObserver(this);
                                        this._inputStream.resetStream();
                                    }
                                    catch (IOException e15) {
                                        this.exception(e15);
                                    }
                                } else if (this._response != null) {
                                    try {
                                        if (this._inputStream.getContentLength() > 0) {
                                            while (this._inputStream.skip(4096L) > 0L || this._inputStream.read() >= 0) {
                                            }
                                        }
                                        this._inputStream.resetStream();
                                    }
                                    catch (IOException e16) {
                                        Code.ignore(e16);
                                    }
                                    try {
                                        this._outputStream.flush();
                                        this._response.commit();
                                        bytes_written5 = this._outputStream.getBytesWritten();
                                        this._outputStream.close();
                                        this._outputStream.resetStream();
                                    }
                                    catch (IOException e17) {
                                        this.exception(e17);
                                    }
                                }
                                if (this._response != null) {
                                    Code.debug((Object)"RESPONSE:\n", (Object)this._response);
                                    if (this._persistent && content_length5 >= 0 && bytes_written5 > 0 && content_length5 != bytes_written5) {
                                        Code.warning("Invalid length: Content-Length=" + content_length5 + " written=" + bytes_written5 + " for " + this._request.getRequestURL());
                                        this._persistent = false;
                                        try {
                                            this._outputStream.close();
                                        }
                                        catch (IOException e18) {
                                            Code.warning(e18);
                                        }
                                    }
                                }
                                this.statsRequestEnd();
                                if (context != null) {
                                    context.log(this._request, this._response, bytes_written5);
                                }
                                break block154;
                                catch (Error e19) {
                                    int content_length6;
                                    int bytes_written6;
                                    try {
                                        this.exception(e19);
                                        bytes_written6 = 0;
                                        int n4 = content_length6 = this._response == null ? -1 : this._response.getIntField("Content-Length");
                                    }
                                    catch (Throwable throwable222222) {
                                        bytes_written = 0;
                                        int n5 = content_length = this._response == null ? -1 : this._response.getIntField("Content-Length");
                                        if (!this._persistent) break block155;
                                        try {
                                            while (this._inputStream.skip(4096L) > 0L || this._inputStream.read() >= 0) {
                                            }
                                        }
                                        catch (IOException e20) {
                                            if (this._inputStream.getContentLength() > 0) {
                                                this._inputStream.setContentLength(0);
                                            }
                                            this._persistent = false;
                                            Code.ignore(e20);
                                            this.exception(new HttpException(400, "Missing Content"));
                                        }
                                    }
                                    if (this._persistent) {
                                        try {
                                            while (this._inputStream.skip(4096L) > 0L || this._inputStream.read() >= 0) {
                                            }
                                        }
                                        catch (IOException e21) {
                                            if (this._inputStream.getContentLength() > 0) {
                                                this._inputStream.setContentLength(0);
                                            }
                                            this._persistent = false;
                                            Code.ignore(e21);
                                            this.exception(new HttpException(400, "Missing Content"));
                                        }
                                        if (this._inputStream.getContentLength() > 0) {
                                            this._inputStream.setContentLength(0);
                                            this._persistent = false;
                                            this.exception(new HttpException(400, "Missing Content"));
                                        }
                                        try {
                                            this._outputStream.close();
                                            bytes_written6 = this._outputStream.getBytesWritten();
                                            this._outputStream.resetStream();
                                            this._outputStream.addObserver(this);
                                            this._inputStream.resetStream();
                                        }
                                        catch (IOException e22) {
                                            this.exception(e22);
                                        }
                                    } else if (this._response != null) {
                                        try {
                                            if (this._inputStream.getContentLength() > 0) {
                                                while (this._inputStream.skip(4096L) > 0L || this._inputStream.read() >= 0) {
                                                }
                                            }
                                            this._inputStream.resetStream();
                                        }
                                        catch (IOException e23) {
                                            Code.ignore(e23);
                                        }
                                        try {
                                            this._outputStream.flush();
                                            this._response.commit();
                                            bytes_written6 = this._outputStream.getBytesWritten();
                                            this._outputStream.close();
                                            this._outputStream.resetStream();
                                        }
                                        catch (IOException e24) {
                                            this.exception(e24);
                                        }
                                    }
                                    if (this._response != null) {
                                        Code.debug((Object)"RESPONSE:\n", (Object)this._response);
                                        if (this._persistent && content_length6 >= 0 && bytes_written6 > 0 && content_length6 != bytes_written6) {
                                            Code.warning("Invalid length: Content-Length=" + content_length6 + " written=" + bytes_written6 + " for " + this._request.getRequestURL());
                                            this._persistent = false;
                                            try {
                                                this._outputStream.close();
                                            }
                                            catch (IOException e25) {
                                                Code.warning(e25);
                                            }
                                        }
                                    }
                                    this.statsRequestEnd();
                                    if (context != null) {
                                        context.log(this._request, this._response, bytes_written6);
                                    }
                                    break block154;
                                }
                            }
                        }
                    }
                    if (this._persistent) {
                        try {
                            while (this._inputStream.skip(4096L) > 0L || this._inputStream.read() >= 0) {
                            }
                        }
                        catch (IOException e) {
                            if (this._inputStream.getContentLength() > 0) {
                                this._inputStream.setContentLength(0);
                            }
                            this._persistent = false;
                            Code.ignore(e);
                            this.exception(new HttpException(400, "Missing Content"));
                        }
                        if (this._inputStream.getContentLength() > 0) {
                            this._inputStream.setContentLength(0);
                            this._persistent = false;
                            this.exception(new HttpException(400, "Missing Content"));
                        }
                        try {
                            this._outputStream.close();
                            bytes_written2 = this._outputStream.getBytesWritten();
                            this._outputStream.resetStream();
                            this._outputStream.addObserver(this);
                            this._inputStream.resetStream();
                        }
                        catch (IOException e) {
                            this.exception(e);
                        }
                    } else if (this._response != null) {
                        try {
                            if (this._inputStream.getContentLength() > 0) {
                                while (this._inputStream.skip(4096L) > 0L || this._inputStream.read() >= 0) {
                                }
                            }
                            this._inputStream.resetStream();
                        }
                        catch (IOException e) {
                            Code.ignore(e);
                        }
                        try {
                            this._outputStream.flush();
                            this._response.commit();
                            bytes_written2 = this._outputStream.getBytesWritten();
                            this._outputStream.close();
                            this._outputStream.resetStream();
                        }
                        catch (IOException e) {
                            this.exception(e);
                        }
                    }
                    if (this._response != null) {
                        Code.debug((Object)"RESPONSE:\n", (Object)this._response);
                        if (this._persistent && content_length2 >= 0 && bytes_written2 > 0 && content_length2 != bytes_written2) {
                            Code.warning("Invalid length: Content-Length=" + content_length2 + " written=" + bytes_written2 + " for " + this._request.getRequestURL());
                            this._persistent = false;
                            try {
                                this._outputStream.close();
                            }
                            catch (IOException e) {
                                Code.warning(e);
                            }
                        }
                    }
                    this.statsRequestEnd();
                    if (context != null) {
                        context.log(this._request, this._response, bytes_written2);
                    }
                    break block154;
                    if (this._inputStream.getContentLength() > 0) {
                        this._inputStream.setContentLength(0);
                        this._persistent = false;
                        this.exception(new HttpException(400, "Missing Content"));
                    }
                    try {
                        this._outputStream.close();
                        bytes_written = this._outputStream.getBytesWritten();
                        this._outputStream.resetStream();
                        this._outputStream.addObserver(this);
                        this._inputStream.resetStream();
                    }
                    catch (IOException e) {
                        this.exception(e);
                    }
                    break block156;
                }
                if (this._response != null) {
                    try {
                        if (this._inputStream.getContentLength() > 0) {
                            while (this._inputStream.skip(4096L) > 0L || this._inputStream.read() >= 0) {
                            }
                        }
                        this._inputStream.resetStream();
                    }
                    catch (IOException e) {
                        Code.ignore(e);
                    }
                    try {
                        this._outputStream.flush();
                        this._response.commit();
                        bytes_written = this._outputStream.getBytesWritten();
                        this._outputStream.close();
                        this._outputStream.resetStream();
                    }
                    catch (IOException e) {
                        this.exception(e);
                    }
                }
            }
            if (this._response != null) {
                Code.debug((Object)"RESPONSE:\n", (Object)this._response);
                if (this._persistent && content_length >= 0 && bytes_written > 0 && content_length != bytes_written) {
                    Code.warning("Invalid length: Content-Length=" + content_length + " written=" + bytes_written + " for " + this._request.getRequestURL());
                    this._persistent = false;
                    try {
                        this._outputStream.close();
                    }
                    catch (IOException e) {
                        Code.warning(e);
                    }
                }
            }
            this.statsRequestEnd();
            if (context == null) throw throwable222222;
            context.log(this._request, this._response, bytes_written);
            throw throwable222222;
        }
        if (this._tunnel != null) return true;
        if (this._persistent) return true;
        return false;
    }

    protected void statsRequestStart() {
        if (this._statsOn) {
            if (this._reqTime > 0L) {
                this.statsRequestEnd();
            }
            ++this._requests;
            this._reqTime = this._tmpTime = this._request.getTimeStamp();
            this._httpServer.statsGotRequest();
        }
    }

    protected void statsRequestEnd() {
        if (this._statsOn && this._reqTime > 0L) {
            this._httpServer.statsEndRequest(System.currentTimeMillis() - this._reqTime, this._response != null);
            this._reqTime = 0L;
        }
    }

    protected void recycle() {
        this._listener.persistConnection(this);
        if (this._request != null) {
            this._request.recycle(this);
        }
        if (this._response != null) {
            this._response.recycle(this);
        }
    }

    protected void destroy() {
        try {
            this.close();
        }
        catch (IOException e) {
            Code.ignore(e);
        }
        catch (Exception e) {
            Code.warning(e);
        }
        if (this._request != null) {
            this._request.destroy();
        }
        if (this._response != null) {
            this._response.destroy();
        }
        if (this._inputStream != null) {
            this._inputStream.destroy();
        }
        if (this._outputStream != null) {
            this._outputStream.destroy();
        }
        this._inputStream = null;
        this._outputStream = null;
        this._request = null;
        this._response = null;
        this._handlingThread = null;
        if (this._statsOn) {
            this._tmpTime = System.currentTimeMillis();
            if (this._reqTime > 0L) {
                this._httpServer.statsEndRequest(this._tmpTime - this._reqTime, false);
            }
            this._httpServer.statsCloseConnection(this._tmpTime - this._openTime, this._requests);
        }
    }
}

