/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import javax.servlet.http.Cookie;
import org.mortbay.http.HttpConnection;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpFields;
import org.mortbay.http.HttpInputStream;
import org.mortbay.http.HttpMessage;
import org.mortbay.http.HttpOutputStream;
import org.mortbay.http.HttpRequest;
import org.mortbay.util.ByteArrayISO8859Writer;
import org.mortbay.util.Code;
import org.mortbay.util.StringUtil;
import org.mortbay.util.TypeUtil;
import org.mortbay.util.URI;
import org.mortbay.util.UrlEncoded;

public class HttpResponse
extends HttpMessage {
    public static final int __100_Continue = 100;
    public static final int __101_Switching_Protocols = 101;
    public static final int __102_Processing = 102;
    public static final int __200_OK = 200;
    public static final int __201_Created = 201;
    public static final int __202_Accepted = 202;
    public static final int __203_Non_Authoritative_Information = 203;
    public static final int __204_No_Content = 204;
    public static final int __205_Reset_Content = 205;
    public static final int __206_Partial_Content = 206;
    public static final int __207_Multi_Status = 207;
    public static final int __300_Multiple_Choices = 300;
    public static final int __301_Moved_Permanently = 301;
    public static final int __302_Moved_Temporarily = 302;
    public static final int __302_Found = 302;
    public static final int __303_See_Other = 303;
    public static final int __304_Not_Modified = 304;
    public static final int __305_Use_Proxy = 305;
    public static final int __400_Bad_Request = 400;
    public static final int __401_Unauthorized = 401;
    public static final int __402_Payment_Required = 402;
    public static final int __403_Forbidden = 403;
    public static final int __404_Not_Found = 404;
    public static final int __405_Method_Not_Allowed = 405;
    public static final int __406_Not_Acceptable = 406;
    public static final int __407_Proxy_Authentication_Required = 407;
    public static final int __408_Request_Timeout = 408;
    public static final int __409_Conflict = 409;
    public static final int __410_Gone = 410;
    public static final int __411_Length_Required = 411;
    public static final int __412_Precondition_Failed = 412;
    public static final int __413_Request_Entity_Too_Large = 413;
    public static final int __414_Request_URI_Too_Large = 414;
    public static final int __415_Unsupported_Media_Type = 415;
    public static final int __416_Requested_Range_Not_Satisfiable = 416;
    public static final int __417_Expectation_Failed = 417;
    public static final int __422_Unprocessable_Entity = 422;
    public static final int __423_Locked = 423;
    public static final int __424_Failed_Dependency = 424;
    public static final int __500_Internal_Server_Error = 500;
    public static final int __501_Not_Implemented = 501;
    public static final int __502_Bad_Gateway = 502;
    public static final int __503_Service_Unavailable = 503;
    public static final int __504_Gateway_Timeout = 504;
    public static final int __505_HTTP_Version_Not_Supported = 505;
    public static final int __507_Insufficient_Storage = 507;
    public static final HashMap __statusMsg = new HashMap();
    static byte[] __Continue;
    private int _status = 200;
    private String _reason;
    private HttpContext _httpContext;
    static /* synthetic */ Class class$org$mortbay$http$HttpResponse;

    public HttpResponse() {
        this._version = "HTTP/1.0";
        this._state = 0;
    }

    public HttpResponse(HttpConnection connection) {
        super(connection);
        this._version = "HTTP/1.0";
        this._state = 0;
    }

    public HttpContext getHttpContext() {
        return this._httpContext;
    }

    void setHttpContext(HttpContext context) {
        this._httpContext = context;
    }

    public boolean isDirty() {
        return this._status != 200 || super.isDirty();
    }

    public void reset() {
        if (this.isCommitted()) {
            throw new IllegalStateException("Already committed");
        }
        try {
            ((HttpOutputStream)this.getOutputStream()).resetBuffer();
            this._status = 200;
            this._reason = null;
            super.reset();
        }
        catch (Exception e) {
            Code.warning(e);
            throw new IllegalStateException(e.toString());
        }
    }

    public HttpRequest getRequest() {
        return this.getHttpRequest();
    }

    public HttpRequest getHttpRequest() {
        if (this._connection == null) {
            return null;
        }
        return this._connection.getRequest();
    }

    public void readHeader(HttpInputStream in) throws IOException {
        this._state = 1;
        Code.notImplemented();
    }

    public void writeHeader(Writer writer) throws IOException {
        if (this._state != 0) {
            throw new IllegalStateException(HttpMessage.__state[this._state] + " is not EDITABLE");
        }
        if (this._header == null) {
            throw new IllegalStateException("Response is destroyed");
        }
        if (this.getHttpRequest().getDotVersion() >= 0) {
            this._state = 1;
            writer.write(this._version);
            writer.write(32);
            writer.write(48 + this._status / 100 % 10);
            writer.write(48 + this._status / 10 % 10);
            writer.write(48 + this._status % 10);
            writer.write(32);
            writer.write(this.getReason());
            writer.write(HttpFields.__CRLF);
            this._header.write(writer);
        }
        this._state = 3;
    }

    public int getStatus() {
        return this._status;
    }

    public void setStatus(int status) {
        this._status = status;
    }

    public String getReason() {
        if (this._reason != null) {
            return this._reason;
        }
        this._reason = (String)__statusMsg.get(TypeUtil.newInteger(this._status));
        if (this._reason == null) {
            this._reason = "unknown";
        }
        return this._reason;
    }

    public void setReason(String reason) {
        this._reason = reason;
    }

    protected HttpFields setFields() throws IllegalStateException {
        HttpRequest request;
        if (!this._acceptTrailer && this._state == 3 && this._version.equals("HTTP/1.1") && (request = this._connection.getRequest()) != null) {
            request.getAcceptableTransferCodings();
        }
        return super.setFields();
    }

    public void sendError(int code, String message) throws IOException {
        Integer code_integer = TypeUtil.newInteger(code);
        if (message == null && (message = (String)__statusMsg.get(code_integer)) == null) {
            message = "" + code;
        }
        HttpRequest request = this.getHttpRequest();
        Class exClass = (Class)request.getAttribute("javax.servlet.error.exception_type");
        this.setStatus(code);
        this.setReason(UrlEncoded.encodeString(message));
        if (code != 204 && code != 304 && code != 206 && code >= 200) {
            String error_page = null;
            while (error_page == null && exClass != null && this._httpContext != null) {
                error_page = this._httpContext.getErrorPage(exClass.getName());
                exClass = exClass.getSuperclass();
                Code.debug((Object)"error page: ", exClass, (Object)" -> ", error_page);
            }
            if (error_page == null && this._httpContext != null) {
                error_page = this._httpContext.getErrorPage(TypeUtil.toString(code));
                Code.debug("error page: " + code, " -> ", error_page);
            }
            if (error_page != null) {
                if (!error_page.startsWith("/")) {
                    error_page = "/" + error_page;
                }
                if (request.getAttribute("javax.servlet.error.status_code") == null) {
                    request.setWrapper(null);
                    this.setWrapper(null);
                    request.setAttribute("javax.servlet.error.request_uri", this.getHttpRequest().getEncodedPath());
                    request.setAttribute("javax.servlet.error.status_code", code_integer);
                    request.setAttribute("javax.servlet.error.message", message);
                    request.setState(0);
                    request.setMethod("GET");
                    request.getURI().setPath(URI.addPaths(this._httpContext.getContextPath(), error_page));
                    request.setState(2);
                    this.setContentType("text/html");
                    String query = null;
                    int q = error_page.indexOf(63);
                    if (q > 0) {
                        query = error_page.substring(q + 1);
                        error_page = error_page.substring(0, q);
                    }
                    this.getHttpContext().handle(error_page, query, request, this);
                } else {
                    Code.warning("Error " + code + " while serving error page for " + request.getAttribute("javax.servlet.error.status_code"));
                }
            } else {
                this.setContentType("text/html");
                this._mimeType = "text/html";
                this._characterEncoding = null;
                ByteArrayISO8859Writer writer = new ByteArrayISO8859Writer(((HttpOutputStream)this.getOutputStream()).getBufferSize());
                this.writeErrorPage(writer, code, message);
                writer.flush();
                this.setContentLength(writer.size());
                writer.writeTo(this.getOutputStream());
                writer.destroy();
            }
        } else if (code != 206) {
            this._header.remove("Content-Type");
            this._header.remove("Content-Length");
            this._characterEncoding = null;
            this._mimeType = null;
        }
        this.commit();
    }

    public void writeErrorPage(Writer writer, int code, String message) throws IOException {
        if (message != null) {
            message = StringUtil.replace(message, "<", "&lt;");
            message = StringUtil.replace(message, ">", "&gt;");
        }
        String uri = this.getHttpRequest().getPath();
        uri = StringUtil.replace(uri, "<", "&lt;");
        uri = StringUtil.replace(uri, ">", "&gt;");
        writer.write("<html>\n<head>\n<title>Error ");
        writer.write(Integer.toString(code));
        writer.write(32);
        writer.write(message);
        writer.write("</title>\n<BODY>\n<h2>HTTP ERROR: ");
        writer.write(Integer.toString(code));
        writer.write(32);
        writer.write(message);
        writer.write("</h2>\n");
        writer.write("RequestURI=");
        writer.write(uri);
        writer.write("<p><i><small><a href=\"http://jetty.mortbay.org\">Powered by Jetty://</a></small></i></p>");
        int i = 0;
        while (i < 20) {
            writer.write("\n                                                ");
            ++i;
        }
        writer.write("\n</body>\n</html>\n");
    }

    public void sendError(int code) throws IOException {
        this.sendError(code, null);
    }

    public void sendRedirect(String location) throws IOException {
        if (this.isCommitted()) {
            throw new IllegalStateException("Commited");
        }
        this._header.put("Location", location);
        this.setStatus(302);
        this.commit();
    }

    public void addSetCookie(String name, String value) {
        this.addSetCookie(new Cookie(name, value), false);
    }

    public void addSetCookie(Cookie cookie) {
        this.addSetCookie(cookie, false);
    }

    public void addSetCookie(Cookie cookie, boolean cookie2) {
        this._header.addSetCookie(cookie, cookie2);
    }

    public void commit() throws IOException {
        if (!this.isCommitted()) {
            this.getOutputStream().flush();
        }
    }

    void recycle(HttpConnection connection) {
        super.recycle(connection);
        this._status = 200;
        this._reason = null;
        this._httpContext = null;
    }

    public void destroy() {
        this._reason = null;
        super.destroy();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            Field[] fields = (class$org$mortbay$http$HttpResponse == null ? (class$org$mortbay$http$HttpResponse = HttpResponse.class$("org.mortbay.http.HttpResponse")) : class$org$mortbay$http$HttpResponse).getDeclaredFields();
            int f = fields.length;
            while (f-- > 0) {
                int m = fields[f].getModifiers();
                String name = fields[f].getName();
                if (!Modifier.isFinal(m) || !Modifier.isStatic(m) || !fields[f].getType().equals(Integer.TYPE) || !name.startsWith("__") || !Character.isDigit(name.charAt(2))) continue;
                String message = name.substring(6);
                message = message.replace('_', ' ');
                __statusMsg.put(fields[f].get(null), message);
            }
        }
        catch (Exception e) {
            Code.warning(e);
        }
        try {
            __Continue = "HTTP/1.1 100 Continue\r\n\r\n".getBytes(StringUtil.__ISO_8859_1);
        }
        catch (Exception e) {
            Code.fail(e);
        }
    }
}

