/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.io.IOException;
import java.net.Socket;
import org.mortbay.http.HttpConnection;
import org.mortbay.http.HttpListener;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpServer;
import org.mortbay.util.Code;
import org.mortbay.util.InetAddrPort;
import org.mortbay.util.Log;
import org.mortbay.util.ThreadedServer;

public class SocketListener
extends ThreadedServer
implements HttpListener {
    private int _lowResourcePersistTimeMs = 2000;
    private String _scheme = "http";
    private String _integralScheme = "https";
    private String _confidentialScheme = "https";
    private int _integralPort = 0;
    private int _confidentialPort = 0;
    private boolean _identifyListener = false;
    private int _bufferSize = 8192;
    private int _bufferReserve = 512;
    private transient HttpServer _server;
    private transient boolean _isLow = false;
    private transient boolean _isOut = false;
    private transient long _warned = 0L;

    public SocketListener() {
    }

    public SocketListener(InetAddrPort address) {
        super(address);
    }

    public void setHttpServer(HttpServer server) {
        Code.assertTrue(server == null || this._server == null || this._server == server, "Cannot share listeners");
        this._server = server;
    }

    public HttpServer getHttpServer() {
        return this._server;
    }

    public int getBufferSize() {
        return this._bufferSize;
    }

    public void setBufferSize(int size) {
        this._bufferSize = size;
    }

    public int getBufferReserve() {
        return this._bufferReserve;
    }

    public void setBufferReserve(int size) {
        this._bufferReserve = size;
    }

    public boolean getIdentifyListener() {
        return this._identifyListener;
    }

    public void setIdentifyListener(boolean identifyListener) {
        this._identifyListener = identifyListener;
    }

    public void setDefaultScheme(String scheme) {
        this._scheme = scheme;
    }

    public String getDefaultScheme() {
        return this._scheme;
    }

    public int getLowResourcePersistTimeMs() {
        return this._lowResourcePersistTimeMs;
    }

    public void setLowResourcePersistTimeMs(int ms) {
        this._lowResourcePersistTimeMs = ms;
    }

    public void start() throws Exception {
        super.start();
        Log.event("Started SocketListener on " + this.getInetAddrPort());
    }

    public void stop() throws InterruptedException {
        super.stop();
        Log.event("Stopped SocketListener on " + this.getInetAddrPort());
    }

    public void handleConnection(Socket socket) throws IOException {
        socket.setTcpNoDelay(true);
        HttpConnection connection = new HttpConnection(this, socket.getInetAddress(), socket.getInputStream(), socket.getOutputStream(), socket);
        try {
            if (this._lowResourcePersistTimeMs > 0 && this.isLowOnResources()) {
                socket.setSoTimeout(this._lowResourcePersistTimeMs);
                connection.setThrottled(true);
            } else {
                socket.setSoTimeout(this.getMaxIdleTimeMs());
                connection.setThrottled(false);
            }
        }
        catch (Exception e) {
            Code.warning(e);
        }
        connection.handle();
    }

    public void customizeRequest(HttpConnection connection, HttpRequest request) {
        if (this._identifyListener) {
            request.setAttribute("org.mortbay.http.HttpListener", this.getName());
        }
        Socket socket = (Socket)connection.getConnection();
        this.customizeRequest(socket, request);
    }

    protected void customizeRequest(Socket socket, HttpRequest request) {
        try {
            if (request.getHttpConnection().isThrottled()) {
                socket.setSoTimeout(this.getMaxIdleTimeMs());
                request.getHttpConnection().setThrottled(false);
            }
        }
        catch (Exception e) {
            Code.ignore(e);
        }
    }

    public void persistConnection(HttpConnection connection) {
        block3: {
            try {
                Socket socket = (Socket)connection.getConnection();
                if (this._lowResourcePersistTimeMs > 0 && this.isLowOnResources()) {
                    socket.setSoTimeout(this._lowResourcePersistTimeMs);
                    connection.setThrottled(true);
                    break block3;
                }
                connection.setThrottled(false);
            }
            catch (Exception e) {
                Code.ignore(e);
            }
        }
    }

    public boolean isLowOnResources() {
        boolean low;
        boolean bl = low = this.getThreads() == this.getMaxThreads() && this.getIdleThreads() < this.getMinThreads();
        if (low && !this._isLow) {
            Log.event("LOW ON THREADS: " + this);
            this._warned = System.currentTimeMillis();
            this._isLow = true;
        } else if (!low && this._isLow && System.currentTimeMillis() - this._warned > 1000L) {
            this._isOut = false;
            this._isLow = false;
        }
        return low;
    }

    public boolean isOutOfResources() {
        boolean out;
        boolean bl = out = this.getThreads() == this.getMaxThreads() && this.getIdleThreads() == 0;
        if (out && !this._isOut) {
            Code.warning("OUT OF THREADS: " + this);
            this._warned = System.currentTimeMillis();
            this._isOut = true;
        }
        return out;
    }

    public boolean isIntegral(HttpConnection connection) {
        return false;
    }

    public boolean isConfidential(HttpConnection connection) {
        return false;
    }

    public String getIntegralScheme() {
        return this._integralScheme;
    }

    public void setIntegralScheme(String integralScheme) {
        this._integralScheme = integralScheme;
    }

    public int getIntegralPort() {
        return this._integralPort;
    }

    public void setIntegralPort(int integralPort) {
        this._integralPort = integralPort;
    }

    public String getConfidentialScheme() {
        return this._confidentialScheme;
    }

    public void setConfidentialScheme(String confidentialScheme) {
        this._confidentialScheme = confidentialScheme;
    }

    public int getConfidentialPort() {
        return this._confidentialPort;
    }

    public void setConfidentialPort(int confidentialPort) {
        this._confidentialPort = confidentialPort;
    }
}

