/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http.handler;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.UserRealm;
import org.mortbay.http.handler.AbstractHttpHandler;
import org.mortbay.util.B64Code;
import org.mortbay.util.Resource;
import org.mortbay.util.StringUtil;
import org.mortbay.util.URI;
import org.mortbay.util.UnixCrypt;

public class HTAccessHandler
extends AbstractHttpHandler {
    private static Log log = LogFactory.getLog((Class)(class$org$mortbay$http$handler$HTAccessHandler == null ? (class$org$mortbay$http$handler$HTAccessHandler = HTAccessHandler.class$("org.mortbay.http.handler.HTAccessHandler")) : class$org$mortbay$http$handler$HTAccessHandler));
    String _default = null;
    String _accessFile = ".htaccess";
    transient HashMap _htCache = new HashMap();
    static /* synthetic */ Class class$org$mortbay$http$handler$HTAccessHandler;

    public void handle(String pathInContext, String pathParams, HttpRequest request, HttpResponse response) throws HttpException, IOException {
        block20: {
            String credentials;
            String user = null;
            String password = null;
            boolean IPValid = true;
            if (log.isDebugEnabled()) {
                log.debug((Object)("HTAccessHandler pathInContext=" + pathInContext));
            }
            if ((credentials = request.getField("Authorization")) != null) {
                credentials = credentials.substring(credentials.indexOf(32) + 1);
                credentials = B64Code.decode(credentials, StringUtil.__ISO_8859_1);
                int i = credentials.indexOf(58);
                user = credentials.substring(0, i);
                password = credentials.substring(i + 1);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("User=" + user + ", password=" + "******************************".substring(0, password.length())));
                }
            }
            HTAccess ht = null;
            try {
                Resource resource = null;
                String directory = pathInContext.endsWith("/") ? pathInContext : URI.parentPath(pathInContext);
                while (directory != null) {
                    String htPath = directory + this._accessFile;
                    resource = this.getHttpContext().getResource(htPath);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("directory=" + directory + " resource=" + resource));
                    }
                    if (resource != null && resource.exists() && !resource.isDirectory()) break;
                    resource = null;
                    directory = URI.parentPath(directory);
                }
                if (resource == null && this._default != null && (!(resource = Resource.newResource(this._default)).exists() || resource.isDirectory())) {
                    return;
                }
                if (resource == null) {
                    return;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("HTACCESS=" + resource));
                }
                if ((ht = (HTAccess)this._htCache.get(resource)) == null || ht.getLastModified() != resource.lastModified()) {
                    ht = new HTAccess(resource);
                    this._htCache.put(resource, ht);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("HTCache loaded " + ht));
                    }
                }
                if (pathInContext.endsWith(this._accessFile)) {
                    response.sendError(403);
                    request.setHandled(true);
                    return;
                }
                if (ht.isForbidden()) {
                    log.warn((Object)("Mis-configured htaccess: " + ht));
                    response.sendError(403);
                    request.setHandled(true);
                    return;
                }
                HashMap methods = ht.getMethods();
                if (methods.size() > 0 && !methods.containsKey(request.getMethod())) {
                    return;
                }
                int satisfy = ht.getSatisfy();
                IPValid = ht.checkAccess("", request.getRemoteAddr());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("IPValid = " + IPValid));
                }
                if (IPValid && satisfy == 0) {
                    return;
                }
                if (!IPValid && satisfy == 1) {
                    response.sendError(403);
                    request.setHandled(true);
                    return;
                }
                if (!ht.checkAuth(user, password, this.getHttpContext(), request)) {
                    log.debug((Object)"Auth Failed");
                    response.setField("WWW-Authenticate", "basic realm=" + ht.getName());
                    response.sendError(401);
                    response.commit();
                    request.setHandled(true);
                    return;
                }
                if (user != null) {
                    request.setAuthType("BASIC");
                    request.setAuthUser(user);
                }
            }
            catch (Exception ex) {
                log.warn((Object)"EXCEPTION ", (Throwable)ex);
                if (ht == null) break block20;
                response.sendError(500);
                request.setHandled(true);
            }
        }
    }

    public void setDefault(String dir) {
        this._default = dir;
    }

    public void setAccessFile(String anArg) {
        this._accessFile = anArg == null ? new String(".htaccess") : new String(anArg);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class HTAccess {
        static final int ANY = 0;
        static final int ALL = 1;
        static final String USER = "user";
        static final String GROUP = "group";
        static final String VALID_USER = "valid-user";
        String _userFile;
        Resource _userResource;
        HashMap _users;
        long _userModified;
        String _groupFile;
        Resource _groupResource;
        HashMap _groups;
        long _groupModified;
        int _satisfy;
        String _type;
        String _name;
        HashMap _methods;
        HashSet _requireEntities;
        String _requireName;
        int _order;
        ArrayList _allowList;
        ArrayList _denyList;
        long _lastModified;
        boolean _forbidden;

        public HTAccess(Resource resource) {
            block9: {
                this._users = null;
                this._groups = null;
                this._satisfy = 0;
                this._methods = new HashMap();
                this._requireEntities = new HashSet();
                this._allowList = new ArrayList();
                this._denyList = new ArrayList();
                this._forbidden = false;
                BufferedReader htin = null;
                try {
                    htin = new BufferedReader(new InputStreamReader(resource.getInputStream()));
                    this.parse(htin);
                    this._lastModified = resource.lastModified();
                    if (this._userFile != null) {
                        this._userResource = Resource.newResource(this._userFile);
                        if (!this._userResource.exists()) {
                            this._forbidden = true;
                            log.warn((Object)("Could not find ht user file: " + this._userFile));
                        } else if (log.isDebugEnabled()) {
                            log.debug((Object)("user file: " + this._userResource));
                        }
                    }
                    if (this._groupFile == null) break block9;
                    this._groupResource = Resource.newResource(this._groupFile);
                    if (!this._groupResource.exists()) {
                        this._forbidden = true;
                        log.warn((Object)("Could not find ht group file: " + this._groupResource));
                    } else if (log.isDebugEnabled()) {
                        log.debug((Object)("group file: " + this._groupResource));
                    }
                }
                catch (IOException e) {
                    this._forbidden = true;
                    log.warn((Object)"EXCEPTION ", (Throwable)e);
                }
            }
        }

        public boolean isForbidden() {
            return this._forbidden;
        }

        public HashMap getMethods() {
            return this._methods;
        }

        public long getLastModified() {
            return this._lastModified;
        }

        public Resource getUserResource() {
            return this._userResource;
        }

        public Resource getGroupResource() {
            return this._groupResource;
        }

        public int getSatisfy() {
            return this._satisfy;
        }

        public String getName() {
            return this._name;
        }

        public String getType() {
            return this._type;
        }

        public boolean checkAccess(String host, String ip) {
            String elm;
            boolean alp = false;
            boolean dep = false;
            if (this._allowList.size() == 0 && this._denyList.size() == 0) {
                return true;
            }
            int i = 0;
            while (i < this._allowList.size()) {
                elm = (String)this._allowList.get(i);
                if (elm.equals("all")) {
                    alp = true;
                    break;
                }
                char c = elm.charAt(0);
                if (c >= '0' && c <= '9') {
                    if (ip.startsWith(elm)) {
                        alp = true;
                        break;
                    }
                } else if (host.endsWith(elm)) {
                    alp = true;
                    break;
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < this._denyList.size()) {
                elm = (String)this._denyList.get(i2);
                if (elm.equals("all")) {
                    dep = true;
                    break;
                }
                char c = elm.charAt(0);
                if (c >= '0' && c <= '9') {
                    if (ip.startsWith(elm)) {
                        dep = true;
                        break;
                    }
                } else if (host.endsWith(elm)) {
                    dep = true;
                    break;
                }
                ++i2;
            }
            if (this._order < 0) {
                return !dep || alp;
            }
            return alp && !dep;
        }

        public boolean checkAuth(String user, String pass, HttpContext context, HttpRequest request) {
            Principal principal;
            if (this._requireName == null) {
                return true;
            }
            UserRealm realm = context.getRealm();
            Principal principal2 = principal = realm == null ? null : realm.authenticate(user, pass, request);
            if (principal == null) {
                String cred;
                String code = this.getUserCode(user);
                String string = cred = user != null && pass != null ? UnixCrypt.crypt(user, pass) : null;
                if (code == null || code.equals("") && !pass.equals("") || !code.equals(cred)) {
                    return false;
                }
            }
            if (this._requireName.equalsIgnoreCase(USER)) {
                if (this._requireEntities.contains(user)) {
                    return true;
                }
            } else if (this._requireName.equalsIgnoreCase(GROUP)) {
                ArrayList gps = this.getUserGroups(user);
                if (gps != null) {
                    int g = gps.size();
                    while (g-- > 0) {
                        if (!this._requireEntities.contains(gps.get(g))) continue;
                        return true;
                    }
                }
            } else if (this._requireName.equalsIgnoreCase(VALID_USER)) {
                return true;
            }
            return false;
        }

        public boolean isAccessLimited() {
            return this._allowList.size() > 0 || this._denyList.size() > 0;
        }

        public boolean isAuthLimited() {
            return this._requireName != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private String getUserCode(String user) {
            if (this._userResource == null) {
                return null;
            }
            if (this._users == null || this._userModified != this._userResource.lastModified()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("LOAD " + this._userResource));
                }
                this._users = new HashMap();
                BufferedReader ufin = null;
                try {
                    String line;
                    ufin = new BufferedReader(new InputStreamReader(this._userResource.getInputStream()));
                    this._userModified = this._userResource.lastModified();
                    while ((line = ufin.readLine()) != null) {
                        int spos;
                        void var3_3;
                        line = var3_3.trim();
                        if (line.startsWith("#") || (spos = line.indexOf(58)) < 0) continue;
                        String u = line.substring(0, spos).trim();
                        String p = line.substring(spos + 1).trim();
                        this._users.put(u, p);
                    }
                }
                catch (IOException e) {
                    log.warn((Object)"EXCEPTION ", (Throwable)e);
                }
                finally {
                    try {
                        if (ufin != null) {
                            ufin.close();
                        }
                    }
                    catch (IOException e2) {
                        log.warn((Object)"EXCEPTION ", (Throwable)e2);
                    }
                }
            }
            return (String)this._users.get(user);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        private ArrayList getUserGroups(String group) {
            block17: {
                if (this._groupResource == null) {
                    return null;
                }
                if (this._groups != null && this._groupModified == this._groupResource.lastModified()) break block17;
                if (HTAccessHandler.access$000().isDebugEnabled()) {
                    HTAccessHandler.access$000().debug((Object)("LOAD " + this._groupResource));
                }
                this._groups = new HashMap<K, V>();
                ufin = null;
                try {
                    ufin = new BufferedReader(new InputStreamReader(this._groupResource.getInputStream()));
                    this._groupModified = this._groupResource.lastModified();
                    while ((line = ufin.readLine()) != null) {
                        line = var3_3.trim();
                        if (line.startsWith("#") || line.length() == 0 || !(tok = new StringTokenizer(line, ": \t")).hasMoreTokens()) continue;
                        g = tok.nextToken();
                        if (tok.hasMoreTokens()) ** GOTO lbl25
                        continue;
lbl-1000:
                        // 1 sources

                        {
                            u = tok.nextToken();
                            gl = (ArrayList<String>)this._groups.get(u);
                            if (gl == null) {
                                gl = new ArrayList<String>();
                                this._groups.put(u, gl);
                            }
                            gl.add(g);
lbl25:
                            // 2 sources

                            ** while (tok.hasMoreTokens())
                        }
lbl26:
                        // 1 sources

                    }
                }
                catch (IOException e) {
                    HTAccessHandler.access$000().warn((Object)"EXCEPTION ", (Throwable)e);
                }
                finally {
                    try {
                        if (ufin != null) {
                            ufin.close();
                        }
                    }
                    catch (IOException e2) {
                        HTAccessHandler.access$000().warn((Object)"EXCEPTION ", (Throwable)e2);
                    }
                }
            }
            return (ArrayList)this._groups.get(group);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("AuthUserFile=");
            buf.append(this._userFile);
            buf.append(", AuthGroupFile=");
            buf.append(this._groupFile);
            buf.append(", AuthName=");
            buf.append(this._name);
            buf.append(", AuthType=");
            buf.append(this._type);
            buf.append(", Methods=");
            buf.append(this._methods);
            buf.append(", satisfy=");
            buf.append(this._satisfy);
            if (this._order < 0) {
                buf.append(", order=deny,allow");
            } else if (this._order > 0) {
                buf.append(", order=allow,deny");
            } else {
                buf.append(", order=mutual-failure");
            }
            buf.append(", Allow from=");
            buf.append(this._allowList);
            buf.append(", deny from=");
            buf.append(this._denyList);
            buf.append(", requireName=");
            buf.append(this._requireName);
            buf.append(" ");
            buf.append(this._requireEntities);
            return buf.toString();
        }

        /*
         * WARNING - void declaration
         */
        private void parse(BufferedReader htin) throws IOException {
            String line;
            block0: while ((line = htin.readLine()) != null) {
                void var2_2;
                line = var2_2.trim();
                if (line.startsWith("#")) continue;
                if (line.startsWith("AuthUserFile")) {
                    this._userFile = line.substring(13).trim();
                    continue;
                }
                if (line.startsWith("AuthGroupFile")) {
                    this._groupFile = line.substring(14).trim();
                    continue;
                }
                if (line.startsWith("AuthName")) {
                    this._name = line.substring(8).trim();
                    continue;
                }
                if (line.startsWith("AuthType")) {
                    this._type = line.substring(8).trim();
                    continue;
                }
                if (!line.startsWith("<Limit")) continue;
                int limit = line.length();
                int endp = line.indexOf(62);
                if (endp < 0) {
                    endp = limit;
                }
                StringTokenizer tkns = new StringTokenizer(line.substring(6, endp));
                while (tkns.hasMoreTokens()) {
                    this._methods.put(tkns.nextToken(), Boolean.TRUE);
                }
                while ((line = htin.readLine()) != null) {
                    int pos2;
                    int pos1;
                    if ((line = line.trim()).startsWith("#")) continue;
                    if (line.startsWith("satisfy")) {
                        pos1 = 7;
                        limit = line.length();
                        while (pos1 < limit && line.charAt(pos1) <= ' ') {
                            ++pos1;
                        }
                        pos2 = pos1;
                        while (pos2 < limit && line.charAt(pos2) > ' ') {
                            ++pos2;
                        }
                        String l_string = line.substring(pos1, pos2);
                        if (l_string.equals("all")) {
                            this._satisfy = 1;
                            continue;
                        }
                        if (!l_string.equals("any")) continue;
                        this._satisfy = 0;
                        continue;
                    }
                    if (line.startsWith("require")) {
                        pos1 = 7;
                        limit = line.length();
                        while (pos1 < limit && line.charAt(pos1) <= ' ') {
                            ++pos1;
                        }
                        pos2 = pos1;
                        while (pos2 < limit && line.charAt(pos2) > ' ') {
                            ++pos2;
                        }
                        this._requireName = line.substring(pos1, pos2).toLowerCase();
                        if (USER.equals(this._requireName)) {
                            this._requireName = USER;
                        } else if (GROUP.equals(this._requireName)) {
                            this._requireName = GROUP;
                        } else if (VALID_USER.equals(this._requireName)) {
                            this._requireName = VALID_USER;
                        }
                        pos1 = pos2 + 1;
                        if (pos1 >= limit) continue;
                        while (pos1 < limit && line.charAt(pos1) <= ' ') {
                            ++pos1;
                        }
                        tkns = new StringTokenizer(line.substring(pos1));
                        while (tkns.hasMoreTokens()) {
                            this._requireEntities.add(tkns.nextToken());
                        }
                        continue;
                    }
                    if (line.startsWith("order")) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("orderline=" + line + "order=" + this._order));
                        }
                        if (line.indexOf("allow,deny") > 0) {
                            log.debug((Object)"==>allow+deny");
                            this._order = 1;
                            continue;
                        }
                        if (line.indexOf("deny,allow") > 0) {
                            log.debug((Object)"==>deny,allow");
                            this._order = -1;
                            continue;
                        }
                        if (line.indexOf("mutual-failure") <= 0) continue;
                        log.debug((Object)"==>mutual");
                        this._order = 0;
                        continue;
                    }
                    if (line.startsWith("allow from")) {
                        pos1 = 10;
                        limit = line.length();
                        while (pos1 < limit && line.charAt(pos1) <= ' ') {
                            ++pos1;
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("allow process:" + line.substring(pos1)));
                        }
                        tkns = new StringTokenizer(line.substring(pos1));
                        while (tkns.hasMoreTokens()) {
                            this._allowList.add(tkns.nextToken());
                        }
                        continue;
                    }
                    if (line.startsWith("deny from")) {
                        pos1 = 9;
                        limit = line.length();
                        while (pos1 < limit && line.charAt(pos1) <= ' ') {
                            ++pos1;
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("deny process:" + line.substring(pos1)));
                        }
                        tkns = new StringTokenizer(line.substring(pos1));
                        while (tkns.hasMoreTokens()) {
                            this._denyList.add(tkns.nextToken());
                        }
                        continue;
                    }
                    if (line.startsWith("</Limit>")) continue block0;
                }
            }
        }
    }
}

