/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.jetty.servlet.FormAuthenticator;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.servlet.ServletHttpRequest;
import org.mortbay.jetty.servlet.ServletHttpResponse;

public class ServletHttpContext
extends HttpContext {
    private HashMap _localeEncodingMap = new HashMap();
    private ServletHandler _servletHandler = null;
    static /* synthetic */ Class class$org$mortbay$jetty$servlet$ServletHandler;

    public ServletContext getServletContext() {
        ServletHandler shandler = this.getServletHandler();
        if (shandler != null) {
            return shandler.getServletContext();
        }
        throw new IllegalStateException();
    }

    public synchronized ServletHandler getServletHandler() {
        if (this._servletHandler == null) {
            this._servletHandler = (ServletHandler)this.getHandler(class$org$mortbay$jetty$servlet$ServletHandler == null ? (class$org$mortbay$jetty$servlet$ServletHandler = ServletHttpContext.class$("org.mortbay.jetty.servlet.ServletHandler")) : class$org$mortbay$jetty$servlet$ServletHandler);
        }
        if (this._servletHandler == null) {
            this._servletHandler = new ServletHandler();
            this.addHandler(this._servletHandler);
        }
        return this._servletHandler;
    }

    public synchronized ServletHolder addServlet(String pathSpec, String className) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        return this.addServlet(className, pathSpec, className);
    }

    public synchronized ServletHolder addServlet(String name, String pathSpec, String className) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        return this.getServletHandler().addServlet(name, pathSpec, className, null);
    }

    protected boolean jSecurityCheck(String pathInContext, HttpRequest request, HttpResponse response) throws IOException {
        return !(this.getAuthenticator() instanceof FormAuthenticator) || !pathInContext.endsWith("j_security_check") || this.getAuthenticator().authenticate(this.getRealm(), pathInContext, request, response) != null;
    }

    public boolean checkSecurityConstraints(String pathInContext, HttpRequest request, HttpResponse response) throws HttpException, IOException {
        return super.checkSecurityConstraints(pathInContext, request, response) && this.jSecurityCheck(pathInContext, request, response);
    }

    public void addLocaleEncoding(String locale, String encoding) {
        this._localeEncodingMap.put(locale, encoding);
    }

    public String getLocaleEncoding(Locale locale) {
        String encoding = (String)this._localeEncodingMap.get(locale.toString());
        if (encoding == null) {
            encoding = (String)this._localeEncodingMap.get(locale.getLanguage());
        }
        return encoding;
    }

    public String toString() {
        return "Servlet" + super.toString();
    }

    public void sendError(HttpResponse response, int code, String msg) throws IOException {
        Object wrapper = response.getWrapper();
        if (wrapper != null && wrapper instanceof HttpServletResponse) {
            ((HttpServletResponse)wrapper).sendError(code, msg);
        } else {
            super.sendError(response, code, msg);
        }
    }

    public void destroy() {
        super.destroy();
        if (this._localeEncodingMap != null) {
            this._localeEncodingMap.clear();
        }
        this._localeEncodingMap = null;
    }

    public Object enterContextScope(HttpRequest request, HttpResponse response) {
        ServletHttpRequest srequest = (ServletHttpRequest)request.getWrapper();
        ServletHttpResponse sresponse = (ServletHttpResponse)response.getWrapper();
        if (srequest == null) {
            srequest = new ServletHttpRequest(this.getServletHandler(), null, request);
            sresponse = new ServletHttpResponse(srequest, response);
            request.setWrapper(srequest);
            response.setWrapper(sresponse);
        }
        return super.enterContextScope(request, response);
    }

    protected void doStop() throws Exception {
        this._servletHandler = null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

