/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.servlet;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mortbay.util.LineInput;
import org.mortbay.util.MultiMap;
import org.mortbay.util.StringUtil;

public class MultiPartFilter
implements Filter {
    private static Log log = LogFactory.getLog((Class)(class$org$mortbay$servlet$MultiPartFilter == null ? (class$org$mortbay$servlet$MultiPartFilter = MultiPartFilter.class$("org.mortbay.servlet.MultiPartFilter")) : class$org$mortbay$servlet$MultiPartFilter));
    private File tempdir;
    static /* synthetic */ Class class$org$mortbay$servlet$MultiPartFilter;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.tempdir = (File)filterConfig.getServletContext().getAttribute("javax.servlet.context.tempdir");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest srequest = (HttpServletRequest)request;
        if (srequest.getContentType() == null || !srequest.getContentType().startsWith("multipart/form-data")) {
            chain.doFilter(request, response);
            return;
        }
        LineInput in = new LineInput((InputStream)request.getInputStream());
        String content_type = srequest.getContentType();
        String boundary = "--" + this.value(content_type.substring(content_type.indexOf("boundary=")));
        byte[] byteBoundary = (boundary + "--").getBytes(StringUtil.__ISO_8859_1);
        MultiMap params = new MultiMap();
        String line = in.readLine();
        if (!line.equals(boundary)) {
            log.warn((Object)line);
            throw new IOException("Missing initial multi part boundary");
        }
        boolean lastPart = false;
        String content_disposition = null;
        while (!lastPart) {
            while ((line = in.readLine()) != null && line.length() != 0) {
                int c = line.indexOf(58, 0);
                if (c <= 0) continue;
                String key = line.substring(0, c).trim().toLowerCase();
                String value = line.substring(c + 1, line.length()).trim();
                if (!key.equals("content-disposition")) continue;
                content_disposition = value;
            }
            boolean form_data = false;
            if (content_disposition == null) {
                throw new IOException("Missing content-disposition");
            }
            StringTokenizer tok = new StringTokenizer(content_disposition, ";");
            String name = null;
            String filename = null;
            while (tok.hasMoreTokens()) {
                String t = tok.nextToken().trim();
                String tl = t.toLowerCase();
                if (t.startsWith("form-data")) {
                    form_data = true;
                    continue;
                }
                if (tl.startsWith("name=")) {
                    name = this.value(t);
                    continue;
                }
                if (!tl.startsWith("filename=")) continue;
                filename = this.value(t);
            }
            if (!form_data) {
                log.warn((Object)"Non form-data part in multipart/form-data");
                continue;
            }
            if (name == null || name.length() == 0) {
                log.warn((Object)"Part with no name in multipart/form-data");
                continue;
            }
            OutputStream out = null;
            File file = null;
            if (filename != null && filename.length() > 0) {
                file = File.createTempFile("MultiPart", "", this.tempdir);
                out = new FileOutputStream(file);
                request.setAttribute(name, (Object)file);
                params.put(name, filename);
            } else {
                out = new ByteArrayOutputStream();
            }
            int state = -2;
            boolean cr = false;
            boolean lf = false;
            while (true) {
                int c;
                int b = 0;
                while ((c = state != -2 ? state : in.read()) != -1) {
                    state = -2;
                    if (c == 13 || c == 10) {
                        if (c != 13) break;
                        state = in.read();
                        break;
                    }
                    if (b >= 0 && b < byteBoundary.length && c == byteBoundary[b]) {
                        ++b;
                        continue;
                    }
                    if (cr) {
                        out.write(13);
                    }
                    if (lf) {
                        out.write(10);
                    }
                    lf = false;
                    cr = false;
                    if (b > 0) {
                        out.write(byteBoundary, 0, b);
                    }
                    b = -1;
                    out.write(c);
                }
                if (b > 0 && b < byteBoundary.length - 2 || b == byteBoundary.length - 1) {
                    if (cr) {
                        out.write(13);
                    }
                    if (lf) {
                        out.write(10);
                    }
                    lf = false;
                    cr = false;
                    out.write(byteBoundary, 0, b);
                    b = -1;
                }
                if (b > 0 || c == -1) {
                    if (b == byteBoundary.length) {
                        lastPart = true;
                    }
                    if (state != 10) break;
                    state = -2;
                    break;
                }
                if (cr) {
                    out.write(13);
                }
                if (lf) {
                    out.write(10);
                }
                cr = c == 13;
                boolean bl = lf = c == 10 || state == 10;
                if (state != 10) continue;
                state = -2;
            }
            out.close();
            if (file != null) continue;
            byte[] bytes = ((ByteArrayOutputStream)out).toByteArray();
            params.add(name, bytes);
        }
        chain.doFilter((ServletRequest)new Wrapper(srequest, params), response);
    }

    private String value(String nameEqualsValue) {
        String value = nameEqualsValue.substring(nameEqualsValue.indexOf(61) + 1).trim();
        int i = value.indexOf(59);
        if (i > 0) {
            value = value.substring(0, i);
        }
        if (value.startsWith("\"")) {
            value = value.substring(1, value.indexOf(34, 1));
        } else {
            i = value.indexOf(32);
            if (i > 0) {
                value = value.substring(0, i);
            }
        }
        return value;
    }

    public void destroy() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Wrapper
    extends HttpServletRequestWrapper {
        String encoding = "UTF-8";
        MultiMap map;

        public Wrapper(HttpServletRequest request, MultiMap map) {
            super(request);
            this.map = map;
        }

        public int getContentLength() {
            return 0;
        }

        public String getParameter(String name) {
            Object o = this.map.get(name);
            if (o instanceof byte[]) {
                try {
                    String s = new String((byte[])o, this.encoding);
                    return s;
                }
                catch (Exception e) {
                    log.warn((Object)e);
                }
            } else if (o instanceof String) {
                return (String)o;
            }
            return null;
        }

        public Map getParameterMap() {
            return this.map;
        }

        public Enumeration getParameterNames() {
            return Collections.enumeration(this.map.keySet());
        }

        public String[] getParameterValues(String name) {
            List l = this.map.getValues(name);
            if (l == null || l.size() == 0) {
                return new String[0];
            }
            String[] v = new String[l.size()];
            for (int i = 0; i < l.size(); ++i) {
                Object o = l.get(i);
                if (o instanceof byte[]) {
                    try {
                        v[i] = new String((byte[])o, this.encoding);
                    }
                    catch (Exception e) {
                        log.warn((Object)e);
                    }
                    continue;
                }
                if (!(o instanceof String)) continue;
                v[i] = (String)o;
            }
            return v;
        }

        public void setCharacterEncoding(String enc) throws UnsupportedEncodingException {
            this.encoding = enc;
        }
    }
}

