/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.SessionContext;
import org.mortbay.jetty.servlet.SessionManager;
import org.mortbay.util.LazyList;
import org.mortbay.util.LogSupport;

public abstract class AbstractSessionManager
implements SessionManager {
    private static Log log = LogFactory.getLog((Class)(class$org$mortbay$jetty$servlet$AbstractSessionManager == null ? (class$org$mortbay$jetty$servlet$AbstractSessionManager = AbstractSessionManager.class$("org.mortbay.jetty.servlet.AbstractSessionManager")) : class$org$mortbay$jetty$servlet$AbstractSessionManager));
    public static final int __distantFuture = 628992000;
    private int _dftMaxIdleSecs = -1;
    private int _scavengePeriodMs = 30000;
    private String _workerName;
    private boolean _useRequestedId = false;
    protected transient ArrayList _sessionListeners = new ArrayList();
    protected transient ArrayList _sessionAttributeListeners = new ArrayList();
    protected transient Map _sessions;
    protected transient Random _random;
    protected transient ServletHandler _handler;
    protected int _minSessions = 0;
    protected int _maxSessions = 0;
    private transient SessionScavenger _scavenger = null;
    static /* synthetic */ Class class$org$mortbay$jetty$servlet$AbstractSessionManager;

    public AbstractSessionManager() {
        this(null);
    }

    public AbstractSessionManager(Random random) {
        this._random = random;
    }

    public boolean getUseRequestedId() {
        return this._useRequestedId;
    }

    public void setUseRequestedId(boolean useRequestedId) {
        this._useRequestedId = useRequestedId;
    }

    public void initialize(ServletHandler handler) {
        this._handler = handler;
    }

    public Map getSessionMap() {
        return Collections.unmodifiableMap(this._sessions);
    }

    public int getSessions() {
        return this._sessions.size();
    }

    public int getMinSessions() {
        return this._minSessions;
    }

    public int getMaxSessions() {
        return this._maxSessions;
    }

    public void resetStats() {
        this._minSessions = this._sessions.size();
        this._maxSessions = this._sessions.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String newSessionId(HttpServletRequest request, long created) {
        Map map = this._sessions;
        synchronized (map) {
            String id = this._useRequestedId ? request.getRequestedSessionId() : null;
            while (id == null || id.length() == 0 || this._sessions.containsKey(id)) {
                long r = this._random.nextLong();
                if (r < 0L) {
                    r = -r;
                }
                id = Long.toString(r, 30 + (int)(created % 7L));
                String worker = (String)request.getAttribute("org.mortbay.http.ajp.JVMRoute");
                if (worker != null) {
                    id = id + "." + worker;
                    continue;
                }
                if (this._workerName == null) continue;
                id = id + "." + this._workerName;
            }
            return id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpSession getHttpSession(String id) {
        Map map = this._sessions;
        synchronized (map) {
            return (HttpSession)this._sessions.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpSession newHttpSession(HttpServletRequest request) {
        Session session = this.newSession(request);
        session.setMaxInactiveInterval(this._dftMaxIdleSecs);
        Map map = this._sessions;
        synchronized (map) {
            this._sessions.put(session.getId(), session);
            if (this._sessions.size() > this._maxSessions) {
                this._maxSessions = this._sessions.size();
            }
        }
        HttpSessionEvent event = new HttpSessionEvent((HttpSession)session);
        int i = 0;
        while (i < this._sessionListeners.size()) {
            ((HttpSessionListener)this._sessionListeners.get(i)).sessionCreated(event);
            ++i;
        }
        return session;
    }

    protected abstract Session newSession(HttpServletRequest var1);

    public String getWorkerName() {
        return this._workerName;
    }

    public void setWorkerName(String workerName) {
        this._workerName = workerName;
    }

    public int getMaxInactiveInterval() {
        return this._dftMaxIdleSecs;
    }

    public void setMaxInactiveInterval(int seconds) {
        this._dftMaxIdleSecs = seconds;
        if (this._dftMaxIdleSecs > 0 && this._scavengePeriodMs > this._dftMaxIdleSecs * 100) {
            this.setScavengePeriod((this._dftMaxIdleSecs + 9) / 10);
        }
    }

    public int getScavengePeriod() {
        return this._scavengePeriodMs / 1000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScavengePeriod(int seconds) {
        if (seconds == 0) {
            seconds = 60;
        }
        int old_period = this._scavengePeriodMs;
        int period = seconds * 1000;
        if (period > 60000) {
            period = 60000;
        }
        if (period < 1000) {
            period = 1000;
        }
        if (period != old_period) {
            AbstractSessionManager abstractSessionManager = this;
            synchronized (abstractSessionManager) {
                this._scavengePeriodMs = period;
                if (this._scavenger != null) {
                    this._scavenger.interrupt();
                }
            }
        }
    }

    public void addEventListener(EventListener listener) throws IllegalArgumentException {
        boolean known = false;
        if (listener instanceof HttpSessionAttributeListener) {
            this._sessionAttributeListeners.add(listener);
            known = true;
        }
        if (listener instanceof HttpSessionListener) {
            this._sessionListeners.add(listener);
            known = true;
        }
        if (!known) {
            throw new IllegalArgumentException("Unknown listener " + listener);
        }
    }

    public void removeEventListener(EventListener listener) {
        if (listener instanceof HttpSessionAttributeListener) {
            this._sessionAttributeListeners.remove(listener);
        }
        if (listener instanceof HttpSessionListener) {
            this._sessionListeners.remove(listener);
        }
    }

    public boolean isStarted() {
        return this._scavenger != null;
    }

    public void start() throws Exception {
        if (this._random == null) {
            log.debug((Object)"New random session seed");
            this._random = new Random();
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Initializing random session key: " + this._random));
        }
        this._random.nextLong();
        if (this._sessions == null) {
            this._sessions = new HashMap();
        }
        if (this._scavenger == null) {
            this._scavenger = new SessionScavenger();
            this._scavenger.start();
        }
    }

    public void stop() {
        ArrayList sessions = new ArrayList(this._sessions.values());
        Iterator i = sessions.iterator();
        while (i.hasNext()) {
            Session session = (Session)i.next();
            session.invalidate();
        }
        this._sessions.clear();
        SessionScavenger scavenger = this._scavenger;
        this._scavenger = null;
        if (scavenger != null) {
            scavenger.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scavenge() {
        Thread thread = Thread.currentThread();
        ClassLoader old_loader = thread.getContextClassLoader();
        try {
            long idleTime2;
            Session session;
            if (this._handler == null) {
                Object var15_3 = null;
                thread.setContextClassLoader(old_loader);
                return;
            }
            ClassLoader loader = this._handler.getClassLoader();
            if (loader != null) {
                thread.setContextClassLoader(loader);
            }
            long now = System.currentTimeMillis();
            Object stale = null;
            try {
                Iterator i = this._sessions.values().iterator();
                while (i.hasNext()) {
                    session = (Session)i.next();
                    idleTime2 = session._maxIdleMs;
                    if (idleTime2 <= 0L || session._accessed + idleTime2 >= now) continue;
                    stale = LazyList.add(stale, session);
                }
            }
            catch (ConcurrentModificationException e) {
                LogSupport.ignore(log, e);
                int oldPriority = Thread.currentThread().getPriority();
                Thread.currentThread().setPriority(10);
                try {
                    AbstractSessionManager idleTime2 = this;
                    synchronized (idleTime2) {
                        stale = null;
                        this.scavenge();
                    }
                    Object var13_18 = null;
                    Thread.currentThread().setPriority(oldPriority);
                }
                catch (Throwable throwable) {
                    Object var13_19 = null;
                    Thread.currentThread().setPriority(oldPriority);
                    throw throwable;
                }
            }
            int i = LazyList.size(stale);
            while (i-- > 0) {
                session = (Session)LazyList.get(stale, i);
                idleTime2 = session._maxIdleMs;
                if (idleTime2 <= 0L || session._accessed + idleTime2 >= System.currentTimeMillis()) continue;
                session.invalidate();
                int nbsess = this._sessions.size();
                if (nbsess >= this._minSessions) continue;
                this._minSessions = nbsess;
            }
        }
        catch (Throwable throwable) {
            Object var15_5 = null;
            thread.setContextClassLoader(old_loader);
            throw throwable;
        }
        Object var15_4 = null;
        thread.setContextClassLoader(old_loader);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public abstract class Session
    implements SessionManager.Session {
        Map _values;
        boolean _invalid = false;
        boolean _newSession = true;
        long _created;
        long _accessed = this._created = System.currentTimeMillis();
        long _maxIdleMs = AbstractSessionManager.access$400(AbstractSessionManager.this) * 1000;
        String _id;

        protected Session(HttpServletRequest request) {
            this._id = AbstractSessionManager.this.newSessionId(request, this._created);
            if (AbstractSessionManager.this._dftMaxIdleSecs >= 0) {
                this._maxIdleMs = AbstractSessionManager.this._dftMaxIdleSecs * 1000;
            }
        }

        protected abstract Map newAttributeMap();

        public void access() {
            this._newSession = false;
            this._accessed = System.currentTimeMillis();
        }

        public boolean isValid() {
            return !this._invalid;
        }

        public ServletContext getServletContext() {
            return AbstractSessionManager.this._handler.getServletContext();
        }

        public String getId() throws IllegalStateException {
            return this._id;
        }

        public long getCreationTime() throws IllegalStateException {
            if (this._invalid) {
                throw new IllegalStateException();
            }
            return this._created;
        }

        public long getLastAccessedTime() throws IllegalStateException {
            if (this._invalid) {
                throw new IllegalStateException();
            }
            return this._accessed;
        }

        public int getMaxInactiveInterval() {
            if (this._invalid) {
                throw new IllegalStateException();
            }
            return (int)(this._maxIdleMs / 1000L);
        }

        public HttpSessionContext getSessionContext() throws IllegalStateException {
            if (this._invalid) {
                throw new IllegalStateException();
            }
            return SessionContext.NULL_IMPL;
        }

        public void setMaxInactiveInterval(int secs) {
            this._maxIdleMs = (long)secs * 1000L;
            if (this._maxIdleMs > 0L && this._maxIdleMs / 10L < (long)AbstractSessionManager.this._scavengePeriodMs) {
                AbstractSessionManager.this.setScavengePeriod((secs + 9) / 10);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void invalidate() throws IllegalStateException {
            if (this._invalid) {
                throw new IllegalStateException();
            }
            if (AbstractSessionManager.this._sessionListeners != null) {
                HttpSessionEvent event = new HttpSessionEvent((HttpSession)this);
                int i = 0;
                while (i < AbstractSessionManager.this._sessionListeners.size()) {
                    ((HttpSessionListener)AbstractSessionManager.this._sessionListeners.get(i)).sessionDestroyed(event);
                    ++i;
                }
            }
            if (this._values != null) {
                Iterator iter = this._values.keySet().iterator();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    Object value = this._values.get(key);
                    iter.remove();
                    this.unbindValue(key, value);
                    if (AbstractSessionManager.this._sessionAttributeListeners.size() <= 0) continue;
                    HttpSessionBindingEvent event = new HttpSessionBindingEvent((HttpSession)this, key, value);
                    int i = 0;
                    while (i < AbstractSessionManager.this._sessionAttributeListeners.size()) {
                        ((HttpSessionAttributeListener)AbstractSessionManager.this._sessionAttributeListeners.get(i)).attributeRemoved(event);
                        ++i;
                    }
                }
            }
            AbstractSessionManager abstractSessionManager = AbstractSessionManager.this;
            synchronized (abstractSessionManager) {
                this._invalid = true;
                AbstractSessionManager.this._sessions.remove(this.getId());
            }
        }

        public boolean isNew() throws IllegalStateException {
            if (this._invalid) {
                throw new IllegalStateException();
            }
            return this._newSession;
        }

        public synchronized Object getAttribute(String name) {
            if (this._invalid) {
                throw new IllegalStateException();
            }
            if (this._values == null) {
                return null;
            }
            return this._values.get(name);
        }

        public synchronized Enumeration getAttributeNames() {
            if (this._invalid) {
                throw new IllegalStateException();
            }
            List<Object> names = this._values == null ? Collections.EMPTY_LIST : new ArrayList(this._values.keySet());
            return Collections.enumeration(names);
        }

        public synchronized void setAttribute(String name, Object value) {
            if (this._invalid) {
                throw new IllegalStateException();
            }
            if (this._values == null) {
                this._values = this.newAttributeMap();
            }
            Object oldValue = this._values.put(name, value);
            if (value == null || !value.equals(oldValue)) {
                this.unbindValue(name, oldValue);
                this.bindValue(name, value);
                if (AbstractSessionManager.this._sessionAttributeListeners.size() > 0) {
                    HttpSessionBindingEvent event = new HttpSessionBindingEvent((HttpSession)this, name, oldValue == null ? value : oldValue);
                    int i = 0;
                    while (i < AbstractSessionManager.this._sessionAttributeListeners.size()) {
                        HttpSessionAttributeListener l = (HttpSessionAttributeListener)AbstractSessionManager.this._sessionAttributeListeners.get(i);
                        if (oldValue == null) {
                            l.attributeAdded(event);
                        } else if (value == null) {
                            l.attributeRemoved(event);
                        } else {
                            l.attributeReplaced(event);
                        }
                        ++i;
                    }
                }
            }
        }

        public synchronized void removeAttribute(String name) {
            if (this._invalid) {
                throw new IllegalStateException();
            }
            if (this._values == null) {
                return;
            }
            Object old = this._values.remove(name);
            if (old != null) {
                this.unbindValue(name, old);
                if (AbstractSessionManager.this._sessionAttributeListeners.size() > 0) {
                    HttpSessionBindingEvent event = new HttpSessionBindingEvent((HttpSession)this, name, old);
                    int i = 0;
                    while (i < AbstractSessionManager.this._sessionAttributeListeners.size()) {
                        HttpSessionAttributeListener l = (HttpSessionAttributeListener)AbstractSessionManager.this._sessionAttributeListeners.get(i);
                        l.attributeRemoved(event);
                        ++i;
                    }
                }
            }
        }

        public Object getValue(String name) throws IllegalStateException {
            return this.getAttribute(name);
        }

        public synchronized String[] getValueNames() throws IllegalStateException {
            if (this._invalid) {
                throw new IllegalStateException();
            }
            if (this._values == null) {
                return new String[0];
            }
            String[] a = new String[this._values.size()];
            return this._values.keySet().toArray(a);
        }

        public void putValue(String name, Object value) throws IllegalStateException {
            this.setAttribute(name, value);
        }

        public void removeValue(String name) throws IllegalStateException {
            this.removeAttribute(name);
        }

        private void bindValue(String name, Object value) {
            if (value != null && value instanceof HttpSessionBindingListener) {
                ((HttpSessionBindingListener)value).valueBound(new HttpSessionBindingEvent((HttpSession)this, name));
            }
        }

        private void unbindValue(String name, Object value) {
            if (value != null && value instanceof HttpSessionBindingListener) {
                ((HttpSessionBindingListener)value).valueUnbound(new HttpSessionBindingEvent((HttpSession)this, name));
            }
        }
    }

    class SessionScavenger
    extends Thread {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            int period = -1;
            try {
                while (true) {
                    if (!AbstractSessionManager.this.isStarted()) {
                        Object var6_5 = null;
                        break;
                    }
                    try {
                        if (period != AbstractSessionManager.this._scavengePeriodMs) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Session scavenger period = " + AbstractSessionManager.this._scavengePeriodMs / 1000 + "s"));
                            }
                            period = AbstractSessionManager.this._scavengePeriodMs;
                        }
                        Thread.sleep(period > 1000 ? (long)period : 1000L);
                        AbstractSessionManager.this.scavenge();
                    }
                    catch (InterruptedException ex) {
                    }
                    catch (Error e) {
                        log.warn((Object)"EXCEPTION ", (Throwable)e);
                    }
                    catch (Exception e) {
                        log.warn((Object)"EXCEPTION ", (Throwable)e);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                AbstractSessionManager.this._scavenger = null;
                log.debug((Object)"Session scavenger exited");
                throw throwable;
            }
            AbstractSessionManager.this._scavenger = null;
            log.debug((Object)"Session scavenger exited");
        }

        SessionScavenger() {
            super("SessionScavenger");
            this.setDaemon(true);
        }
    }
}

