/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.io.nio;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.mortbay.io.AbstractBuffer;
import org.mortbay.io.Buffer;

public class NIOBuffer
extends AbstractBuffer {
    public static final boolean DIRECT = true;
    public static final boolean INDIRECT = false;
    private String _string;
    private boolean _volatile;
    private ByteBuffer _buf;

    public NIOBuffer(int size, boolean direct) {
        super(2, false);
        this._buf = direct ? ByteBuffer.allocateDirect(size) : ByteBuffer.allocate(size);
        this._buf.position(0);
        this._buf.limit(this._buf.capacity());
    }

    public NIOBuffer(File file) throws IOException {
        super(1, false);
        FileInputStream fis = new FileInputStream(file);
        FileChannel fc = fis.getChannel();
        this._buf = fc.map(FileChannel.MapMode.READ_ONLY, 0L, file.length());
        this.setGetIndex(0);
        this.setPutIndex((int)file.length());
        this._access = 0;
    }

    public byte[] array() {
        if (!this._buf.hasArray()) {
            return null;
        }
        return this._buf.array();
    }

    public int capacity() {
        return this._buf.capacity();
    }

    public byte peek(int position) {
        return this._buf.get(position);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int peek(int index, byte[] b, int offset, int length) {
        int l = length;
        if (index + l > this.capacity()) {
            l = this.capacity() - index;
        }
        if (l <= 0) {
            return -1;
        }
        try {
            this._buf.position(index);
            this._buf.get(b, offset, l);
        }
        finally {
            this._buf.position(0);
        }
        return l;
    }

    public void poke(int position, byte b) {
        if (this.isReadOnly()) {
            throw new IllegalStateException("READONLY");
        }
        this._buf.put(position, b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int poke(int index, Buffer src) {
        if (this.isReadOnly()) {
            throw new IllegalStateException("READONLY");
        }
        byte[] array = src.array();
        if (array != null) {
            int length = this.poke(index, array, src.getIndex(), src.length());
            if (!src.isImmutable()) {
                src.setGetIndex(src.getIndex() + length);
            }
            return length;
        }
        Buffer src_buf = src.buffer();
        if (src_buf instanceof NIOBuffer) {
            int n;
            ByteBuffer src_bytebuf = ((NIOBuffer)src_buf)._buf;
            if (src_bytebuf == this._buf) {
                src_bytebuf = this._buf.duplicate();
            }
            try {
                int length = src.length();
                if (length > this.space()) {
                    length = this.space();
                }
                src_bytebuf.position(src.getIndex());
                src_bytebuf.limit(src.getIndex() + length);
                this._buf.position(index);
                this._buf.put(src_bytebuf);
                if (!src.isImmutable()) {
                    src.setGetIndex(src.getIndex() + length);
                }
                n = length;
                Object var9_9 = null;
                this._buf.position(0);
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                this._buf.position(0);
                src_bytebuf.limit(src_bytebuf.capacity());
                src_bytebuf.position(0);
                throw throwable;
            }
            src_bytebuf.limit(src_bytebuf.capacity());
            src_bytebuf.position(0);
            return n;
        }
        return super.poke(index, src);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int poke(int index, byte[] b, int offset, int length) {
        if (this.isReadOnly()) {
            throw new IllegalStateException("READONLY");
        }
        try {
            if (index + length > this.capacity()) {
                length = this.capacity() - index;
            }
            this._buf.position(index);
            this._buf.put(b, offset, length);
            int n = length;
            return n;
        }
        finally {
            this._buf.position(0);
        }
    }

    public ByteBuffer getByteBuffer() {
        return this._buf;
    }
}

