/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import org.mortbay.io.Buffer;
import org.mortbay.io.ByteArrayBuffer;
import org.mortbay.io.EndPoint;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Continuation;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HttpContent;
import org.mortbay.jetty.HttpFields;
import org.mortbay.jetty.HttpGenerator;
import org.mortbay.jetty.HttpHeaderValues;
import org.mortbay.jetty.HttpHeaders;
import org.mortbay.jetty.HttpMethods;
import org.mortbay.jetty.HttpParser;
import org.mortbay.jetty.HttpVersions;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.Response;
import org.mortbay.jetty.RetryRequest;
import org.mortbay.util.URIUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpConnection {
    private static Logger log = LoggerFactory.getLogger((Class)(class$org$mortbay$jetty$HttpConnection == null ? (class$org$mortbay$jetty$HttpConnection = HttpConnection.class$("org.mortbay.jetty.HttpConnection")) : class$org$mortbay$jetty$HttpConnection));
    private static int UNKNOWN = -2;
    private static ThreadLocal __currentConnection = new ThreadLocal();
    private Connector _connector;
    private EndPoint _endp;
    private Handler _handler;
    private boolean _expectingContinues;
    private URI _uri;
    private HttpParser _parser;
    private HttpFields _requestFields;
    private Request _request;
    private Input _in;
    private HttpGenerator _generator;
    private HttpFields _responseFields;
    private Response _response;
    private Output _out;
    private RetryRequest _retry;
    private transient Buffer _content;
    private transient int _connection = UNKNOWN;
    private transient int _expect = UNKNOWN;
    private transient int _version = UNKNOWN;
    private transient boolean _head = false;
    private transient boolean _host = false;
    static /* synthetic */ Class class$org$mortbay$jetty$HttpConnection;

    public static HttpConnection getCurrentConnection() {
        return (HttpConnection)__currentConnection.get();
    }

    public HttpConnection(Connector connector, EndPoint endpoint, Handler handler) {
        this._connector = connector;
        this._endp = endpoint;
        this._parser = new HttpParser(this._connector, endpoint, new RequestHandler(), this._connector.getHeaderBufferSize(), this._connector.getRequestBufferSize());
        this._requestFields = new HttpFields();
        this._responseFields = new HttpFields();
        this._request = new Request(this);
        this._response = new Response(this);
        this._generator = new HttpGenerator(this._connector, this._endp, this._connector.getHeaderBufferSize(), this._connector.getResponseBufferSize());
        this._handler = handler;
    }

    public void content(int index, Buffer ref) {
        this._content = ref;
    }

    public Connector getConnector() {
        return this._connector;
    }

    public Handler getHandler() {
        return this._handler;
    }

    public HttpFields getRequestFields() {
        return this._requestFields;
    }

    public HttpFields getResponseFields() {
        return this._responseFields;
    }

    public boolean isConfidential(Request request) {
        return false;
    }

    public EndPoint getEndPoint() {
        return this._endp;
    }

    public boolean useDNS() {
        return false;
    }

    public Request getRequest() {
        return this._request;
    }

    public Response getResponse() {
        return this._response;
    }

    public ServletInputStream getInputStream() {
        if (this._in == null) {
            this._in = new Input();
        }
        return this._in;
    }

    public ServletOutputStream getOutputStream() {
        if (this._out == null) {
            this._out = new Output();
        }
        return this._out;
    }

    public boolean isResponseCommitted() {
        return this._generator.isCommitted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle() throws IOException {
        try {
            __currentConnection.set(this);
            Continuation continuation = this._request.getContinuation();
            if (continuation != null) {
                this.doHandler();
            } else {
                if (!(this._parser.isState(0) || this._content != null && this._content.length() != 0)) {
                    this._parser.parseAvailable();
                }
                if (this._generator.isState(3) || this._generator.isState(2)) {
                    this._generator.flushBuffers();
                }
            }
            Object var3_2 = null;
            __currentConnection.set(null);
            if (this._parser.isState(0) && this._generator.isState(4)) {
                this._expectingContinues = false;
                this._parser.reset();
                this._requestFields.clear();
                this._request.recycle();
                this._generator.reset(!this._generator.isPersistent());
                this._responseFields.clear();
                this._response.recycle();
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            __currentConnection.set(null);
            if (this._parser.isState(0) && this._generator.isState(4)) {
                this._expectingContinues = false;
                this._parser.reset();
                this._requestFields.clear();
                this._request.recycle();
                this._generator.reset(!this._generator.isPersistent());
                this._responseFields.clear();
                this._response.recycle();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doHandler() throws IOException {
        block8: {
            if (this._handler == null) return;
            boolean retry = false;
            try {
                try {
                    this._request.setRequestURI(this._uri.getRawPath());
                    String target = URIUtil.canonicalPath(this._uri.getPath());
                    this._handler.handle(target, this._request, this._response, 1);
                }
                catch (RetryRequest r) {
                    log.debug("retry ", (Throwable)r);
                    return;
                }
                catch (ServletException e) {
                    log.warn("handling", (Throwable)e);
                    this._generator.sendError(500, null, null, true);
                    Object var4_7 = null;
                    if (retry) return;
                    this._request.setContinuation(null);
                    if (this._response != null) {
                        this._response.complete();
                    }
                    if (this._generator.isComplete()) return;
                    this._generator.completeHeader(this._responseFields, true);
                    this._generator.complete();
                    return;
                }
                Object var4_5 = null;
                if (retry) return;
                this._request.setContinuation(null);
                if (this._response == null) break block8;
            }
            catch (Throwable throwable) {
                Object var4_8 = null;
                if (retry) throw throwable;
                this._request.setContinuation(null);
                if (this._response != null) {
                    this._response.complete();
                }
                if (this._generator.isComplete()) throw throwable;
                this._generator.completeHeader(this._responseFields, true);
                this._generator.complete();
                throw throwable;
            }
            this._response.complete();
        }
        if (this._generator.isComplete()) return;
        this._generator.completeHeader(this._responseFields, true);
        this._generator.complete();
    }

    public void commitResponse(boolean last) throws IOException {
        if (!this._generator.isCommitted()) {
            this._generator.setResponse(this._response.getStatus(), this._response.getReason());
            this._generator.completeHeader(this._responseFields, last);
        }
        if (last) {
            this._generator.complete();
        }
    }

    public void completeResponse() throws IOException {
        if (!this._generator.isCommitted()) {
            this._generator.setResponse(this._response.getStatus(), this._response.getReason());
            this._generator.completeHeader(this._responseFields, true);
        }
        if (!this._generator.isComplete()) {
            this._generator.complete();
        }
    }

    public void flushResponse() throws IOException {
        this.commitResponse(false);
        this._generator.flushBuffers();
    }

    HttpGenerator getGenerator() {
        return this._generator;
    }

    public RetryRequest getRetryRequest() {
        return this._retry;
    }

    public void setRetryRequest(RetryRequest retry) {
        this._retry = retry;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class Output
    extends ServletOutputStream {
        ByteArrayBuffer _buf1 = null;
        ByteArrayBuffer _bufn = null;

        public void close() throws IOException {
            HttpConnection.this.commitResponse(true);
        }

        public void flush() throws IOException {
            HttpConnection.this.flushResponse();
        }

        public void write(byte[] b, int off, int len) throws IOException {
            if (this._bufn == null) {
                this._bufn = new ByteArrayBuffer(b, off, len);
            } else {
                this._bufn.wrap(b, off, len);
            }
            this.write(this._bufn);
        }

        public void write(byte[] b) throws IOException {
            if (this._bufn == null) {
                this._bufn = new ByteArrayBuffer(b);
            } else {
                this._bufn.wrap(b);
            }
            this.write(this._bufn);
        }

        public void write(int b) throws IOException {
            if (this._buf1 == null) {
                this._buf1 = new ByteArrayBuffer(1);
            } else {
                this._buf1.compact();
            }
            this._buf1.put((byte)b);
            this.write(this._buf1);
        }

        private void write(Buffer buffer) throws IOException {
            while (HttpConnection.this._generator.isBufferFull() && !HttpConnection.this._endp.isClosed() && !HttpConnection.this._endp.isBlocking()) {
                HttpConnection.this._endp.blockWritable(60000L);
                HttpConnection.this._generator.flushBuffers();
            }
            HttpConnection.this._generator.addContent(buffer, false);
            if (HttpConnection.this._generator.isBufferFull()) {
                HttpConnection.this.commitResponse(false);
                HttpConnection.this._generator.flushBuffers();
            }
            while (buffer.length() > 0 && !HttpConnection.this._endp.isClosed() && !HttpConnection.this._endp.isBlocking()) {
                HttpConnection.this._endp.blockWritable(60000L);
                HttpConnection.this._generator.flushBuffers();
            }
        }

        public void sendContent(Object content) throws IOException {
            if (HttpConnection.this._generator.getContentAdded() > 0L) {
                throw new IllegalStateException("!empty");
            }
            if (content instanceof HttpContent) {
                HttpContent c = (HttpContent)content;
                if (c.getContentType() != null && !HttpConnection.this._responseFields.containsKey(HttpHeaders.CONTENT_TYPE_BUFFER)) {
                    HttpConnection.this._responseFields.add(HttpHeaders.CONTENT_TYPE_BUFFER, c.getContentType());
                }
                if (c.getContentLength() > 0L) {
                    HttpConnection.this._responseFields.addLongField(HttpHeaders.CONTENT_LENGTH_BUFFER, c.getContentLength());
                }
                if (c.getLastModified() != null) {
                    HttpConnection.this._responseFields.add(HttpHeaders.LAST_MODIFIED_BUFFER, c.getLastModified());
                }
                if (c.getBuffer() != null) {
                    HttpConnection.this._generator.addContent(c.getBuffer(), true);
                }
                HttpConnection.this.commitResponse(true);
            } else if (content instanceof Buffer) {
                HttpConnection.this._generator.addContent((Buffer)content, true);
                HttpConnection.this.commitResponse(true);
            } else {
                throw new IllegalArgumentException("unknown content type?");
            }
        }
    }

    private class Input
    extends ServletInputStream {
        private Input() {
        }

        public int read() throws IOException {
            while (HttpConnection.this._content == null || HttpConnection.this._content.length() == 0) {
                if (HttpConnection.this._parser.isState(0)) {
                    return -1;
                }
                HttpConnection.this._content = null;
                HttpConnection.this._parser.parseNext();
                if (!(HttpConnection.this._parser.isState(0) || HttpConnection.this._content != null && HttpConnection.this._content.length() != 0 || HttpConnection.this._endp == null || HttpConnection.this._endp.isBlocking())) {
                    HttpConnection.this._endp.blockWritable(60000L);
                    HttpConnection.this._parser.parseNext();
                }
                if (HttpConnection.this._parser.isState(0) || HttpConnection.this._content != null && HttpConnection.this._content.length() != 0) continue;
                throw new InterruptedIOException("timeout");
            }
            return HttpConnection.this._content.get();
        }
    }

    private class RequestHandler
    extends HttpParser.EventHandler {
        private RequestHandler() {
        }

        public void startRequest(Buffer method, Buffer uri, Buffer version) throws IOException {
            HttpConnection.this._host = false;
            HttpConnection.this._expect = UNKNOWN;
            HttpConnection.this._connection = UNKNOWN;
            HttpConnection.this._request.setTimeStamp(System.currentTimeMillis());
            HttpConnection.this._request.setMethod(method.toString());
            try {
                HttpConnection.this._uri = new URI(uri.toString());
                HttpConnection.this._uri = HttpConnection.this._uri.normalize();
                HttpConnection.this._request.setUri(HttpConnection.this._uri);
                HttpConnection.this._version = version == null ? 9 : HttpVersions.CACHE.getOrdinal(version);
                if (HttpConnection.this._version <= 0) {
                    HttpConnection.this._version = 10;
                }
                HttpConnection.this._request.setProtocol(HttpVersions.CACHE.get(HttpConnection.this._version).toString());
                HttpConnection.this._head = HttpMethods.CACHE.getOrdinal(method) == 3;
            }
            catch (URISyntaxException e) {
                HttpConnection.this._parser.reset();
                HttpConnection.this._generator.setResponse(400, null);
                HttpConnection.this._responseFields.put(HttpHeaders.CONNECTION_BUFFER, HttpHeaderValues.CLOSE_BUFFER);
                HttpConnection.this._generator.complete();
                return;
            }
        }

        public void parsedHeader(Buffer name, Buffer value) {
            int ho = HttpHeaders.CACHE.getOrdinal(name);
            switch (ho) {
                case 27: {
                    HttpConnection.this._host = true;
                    break;
                }
                case 24: {
                    HttpConnection.this._expect = HttpHeaderValues.CACHE.getOrdinal(value);
                }
                case 1: {
                    HttpConnection.this._connection = HttpHeaderValues.CACHE.getOrdinal(value);
                    HttpConnection.this._responseFields.put(HttpHeaders.CONNECTION_BUFFER, value);
                }
            }
            HttpConnection.this._requestFields.add(name, value);
        }

        public void headerComplete() throws IOException {
            HttpConnection.this._generator.setVersion(HttpConnection.this._version);
            switch (HttpConnection.this._version) {
                case 9: {
                    break;
                }
                case 10: {
                    HttpConnection.this._generator.setHead(HttpConnection.this._head);
                    break;
                }
                case 11: {
                    HttpConnection.this._generator.setHead(HttpConnection.this._head);
                    if (!HttpConnection.this._host) {
                        HttpConnection.this._generator.setResponse(400, null);
                        HttpConnection.this._responseFields.put(HttpHeaders.CONNECTION_BUFFER, HttpHeaderValues.CLOSE_BUFFER);
                        HttpConnection.this._generator.complete();
                        return;
                    }
                    if (HttpConnection.this._expect == UNKNOWN) break;
                    if (HttpConnection.this._expect == HttpHeaderValues.CONTINUE_ORDINAL) {
                        HttpConnection.this._expectingContinues = true;
                        HttpConnection.this._generator.setResponse(100, null);
                        HttpConnection.this._generator.complete();
                        HttpConnection.this._generator.reset(false);
                        break;
                    }
                    HttpConnection.this._generator.sendError(417, null, null, true);
                    return;
                }
            }
            HttpConnection.this.doHandler();
        }

        public void content(int index, Buffer ref) throws IOException {
            if (HttpConnection.this._content != null) {
                throw new IllegalStateException("content not read");
            }
            HttpConnection.this._content = ref;
        }

        public void messageComplete(int contextLength) throws IOException {
        }

        public void startResponse(Buffer version, int status, Buffer reason) {
            throw new IllegalStateException("response");
        }
    }
}

