/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty;

import java.io.IOException;
import java.io.OutputStream;
import org.mortbay.util.StringUtil;

public class MultiPartResponse {
    private static byte[] __CRLF;
    private static byte[] __DASHDASH;
    private String boundary;
    private byte[] boundaryBytes;
    private OutputStream out = null;
    private boolean inPart = false;

    private MultiPartResponse() {
        try {
            this.boundary = "org.mortbay.http.MultiPartResponse.boundary." + Long.toString(System.currentTimeMillis(), 36);
            this.boundaryBytes = this.boundary.getBytes(StringUtil.__ISO_8859_1);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public String getBoundary() {
        return this.boundary;
    }

    public OutputStream getOut() {
        return this.out;
    }

    public MultiPartResponse(OutputStream out) throws IOException {
        this();
        this.out = out;
        this.inPart = false;
    }

    public void startPart(String contentType) throws IOException {
        if (this.inPart) {
            this.out.write(__CRLF);
        }
        this.inPart = true;
        this.out.write(__DASHDASH);
        this.out.write(this.boundaryBytes);
        this.out.write(__CRLF);
        this.out.write(("Content-Type: " + contentType).getBytes(StringUtil.__ISO_8859_1));
        this.out.write(__CRLF);
        this.out.write(__CRLF);
    }

    public void startPart(String contentType, String[] headers) throws IOException {
        if (this.inPart) {
            this.out.write(__CRLF);
        }
        this.inPart = true;
        this.out.write(__DASHDASH);
        this.out.write(this.boundaryBytes);
        this.out.write(__CRLF);
        this.out.write(("Content-Type: " + contentType).getBytes(StringUtil.__ISO_8859_1));
        this.out.write(__CRLF);
        for (int i = 0; headers != null && i < headers.length; ++i) {
            this.out.write(headers[i].getBytes(StringUtil.__ISO_8859_1));
            this.out.write(__CRLF);
        }
        this.out.write(__CRLF);
    }

    public void close() throws IOException {
        if (this.inPart) {
            this.out.write(__CRLF);
        }
        this.out.write(__DASHDASH);
        this.out.write(this.boundaryBytes);
        this.out.write(__DASHDASH);
        this.out.write(__CRLF);
        this.inPart = false;
    }

    static {
        try {
            __CRLF = "\r\n".getBytes(StringUtil.__ISO_8859_1);
            __DASHDASH = "--".getBytes(StringUtil.__ISO_8859_1);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

