/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.mortbay.io.Buffer;
import org.mortbay.io.BufferUtil;
import org.mortbay.io.EndPoint;
import org.mortbay.jetty.Continuation;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.HttpFields;
import org.mortbay.jetty.HttpHeaders;
import org.mortbay.jetty.SessionManager;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.util.Attributes;
import org.mortbay.util.AttributesMap;
import org.mortbay.util.LazyList;
import org.mortbay.util.LogSupport;
import org.mortbay.util.MultiMap;
import org.mortbay.util.QuotedStringTokenizer;
import org.mortbay.util.StringUtil;
import org.mortbay.util.URIUtil;
import org.mortbay.util.UrlEncoded;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Request
implements HttpServletRequest {
    private static final Collection __defaultLocale = Collections.singleton(Locale.getDefault());
    private static Logger log = LoggerFactory.getLogger((Class)(class$org$mortbay$jetty$HttpConnection == null ? (class$org$mortbay$jetty$HttpConnection = Request.class$("org.mortbay.jetty.HttpConnection")) : class$org$mortbay$jetty$HttpConnection));
    private static final int NONE = 0;
    private static final int STREAM = 1;
    private static final int READER = 2;
    private static Cookie[] __noCookies = new Cookie[0];
    private HttpConnection _connection;
    private EndPoint _endp;
    private Attributes _attributes;
    private String _authType;
    private String _characterEncoding;
    private String _serverName;
    private String _method;
    private String _pathInfo;
    private int _port;
    private String _protocol = "HTTP/1.1";
    private String _queryString;
    private String _requestedSessionId;
    private boolean _requestedSessionIdFromCookie = false;
    private String _requestURI;
    private String _scheme = "http";
    private String _contextPath;
    private String _servletPath;
    private URI _uri;
    private Principal _userPrincipal;
    private MultiMap _parameters;
    private boolean _paramsExtracted;
    private int _inputState;
    private BufferedReader _reader;
    private boolean _dns = false;
    private ContextHandler.Context _context;
    private HttpSession _session;
    private SessionManager _sessionManager;
    private boolean _cookiesExtracted = false;
    private Cookie[] _cookies;
    private String[] _lastCookies;
    private long _timeStamp;
    private String _timeStampStr;
    private Continuation _continuation;
    static /* synthetic */ Class class$org$mortbay$jetty$HttpConnection;

    Request(HttpConnection connection) {
        this._connection = connection;
        this._endp = connection.getEndPoint();
        this._dns = this._connection.useDNS();
    }

    void recycle() {
        if (this._attributes != null) {
            this._attributes.clear();
        }
        this._authType = null;
        this._characterEncoding = null;
        this._context = null;
        this._serverName = null;
        this._method = null;
        this._pathInfo = null;
        this._port = 0;
        this._protocol = "HTTP/1.1";
        this._queryString = null;
        this._requestedSessionId = null;
        this._requestedSessionIdFromCookie = false;
        this._requestURI = null;
        this._scheme = "http";
        this._servletPath = null;
        this._uri = null;
        this._userPrincipal = null;
        if (this._parameters != null) {
            this._parameters.clear();
        }
        this._paramsExtracted = false;
        this._inputState = 0;
        this._reader = null;
        this._cookiesExtracted = false;
        this._continuation = null;
    }

    public String getTimeStampStr() {
        if (this._timeStampStr == null && this._timeStamp > 0L) {
            this._timeStampStr = HttpFields.__dateCache.format(this._timeStamp);
        }
        return this._timeStampStr;
    }

    public long getTimeStamp() {
        return this._timeStamp;
    }

    public void setTimeStamp(long ts) {
        this._timeStamp = ts;
    }

    public Object getAttribute(String name) {
        if (this._attributes == null) {
            return null;
        }
        return this._attributes.getAttribute(name);
    }

    public Enumeration getAttributeNames() {
        if (this._attributes == null) {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }
        return this._attributes.getAttributeNames();
    }

    public String getAuthType() {
        return this._authType;
    }

    public String getCharacterEncoding() {
        return this._characterEncoding;
    }

    public Object getContent() throws IOException {
        return null;
    }

    public Object getContentAs(Object type) throws IOException {
        return null;
    }

    public int getContentLength() {
        return (int)this._connection.getRequestFields().getLongField(HttpHeaders.CONTENT_LENGTH_BUFFER);
    }

    public String getContentType() {
        return this._connection.getRequestFields().getStringField(HttpHeaders.CONTENT_TYPE_BUFFER);
    }

    public String getContextPath() {
        return this._contextPath;
    }

    public Cookie[] getCookies() {
        if (this._cookiesExtracted) {
            return this._cookies;
        }
        try {
            int i;
            if (!this._connection.getRequestFields().containsKey(HttpHeaders.COOKIE_BUFFER)) {
                this._cookies = __noCookies;
                this._cookiesExtracted = true;
                this._lastCookies = null;
                return this._cookies;
            }
            if (this._lastCookies != null) {
                int last = 0;
                Enumeration enm = this._connection.getRequestFields().getValues(HttpHeaders.COOKIE_BUFFER);
                while (enm.hasMoreElements()) {
                    String c = enm.nextElement().toString();
                    if (last >= this._lastCookies.length || !c.equals(this._lastCookies[last])) {
                        this._lastCookies = null;
                        break;
                    }
                    ++last;
                }
                if (this._lastCookies != null) {
                    this._cookiesExtracted = true;
                    return this._cookies;
                }
            }
            Object cookies = null;
            Object lastCookies = null;
            int version = 0;
            Cookie cookie = null;
            Enumeration enm = this._connection.getRequestFields().getValues(HttpHeaders.COOKIE_BUFFER);
            while (enm.hasMoreElements()) {
                String hdr = enm.nextElement().toString();
                lastCookies = LazyList.add(lastCookies, hdr);
                QuotedStringTokenizer tok = new QuotedStringTokenizer(hdr, ",;", false, false);
                while (tok.hasMoreElements()) {
                    String c = (String)tok.nextElement();
                    if (c == null) continue;
                    c = c.trim();
                    try {
                        String v;
                        String n;
                        int e = c.indexOf(61);
                        if (e > 0) {
                            n = c.substring(0, e);
                            v = c.substring(e + 1);
                        } else {
                            n = c;
                            v = "";
                        }
                        if (version > 0) {
                            v = StringUtil.unquote(v);
                        }
                        if (n.startsWith("$")) {
                            if ("$version".equalsIgnoreCase(n)) {
                                version = Integer.parseInt(StringUtil.unquote(v));
                                continue;
                            }
                            if ("$path".equalsIgnoreCase(n) && cookie != null) {
                                cookie.setPath(v);
                                continue;
                            }
                            if (!"$domain".equalsIgnoreCase(n) || cookie == null) continue;
                            cookie.setDomain(v);
                            continue;
                        }
                        v = URIUtil.decodePath(v);
                        cookie = new Cookie(n, v);
                        if (version > 0) {
                            cookie.setVersion(version);
                        }
                        cookies = LazyList.add(cookies, cookie);
                    }
                    catch (Exception ex) {
                        LogSupport.ignore(log, ex);
                    }
                }
            }
            int l = LazyList.size(cookies);
            if (this._cookies == null || this._cookies.length != l) {
                this._cookies = new Cookie[l];
            }
            for (i = 0; i < l; ++i) {
                this._cookies[i] = (Cookie)LazyList.get(cookies, i);
            }
            this._cookiesExtracted = true;
            l = LazyList.size(lastCookies);
            this._lastCookies = new String[l];
            for (i = 0; i < l; ++i) {
                this._lastCookies[i] = (String)LazyList.get(lastCookies, i);
            }
        }
        catch (Exception e) {
            log.warn("EXCEPTION ", (Throwable)e);
        }
        return this._cookies;
    }

    public long getDateHeader(String name) {
        return this._connection.getRequestFields().getDateField(name);
    }

    public String getHeader(String name) {
        return this._connection.getRequestFields().getStringField(name);
    }

    public Enumeration getHeaderNames() {
        return this._connection.getRequestFields().getFieldNames();
    }

    public Enumeration getHeaders(String name) {
        Enumeration e = this._connection.getRequestFields().getValues(name);
        if (e == null) {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }
        return e;
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this._inputState != 0 && this._inputState != 1) {
            throw new IllegalStateException("READER");
        }
        this._inputState = 1;
        return this._connection.getInputStream();
    }

    public int getIntHeader(String name) {
        return (int)this._connection.getRequestFields().getLongField(name);
    }

    public String getLocalAddr() {
        return this._endp == null ? null : this._endp.getLocalAddr();
    }

    public Locale getLocale() {
        Enumeration enm = this._connection.getRequestFields().getValues("Accept-Language", ", \t");
        if (enm == null || !enm.hasMoreElements()) {
            return Locale.getDefault();
        }
        List acceptLanguage = HttpFields.qualityList(enm);
        if (acceptLanguage.size() == 0) {
            return Locale.getDefault();
        }
        int i = 0;
        int size = acceptLanguage.size();
        if (i < size) {
            String language = (String)acceptLanguage.get(i);
            language = HttpFields.valueParameters(language, null);
            String country = "";
            int dash = language.indexOf(45);
            if (dash > -1) {
                country = language.substring(dash + 1).trim();
                language = language.substring(0, dash).trim();
            }
            return new Locale(language, country);
        }
        return Locale.getDefault();
    }

    public Enumeration getLocales() {
        Enumeration enm = this._connection.getRequestFields().getValues("Accept-Language", ", \t");
        if (enm == null || !enm.hasMoreElements()) {
            return Collections.enumeration(__defaultLocale);
        }
        List acceptLanguage = HttpFields.qualityList(enm);
        if (acceptLanguage.size() == 0) {
            return Collections.enumeration(__defaultLocale);
        }
        Object langs = null;
        int size = acceptLanguage.size();
        for (int i = 0; i < size; ++i) {
            String language = (String)acceptLanguage.get(i);
            language = HttpFields.valueParameters(language, null);
            String country = "";
            int dash = language.indexOf(45);
            if (dash > -1) {
                country = language.substring(dash + 1).trim();
                language = language.substring(0, dash).trim();
            }
            langs = LazyList.ensureSize(langs, size);
            langs = LazyList.add(langs, new Locale(language, country));
        }
        if (LazyList.size(langs) == 0) {
            return Collections.enumeration(__defaultLocale);
        }
        return Collections.enumeration(LazyList.getList(langs));
    }

    public String getLocalName() {
        if (this._dns) {
            return this._endp == null ? null : this._endp.getLocalHost();
        }
        return this._endp == null ? null : this._endp.getLocalAddr();
    }

    public int getLocalPort() {
        return this._endp == null ? 0 : this._endp.getLocalPort();
    }

    public String getMethod() {
        return this._method;
    }

    public String getParameter(String name) {
        if (!this._paramsExtracted) {
            this.extractParameters();
        }
        return (String)this._parameters.getValue(name, 0);
    }

    public Map getParameterMap() {
        if (!this._paramsExtracted) {
            this.extractParameters();
        }
        return this._parameters.toStringArrayMap();
    }

    public Enumeration getParameterNames() {
        if (!this._paramsExtracted) {
            this.extractParameters();
        }
        return Collections.enumeration(this._parameters.keySet());
    }

    public String[] getParameterValues(String name) {
        List vals;
        if (!this._paramsExtracted) {
            this.extractParameters();
        }
        if ((vals = this._parameters.getValues(name)) == null) {
            return new String[0];
        }
        return vals.toArray(new String[vals.size()]);
    }

    public String getPathInfo() {
        return this._pathInfo;
    }

    public String getPathTranslated() {
        if (this._pathInfo == null || this._context == null) {
            return null;
        }
        return this._context.getRealPath(this._pathInfo);
    }

    public String getProtocol() {
        return this._protocol;
    }

    public BufferedReader getReader() throws IOException {
        if (this._inputState != 0 && this._inputState != 2) {
            throw new IllegalStateException("STREAMED");
        }
        if (this._reader == null) {
            String encoding = this.getCharacterEncoding();
            if (encoding == null) {
                encoding = StringUtil.__ISO_8859_1;
            }
            this._reader = new BufferedReader(new InputStreamReader((InputStream)this.getInputStream(), encoding));
        }
        this._inputState = 2;
        return this._reader;
    }

    public String getRealPath(String path) {
        if (this._context == null) {
            return null;
        }
        return this._context.getRealPath(path);
    }

    public String getRemoteAddr() {
        return this._endp == null ? null : this._endp.getRemoteAddr();
    }

    public String getRemoteHost() {
        if (this._dns) {
            return this._endp == null ? null : this._endp.getRemoteHost();
        }
        return this._endp == null ? null : this._endp.getRemoteAddr();
    }

    public int getRemotePort() {
        return this._endp == null ? 0 : this._endp.getRemotePort();
    }

    public String getRemoteUser() {
        if (this._userPrincipal == null) {
            return null;
        }
        return ((Object)this._userPrincipal).toString();
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        if (path == null || this._context == null) {
            return null;
        }
        if (!path.startsWith("/")) {
            String relTo = URIUtil.addPaths(this._servletPath, this._pathInfo);
            int slash = relTo.lastIndexOf("/");
            relTo = slash > 1 ? relTo.substring(0, slash + 1) : "/";
            path = URIUtil.addPaths(relTo, path);
        }
        return this._context.getRequestDispatcher(path);
    }

    public String getRequestedSessionId() {
        return this._requestedSessionId;
    }

    public String getRequestURI() {
        if (this._requestURI == null) {
            this._requestURI = this._uri.getRawPath();
        }
        return this._requestURI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuffer getRequestURL() {
        StringBuffer url;
        StringBuffer stringBuffer = url = new StringBuffer(48);
        synchronized (stringBuffer) {
            String scheme = this.getScheme();
            int port = this.getServerPort();
            url.append(scheme);
            url.append("://");
            url.append(this.getServerName());
            if (this._port > 0 && (scheme.equalsIgnoreCase("http") && port != 80 || scheme.equalsIgnoreCase("https") && port != 443)) {
                url.append(':');
                url.append(this._port);
            }
            url.append(this.getRequestURI());
            return url;
        }
    }

    public String getScheme() {
        return this._scheme;
    }

    public String getServerName() {
        if (this._serverName != null) {
            return this._serverName;
        }
        this._serverName = this._uri.getHost();
        this._port = this._uri.getPort();
        if (this._serverName != null) {
            return this._serverName;
        }
        Buffer hostPort = this._connection.getRequestFields().get(HttpHeaders.HOST_BUFFER);
        if (hostPort != null) {
            int i = hostPort.length();
            while (i-- > 0) {
                if (hostPort.peek(hostPort.getIndex() + i) != 58) continue;
                this._serverName = hostPort.peek(hostPort.getIndex(), i).toString();
                this._port = BufferUtil.toInt(hostPort.peek(hostPort.getIndex() + i + 1, hostPort.length() - i - 1));
            }
            if (this._serverName == null || this._port < 0) {
                this._serverName = hostPort.toString();
                this._port = 0;
            }
            return this._serverName;
        }
        if (this._connection != null) {
            this._serverName = this.getLocalName();
            this._port = this.getLocalPort();
            if (this._serverName != null && !"0.0.0.0".equals(this._serverName)) {
                return this._serverName;
            }
        }
        try {
            this._serverName = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            LogSupport.ignore(log, e);
        }
        return this._serverName;
    }

    public int getServerPort() {
        if (this._port <= 0) {
            if (this._serverName == null) {
                this.getServerName();
            }
            if (this._port <= 0 && this._serverName != null && this._uri != null && this._uri.isAbsolute()) {
                this._port = this._uri.getPort();
            } else {
                int n = this._port = this._endp == null ? 0 : this._endp.getLocalPort();
            }
        }
        if (this._port <= 0) {
            if (this.getScheme().equalsIgnoreCase("https")) {
                return 443;
            }
            return 80;
        }
        return this._port;
    }

    public String getServletPath() {
        if (this._servletPath == null) {
            this._servletPath = "";
        }
        return this._servletPath;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean create) {
        if (this._session != null && this._session.getId() != null) {
            return this._session;
        }
        this._session = null;
        String id = this.getRequestedSessionId();
        if (id != null && this._sessionManager != null) {
            this._session = this._sessionManager.getHttpSession(id);
            if (this._session == null && !create) {
                return null;
            }
        }
        if (this._session == null && create) {
            this._session = this._sessionManager.newHttpSession(this);
            Cookie cookie = this._sessionManager.getSessionCookie(this._session, this.isSecure());
            if (cookie != null) {
                this._connection.getResponse().addCookie(cookie);
            }
        }
        return this._session;
    }

    public Principal getUserPrincipal() {
        return this._userPrincipal;
    }

    public String getQueryString() {
        return this._queryString;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this._requestedSessionId != null && this._requestedSessionIdFromCookie;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this._requestedSessionId != null && !this._requestedSessionIdFromCookie;
    }

    public boolean isRequestedSessionIdFromURL() {
        return this._requestedSessionId != null && !this._requestedSessionIdFromCookie;
    }

    public boolean isRequestedSessionIdValid() {
        HttpSession session = null;
        return this._requestedSessionId != null && (session = this.getSession(false)) != null && this._requestedSessionId.equals(session.getId());
    }

    public boolean isSecure() {
        return this._connection.isConfidential(this);
    }

    public boolean isUserInRole(String role) {
        return false;
    }

    public void removeAttribute(String name) {
        if (this._attributes != null) {
            this._attributes.removeAttribute(name);
        }
    }

    public void setAttribute(String name, Object attribute) {
        if (this._attributes == null) {
            this._attributes = new AttributesMap();
        }
        this._attributes.setAttribute(name, attribute);
    }

    public void setCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        if (this._inputState != 0) {
            return;
        }
        this._characterEncoding = encoding;
    }

    private void extractParameters() {
        String content_type;
        String encoding;
        if (this._paramsExtracted) {
            return;
        }
        this._paramsExtracted = true;
        if (this._parameters == null) {
            this._parameters = new MultiMap(16);
        }
        if ((encoding = this.getCharacterEncoding()) == null) {
            encoding = StringUtil.__ISO_8859_1;
            if (this._uri != null && this._uri.getQuery() != null) {
                UrlEncoded.decodeTo(this._uri.getQuery(), this._parameters);
            }
        } else if (this._uri != null && this._uri.getRawQuery() != null) {
            UrlEncoded.decodeTo(this._uri.getRawQuery(), this._parameters, encoding);
        }
        if ((content_type = this.getContentType()) != null && content_type.length() > 0 && "application/x-www-form-urlencoded".equalsIgnoreCase(content_type = HttpFields.valueParameters(content_type, null)) && "POST".equals(this.getMethod())) {
            int content_length = this.getContentLength();
            if (content_length <= 0) {
                log.debug("No form _content");
            } else {
                try {
                    ServletInputStream in = this.getInputStream();
                    UrlEncoded.decodeTo((InputStream)in, this._parameters, encoding);
                }
                catch (IOException e) {
                    if (log.isDebugEnabled()) {
                        log.warn("EXCEPTION ", (Throwable)e);
                    }
                    log.warn(e.toString());
                }
            }
        }
    }

    public void setServerName(String host) {
        this._serverName = host;
    }

    public URI getUri() {
        return this._uri;
    }

    public void setUri(URI uri) {
        this._uri = uri;
    }

    public HttpConnection getConnection() {
        return this._connection;
    }

    public int getInputState() {
        return this._inputState;
    }

    public void setAuthType(String authType) {
        this._authType = authType;
    }

    public void setCookies(Cookie[] cookies) {
        this._cookies = cookies;
    }

    public void setMethod(String method) {
        this._method = method;
    }

    public void setPathInfo(String pathInfo) {
        this._pathInfo = pathInfo;
    }

    public void setProtocol(String protocol) {
        this._protocol = protocol;
    }

    public void setRequestedSessionId(String requestedSessionId) {
        this._requestedSessionId = requestedSessionId;
    }

    public SessionManager getSessionManager() {
        return this._sessionManager;
    }

    public void setSessionManager(SessionManager sessionManager) {
        this._sessionManager = sessionManager;
    }

    public void setRequestedSessionIdFromCookie(boolean requestedSessionIdCookie) {
        this._requestedSessionIdFromCookie = requestedSessionIdCookie;
    }

    public void setSession(HttpSession session) {
        this._session = session;
    }

    public void setScheme(String scheme) {
        this._scheme = scheme;
    }

    public void setQueryString(String queryString) {
        this._queryString = queryString;
    }

    public void setRequestURI(String requestURI) {
        this._requestURI = requestURI;
    }

    public void setContextPath(String contextPath) {
        this._contextPath = contextPath;
    }

    public void setServletPath(String servletPath) {
        this._servletPath = servletPath;
    }

    public void setUserPrincipal(Principal userPrincipal) {
        this._userPrincipal = userPrincipal;
    }

    public void setContext(ContextHandler.Context context) {
        this._context = context;
    }

    public ContextHandler.Context getContext() {
        return this._context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuffer getRootURL() {
        StringBuffer url;
        StringBuffer stringBuffer = url = new StringBuffer(48);
        synchronized (stringBuffer) {
            String scheme = this.getScheme();
            int port = this.getServerPort();
            url.append(scheme);
            url.append("://");
            url.append(this.getServerName());
            if (port > 0 && (scheme.equalsIgnoreCase("http") && port != 80 || scheme.equalsIgnoreCase("https") && port != 443)) {
                url.append(':');
                url.append(port);
            }
            return url;
        }
    }

    public Attributes getAttributes() {
        if (this._attributes == null) {
            this._attributes = new AttributesMap();
        }
        return this._attributes;
    }

    public void setAttributes(Attributes attributes) {
        this._attributes = attributes;
    }

    public Continuation getContinuation() {
        return this._continuation;
    }

    void setContinuation(Continuation cont) {
        this._continuation = cont;
    }

    public Continuation newContinuation() {
        if (this._continuation != null) {
            throw new IllegalStateException();
        }
        this._continuation = this.getConnection().getConnector().newContinuation();
        return this._continuation;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

