/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.io.IO;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.HttpHeaders;
import org.mortbay.jetty.MimeTypes;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.ServletWriter;
import org.mortbay.jetty.handler.ErrorPageHandler;
import org.mortbay.util.QuotedStringTokenizer;
import org.mortbay.util.StringUtil;
import org.mortbay.util.URIUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Response
implements HttpServletResponse {
    private static Logger log = LoggerFactory.getLogger((Class)(class$org$mortbay$jetty$Response == null ? (class$org$mortbay$jetty$Response = Response.class$("org.mortbay.jetty.Response")) : class$org$mortbay$jetty$Response));
    public static final int DISABLED = -1;
    public static final int NONE = 0;
    public static final int STREAM = 1;
    public static final int WRITER = 2;
    private static ServletWriter __nullServletWriter;
    private static ServletOutputStream __nullServletOut;
    private static String[] __reasons;
    private HttpConnection _connection;
    private int _status = 200;
    private String _reason;
    private Locale _locale;
    private String _mimeType;
    private String _characterEncoding;
    private boolean _explicitEncoding;
    private String _contentType;
    private int _outputState;
    private ServletWriter _writer;
    static /* synthetic */ Class class$org$mortbay$jetty$Response;
    static /* synthetic */ Class class$javax$servlet$http$HttpServletResponse;

    Response(HttpConnection connection) {
        this._connection = connection;
    }

    void recycle() {
        this._status = 200;
        this._reason = null;
        this._locale = null;
        this._mimeType = null;
        this._characterEncoding = null;
        this._explicitEncoding = false;
        this._contentType = null;
        this._outputState = 0;
        this._writer = null;
    }

    public void addCookie(Cookie cookie) {
        this._connection.getResponseFields().addSetCookie(cookie);
    }

    public boolean containsHeader(String name) {
        return this._connection.getResponseFields().containsKey(name);
    }

    public String encodeURL(String url) {
        return url;
    }

    public String encodeRedirectURL(String url) {
        return this.encodeURL(url);
    }

    public String encodeUrl(String url) {
        return this.encodeURL(url);
    }

    public String encodeRedirectUrl(String url) {
        return this.encodeURL(url);
    }

    public void sendError(int code, String message) throws IOException {
        this.reset();
        this.setStatus(code, message);
        Request request = this._connection.getRequest();
        if (code != 204 && code != 304 && code != 206 && code >= 200) {
            new ErrorPageHandler().handle(null, this._connection.getRequest(), this, 8);
        } else if (code != 206) {
            this._connection.getRequestFields().remove(HttpHeaders.CONTENT_TYPE_BUFFER);
            this._connection.getRequestFields().remove(HttpHeaders.CONTENT_LENGTH_BUFFER);
            this._characterEncoding = null;
            this._mimeType = null;
        }
        this.complete();
    }

    public void sendError(int sc) throws IOException {
        this.sendError(sc, null);
    }

    public void sendRedirect(String location) throws IOException {
        if (location == null) {
            throw new IllegalArgumentException();
        }
        if (!URIUtil.hasScheme(location)) {
            StringBuffer buf = this._connection.getRequest().getRootURL();
            if (location.startsWith("/")) {
                buf.append(URIUtil.canonicalPath(location));
            } else {
                String path = this._connection.getRequest().getRequestURI();
                String parent = path.endsWith("/") ? path : URIUtil.parentPath(path);
                location = URIUtil.canonicalPath(URIUtil.addPaths(parent, location));
                if (!location.startsWith("/")) {
                    buf.append('/');
                }
                buf.append(location);
            }
            location = buf.toString();
        }
        this.resetBuffer();
        this.setHeader("Location", location);
        this.setStatus(302);
    }

    public void setDateHeader(String name, long date) {
        this._connection.getResponseFields().putDateField(name, date);
    }

    public void addDateHeader(String name, long date) {
        this._connection.getResponseFields().addDateField(name, date);
    }

    public void setHeader(String name, String value) {
        this._connection.getResponseFields().put(name, value);
    }

    public void addHeader(String name, String value) {
        this._connection.getResponseFields().put(name, value);
    }

    public void setIntHeader(String name, int value) {
        this._connection.getResponseFields().putLongField(name, value);
    }

    public void addIntHeader(String name, int value) {
        this._connection.getResponseFields().addLongField(name, (long)value);
    }

    public void setStatus(int sc) {
        this.setStatus(sc, null);
    }

    public void setStatus(int sc, String sm) {
        this._status = sc;
        if (sm == null && sc < __reasons.length) {
            sm = __reasons[sc];
        }
        this._reason = sm;
    }

    public String getCharacterEncoding() {
        if (this._characterEncoding == null) {
            this._characterEncoding = StringUtil.__ISO_8859_1;
        }
        return this._characterEncoding;
    }

    public String getContentType() {
        return this._contentType;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this._outputState == -1) {
            return __nullServletOut;
        }
        if (this._outputState != 0 && this._outputState != 1) {
            throw new IllegalStateException("WRITER");
        }
        this._outputState = 1;
        return this._connection.getOutputStream();
    }

    public PrintWriter getWriter() throws IOException {
        if (this._outputState == -1) {
            return __nullServletWriter;
        }
        if (this._outputState != 0 && this._outputState != 2) {
            throw new IllegalStateException("STREAM");
        }
        if (this._writer == null) {
            String encoding = this._characterEncoding;
            if (encoding == null) {
                if (this._mimeType != null) {
                    encoding = null;
                }
                if (encoding == null) {
                    encoding = StringUtil.__ISO_8859_1;
                }
                this.setCharacterEncoding(encoding);
            }
            this._writer = new ServletWriter((OutputStream)this._connection.getOutputStream(), encoding);
        }
        this._outputState = 2;
        return this._writer;
    }

    public void setCharacterEncoding(String encoding) {
        if (this._outputState == 0 && !this.isCommitted()) {
            this._explicitEncoding = true;
            if (encoding == null) {
                if (this._characterEncoding != null) {
                    this._characterEncoding = null;
                    this._connection.getResponseFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, this._mimeType);
                }
            } else {
                this._characterEncoding = encoding;
                if (this._mimeType != null) {
                    this._connection.getResponseFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, this._mimeType + ";charset=" + QuotedStringTokenizer.quote(this._characterEncoding, ";= "));
                }
            }
        }
    }

    public void setContentLength(int len) {
        if (!this.isCommitted()) {
            this._connection.getResponseFields().putLongField("Content-Length", len);
        }
    }

    public void setLongContentLength(long len) {
        if (!this.isCommitted()) {
            this._connection.getResponseFields().putLongField("Content-Length", len);
        }
    }

    public void setContentType(String typeAndMime) {
        if (this.isCommitted()) {
            return;
        }
        if (typeAndMime == null) {
            if (this._locale == null) {
                this._characterEncoding = null;
            }
            this._mimeType = null;
            this._contentType = null;
            this._connection.getResponseFields().remove(HttpHeaders.CONTENT_TYPE_BUFFER);
        } else {
            int i0 = typeAndMime.indexOf(59);
            if (i0 > 0) {
                this._mimeType = typeAndMime.substring(0, i0).trim();
                int i1 = typeAndMime.indexOf("charset=", i0);
                if (i1 >= 0) {
                    int i2 = typeAndMime.indexOf(32, i1 += 8);
                    this._characterEncoding = 0 < i2 ? typeAndMime.substring(i1, i2) : typeAndMime.substring(i1);
                    this._characterEncoding = QuotedStringTokenizer.unquote(this._characterEncoding);
                    this._contentType = typeAndMime;
                } else if (this._characterEncoding != null) {
                    this._contentType = typeAndMime + ";charset=" + QuotedStringTokenizer.quote(this._characterEncoding, ";= ");
                }
            } else {
                this._mimeType = typeAndMime;
                this._contentType = this._characterEncoding != null ? typeAndMime + ";charset=" + QuotedStringTokenizer.quote(this._characterEncoding, ";= ") : this._mimeType;
            }
            this._connection.getResponseFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, MimeTypes.CACHE.lookup(this._contentType));
        }
    }

    public void setBufferSize(int size) {
        this._connection.getGenerator().increaseContentBufferSize(size);
    }

    public int getBufferSize() {
        return this._connection.getGenerator().getContentBufferSize();
    }

    public void flushBuffer() throws IOException {
        this._connection.flushResponse();
    }

    public void reset() {
        this.resetBuffer();
        this._status = 200;
        this._reason = null;
        this._characterEncoding = null;
        this._contentType = null;
        this._mimeType = null;
        this._explicitEncoding = false;
        this._locale = null;
        this._outputState = 0;
        this._writer = null;
    }

    public void resetBuffer() {
        if (this.isCommitted()) {
            throw new IllegalStateException("Committed");
        }
        if (this._writer != null) {
            this._writer.reset();
        }
    }

    public boolean isCommitted() {
        return this._connection.isResponseCommitted();
    }

    public void setLocale(Locale locale) {
        String charset;
        if (this._outputState != 0 || locale == null || this.isCommitted()) {
            return;
        }
        this._locale = locale;
        this._connection.getResponseFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, locale.toString().replace('_', '-'));
        String type = this.getContentType();
        if (type == null) {
            type = "application/octet-stream";
        }
        if ((charset = this._connection.getRequest().getContext().getContextHandler().getLocaleEncoding(locale)) != null && charset.length() > 0) {
            int semi = type.indexOf(59);
            if (semi < 0) {
                type = type + "; charset=" + charset;
            } else if (!this._explicitEncoding) {
                type = type.substring(0, semi) + "; charset=" + charset;
            }
            this._connection.getResponseFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, type);
        }
    }

    public Locale getLocale() {
        if (this._locale == null) {
            return Locale.getDefault();
        }
        return this._locale;
    }

    public int getStatus() {
        return this._status;
    }

    public String getReason() {
        return this._reason;
    }

    public void complete() throws IOException {
        if (this._outputState == 2 && this._writer != null && this._writer.isWritten()) {
            this._writer.close();
        }
        this._connection.completeResponse();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        __reasons = new String[600];
        try {
            __nullServletWriter = new ServletWriter(IO.getNullStream());
            __nullServletOut = new NullOutput();
            Field[] fields = (class$javax$servlet$http$HttpServletResponse == null ? (class$javax$servlet$http$HttpServletResponse = Response.class$("javax.servlet.http.HttpServletResponse")) : class$javax$servlet$http$HttpServletResponse).getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                int code;
                if ((fields[i].getModifiers() & 8) == 0 || !fields[i].getName().startsWith("SC_") || (code = fields[i].getInt(null)) >= __reasons.length) continue;
                Response.__reasons[code] = fields[i].getName().substring(3);
            }
        }
        catch (Exception e) {
            log.error("EXCEPTION ", (Throwable)e);
        }
    }

    private static class NullOutput
    extends ServletOutputStream {
        private NullOutput() {
        }

        public void write(int b) throws IOException {
        }
    }
}

