/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.bio;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.mortbay.io.Buffer;
import org.mortbay.io.ByteArrayBuffer;
import org.mortbay.io.bio.SocketEndPoint;
import org.mortbay.jetty.AbstractConnector;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.RetryRequest;
import org.mortbay.util.LogSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketConnector
extends AbstractConnector {
    private static Logger log = LoggerFactory.getLogger((Class)(class$org$mortbay$jetty$bio$SocketConnector == null ? (class$org$mortbay$jetty$bio$SocketConnector = SocketConnector.class$("org.mortbay.jetty.bio.SocketConnector")) : class$org$mortbay$jetty$bio$SocketConnector));
    ServerSocket _acceptSocket;
    static /* synthetic */ Class class$org$mortbay$jetty$bio$SocketConnector;

    public void open() throws IOException {
        this._acceptSocket = new ServerSocket();
        this._acceptSocket.bind(this.getAddress());
        log.info("Opened " + this._acceptSocket);
    }

    public void close() throws IOException {
        if (this._acceptSocket != null) {
            this._acceptSocket.close();
        }
        this._acceptSocket = null;
    }

    public void accept() throws IOException, InterruptedException {
        Socket socket = this._acceptSocket.accept();
        this.configure(socket);
        Connection connection = new Connection(socket);
        connection.dispatch();
    }

    protected Buffer newBuffer(int size) {
        return new ByteArrayBuffer(size);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class Connection
    extends SocketEndPoint
    implements Runnable {
        boolean _dispatched = false;
        HttpConnection _connection;

        Connection(Socket socket) throws IOException {
            super(socket);
            this._connection = new HttpConnection(SocketConnector.this, this, SocketConnector.this.getHandler());
        }

        void dispatch() throws InterruptedException {
            SocketConnector.this.getThreadPool().dispatch(this);
        }

        public int fill(Buffer buffer) throws IOException {
            int l = super.fill(buffer);
            if (l < 0) {
                this.close();
            }
            return l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (!this.isClosed()) {
                    this._connection.handle();
                }
            }
            catch (RetryRequest e) {
                throw e;
            }
            catch (IOException e) {
                if ("BAD".equals(e.getMessage())) {
                    log.warn("BAD Request");
                    log.debug("BAD", (Throwable)e);
                } else if ("EOF".equals(e.getMessage())) {
                    log.debug("EOF", (Throwable)e);
                } else {
                    log.warn("IO", (Throwable)e);
                }
                try {
                    this.close();
                }
                catch (IOException e2) {
                    LogSupport.ignore(log, e2);
                }
            }
            catch (Throwable e) {
                log.warn("handle failed", e);
                try {
                    this.close();
                }
                catch (IOException e2) {
                    LogSupport.ignore(log, e2);
                }
            }
        }
    }
}

