/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.nio;

import java.io.IOException;
import java.net.Socket;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Iterator;
import org.mortbay.io.Buffer;
import org.mortbay.io.nio.ChannelEndPoint;
import org.mortbay.io.nio.NIOBuffer;
import org.mortbay.jetty.AbstractConnector;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.util.LogSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectBlockingChannelConnector
extends AbstractConnector {
    private static Logger log = LoggerFactory.getLogger((Class)(class$org$mortbay$jetty$nio$SelectBlockingChannelConnector == null ? (class$org$mortbay$jetty$nio$SelectBlockingChannelConnector = SelectBlockingChannelConnector.class$("org.mortbay.jetty.nio.SelectBlockingChannelConnector")) : class$org$mortbay$jetty$nio$SelectBlockingChannelConnector));
    private transient ServerSocketChannel _acceptChannel;
    private transient SelectionKey _acceptKey;
    private transient Selector _selector;
    private transient ArrayList _unDispatched = new ArrayList();
    static /* synthetic */ Class class$org$mortbay$jetty$nio$SelectBlockingChannelConnector;

    public void open() throws IOException {
        if (this._acceptChannel == null) {
            this._acceptChannel = ServerSocketChannel.open();
            this._acceptChannel.configureBlocking(false);
            this._acceptChannel.socket().bind(this.getAddress());
            this._selector = Selector.open();
            this._acceptKey = this._acceptChannel.register(this._selector, 16);
        }
    }

    public void close() throws IOException {
        if (this._acceptChannel != null) {
            this._acceptChannel.close();
        }
        this._acceptChannel = null;
        try {
            if (this._selector != null) {
                this._selector.close();
            }
        }
        catch (IOException e) {
            LogSupport.ignore(log, e);
        }
        this._selector = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept() throws IOException {
        ArrayList arrayList = this._unDispatched;
        synchronized (arrayList) {
            if (this._unDispatched.size() > 0) {
                this._selector.selectNow();
            }
            for (int i = 0; i < this._unDispatched.size(); ++i) {
                try {
                    HttpEndPoint c = (HttpEndPoint)this._unDispatched.get(i);
                    SocketChannel channel = (SocketChannel)c.getChannel();
                    if (!channel.isOpen()) continue;
                    channel.configureBlocking(false);
                    c.setKey(channel.register(this._selector, 1));
                    continue;
                }
                catch (CancelledKeyException e) {
                    log.warn("???", (Throwable)e);
                }
            }
            this._unDispatched.clear();
        }
        if (this._selector.selectedKeys().size() == 0) {
            this._selector.select(this._maxIdleTime);
        }
        Iterator<SelectionKey> iter = this._selector.selectedKeys().iterator();
        while (iter.hasNext()) {
            SelectionKey key = iter.next();
            iter.remove();
            try {
                HttpEndPoint connection;
                if (!key.isValid()) {
                    key.cancel();
                    connection = (HttpEndPoint)key.attachment();
                    if (connection == null) continue;
                    connection._key = null;
                    continue;
                }
                if (key.equals(this._acceptKey)) {
                    if (key.isAcceptable()) {
                        SocketChannel channel = this._acceptChannel.accept();
                        channel.configureBlocking(true);
                        Socket socket = channel.socket();
                        this.configure(socket);
                        HttpEndPoint connection2 = new HttpEndPoint(channel);
                        connection2.dispatch();
                    }
                } else {
                    connection = (HttpEndPoint)key.attachment();
                    if (connection != null) {
                        connection.dispatch();
                    }
                }
                key = null;
            }
            catch (Exception e) {
                if (this.isRunning()) {
                    log.warn("selector", (Throwable)e);
                }
                if (key == null || key == this._acceptKey) continue;
                key.interestOps(0);
            }
        }
    }

    protected Buffer newBuffer(int size) {
        return new NIOBuffer(size, true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class HttpEndPoint
    extends ChannelEndPoint
    implements Runnable {
        boolean _dispatched = false;
        SelectionKey _key;
        HttpConnection _connection;

        HttpEndPoint(SocketChannel channel) {
            super(channel);
            this._connection = new HttpConnection(SelectBlockingChannelConnector.this, this, SelectBlockingChannelConnector.this.getHandler());
        }

        void setKey(SelectionKey key) {
            this._key = key;
            this._key.attach(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        boolean dispatch() throws IOException {
            boolean dispatch_done;
            block8: {
                boolean bl;
                block7: {
                    dispatch_done = false;
                    try {
                        HttpEndPoint httpEndPoint = this;
                        synchronized (httpEndPoint) {
                            if (this._dispatched) {
                                bl = false;
                                // MONITOREXIT @DISABLED, blocks:[0, 3, 6] lbl7 : MonitorExitStatement: MONITOREXIT : var2_2
                                Object var6_4 = null;
                                if (dispatch_done) return bl;
                                break block7;
                            }
                            if (this._key != null) {
                                this._key.cancel();
                                this._key.attach(null);
                                this._key = null;
                            }
                            ((SelectableChannel)((Object)this.getChannel())).configureBlocking(true);
                            this._dispatched = true;
                        }
                        dispatch_done = SelectBlockingChannelConnector.this.getThreadPool().dispatch(this);
                        break block8;
                    }
                    catch (Throwable throwable) {
                        Object var6_6 = null;
                        if (dispatch_done) throw throwable;
                        log.warn("dispatch failed");
                        this.undispatch();
                        throw throwable;
                    }
                }
                log.warn("dispatch failed");
                this.undispatch();
                return bl;
            }
            Object var6_5 = null;
            if (dispatch_done) return true;
            log.warn("dispatch failed");
            this.undispatch();
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void undispatch() throws IOException {
            HttpEndPoint httpEndPoint = this;
            synchronized (httpEndPoint) {
                this._dispatched = false;
                ArrayList arrayList = SelectBlockingChannelConnector.this._unDispatched;
                synchronized (arrayList) {
                    SelectBlockingChannelConnector.this._unDispatched.add(this);
                }
            }
            SelectBlockingChannelConnector.this._selector.wakeup();
        }

        public int fill(Buffer buffer) throws IOException {
            int l = super.fill(buffer);
            if (l < 0) {
                this.getChannel().close();
            }
            return l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            HttpEndPoint httpEndPoint;
            try {
                this._connection.handle();
                Object var4_1 = null;
                httpEndPoint = this;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                HttpEndPoint httpEndPoint2 = this;
                synchronized (httpEndPoint2) {
                    try {
                        this.undispatch();
                    }
                    catch (Exception e2) {
                        log.warn("EXCEPTION ", (Throwable)e2);
                    }
                }
                throw throwable;
            }
            synchronized (httpEndPoint) {
                try {
                    this.undispatch();
                }
                catch (Exception e2) {
                    log.warn("EXCEPTION ", (Throwable)e2);
                }
            }
            {
                catch (ClosedChannelException e) {
                    log.debug("handle", (Throwable)e);
                    Object var4_2 = null;
                    HttpEndPoint httpEndPoint3 = this;
                    synchronized (httpEndPoint3) {
                        try {
                            this.undispatch();
                        }
                        catch (Exception e2) {
                            log.warn("EXCEPTION ", (Throwable)e2);
                        }
                    }
                }
                catch (IOException e) {
                    if ("BAD".equals(e.getMessage())) {
                        log.warn("BAD Request");
                        log.debug("BAD", (Throwable)e);
                    } else if ("EOF".equals(e.getMessage())) {
                        log.debug("EOF", (Throwable)e);
                    } else {
                        log.warn("IO", (Throwable)e);
                    }
                    if (this._key != null) {
                        this._key.cancel();
                    }
                    this._key = null;
                    try {
                        this.close();
                    }
                    catch (IOException e2) {
                        LogSupport.ignore(log, e2);
                    }
                    Object var4_3 = null;
                    HttpEndPoint httpEndPoint4 = this;
                    synchronized (httpEndPoint4) {
                        try {
                            this.undispatch();
                        }
                        catch (Exception e2) {
                            log.warn("EXCEPTION ", (Throwable)e2);
                        }
                    }
                }
                catch (Throwable e) {
                    log.warn("handle failed", e);
                    if (this._key != null) {
                        this._key.cancel();
                    }
                    this._key = null;
                    try {
                        this.close();
                    }
                    catch (IOException e2) {
                        LogSupport.ignore(log, e2);
                    }
                    Object var4_4 = null;
                    HttpEndPoint httpEndPoint5 = this;
                    synchronized (httpEndPoint5) {
                        try {
                            this.undispatch();
                        }
                        catch (Exception e2) {
                            log.warn("EXCEPTION ", (Throwable)e2);
                        }
                    }
                }
            }
        }
    }
}

