/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.nio;

import java.io.IOException;
import java.net.Socket;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Iterator;
import org.mortbay.io.Buffer;
import org.mortbay.io.nio.ChannelEndPoint;
import org.mortbay.io.nio.NIOBuffer;
import org.mortbay.jetty.AbstractConnector;
import org.mortbay.jetty.Continuation;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.RetryRequest;
import org.mortbay.thread.Timeout;
import org.mortbay.util.LogSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectChannelConnector
extends AbstractConnector {
    private static Logger log = LoggerFactory.getLogger((Class)(class$org$mortbay$jetty$nio$SelectChannelConnector == null ? (class$org$mortbay$jetty$nio$SelectChannelConnector = SelectChannelConnector.class$("org.mortbay.jetty.nio.SelectChannelConnector")) : class$org$mortbay$jetty$nio$SelectChannelConnector));
    private transient Timeout _idleTimeout;
    private transient Timeout _retryTimeout;
    private transient ServerSocketChannel _acceptChannel;
    private transient SelectionKey _acceptKey;
    private transient Selector _selector;
    private transient ArrayList _keyChanges = new ArrayList();
    static /* synthetic */ Class class$org$mortbay$jetty$nio$SelectChannelConnector;

    protected void doStart() throws Exception {
        this._idleTimeout = new Timeout();
        this._idleTimeout.setDuration(this.getMaxIdleTime());
        this._retryTimeout = new Timeout();
        this._retryTimeout.setDuration(0L);
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
        this._idleTimeout.cancelAll();
        this._idleTimeout = null;
        this._retryTimeout.cancelAll();
        this._retryTimeout = null;
    }

    public void setMaxIdleTime(long maxIdleTime) {
        super.setMaxIdleTime(maxIdleTime);
        if (this._idleTimeout != null) {
            this._idleTimeout.setDuration(maxIdleTime);
        }
    }

    public void open() throws IOException {
        if (this._acceptChannel == null) {
            this._acceptChannel = ServerSocketChannel.open();
            this._acceptChannel.configureBlocking(false);
            this._acceptChannel.socket().bind(this.getAddress());
            this._selector = Selector.open();
            this._acceptKey = this._acceptChannel.register(this._selector, 16);
        }
    }

    public void close() throws IOException {
        if (this._acceptChannel != null) {
            this._acceptChannel.close();
        }
        this._acceptChannel = null;
        try {
            if (this._selector != null) {
                this._selector.close();
            }
        }
        catch (IOException e) {
            LogSupport.ignore(log, e);
        }
        this._selector = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept() throws IOException {
        ArrayList arrayList = this._keyChanges;
        synchronized (arrayList) {
            for (int i = 0; i < this._keyChanges.size(); ++i) {
                try {
                    HttpEndPoint c = (HttpEndPoint)this._keyChanges.get(i);
                    if (c._interestOps >= 0 && c._key != null && c._key.isValid()) {
                        c._key.interestOps(c._interestOps);
                        continue;
                    }
                    if (c._key != null && c._key.isValid()) {
                        c._key.cancel();
                    }
                    c._key = null;
                    continue;
                }
                catch (CancelledKeyException e) {
                    log.warn("???", (Throwable)e);
                }
            }
            this._keyChanges.clear();
        }
        long wait = this.getMaxIdleTime();
        long to_next = this._idleTimeout.getTimeToNext();
        if (wait < 0L || to_next >= 0L && wait > to_next) {
            wait = to_next;
        }
        to_next = this._retryTimeout.getTimeToNext();
        if (wait < 0L || to_next >= 0L && wait > to_next) {
            wait = to_next;
        }
        if (wait > 0L) {
            this._selector.select(wait);
        } else if (wait == 0L) {
            this._selector.selectNow();
        } else {
            this._selector.select();
        }
        long now = System.currentTimeMillis();
        this._idleTimeout.setNow(now);
        this._retryTimeout.setNow(now);
        Iterator<SelectionKey> iter = this._selector.selectedKeys().iterator();
        while (iter.hasNext()) {
            SelectionKey key = iter.next();
            iter.remove();
            try {
                HttpEndPoint connection;
                if (!key.isValid()) {
                    key.cancel();
                    connection = (HttpEndPoint)key.attachment();
                    if (connection == null) continue;
                    connection._key = null;
                    continue;
                }
                if (key.equals(this._acceptKey)) {
                    if (key.isAcceptable()) {
                        SocketChannel channel = this._acceptChannel.accept();
                        channel.configureBlocking(false);
                        Socket socket = channel.socket();
                        this.configure(socket);
                        SelectionKey cKey = channel.register(this._selector, 1);
                        HttpEndPoint connection2 = new HttpEndPoint(channel);
                        connection2.setKey(cKey);
                        connection2.dispatch();
                    }
                } else {
                    connection = (HttpEndPoint)key.attachment();
                    if (connection != null) {
                        connection.dispatch();
                    }
                }
                key = null;
            }
            catch (Exception e) {
                if (this.isRunning()) {
                    log.warn("selector", (Throwable)e);
                }
                if (key == null || key == this._acceptKey) continue;
                key.interestOps(0);
            }
        }
        now = System.currentTimeMillis();
        this._retryTimeout.setNow(now);
        this._retryTimeout.tick();
        this._idleTimeout.setNow(now);
        this._idleTimeout.tick();
    }

    protected Buffer newBuffer(int size) {
        return new NIOBuffer(size, true);
    }

    public Continuation newContinuation() {
        return new RetryContinuation();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class RetryContinuation
    extends Timeout.Task
    implements Continuation {
        Object _object;
        HttpEndPoint _endPoint;
        long _timeout;

        private RetryContinuation() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setEndPoint(HttpEndPoint ep) {
            RetryContinuation retryContinuation = this;
            synchronized (retryContinuation) {
                this._endPoint = ep;
                if (this._object != null) {
                    this.redispatch();
                }
            }
        }

        long getTimeout() {
            return this._timeout;
        }

        public void expire() {
            this.redispatch();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getObject(long timeout) {
            RetryContinuation retryContinuation = this;
            synchronized (retryContinuation) {
                if (!this.isExpired() && this._object == null && timeout > 0L) {
                    if (this._endPoint != null) {
                        throw new IllegalStateException();
                    }
                    this._timeout = timeout;
                    throw new RetryRequest();
                }
            }
            return this._object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resume(Object object) {
            RetryContinuation retryContinuation = this;
            synchronized (retryContinuation) {
                Object object2 = this._object = object == null ? this : object;
                if (this._endPoint != null) {
                    this.redispatch();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void redispatch() {
            boolean dispatch_done = false;
            try {
                dispatch_done = SelectChannelConnector.this.getThreadPool().dispatch(this._endPoint);
                Object var3_2 = null;
                if (dispatch_done) return;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (dispatch_done) throw throwable;
                log.warn("dispatch failed");
                this._endPoint.undispatch();
                throw throwable;
            }
            log.warn("dispatch failed");
            this._endPoint.undispatch();
        }
    }

    private class HttpEndPoint
    extends ChannelEndPoint
    implements Runnable {
        boolean _dispatched = false;
        boolean _writable = true;
        SelectionKey _key;
        HttpConnection _connection;
        int _interestOps;
        int _readBlocked;
        int _writeBlocked;
        IdleTask _timeoutTask = new IdleTask();

        HttpEndPoint(SocketChannel channel) {
            super(channel);
            this._connection = new HttpConnection(SelectChannelConnector.this, this, SelectChannelConnector.this.getHandler());
            this._timeoutTask.schedule(SelectChannelConnector.this._idleTimeout);
        }

        void setKey(SelectionKey key) {
            this._key = key;
            this._key.attach(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        void dispatch() throws IOException {
            HttpEndPoint httpEndPoint = this;
            synchronized (httpEndPoint) {
                this._timeoutTask.reschedule();
                if (this._readBlocked > 0 || this._writeBlocked > 0) {
                    this.notifyAll();
                    this._key.interestOps(0);
                    return;
                }
                if (this._dispatched) {
                    this._key.interestOps(0);
                    return;
                }
                if ((this._key.readyOps() | 4) != 0 && (this._key.interestOps() | 4) != 0) {
                    this._interestOps = this._key.interestOps() & 0xFFFFFFFB;
                    this._key.interestOps(this._interestOps);
                }
                this._dispatched = true;
            }
            boolean dispatch_done = false;
            try {
                dispatch_done = SelectChannelConnector.this.getThreadPool().dispatch(this);
                Object var4_4 = null;
                if (dispatch_done) return;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                if (dispatch_done) throw throwable;
                log.warn("dispatch failed");
                this.undispatch();
                throw throwable;
            }
            log.warn("dispatch failed");
            this.undispatch();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void undispatch() {
            try {
                this._dispatched = false;
                if (this.getChannel().isOpen()) {
                    this.updateKey();
                }
            }
            catch (Exception e) {
                log.error("???", (Throwable)e);
                this._interestOps = -1;
                ArrayList arrayList = SelectChannelConnector.this._keyChanges;
                synchronized (arrayList) {
                    SelectChannelConnector.this._keyChanges.add(this);
                }
            }
        }

        public int fill(Buffer buffer) throws IOException {
            int l = super.fill(buffer);
            if (l < 0) {
                this.getChannel().close();
            }
            return l;
        }

        public int flush(Buffer header, Buffer buffer, Buffer trailer) throws IOException {
            int l = super.flush(header, buffer, trailer);
            this._writable = l > 0;
            return l;
        }

        public int flush(Buffer buffer) throws IOException {
            int l = super.flush(buffer);
            this._writable = l > 0;
            return l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void blockReadable(long timeoutMs) {
            HttpEndPoint httpEndPoint = this;
            synchronized (httpEndPoint) {
                if (this.getChannel().isOpen() && this._key.isValid()) {
                    try {
                        ++this._readBlocked;
                        this.updateKey();
                        this.wait(timeoutMs);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    finally {
                        --this._readBlocked;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void blockWritable(long timeoutMs) {
            HttpEndPoint httpEndPoint = this;
            synchronized (httpEndPoint) {
                if (this.getChannel().isOpen() && this._key.isValid()) {
                    try {
                        ++this._writeBlocked;
                        this.updateKey();
                        this.wait(timeoutMs);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    finally {
                        --this._writeBlocked;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateKey() {
            HttpEndPoint httpEndPoint = this;
            synchronized (httpEndPoint) {
                int ops = this._key == null ? 0 : this._key.interestOps();
                this._interestOps = ops | (!this._dispatched || this._readBlocked > 0 ? 1 : 0) | (!this._writable || this._writeBlocked > 0 ? 4 : 0);
                this._writable = true;
                if (this._interestOps != ops) {
                    ArrayList arrayList = SelectChannelConnector.this._keyChanges;
                    synchronized (arrayList) {
                        SelectChannelConnector.this._keyChanges.add(this);
                    }
                    SelectChannelConnector.this._selector.wakeup();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            HttpEndPoint httpEndPoint;
            try {
                try {
                    this._connection.handle();
                }
                catch (ClosedChannelException e) {
                    log.debug("handle", (Throwable)e);
                    Object var4_2 = null;
                    HttpEndPoint httpEndPoint3 = this;
                    synchronized (httpEndPoint3) {
                        RetryContinuation continuation = (RetryContinuation)this._connection.getRequest().getContinuation();
                        if (continuation != null && continuation.getObject(0L) == null) {
                            log.debug("continuation {}", (Object)continuation);
                            long timeout = continuation.getTimeout();
                            continuation.setEndPoint(this);
                            SelectChannelConnector.this._retryTimeout.schedule(continuation, timeout);
                            SelectChannelConnector.this._selector.wakeup();
                        } else {
                            this.undispatch();
                        }
                        return;
                    }
                }
                catch (IOException e) {
                    if ("BAD".equals(e.getMessage())) {
                        log.warn("BAD Request");
                        log.debug("BAD", (Throwable)e);
                    } else if ("EOF".equals(e.getMessage())) {
                        log.debug("EOF", (Throwable)e);
                    } else {
                        log.warn("IO", (Throwable)e);
                    }
                    if (this._key != null) {
                        this._key.cancel();
                    }
                    this._key = null;
                    try {
                        this.close();
                    }
                    catch (IOException e2) {
                        LogSupport.ignore(log, e2);
                    }
                    Object var4_3 = null;
                    HttpEndPoint httpEndPoint4 = this;
                    synchronized (httpEndPoint4) {
                        RetryContinuation continuation = (RetryContinuation)this._connection.getRequest().getContinuation();
                        if (continuation != null && continuation.getObject(0L) == null) {
                            log.debug("continuation {}", (Object)continuation);
                            long timeout = continuation.getTimeout();
                            continuation.setEndPoint(this);
                            SelectChannelConnector.this._retryTimeout.schedule(continuation, timeout);
                            SelectChannelConnector.this._selector.wakeup();
                        } else {
                            this.undispatch();
                        }
                        return;
                    }
                }
                catch (Throwable e) {
                    log.warn("handle failed", e);
                    if (this._key != null) {
                        this._key.cancel();
                    }
                    this._key = null;
                    try {
                        this.close();
                    }
                    catch (IOException e2) {
                        LogSupport.ignore(log, e2);
                    }
                    Object var4_4 = null;
                    HttpEndPoint httpEndPoint5 = this;
                    synchronized (httpEndPoint5) {
                        RetryContinuation continuation = (RetryContinuation)this._connection.getRequest().getContinuation();
                        if (continuation != null && continuation.getObject(0L) == null) {
                            log.debug("continuation {}", (Object)continuation);
                            long timeout = continuation.getTimeout();
                            continuation.setEndPoint(this);
                            SelectChannelConnector.this._retryTimeout.schedule(continuation, timeout);
                            SelectChannelConnector.this._selector.wakeup();
                        } else {
                            this.undispatch();
                        }
                        return;
                    }
                }
                Object var4_1 = null;
                httpEndPoint = this;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                HttpEndPoint httpEndPoint2 = this;
                synchronized (httpEndPoint2) {
                    RetryContinuation continuation = (RetryContinuation)this._connection.getRequest().getContinuation();
                    if (continuation != null && continuation.getObject(0L) == null) {
                        log.debug("continuation {}", (Object)continuation);
                        long timeout = continuation.getTimeout();
                        continuation.setEndPoint(this);
                        SelectChannelConnector.this._retryTimeout.schedule(continuation, timeout);
                        SelectChannelConnector.this._selector.wakeup();
                    } else {
                        this.undispatch();
                    }
                    throw throwable;
                }
            }
            synchronized (httpEndPoint) {
                RetryContinuation continuation = (RetryContinuation)this._connection.getRequest().getContinuation();
                if (continuation != null && continuation.getObject(0L) == null) {
                    log.debug("continuation {}", (Object)continuation);
                    long timeout = continuation.getTimeout();
                    continuation.setEndPoint(this);
                    SelectChannelConnector.this._retryTimeout.schedule(continuation, timeout);
                    SelectChannelConnector.this._selector.wakeup();
                } else {
                    this.undispatch();
                }
                return;
            }
        }

        public String toString() {
            return "HEP[d=" + this._dispatched + ",io=" + this._interestOps + ",w=" + this._writable + ",b=" + this._readBlocked + "|" + this._writeBlocked + "]";
        }

        private class IdleTask
        extends Timeout.Task {
            private IdleTask() {
            }

            public void expire() {
                try {
                    HttpEndPoint.this.close();
                }
                catch (IOException e) {
                    LogSupport.ignore(log, e);
                }
            }

            public String toString() {
                return "TimeoutTask:" + HttpEndPoint.this.toString();
            }
        }
    }
}

