/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestListener;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.RetryRequest;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.handler.WrappedHandler;
import org.mortbay.jetty.servlet.Dispatcher;
import org.mortbay.jetty.servlet.FilterHolder;
import org.mortbay.jetty.servlet.FilterMapping;
import org.mortbay.jetty.servlet.Holder;
import org.mortbay.jetty.servlet.PathMap;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.servlet.ServletMapping;
import org.mortbay.thread.AbstractLifeCycle;
import org.mortbay.util.LazyList;
import org.mortbay.util.LogSupport;
import org.mortbay.util.MultiException;
import org.mortbay.util.MultiMap;
import org.mortbay.util.URIUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletHandler
extends WrappedHandler {
    private static String __AllowString = "GET, HEAD, POST, OPTIONS, TRACE";
    public static final String __DEFAULT_SERVLET = "default";
    public static final String __J_S_CONTEXT_TEMPDIR = "javax.servlet.context.tempdir";
    public static final String __J_S_ERROR_EXCEPTION = "javax.servlet.error.exception";
    public static final String __J_S_ERROR_EXCEPTION_TYPE = "javax.servlet.error.exception_type";
    public static final String __J_S_ERROR_MESSAGE = "javax.servlet.error.message";
    public static final String __J_S_ERROR_REQUEST_URI = "javax.servlet.error.request_uri";
    public static final String __J_S_ERROR_SERVLET_NAME = "javax.servlet.error.servlet_name";
    public static final String __J_S_ERROR_STATUS_CODE = "javax.servlet.error.status_code";
    private static final boolean __Slosh2Slash = File.separatorChar == '\\';
    private static Logger log = LoggerFactory.getLogger((Class)(class$org$mortbay$jetty$servlet$ServletHolder == null ? (class$org$mortbay$jetty$servlet$ServletHolder = ServletHandler.class$("org.mortbay.jetty.servlet.ServletHolder")) : class$org$mortbay$jetty$servlet$ServletHolder));
    private ContextHandler _contextHandler;
    private ContextHandler.Context _servletContext;
    private FilterHolder[] _filters;
    private FilterMapping[] _filterMappings;
    private boolean _filterChainsCached = true;
    private ServletHolder[] _servlets;
    private ServletMapping[] _servletMappings;
    private Logger _contextLog;
    private boolean _initializeAtStart = true;
    private transient Map _filterNameMap;
    private transient List _filterPathMappings;
    private transient MultiMap _filterNameMappings;
    private transient Map _servletNameMap;
    private transient PathMap _servletPathMap;
    protected transient HashMap[] _chainCache;
    protected transient HashMap[] _namedChainCache;
    private Object _requestAttributeListeners;
    private Object _contextAttributeListeners;
    private Object _requestListeners;
    static /* synthetic */ Class class$org$mortbay$jetty$servlet$ServletHolder;

    protected synchronized void doStart() throws Exception {
        this._servletContext = ContextHandler.getCurrentContext();
        this._contextHandler = this._servletContext.getContextHandler();
        this._contextLog = LoggerFactory.getLogger((String)this._servletContext.getServletContextName());
        if (this._contextLog == null) {
            this._contextLog = log;
        }
        this.updateMappings();
        if (this.isInitializeAtStart()) {
            this.initialize();
        }
        if (this._filterChainsCached && this._filters != null && this._filters.length > 0) {
            this._chainCache = new HashMap[]{null, new HashMap(), new HashMap(), null, new HashMap(), null, null, null, new HashMap()};
            this._namedChainCache = new HashMap[]{null, null, new HashMap(), null, new HashMap(), null, null, null, new HashMap()};
        }
        super.doStart();
    }

    protected synchronized void doStop() throws Exception {
        int i;
        super.doStop();
        if (this._filters != null) {
            i = this._filters.length;
            while (i-- > 0) {
                try {
                    this._filters[i].stop();
                }
                catch (Exception e) {
                    log.warn("EXCEPTION ", (Throwable)e);
                }
            }
        }
        if (this._servlets != null) {
            i = this._servlets.length;
            while (i-- > 0) {
                try {
                    this._servlets[i].stop();
                }
                catch (Exception e) {
                    log.warn("EXCEPTION ", (Throwable)e);
                }
            }
        }
        this._filterNameMap = null;
        this._filterPathMappings = null;
        this._filterNameMappings = null;
        this._servletNameMap = null;
        this._servletPathMap = null;
        this._chainCache = null;
        this._namedChainCache = null;
    }

    public Logger getContextLog() {
        return this._contextLog;
    }

    public FilterMapping[] getFilterMappings() {
        return this._filterMappings;
    }

    public FilterHolder[] getFilters() {
        return this._filters;
    }

    private Map.Entry getHolderEntry(String pathInContext) {
        return this._servletPathMap.getMatch(pathInContext);
    }

    public RequestDispatcher getRequestDispatcher(String uriInContext) {
        if (uriInContext == null) {
            return null;
        }
        if (!uriInContext.startsWith("/")) {
            return null;
        }
        try {
            String query = null;
            int q = 0;
            q = uriInContext.indexOf(63);
            if (q > 0) {
                query = uriInContext.substring(q + 1);
                uriInContext = uriInContext.substring(0, q);
            }
            if ((q = uriInContext.indexOf(59)) > 0) {
                uriInContext = uriInContext.substring(0, q);
            }
            String pathInContext = URIUtil.canonicalPath(URIUtil.decodePath(uriInContext));
            String uri = URIUtil.addPaths(this._contextHandler.getContextPath(), uriInContext);
            return new Dispatcher(this._contextHandler, uri, pathInContext, query);
        }
        catch (Exception e) {
            LogSupport.ignore(log, e);
            return null;
        }
    }

    public ServletContext getServletContext() {
        return this._servletContext;
    }

    public ServletMapping[] getServletMappings() {
        return this._servletMappings;
    }

    public ServletHolder[] getServlets() {
        return this._servlets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handle(String target, HttpServletRequest request, HttpServletResponse response, int type) throws IOException {
        block37: {
            if (!this.isStarted()) {
                return false;
            }
            Request base_request = request instanceof Request ? (Request)request : HttpConnection.getCurrentConnection().getRequest();
            String old_servlet_path = null;
            String old_path_info = null;
            try {
                block36: {
                    try {
                        old_servlet_path = base_request.getServletPath();
                        old_path_info = base_request.getPathInfo();
                        ServletHolder servlet_holder = null;
                        FilterChain chain = null;
                        if (target.startsWith("/")) {
                            Map.Entry map = this.getHolderEntry(target);
                            if (map != null) {
                                servlet_holder = (ServletHolder)map.getValue();
                                if (log.isDebugEnabled()) {
                                    log.debug("servlet=" + servlet_holder);
                                }
                                String servlet_path_spec = (String)map.getKey();
                                String servlet_path = PathMap.pathMatch(servlet_path_spec, target);
                                String path_info = PathMap.pathInfo(servlet_path_spec, target);
                                if (type == 4) {
                                    base_request.setAttribute("javax.servlet.forward.servlet_path", servlet_path);
                                    base_request.setAttribute("javax.servlet.include.path_info", path_info);
                                } else {
                                    base_request.setServletPath(servlet_path);
                                    base_request.setPathInfo(path_info);
                                }
                                if (servlet_holder != null && this._filterMappings != null && this._filterMappings.length > 0) {
                                    chain = this.getChainForPath(type, target, servlet_holder);
                                }
                            }
                        } else {
                            servlet_holder = (ServletHolder)this._servletNameMap.get(target);
                            if (servlet_holder != null && this._filterMappings != null && this._filterMappings.length > 0) {
                                chain = this.getChainForName(type, servlet_holder);
                            }
                        }
                        if (log.isDebugEnabled()) {
                            log.debug("chain=" + chain);
                            log.debug("servelet holder=" + servlet_holder);
                        }
                        if (chain != null) {
                            chain.doFilter((ServletRequest)request, (ServletResponse)response);
                            break block36;
                        }
                        if (servlet_holder != null) {
                            servlet_holder.handle((ServletRequest)request, (ServletResponse)response);
                            break block36;
                        }
                        this.notFound(request, response);
                    }
                    catch (RetryRequest e) {
                        throw e;
                    }
                    catch (Exception e) {
                        Throwable cause;
                        log.debug("EXCEPTION ", (Throwable)e);
                        Throwable th = e;
                        while (th instanceof ServletException && (cause = ((ServletException)th).getRootCause()) != th && cause != null) {
                            th = cause;
                        }
                        if (log.isDebugEnabled() || !(th instanceof IOException)) {
                            this._contextLog.warn(request.getRequestURI() + ": ", th);
                            if (log.isDebugEnabled()) {
                                log.warn(request.getRequestURI() + ": ", th);
                                log.debug(request.toString());
                            }
                        }
                        if (!response.isCommitted()) {
                            request.setAttribute(__J_S_ERROR_EXCEPTION_TYPE, th.getClass());
                            request.setAttribute(__J_S_ERROR_EXCEPTION, (Object)th);
                            if (th instanceof UnavailableException) {
                                UnavailableException ue = (UnavailableException)th;
                                if (ue.isPermanent()) {
                                    response.sendError(404, e.getMessage());
                                } else {
                                    response.sendError(503, e.getMessage());
                                }
                            } else {
                                response.sendError(500, e.getMessage());
                            }
                        } else if (log.isDebugEnabled()) {
                            log.debug("Response already committed for handling " + th);
                        }
                        Object var15_20 = null;
                        if (type != 4) {
                            base_request.setServletPath(old_servlet_path);
                        }
                        base_request.setPathInfo(old_path_info);
                        break block37;
                    }
                    catch (Error e) {
                        log.warn("Error for " + request.getRequestURI(), (Throwable)e);
                        if (log.isDebugEnabled()) {
                            log.debug(request.toString());
                        }
                        if (!response.isCommitted()) {
                            request.setAttribute(__J_S_ERROR_EXCEPTION_TYPE, e.getClass());
                            request.setAttribute(__J_S_ERROR_EXCEPTION, (Object)e);
                            response.sendError(500, e.getMessage());
                        } else if (log.isDebugEnabled()) {
                            log.debug("Response already committed for handling ", (Throwable)e);
                        }
                        Object var15_21 = null;
                        if (type != 4) {
                            base_request.setServletPath(old_servlet_path);
                        }
                        base_request.setPathInfo(old_path_info);
                    }
                }
                Object var15_19 = null;
                if (type != 4) {
                    base_request.setServletPath(old_servlet_path);
                }
                base_request.setPathInfo(old_path_info);
            }
            catch (Throwable throwable) {
                Object var15_22 = null;
                if (type != 4) {
                    base_request.setServletPath(old_servlet_path);
                }
                base_request.setPathInfo(old_path_info);
                throw throwable;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FilterChain getChainForName(int requestType, ServletHolder servletHolder) {
        if (servletHolder == null) {
            throw new IllegalStateException("Named dispatch must be to an explicitly named servlet");
        }
        if (this._filterChainsCached) {
            ServletHandler servletHandler = this;
            synchronized (servletHandler) {
                if (this._namedChainCache[requestType].containsKey(servletHolder.getName())) {
                    return (FilterChain)this._namedChainCache[requestType].get(servletHolder.getName());
                }
            }
        }
        Object filters = null;
        if (this._filterNameMappings.size() > 0) {
            Object o = this._filterNameMappings.get(servletHolder.getName());
            for (int i = 0; i < LazyList.size(o); ++i) {
                FilterMapping mapping = (FilterMapping)LazyList.get(o, i);
                if (!mapping.appliesTo(null, requestType)) continue;
                filters = LazyList.add(filters, mapping.getFilterHolder());
            }
        }
        Object chain = null;
        if (this._filterChainsCached) {
            ServletHandler servletHandler = this;
            synchronized (servletHandler) {
                if (LazyList.size(filters) > 0) {
                    chain = new CachedChain(filters, servletHolder);
                }
                this._namedChainCache[requestType].put(servletHolder.getName(), chain);
            }
        } else if (LazyList.size(filters) > 0) {
            chain = new Chain(filters, servletHolder);
        }
        return chain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FilterChain getChainForPath(int requestType, String pathInContext, ServletHolder servletHolder) {
        if (this._filterChainsCached && this._chainCache != null) {
            ServletHandler servletHandler = this;
            synchronized (servletHandler) {
                if (this._chainCache[requestType].containsKey(pathInContext)) {
                    return (FilterChain)this._chainCache[requestType].get(pathInContext);
                }
            }
        }
        Object filters = null;
        if (this._filterPathMappings != null) {
            for (int i = 0; i < this._filterPathMappings.size(); ++i) {
                FilterMapping mapping = (FilterMapping)this._filterPathMappings.get(i);
                if (!mapping.appliesTo(pathInContext, requestType)) continue;
                filters = LazyList.add(filters, mapping.getFilterHolder());
            }
        }
        if (servletHolder != null && this._filterNameMappings != null && this._filterNameMappings.size() > 0) {
            Object o = this._filterNameMappings.get(servletHolder.getName());
            for (int i = 0; i < LazyList.size(o); ++i) {
                FilterMapping mapping = (FilterMapping)LazyList.get(o, i);
                if (!mapping.appliesTo(null, requestType)) continue;
                filters = LazyList.add(filters, mapping.getFilterHolder());
            }
        }
        if (filters == null) {
            return null;
        }
        Object chain = null;
        if (this._filterChainsCached) {
            ServletHandler servletHandler = this;
            synchronized (servletHandler) {
                if (LazyList.size(filters) > 0) {
                    chain = new CachedChain(filters, servletHolder);
                }
                this._chainCache[requestType].put(pathInContext, chain);
            }
        } else if (LazyList.size(filters) > 0) {
            chain = new Chain(filters, servletHolder);
        }
        return chain;
    }

    public boolean isInitializeAtStart() {
        return this._initializeAtStart;
    }

    public void setInitializeAtStart(boolean initializeAtStart) {
        this._initializeAtStart = initializeAtStart;
    }

    public void initialize() throws Exception {
        MultiException mx = new MultiException();
        if (this._filters != null) {
            int i = this._filters.length;
            while (i-- > 0) {
                this._filters[i].start();
            }
        }
        if (this._servlets != null) {
            Object[] servlets = (ServletHolder[])this._servlets.clone();
            Arrays.sort(servlets);
            for (int i = 0; i < servlets.length; ++i) {
                try {
                    ((AbstractLifeCycle)servlets[i]).start();
                    continue;
                }
                catch (Exception e) {
                    log.debug("EXCEPTION ", (Throwable)e);
                    mx.add(e);
                }
            }
            mx.ifExceptionThrow();
        }
    }

    public boolean isFilterChainsCached() {
        return this._filterChainsCached;
    }

    protected synchronized void updateMappings() {
        int i;
        HashMap<String, Holder> nm;
        if (this._servlets == null) {
            this._servletNameMap = null;
        } else {
            nm = new HashMap<String, Holder>();
            for (i = 0; i < this._servlets.length; ++i) {
                nm.put(this._servlets[i].getName(), this._servlets[i]);
                this._servlets[i].setServletHandler(this);
            }
            this._servletNameMap = nm;
        }
        if (this._servletMappings == null || this._servletNameMap == null) {
            this._servletPathMap = null;
        } else {
            PathMap pm = new PathMap();
            for (i = 0; i < this._servletMappings.length; ++i) {
                ServletHolder servlet_holder = (ServletHolder)this._servletNameMap.get(this._servletMappings[i].getServletName());
                if (servlet_holder == null) {
                    throw new IllegalStateException("No such servlet: " + this._servletMappings[i].getServletName());
                }
                if (this._servletMappings[i].getPathSpec() == null) continue;
                pm.put(this._servletMappings[i].getPathSpec(), servlet_holder);
            }
            this._servletPathMap = pm;
        }
        if (this._filters == null) {
            this._filterNameMap = null;
        } else {
            nm = new HashMap();
            for (i = 0; i < this._filters.length; ++i) {
                nm.put(this._filters[i].getName(), this._filters[i]);
                this._filters[i].setServletHandler(this);
            }
            this._filterNameMap = nm;
        }
        if (this._filterMappings == null) {
            this._filterPathMappings = null;
            this._filterNameMappings = null;
        } else {
            this._filterPathMappings = new ArrayList();
            this._filterNameMappings = new MultiMap();
            for (int i2 = 0; i2 < this._filterMappings.length; ++i2) {
                FilterHolder holder = (FilterHolder)this._filterNameMap.get(this._filterMappings[i2].getFilterName());
                if (holder == null) {
                    throw new IllegalStateException("No filter named " + this._filterMappings[i2].getFilterName());
                }
                this._filterMappings[i2].setFilterHolder(holder);
                if (this._filterMappings[i2].getPathSpec() != null) {
                    this._filterPathMappings.add(this._filterMappings[i2]);
                    continue;
                }
                if (this._filterMappings[i2].getServletName() == null) continue;
                this._filterNameMappings.add(this._filterMappings[i2].getServletName(), holder);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("filterNameMap=" + this._filterNameMap);
            log.debug("pathFilters=" + this._filterPathMappings);
            log.debug("servletFilterMap=" + this._filterNameMappings);
            log.debug("servletPathMap=" + this._servletPathMap);
            log.debug("servletNameMap=" + this._servletNameMap);
        }
        try {
            if (this.isStarted()) {
                this.initialize();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void notFound(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("Not Found " + request.getRequestURI());
        }
        response.sendError(404);
    }

    public void setContextLog(Logger contextLog) {
        this._contextLog = contextLog;
    }

    public void setFilterChainsCached(boolean filterChainsCached) {
        this._filterChainsCached = filterChainsCached;
    }

    public void setFilterMappings(FilterMapping[] filterMappings) {
        this._filterMappings = (FilterMapping[])filterMappings.clone();
        if (this.isStarted()) {
            this.updateMappings();
        }
    }

    public synchronized void setFilters(FilterHolder[] holders) {
        this._filters = (FilterHolder[])holders.clone();
    }

    public void setServletMappings(ServletMapping[] servletMappings) {
        this._servletMappings = servletMappings;
        if (this.isStarted()) {
            this.updateMappings();
        }
    }

    public synchronized void setServlets(ServletHolder[] holders) {
        this._servlets = (ServletHolder[])holders.clone();
        this.updateMappings();
    }

    public void addEventListener(EventListener listener) {
        if (listener instanceof ServletRequestAttributeListener) {
            this._requestAttributeListeners = LazyList.add(this._requestAttributeListeners, listener);
        }
        if (listener instanceof ServletContextAttributeListener) {
            this._contextAttributeListeners = LazyList.add(this._contextAttributeListeners, listener);
        }
        if (listener instanceof ServletRequestListener) {
            this._requestListeners = LazyList.add(this._requestListeners, listener);
        }
        if (listener instanceof ServletRequestAttributeListener) {
            this._requestAttributeListeners = LazyList.add(this._requestAttributeListeners, listener);
        }
        if (listener instanceof ServletContextAttributeListener) {
            this._contextAttributeListeners = LazyList.add(this._contextAttributeListeners, listener);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class Chain
    implements FilterChain {
        int _filter = 0;
        Object _filters;
        ServletHolder _servletHolder;

        Chain(Object filters, ServletHolder servletHolder) {
            this._filters = filters;
            this._servletHolder = servletHolder;
        }

        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            if (log.isDebugEnabled()) {
                log.debug("doFilter " + this._filter);
            }
            if (this._filter < LazyList.size(this._filters)) {
                FilterHolder holder = (FilterHolder)LazyList.get(this._filters, this._filter++);
                if (log.isDebugEnabled()) {
                    log.debug("call filter " + holder);
                }
                Filter filter = holder.getFilter();
                filter.doFilter(request, response, (FilterChain)this);
                return;
            }
            if (this._servletHolder != null) {
                if (log.isDebugEnabled()) {
                    log.debug("call servlet " + this._servletHolder);
                }
                this._servletHolder.handle(request, response);
            } else {
                ServletHandler.this.notFound((HttpServletRequest)request, (HttpServletResponse)response);
            }
        }

        public String toString() {
            StringBuffer b = new StringBuffer();
            for (int i = 0; i < LazyList.size(this._filters); ++i) {
                b.append(LazyList.get(this._filters, i).toString());
                b.append("->");
            }
            b.append(this._servletHolder);
            return b.toString();
        }
    }

    private class CachedChain
    implements FilterChain {
        FilterHolder _filterHolder;
        CachedChain _next;
        ServletHolder _servletHolder;

        CachedChain(Object filters, ServletHolder servletHolder) {
            if (LazyList.size(filters) > 0) {
                this._filterHolder = (FilterHolder)LazyList.get(filters, 0);
                filters = LazyList.remove(filters, 0);
                this._next = new CachedChain(filters, servletHolder);
            } else {
                this._servletHolder = servletHolder;
            }
        }

        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            if (this._filterHolder != null) {
                if (log.isDebugEnabled()) {
                    log.debug("call filter " + this._filterHolder);
                }
                Filter filter = this._filterHolder.getFilter();
                filter.doFilter(request, response, (FilterChain)this._next);
                return;
            }
            if (this._servletHolder != null) {
                if (log.isDebugEnabled()) {
                    log.debug("call servlet " + this._servletHolder);
                }
                this._servletHolder.handle(request, response);
            } else {
                ServletHandler.this.notFound((HttpServletRequest)request, (HttpServletResponse)response);
            }
        }

        public String toString() {
            if (this._filterHolder != null) {
                return this._filterHolder + "->" + this._next.toString();
            }
            if (this._servletHolder != null) {
                return this._servletHolder.toString();
            }
            return "null";
        }
    }
}

