/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.thread;

import java.io.Serializable;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.mortbay.thread.AbstractLifeCycle;
import org.mortbay.thread.ThreadPool;

public class BoundedThreadPool
extends AbstractLifeCycle
implements Serializable,
ThreadPool {
    private static final long serialVersionUID = 2806675379803919606L;
    private static int __id;
    private transient List _blocked;
    private int _blockMs = 10000;
    private boolean _daemon;
    private transient int _id;
    private transient int _idle;
    private final String _jobLock = "JOB";
    private transient List _jobs;
    private final String _joinLock = "JOIN";
    private int _maxIdleTimeMs = 10000;
    private int _maxThreads = 255;
    private int _minThreads = 1;
    private String _name = this.getClass().getName();
    int _priority = 5;
    private boolean _queue;
    private transient Set _threads;

    public BoundedThreadPool() {
        int dot = this._name.lastIndexOf(46);
        if (dot >= 0) {
            this._name = this._name.substring(dot + 1);
        }
        this._name = this._name + __id++;
    }

    public int getIdleThreads() {
        return this._idle;
    }

    public int getMaxIdleTimeMs() {
        return this._maxIdleTimeMs;
    }

    public int getMaxThreads() {
        return this._maxThreads;
    }

    public int getMinThreads() {
        return this._minThreads;
    }

    public String getName() {
        return this._name;
    }

    public int getThreads() {
        return this._threads.size();
    }

    public int getThreadsPriority() {
        return this._priority;
    }

    public boolean isDaemon() {
        return this._daemon;
    }

    public boolean isQueue() {
        return this._queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join() throws InterruptedException {
        String string = "JOIN";
        synchronized ("JOIN") {
            while (this.isRunning()) {
                "JOIN".wait(this.getMaxIdleTimeMs());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void newThread() {
        String string = "JOB";
        synchronized ("JOB") {
            PoolThread thread = new PoolThread();
            this._threads.add(thread);
            ++this._idle;
            thread.setName(this._name + "-" + this._id++);
            thread.start();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public boolean dispatch(Runnable job) {
        return this.run(job, this._queue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean run(Runnable job, boolean queue) {
        boolean queued = false;
        String string = "JOB";
        synchronized ("JOB") {
            if (!this.isRunning()) {
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return false;
            }
            int blockMs = this._blockMs;
            while (this._idle - this._jobs.size() <= 0) {
                if (this._threads.size() < this._maxThreads) {
                    this.newThread();
                    break;
                }
                if (queue) break;
                if (blockMs < 0) {
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return false;
                }
                try {
                    this._blocked.add(Thread.currentThread());
                    "JOB".wait(blockMs);
                    blockMs = -1;
                }
                catch (InterruptedException ie) {}
            }
            this._jobs.add(job);
            queued = true;
            "JOB".notify();
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return queued;
        }
    }

    public void setDaemon(boolean daemon) {
        this._daemon = daemon;
    }

    public void setMaxIdleTimeMs(int maxIdleTimeMs) {
        this._maxIdleTimeMs = maxIdleTimeMs;
    }

    public void setMaxThreads(int maxThreads) {
        this._maxThreads = maxThreads;
    }

    public void setMinThreads(int minThreads) {
        this._minThreads = minThreads;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setQueue(boolean queue) {
        this._queue = queue;
    }

    public void setThreadsPriority(int priority) {
        this._priority = priority;
    }

    protected void doStart() throws Exception {
        this._threads = new HashSet();
        this._jobs = new LinkedList();
        this._blocked = new LinkedList();
        this._idle = 0;
        for (int i = 0; i < this._minThreads; ++i) {
            this.newThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws Exception {
        String string = "JOIN";
        synchronized ("JOIN") {
            "JOIN".notifyAll();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected void stopJob(Thread thread, Object job) {
        thread.interrupt();
    }

    public class PoolThread
    extends Thread {
        Runnable _job = null;

        PoolThread() {
            this.setDaemon(BoundedThreadPool.this._daemon);
            this.setPriority(BoundedThreadPool.this._priority);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            try {
                while (BoundedThreadPool.this.isRunning()) {
                    String string;
                    Object var4_3;
                    this._job = null;
                    try {
                        block25: {
                            try {
                                String string2 = "JOB";
                                // MONITORENTER : "JOB"
                                while (BoundedThreadPool.this._jobs.size() == 0 && BoundedThreadPool.this.isRunning()) {
                                    "JOB".wait();
                                }
                                if (BoundedThreadPool.this._jobs.size() > 0 && BoundedThreadPool.this.isRunning()) {
                                    this._job = (Runnable)BoundedThreadPool.this._jobs.remove(0);
                                }
                                if (this._job != null) {
                                    BoundedThreadPool.this._idle--;
                                }
                                // MONITOREXIT : string2
                                if (!BoundedThreadPool.this.isRunning() || this._job == null) break block25;
                                this._job.run();
                            }
                            catch (InterruptedException interruptedException) {
                                var4_3 = null;
                                string = "JOB";
                                // MONITORENTER : "JOB"
                                if (this._job != null) {
                                    BoundedThreadPool.this._idle++;
                                }
                                this._job = null;
                                if (BoundedThreadPool.this._blocked.size() > 0) {
                                    ((Thread)BoundedThreadPool.this._blocked.remove(0)).interrupt();
                                }
                                // MONITOREXIT : string
                                continue;
                            }
                        }
                        var4_3 = null;
                        string = "JOB";
                        // MONITORENTER : "JOB"
                        if (this._job != null) {
                            BoundedThreadPool.this._idle++;
                        }
                        this._job = null;
                        if (BoundedThreadPool.this._blocked.size() > 0) {
                            ((Thread)BoundedThreadPool.this._blocked.remove(0)).interrupt();
                        }
                        // MONITOREXIT : string
                    }
                    catch (Throwable throwable) {
                        var4_3 = null;
                        string = "JOB";
                        // MONITORENTER : "JOB"
                        if (this._job != null) {
                            BoundedThreadPool.this._idle++;
                        }
                        this._job = null;
                        if (BoundedThreadPool.this._blocked.size() > 0) {
                            ((Thread)BoundedThreadPool.this._blocked.remove(0)).interrupt();
                        }
                        // MONITOREXIT : string
                        throw throwable;
                    }
                }
                Object var8_6 = null;
                String string = "JOB";
                // MONITORENTER : "JOB"
                BoundedThreadPool.this._threads.remove(this);
                // MONITOREXIT : string
                return;
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                String string = "JOB";
                // MONITORENTER : "JOB"
                BoundedThreadPool.this._threads.remove(this);
                // MONITOREXIT : string
                throw throwable;
            }
        }
    }
}

