/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.io.bio;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mortbay.io.Buffer;
import org.mortbay.io.EndPoint;

public class StreamEndPoint
implements EndPoint {
    InputStream _in;
    OutputStream _out;

    public StreamEndPoint(InputStream in, OutputStream out) throws IOException {
        this._in = in;
        this._out = out;
    }

    public boolean isBlocking() {
        return true;
    }

    public void blockReadable(long millisecs) {
    }

    public void blockWritable(long millisecs) {
    }

    public boolean isClosed() {
        return this._in == null || this._out == null;
    }

    public void close() throws IOException {
        if (this._in != null) {
            this._in.close();
        }
        this._in = null;
        if (this._out != null) {
            this._out.close();
        }
        this._out = null;
    }

    public int fill(Buffer buffer) throws IOException {
        if (this._in == null) {
            return 0;
        }
        int space = buffer.space();
        if (space <= 0) {
            if (buffer.hasContent()) {
                return 0;
            }
            throw new IOException("FULL");
        }
        byte[] bytes = buffer.array();
        int n = this._in.read(bytes, buffer.putIndex(), space);
        if (n >= 0) {
            buffer.setPutIndex(buffer.putIndex() + n);
            return n;
        }
        return -1;
    }

    public int flush(Buffer buffer) throws IOException {
        if (this._out == null) {
            return -1;
        }
        int length = buffer.length();
        if (length > 0) {
            if (buffer.array() != null) {
                this._out.write(buffer.array(), buffer.getIndex(), length);
            } else {
                byte[] b = new byte[8192];
                while (buffer.length() > 0) {
                    int len = buffer.get(b, 0, 8192);
                    this._out.write(b, 0, len);
                }
            }
        }
        if (!buffer.isImmutable()) {
            buffer.clear();
        }
        return length;
    }

    public int flush(Buffer header, Buffer buffer, Buffer trailer) throws IOException {
        int f;
        int tw;
        int len = 0;
        if (header != null && (tw = header.length()) > 0) {
            len = f = this.flush(header);
            if (f < tw) {
                return len;
            }
        }
        if (buffer != null && (tw = buffer.length()) > 0) {
            f = this.flush(buffer);
            if (f < 0) {
                return len > 0 ? len : f;
            }
            len += f;
            if (f < tw) {
                return len;
            }
        }
        if (trailer != null && (tw = trailer.length()) > 0) {
            f = this.flush(trailer);
            if (f < 0) {
                return len > 0 ? len : f;
            }
            len += f;
        }
        return len;
    }

    public String getLocalAddr() {
        return null;
    }

    public String getLocalHost() {
        return null;
    }

    public int getLocalPort() {
        return 0;
    }

    public String getRemoteAddr() {
        return null;
    }

    public String getRemoteHost() {
        return null;
    }

    public int getRemotePort() {
        return 0;
    }

    public Object getConnection() {
        return null;
    }
}

