/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.ArrayList;
import org.mortbay.io.Buffer;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.util.Continuation;
import org.mortbay.thread.AbstractLifeCycle;
import org.mortbay.thread.ThreadPool;
import org.mortbay.util.LogSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConnector
extends AbstractLifeCycle
implements Connector {
    private static Logger log = LoggerFactory.getLogger((Class)(class$org$mortbay$jetty$AbstractConnector == null ? (class$org$mortbay$jetty$AbstractConnector = AbstractConnector.class$("org.mortbay.jetty.AbstractConnector")) : class$org$mortbay$jetty$AbstractConnector));
    private int _headerBufferSize = 2048;
    private int _requestBufferSize = 16384;
    private int _responseBufferSize = 49152;
    private ThreadPool _threadPool;
    private Handler _handler;
    private String _host;
    private int _port = 8080;
    protected long _maxIdleTime = 30000L;
    protected long _soLingerTime = 1000L;
    private transient SocketAddress _address;
    private transient ArrayList _headerBuffers;
    private transient ArrayList _requestBuffers;
    private transient ArrayList _responseBuffers;
    private transient Thread _acceptorThread;
    static /* synthetic */ Class class$org$mortbay$jetty$AbstractConnector;

    public ThreadPool getThreadPool() {
        return this._threadPool;
    }

    public void setThreadPool(ThreadPool pool) {
        this._threadPool = pool;
    }

    public void setHost(String host) {
        this._host = host;
    }

    public String getHost() {
        return this._host;
    }

    public void setPort(int port) {
        this._port = port;
    }

    public int getPort() {
        return this._port;
    }

    public SocketAddress getAddress() {
        if (this._address == null) {
            this._address = this._host == null ? new InetSocketAddress(this._port) : new InetSocketAddress(this._host, this._port);
        }
        return this._address;
    }

    public Handler getHandler() {
        return this._handler;
    }

    public void setHandler(Handler handler) {
        this._handler = handler;
    }

    public int getHeaderBufferSize() {
        return this._headerBufferSize;
    }

    public void setHeaderBufferSize(int headerBufferSize) {
        this._headerBufferSize = headerBufferSize;
    }

    public long getMaxIdleTime() {
        return this._maxIdleTime;
    }

    public void setMaxIdleTime(long maxIdleTime) {
        this._maxIdleTime = maxIdleTime;
    }

    public int getRequestBufferSize() {
        return this._requestBufferSize;
    }

    public void setRequestBufferSize(int requestBufferSize) {
        this._requestBufferSize = requestBufferSize;
    }

    public int getResponseBufferSize() {
        return this._responseBufferSize;
    }

    public void setResponseBufferSize(int responseBufferSize) {
        this._responseBufferSize = responseBufferSize;
    }

    public long getSoLingerTime() {
        return this._soLingerTime;
    }

    public void setSoLingerTime(long soLingerTime) {
        this._soLingerTime = soLingerTime;
    }

    protected void doStart() throws Exception {
        this.open();
        this._headerBuffers = new ArrayList();
        this._requestBuffers = new ArrayList();
        this._responseBuffers = new ArrayList();
        this._threadPool.dispatch(new Acceptor());
    }

    protected void doStop() throws Exception {
        if (this._acceptorThread != null) {
            this._acceptorThread.interrupt();
        }
        this._acceptorThread = null;
        this._address = null;
        if (this._headerBuffers != null) {
            this._headerBuffers.clear();
        }
        this._headerBuffers = null;
        if (this._requestBuffers != null) {
            this._requestBuffers.clear();
        }
        this._requestBuffers = null;
        if (this._responseBuffers != null) {
            this._responseBuffers.clear();
        }
        this._responseBuffers = null;
        try {
            this.close();
        }
        catch (IOException e) {
            log.warn("stop", (Throwable)e);
        }
    }

    public void join() throws InterruptedException {
        if (this._acceptorThread != null) {
            this._acceptorThread.join();
        }
    }

    protected void configure(Socket socket) throws IOException {
        try {
            socket.setTcpNoDelay(true);
            if (this._maxIdleTime >= 0L) {
                socket.setSoTimeout((int)this._maxIdleTime);
            }
            if (this._soLingerTime >= 0L) {
                socket.setSoLinger(true, (int)this._soLingerTime / 1000);
            } else {
                socket.setSoLinger(false, 0);
            }
        }
        catch (Exception e) {
            LogSupport.ignore(log, e);
        }
    }

    protected abstract Buffer newBuffer(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Buffer getBuffer(int size) {
        if (size == this._headerBufferSize) {
            ArrayList arrayList = this._headerBuffers;
            synchronized (arrayList) {
                if (this._headerBuffers.size() == 0) {
                    return this.newBuffer(size);
                }
                return (Buffer)this._headerBuffers.remove(this._headerBuffers.size() - 1);
            }
        }
        if (size == this._responseBufferSize) {
            ArrayList arrayList = this._responseBuffers;
            synchronized (arrayList) {
                if (this._responseBuffers.size() == 0) {
                    return this.newBuffer(size);
                }
                return (Buffer)this._responseBuffers.remove(this._responseBuffers.size() - 1);
            }
        }
        if (size == this._requestBufferSize) {
            ArrayList arrayList = this._requestBuffers;
            synchronized (arrayList) {
                if (this._requestBuffers.size() == 0) {
                    return this.newBuffer(size);
                }
                return (Buffer)this._requestBuffers.remove(this._headerBuffers.size() - 1);
            }
        }
        return this.newBuffer(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnBuffer(Buffer buffer) {
        buffer.clear();
        if (!buffer.isVolatile() && !buffer.isImmutable()) {
            int c = buffer.capacity();
            if (c == this._headerBufferSize) {
                ArrayList arrayList = this._headerBuffers;
                synchronized (arrayList) {
                    this._headerBuffers.add(buffer);
                }
            }
            if (c == this._responseBufferSize) {
                ArrayList arrayList = this._responseBuffers;
                synchronized (arrayList) {
                    this._responseBuffers.add(buffer);
                }
            }
            if (c == this._requestBufferSize) {
                ArrayList arrayList = this._requestBuffers;
                synchronized (arrayList) {
                    this._requestBuffers.add(buffer);
                }
            }
        }
    }

    public int getConfidentialPort() {
        return 443;
    }

    public String getConfidentialScheme() {
        return "https";
    }

    public boolean isConfidential(Request request) {
        return false;
    }

    protected abstract void accept() throws IOException, InterruptedException;

    public String toString() {
        return "Connector " + this.getHost() + ":" + this.getPort();
    }

    public Continuation newContinuation() {
        return new WaitingContinuation();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class WaitingContinuation
    implements Continuation {
        Object _object;
        Object _event;
        boolean _waited;
        boolean _new = true;
        boolean _pending = true;

        private WaitingContinuation() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resume(Object object) {
            WaitingContinuation waitingContinuation = this;
            synchronized (waitingContinuation) {
                this._event = object == null ? this : object;
                this._pending = false;
                this.notify();
            }
        }

        public boolean isNew() {
            return this._new;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getEvent(long timeout) {
            if (timeout < 0L) {
                throw new IllegalArgumentException();
            }
            WaitingContinuation waitingContinuation = this;
            synchronized (waitingContinuation) {
                this._new = false;
                try {
                    if (!this._waited && this._event == null && timeout > 0L) {
                        this._waited = true;
                        this.wait(timeout);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                this._pending = false;
            }
            return this._event;
        }

        public boolean isPending() {
            return this._pending;
        }

        public Object getObject() {
            return this._object;
        }

        public void setObject(Object object) {
            this._object = object;
        }
    }

    private class Acceptor
    implements Runnable {
        private Acceptor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            AbstractConnector.this._acceptorThread = Thread.currentThread();
            String name = AbstractConnector.this._acceptorThread.getName();
            AbstractConnector.this._acceptorThread.setName(name + " - Acceptor " + AbstractConnector.this);
            try {
                while (AbstractConnector.this.isRunning()) {
                    try {
                        AbstractConnector.this.accept();
                    }
                    catch (Exception e) {
                        log.error("select ", (Throwable)e);
                    }
                }
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                log.info("Stopping " + this);
                Thread.currentThread().setName(name);
                try {
                    AbstractConnector.this.close();
                }
                catch (IOException e) {
                    log.warn("close", (Throwable)e);
                }
                throw throwable;
            }
            log.info("Stopping " + this);
            Thread.currentThread().setName(name);
            try {
                AbstractConnector.this.close();
            }
            catch (IOException e) {
                log.warn("close", (Throwable)e);
            }
        }
    }
}

