/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.servlet.http.Cookie;
import org.mortbay.io.Buffer;
import org.mortbay.io.BufferCache;
import org.mortbay.io.BufferUtil;
import org.mortbay.io.ByteArrayBuffer;
import org.mortbay.io.View;
import org.mortbay.jetty.HttpHeaderValues;
import org.mortbay.jetty.HttpHeaders;
import org.mortbay.jetty.HttpOnlyCookie;
import org.mortbay.util.DateCache;
import org.mortbay.util.LazyList;
import org.mortbay.util.QuotedStringTokenizer;
import org.mortbay.util.StringMap;
import org.mortbay.util.StringUtil;

public class HttpFields {
    public static final String __separators = ", \t";
    private static String[] DAYS = new String[]{"Sat", "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    private static String[] MONTHS = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec", "Jan"};
    private static TimeZone __GMT = TimeZone.getTimeZone("GMT");
    public static final DateCache __dateCache = new DateCache("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
    private static final String[] __dateReceiveFmt = new String[]{"EEE, dd MMM yyyy HH:mm:ss zzz", "EEE, dd MMM yyyy HH:mm:ss", "EEE dd MMM yyyy HH:mm:ss zzz", "EEE dd MMM yyyy HH:mm:ss", "EEE MMM dd yyyy HH:mm:ss zzz", "EEE MMM dd yyyy HH:mm:ss", "EEE MMM-dd-yyyy HH:mm:ss zzz", "EEE MMM-dd-yyyy HH:mm:ss", "dd MMM yyyy HH:mm:ss zzz", "dd MMM yyyy HH:mm:ss", "dd-MMM-yy HH:mm:ss zzz", "dd-MMM-yy HH:mm:ss", "MMM dd HH:mm:ss yyyy zzz", "MMM dd HH:mm:ss yyyy", "EEE MMM dd HH:mm:ss yyyy zzz", "EEE MMM dd HH:mm:ss yyyy", "EEE, MMM dd HH:mm:ss yyyy zzz", "EEE, MMM dd HH:mm:ss yyyy", "EEE, dd-MMM-yy HH:mm:ss zzz", "EEE, dd-MMM-yy HH:mm:ss", "EEE dd-MMM-yy HH:mm:ss zzz", "EEE dd-MMM-yy HH:mm:ss"};
    public static SimpleDateFormat[] __dateReceive;
    public static final String __01Jan1970;
    public static final Buffer __01Jan1970_BUFFER;
    protected ArrayList _fields = new ArrayList(20);
    protected int _revision;
    protected HashMap _bufferMap = new HashMap(32);
    protected SimpleDateFormat[] _dateReceive = new SimpleDateFormat[__dateReceive.length];
    private StringBuffer _dateBuffer;
    private Calendar _calendar;
    private static Float __one;
    private static Float __zero;
    private static StringMap __qualities;

    public static String formatDate(long date, boolean cookie) {
        StringBuffer buf = new StringBuffer(32);
        GregorianCalendar gc = new GregorianCalendar(__GMT);
        gc.setTimeInMillis(date);
        HttpFields.formatDate(buf, gc, cookie);
        return buf.toString();
    }

    public static String formatDate(Calendar calendar, boolean cookie) {
        StringBuffer buf = new StringBuffer(32);
        HttpFields.formatDate(buf, calendar, cookie);
        return buf.toString();
    }

    public static String formatDate(StringBuffer buf, long date, boolean cookie) {
        GregorianCalendar gc = new GregorianCalendar(__GMT);
        gc.setTimeInMillis(date);
        HttpFields.formatDate(buf, gc, cookie);
        return buf.toString();
    }

    public static void formatDate(StringBuffer buf, Calendar calendar, boolean cookie) {
        int day_of_week = calendar.get(7);
        int day_of_month = calendar.get(5);
        int month = calendar.get(2);
        int year = calendar.get(1);
        int century = year / 100;
        year %= 100;
        int epoch = (int)(calendar.getTimeInMillis() / 1000L % 86400L);
        int seconds = epoch % 60;
        int minutes = (epoch /= 60) % 60;
        int hours = epoch / 60;
        buf.append(DAYS[day_of_week]);
        buf.append(',');
        buf.append(' ');
        StringUtil.append2digits(buf, day_of_month);
        if (cookie) {
            buf.append('-');
            buf.append(MONTHS[month]);
            buf.append('-');
            StringUtil.append2digits(buf, year);
        } else {
            buf.append(' ');
            buf.append(MONTHS[month]);
            buf.append(' ');
            StringUtil.append2digits(buf, century);
            StringUtil.append2digits(buf, year);
        }
        buf.append(' ');
        StringUtil.append2digits(buf, hours);
        buf.append(':');
        StringUtil.append2digits(buf, minutes);
        buf.append(':');
        StringUtil.append2digits(buf, seconds);
        buf.append(" GMT");
    }

    public Enumeration getFieldNames() {
        return new Enumeration(){
            int i = 0;
            Field field = null;

            public boolean hasMoreElements() {
                if (this.field != null) {
                    return true;
                }
                while (this.i < HttpFields.this._fields.size()) {
                    Field f;
                    if ((f = (Field)HttpFields.this._fields.get(this.i++)) == null || f._prev != null || f._revision != HttpFields.this._revision) continue;
                    this.field = f;
                    return true;
                }
                return false;
            }

            public Object nextElement() throws NoSuchElementException {
                if (this.field != null || this.hasMoreElements()) {
                    String n = this.field._name.toString();
                    this.field = null;
                    return n;
                }
                throw new NoSuchElementException();
            }
        };
    }

    public Iterator getFields() {
        return new Iterator(){
            int i = 0;
            Field field = null;

            public boolean hasNext() {
                if (this.field != null) {
                    return true;
                }
                while (this.i < HttpFields.this._fields.size()) {
                    Field f;
                    if ((f = (Field)HttpFields.this._fields.get(this.i++)) == null || f._prev != null || f._revision != HttpFields.this._revision) continue;
                    this.field = f;
                    return true;
                }
                return false;
            }

            public Object next() {
                if (this.field != null || this.hasNext()) {
                    Field f = this.field;
                    this.field = null;
                    return f;
                }
                throw new NoSuchElementException();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private Field getField(String name) {
        return (Field)this._bufferMap.get(HttpHeaders.CACHE.lookup(name));
    }

    private Field getField(Buffer name) {
        return (Field)this._bufferMap.get(name);
    }

    public boolean containsKey(Buffer name) {
        return this._bufferMap.containsKey(name);
    }

    public boolean containsKey(String name) {
        return this._bufferMap.containsKey(HttpHeaders.CACHE.lookup(name));
    }

    public String getStringField(String name) {
        Field field = this.getField(name);
        if (field != null && field._revision == this._revision) {
            return field._value.toString();
        }
        return null;
    }

    public String getStringField(Buffer name) {
        Field field = this.getField(name);
        if (field != null && field._revision == this._revision) {
            return field._value.toString();
        }
        return null;
    }

    public Buffer get(Buffer name) {
        Field field = this.getField(name);
        if (field != null && field._revision == this._revision) {
            return field._value;
        }
        return null;
    }

    public Enumeration getValues(String name) {
        Field field = this.getField(name);
        if (field == null) {
            return null;
        }
        return new Enumeration(field){
            Field f;
            private final /* synthetic */ Field val$field;
            {
                this.f = this.val$field = val$field;
            }

            public boolean hasMoreElements() {
                while (this.f != null && this.f._revision != HttpFields.this._revision) {
                    this.f = this.f._next;
                }
                return this.f != null;
            }

            public Object nextElement() throws NoSuchElementException {
                if (this.f == null) {
                    throw new NoSuchElementException();
                }
                Field n = this.f;
                do {
                    this.f = this.f._next;
                } while (this.f != null && this.f._revision != HttpFields.this._revision);
                return n._value.toString();
            }
        };
    }

    public Enumeration getValues(Buffer name) {
        Field field = this.getField(name);
        if (field == null) {
            return null;
        }
        return new Enumeration(field){
            Field f;
            private final /* synthetic */ Field val$field;
            {
                this.f = this.val$field = val$field;
            }

            public boolean hasMoreElements() {
                while (this.f != null && this.f._revision != HttpFields.this._revision) {
                    this.f = this.f._next;
                }
                return this.f != null;
            }

            public Object nextElement() throws NoSuchElementException {
                if (this.f == null) {
                    throw new NoSuchElementException();
                }
                Field n = this.f;
                do {
                    this.f = this.f._next;
                } while (this.f != null && this.f._revision != HttpFields.this._revision);
                return n._value;
            }
        };
    }

    public Enumeration getValues(String name, final String separators) {
        final Enumeration e = this.getValues(name);
        if (e == null) {
            return null;
        }
        return new Enumeration(){
            QuotedStringTokenizer tok = null;

            public boolean hasMoreElements() {
                if (this.tok != null && this.tok.hasMoreElements()) {
                    return true;
                }
                while (e.hasMoreElements()) {
                    String value = (String)e.nextElement();
                    this.tok = new QuotedStringTokenizer(value, separators, false, false);
                    if (!this.tok.hasMoreElements()) continue;
                    return true;
                }
                this.tok = null;
                return false;
            }

            public Object nextElement() throws NoSuchElementException {
                if (!this.hasMoreElements()) {
                    throw new NoSuchElementException();
                }
                String next = (String)this.tok.nextElement();
                if (next != null) {
                    next = next.trim();
                }
                return next;
            }
        };
    }

    public void put(String name, String value) {
        Buffer n = HttpHeaders.CACHE.lookup(name);
        Buffer v = HttpHeaderValues.CACHE.lookup(value);
        this.put(n, v, -1L);
    }

    public void put(Buffer name, String value) {
        Buffer v = HttpHeaderValues.CACHE.lookup(value);
        this.put(name, v, -1L);
    }

    public void put(Buffer name, Buffer value) {
        this.put(name, value, -1L);
    }

    private void put(Buffer name, Buffer value, long numValue) {
        Field field;
        if (value == null) {
            this.remove(name);
            return;
        }
        if (!(name instanceof BufferCache.CachedBuffer)) {
            name = HttpHeaders.CACHE.lookup(name);
        }
        if ((field = (Field)this._bufferMap.get(name)) != null) {
            field.reset(value, numValue, this._revision);
            field = field._next;
            while (field != null) {
                field.clear();
                field = field._next;
            }
            return;
        }
        field = new Field(name, value, numValue, this._revision);
        this._fields.add(field);
        this._bufferMap.put(name, field);
    }

    public void put(String name, List list) {
        if (list == null || list.size() == 0) {
            this.remove(name);
            return;
        }
        Buffer n = HttpHeaders.CACHE.lookup(name);
        Object v = list.get(0);
        if (v != null) {
            this.put(n, HttpHeaderValues.CACHE.lookup(v.toString()));
        } else {
            this.remove(n);
        }
        if (list.size() > 1) {
            Iterator iter = list.iterator();
            iter.next();
            while (iter.hasNext()) {
                v = iter.next();
                if (v == null) continue;
                this.put(n, HttpHeaderValues.CACHE.lookup(v.toString()));
            }
        }
    }

    public void add(String name, String value) throws IllegalArgumentException {
        Buffer n = HttpHeaders.CACHE.lookup(name);
        Buffer v = HttpHeaderValues.CACHE.lookup(value);
        this.add(n, v, -1L);
    }

    public void add(Buffer name, Buffer value) throws IllegalArgumentException {
        this.add(name, value, -1L);
    }

    private void add(Buffer name, Buffer value, long numValue) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException("null value");
        }
        if (!(name instanceof BufferCache.CachedBuffer)) {
            name = HttpHeaders.CACHE.lookup(name);
        }
        Field field = (Field)this._bufferMap.get(name);
        Field last = null;
        if (field != null) {
            while (field != null && field._revision == this._revision) {
                last = field;
                field = field._next;
            }
        }
        if (field != null) {
            field.reset(value, numValue, this._revision);
        } else {
            field = new Field(name, value, numValue, this._revision);
            if (last != null) {
                field._prev = last;
                last._next = field;
            } else {
                this._bufferMap.put(name, field);
            }
            this._fields.add(field);
        }
    }

    public void remove(String name) {
        this.remove(HttpHeaders.CACHE.lookup(name));
    }

    public void remove(Buffer name) {
        Field field = (Field)this._bufferMap.get(name);
        if (field != null) {
            while (field != null) {
                field.clear();
                field = field._next;
            }
        }
    }

    public long getLongField(String name) throws NumberFormatException {
        Field field = this.getField(name);
        if (field != null && field._revision == this._revision) {
            return field.getLongValue();
        }
        return -1L;
    }

    public long getLongField(Buffer name) throws NumberFormatException {
        Field field = this.getField(name);
        if (field != null && field._revision == this._revision) {
            return field.getLongValue();
        }
        return -1L;
    }

    public long getDateField(String name) {
        int i;
        Field field = this.getField(name);
        if (field == null || field._revision != this._revision) {
            return -1L;
        }
        if (field._numValue != -1L) {
            return field._numValue;
        }
        String val = HttpFields.valueParameters(field._value.toString(), null);
        if (val == null) {
            return -1L;
        }
        for (i = 0; i < this._dateReceive.length; ++i) {
            if (this._dateReceive[i] == null) {
                this._dateReceive[i] = (SimpleDateFormat)__dateReceive[i].clone();
            }
            try {
                Date date = (Date)this._dateReceive[i].parseObject(val);
                return field._numValue = date.getTime();
            }
            catch (Exception e) {
                continue;
            }
        }
        if (val.endsWith(" GMT")) {
            val = val.substring(0, val.length() - 4);
            for (i = 0; i < this._dateReceive.length; ++i) {
                try {
                    Date date = (Date)this._dateReceive[i].parseObject(val);
                    return field._numValue = date.getTime();
                }
                catch (Exception e) {
                    continue;
                }
            }
        }
        throw new IllegalArgumentException("Cannot convert date: " + val);
    }

    public void putLongField(String name, long value) {
        Buffer n = HttpHeaders.CACHE.lookup(name);
        Buffer v = BufferUtil.toBuffer(value);
        this.put(n, v, value);
    }

    public void addLongField(String name, long value) {
        Buffer n = HttpHeaders.CACHE.lookup(name);
        Buffer v = BufferUtil.toBuffer(value);
        this.add(n, v, value);
    }

    public void addLongField(Buffer name, long value) {
        Buffer v = BufferUtil.toBuffer(value);
        this.add(name, v, value);
    }

    public void putDateField(String name, long date) {
        if (this._dateBuffer == null) {
            this._dateBuffer = new StringBuffer(32);
            this._calendar = new GregorianCalendar(__GMT);
        }
        this._dateBuffer.setLength(0);
        this._calendar.setTimeInMillis(date);
        HttpFields.formatDate(this._dateBuffer, this._calendar, false);
        Buffer n = HttpHeaders.CACHE.lookup(name);
        ByteArrayBuffer v = new ByteArrayBuffer(this._dateBuffer.toString());
        this.put(n, v, date);
    }

    public void addDateField(String name, long date) {
        if (this._dateBuffer == null) {
            this._dateBuffer = new StringBuffer(32);
            this._calendar = new GregorianCalendar(__GMT);
        }
        this._dateBuffer.setLength(0);
        this._calendar.setTimeInMillis(date);
        HttpFields.formatDate(this._dateBuffer, this._calendar, false);
        Buffer n = HttpHeaders.CACHE.lookup(name);
        ByteArrayBuffer v = new ByteArrayBuffer(this._dateBuffer.toString());
        this.add(n, v, date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSetCookie(Cookie cookie) {
        String name = cookie.getName();
        String value = cookie.getValue();
        int version = cookie.getVersion();
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Bad cookie name");
        }
        StringBuffer buf = new StringBuffer(128);
        String name_value_params = null;
        StringBuffer stringBuffer = buf;
        synchronized (stringBuffer) {
            long maxAge;
            String domain;
            String path;
            buf.append(name);
            buf.append('=');
            if (value != null && value.length() > 0) {
                if (version == 0) {
                    try {
                        buf.append(URLEncoder.encode(value, StringUtil.__ISO_8859_1));
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                } else {
                    QuotedStringTokenizer.quote(buf, value);
                }
            }
            if (version > 0) {
                buf.append(";version=");
                buf.append(version);
                String comment = cookie.getComment();
                if (comment != null && comment.length() > 0) {
                    buf.append(";Comment=");
                    QuotedStringTokenizer.quote(buf, comment);
                }
            }
            if ((path = cookie.getPath()) != null && path.length() > 0) {
                buf.append(";path=");
                buf.append(path);
            }
            if ((domain = cookie.getDomain()) != null && domain.length() > 0) {
                buf.append(";domain=");
                buf.append(domain.toLowerCase());
            }
            if ((maxAge = (long)cookie.getMaxAge()) >= 0L) {
                if (version == 0) {
                    buf.append(";expires=");
                    if (maxAge == 0L) {
                        buf.append(__01Jan1970);
                    } else {
                        HttpFields.formatDate(buf, System.currentTimeMillis() + 1000L * maxAge, true);
                    }
                } else {
                    buf.append(";max-age=");
                    buf.append(maxAge);
                }
            } else if (version > 0) {
                buf.append(";discard");
            }
            if (cookie.getSecure()) {
                buf.append(";Secure");
            }
            if (cookie instanceof HttpOnlyCookie) {
                buf.append(";HttpOnly");
            }
            name_value_params = buf.toString();
        }
        this.put(HttpHeaders.EXPIRES_BUFFER, __01Jan1970_BUFFER);
        this.add(HttpHeaders.SET_COOKIE_BUFFER, new ByteArrayBuffer(name_value_params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Writer writer) throws IOException {
        Writer writer2 = writer;
        synchronized (writer2) {
            for (int i = 0; i < this._fields.size(); ++i) {
                Field field = (Field)this._fields.get(i);
                if (field == null || field._revision != this._revision) continue;
                field.write(writer);
            }
            writer.write("\r\n");
        }
    }

    public void put(Buffer buffer) throws IOException {
        for (int i = 0; i < this._fields.size(); ++i) {
            Field field = (Field)this._fields.get(i);
            if (field == null || field._revision != this._revision) continue;
            field.put(buffer);
        }
        BufferUtil.putCRLF(buffer);
    }

    public String toString() {
        try {
            ByteArrayBuffer buffer = new ByteArrayBuffer(4096);
            this.put(buffer);
            return buffer.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void clear() {
        ++this._revision;
        if (this._revision > 1000000) {
            this._revision = 0;
            int i = this._fields.size();
            while (i-- > 0) {
                Field field = (Field)this._fields.get(i);
                if (field == null) continue;
                field.clear();
            }
        }
    }

    public void destroy() {
        if (this._fields != null) {
            int i = this._fields.size();
            while (i-- > 0) {
                Field field = (Field)this._fields.get(i);
                if (field == null) continue;
                field.destroy();
            }
        }
        this._fields = null;
        this._dateBuffer = null;
        this._calendar = null;
        this._dateReceive = null;
    }

    public void add(HttpFields fields) {
        if (fields == null) {
            return;
        }
        Enumeration e = fields.getFieldNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            Enumeration values = fields.getValues(name);
            while (values.hasMoreElements()) {
                this.add(name, (String)values.nextElement());
            }
        }
    }

    public static String valueParameters(String value, Map parameters) {
        if (value == null) {
            return null;
        }
        int i = value.indexOf(59);
        if (i < 0) {
            return value;
        }
        if (parameters == null) {
            return value.substring(0, i).trim();
        }
        QuotedStringTokenizer tok1 = new QuotedStringTokenizer(value.substring(i), ";", false, true);
        while (((StringTokenizer)tok1).hasMoreTokens()) {
            String token = ((StringTokenizer)tok1).nextToken();
            QuotedStringTokenizer tok2 = new QuotedStringTokenizer(token, "= ");
            if (!((StringTokenizer)tok2).hasMoreTokens()) continue;
            String paramName = ((StringTokenizer)tok2).nextToken();
            String paramVal = null;
            if (((StringTokenizer)tok2).hasMoreTokens()) {
                paramVal = ((StringTokenizer)tok2).nextToken();
            }
            parameters.put(paramName, paramVal);
        }
        return value.substring(0, i).trim();
    }

    public static Float getQuality(String value) {
        Map.Entry entry;
        if (value == null) {
            return __zero;
        }
        int qe = value.indexOf(";");
        if (qe++ < 0 || qe == value.length()) {
            return __one;
        }
        if (value.charAt(qe++) == 'q') {
            // empty if block
        }
        if ((entry = __qualities.getEntry(value, ++qe, value.length() - qe)) != null) {
            return (Float)entry.getValue();
        }
        HashMap params = new HashMap(3);
        HttpFields.valueParameters(value, params);
        String qs = (String)params.get("q");
        Float q = (Float)__qualities.get(qs);
        if (q == null) {
            try {
                q = new Float(qs);
            }
            catch (Exception e) {
                q = __one;
            }
        }
        return q;
    }

    public static List qualityList(Enumeration e) {
        if (e == null || !e.hasMoreElements()) {
            return Collections.EMPTY_LIST;
        }
        Object list = null;
        Object qual = null;
        while (e.hasMoreElements()) {
            String v = e.nextElement().toString();
            Float q = HttpFields.getQuality(v);
            if (!((double)q.floatValue() >= 0.001)) continue;
            list = LazyList.add(list, v);
            qual = LazyList.add(qual, q);
        }
        List vl = LazyList.getList(list, false);
        if (vl.size() < 2) {
            return vl;
        }
        List ql = LazyList.getList(qual, false);
        Float last = __zero;
        int i = vl.size();
        while (i-- > 0) {
            Float q = (Float)ql.get(i);
            if (last.compareTo(q) > 0) {
                Object tmp = vl.get(i);
                vl.set(i, vl.get(i + 1));
                vl.set(i + 1, tmp);
                ql.set(i, ql.get(i + 1));
                ql.set(i + 1, q);
                last = __zero;
                i = vl.size();
                continue;
            }
            last = q;
        }
        ql.clear();
        return vl;
    }

    static {
        __GMT.setID("GMT");
        __dateCache.setTimeZone(__GMT);
        __dateReceive = new SimpleDateFormat[__dateReceiveFmt.length];
        for (int i = 0; i < __dateReceive.length; ++i) {
            HttpFields.__dateReceive[i] = new SimpleDateFormat(__dateReceiveFmt[i], Locale.US);
            __dateReceive[i].setTimeZone(__GMT);
        }
        __01Jan1970 = HttpFields.formatDate(0L, false);
        __01Jan1970_BUFFER = new ByteArrayBuffer(__01Jan1970);
        __one = new Float("1.0");
        __zero = new Float("0.0");
        __qualities = new StringMap();
        __qualities.put(null, (Object)__one);
        __qualities.put("1.0", (Object)__one);
        __qualities.put("1", (Object)__one);
        __qualities.put("0.9", (Object)new Float("0.9"));
        __qualities.put("0.8", (Object)new Float("0.8"));
        __qualities.put("0.7", (Object)new Float("0.7"));
        __qualities.put("0.66", (Object)new Float("0.66"));
        __qualities.put("0.6", (Object)new Float("0.6"));
        __qualities.put("0.5", (Object)new Float("0.5"));
        __qualities.put("0.4", (Object)new Float("0.4"));
        __qualities.put("0.33", (Object)new Float("0.33"));
        __qualities.put("0.3", (Object)new Float("0.3"));
        __qualities.put("0.2", (Object)new Float("0.2"));
        __qualities.put("0.1", (Object)new Float("0.1"));
        __qualities.put("0", (Object)__zero);
        __qualities.put("0.0", (Object)__zero);
    }

    public static final class Field {
        private Buffer _name;
        private Buffer _value;
        private long _numValue;
        private Field _next;
        private Field _prev;
        private int _revision;

        private Field(Buffer name, Buffer value, long numValue, int revision) {
            this._name = name;
            this._value = value.isImmutable() ? value : new View(value);
            this._numValue = numValue;
            this._next = null;
            this._prev = null;
            this._revision = revision;
        }

        private void clear() {
            this._revision = -1;
        }

        private void destroy() {
            this._name = null;
            this._value = null;
            this._next = null;
            this._prev = null;
        }

        private void reset(Buffer value, long numValue, int revision) {
            if (this._value == null) {
                this._value = new View(value);
                this._numValue = numValue;
            } else if (!this._value.equals(value)) {
                if (value.isImmutable()) {
                    this._value = value;
                } else if (this._value instanceof View) {
                    ((View)this._value).update(value);
                } else {
                    this._value = new View(value);
                }
                this._numValue = numValue;
            }
            this._revision = revision;
        }

        public void write(Writer writer) throws IOException {
            writer.write(this._name.toString());
            writer.write(":");
            writer.write(this._value.toString());
            writer.write("\r\n");
        }

        public void put(Buffer buffer) throws IOException {
            buffer.put(this._name);
            buffer.put((byte)58);
            buffer.put((byte)32);
            buffer.put(this._value);
            BufferUtil.putCRLF(buffer);
        }

        public String getName() {
            return this._name.toString();
        }

        Buffer getNameBuffer() {
            return this._name;
        }

        public int getNameOrdinal() {
            return HttpHeaders.CACHE.getOrdinal(this._name);
        }

        public String getValue() {
            return this._value.toString();
        }

        Buffer getValueBuffer() {
            return this._value;
        }

        public int getValueOrdinal() {
            return HttpHeaderValues.CACHE.getOrdinal(this._value);
        }

        public int getIntValue() {
            return (int)this.getLongValue();
        }

        public long getLongValue() {
            if (this._numValue == -1L) {
                this._numValue = BufferUtil.toLong(this._value);
            }
            return this._numValue;
        }

        public String toString() {
            return "[" + (this._prev == null ? "" : "<-") + this.getName() + "=" + this._value + (this._next == null ? "" : "->") + "]";
        }
    }
}

