/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Iterator;
import org.mortbay.io.Buffer;
import org.mortbay.io.BufferUtil;
import org.mortbay.io.Buffers;
import org.mortbay.io.ByteArrayBuffer;
import org.mortbay.io.EndPoint;
import org.mortbay.io.Portable;
import org.mortbay.jetty.HttpFields;
import org.mortbay.jetty.HttpHeaderValues;
import org.mortbay.jetty.HttpHeaders;
import org.mortbay.jetty.HttpStatus;
import org.mortbay.jetty.HttpTokens;
import org.mortbay.jetty.HttpVersions;
import org.mortbay.jetty.MimeTypes;
import org.mortbay.util.UrlEncoded;

public class HttpGenerator
implements HttpTokens {
    public static final int STATE_HEADER = 0;
    public static final int STATE_CONTENT = 2;
    public static final int STATE_FLUSHING = 3;
    public static final int STATE_END = 4;
    public static final boolean LAST = true;
    public static final boolean MORE = false;
    private static byte[] LAST_CHUNK = new byte[]{48, 13, 10, 13, 10};
    private static byte[] CONTENT_LENGTH_0 = Portable.getBytes("Content-Length: 0\r\n");
    private static byte[] CONNECTION_KEEP_ALIVE = Portable.getBytes("HttpConnection: keep-alive\r\n");
    private static byte[] CONNECTION_CLOSE = Portable.getBytes("HttpConnection: close\r\n");
    private static byte[] TRANSFER_ENCODING_CHUNKED = Portable.getBytes("Transfer-Encoding: chunked\r\n");
    private static byte[] SERVER = Portable.getBytes("Server: Jetty(experimental)\r\n");
    private static int CHUNK_SPACE = 12;
    private static String[] __reasons = new String[505];
    private int _state = 0;
    private int _version = 11;
    private int _status = 200;
    private String _reason;
    private long _contentAdded = 0L;
    private long _contentLength = -3L;
    private boolean _last = false;
    private boolean _head = false;
    private boolean _close = false;
    private Buffers _buffers;
    private EndPoint _endp;
    private Buffer _header;
    private Buffer _buffer;
    private Buffer _content;
    boolean _direct = false;
    private boolean _needCRLF = false;
    private boolean _needEOC = false;
    private boolean _bufferChunked = false;
    private int _headerBufferSize;
    private int _contentBufferSize;
    static /* synthetic */ Class class$javax$servlet$http$HttpServletResponse;

    public HttpGenerator(Buffers buffers, EndPoint io, int headerBufferSize, int contentBufferSize) {
        this._buffers = buffers;
        this._endp = io;
        this._headerBufferSize = headerBufferSize;
        this._contentBufferSize = contentBufferSize;
    }

    public void reset(boolean returnBuffers) {
        this._state = 0;
        this._version = 11;
        this._status = 200;
        this._last = false;
        this._head = false;
        this._close = false;
        this._contentAdded = 0L;
        this._contentLength = -3L;
        if (returnBuffers) {
            if (this._header != null) {
                this._buffers.returnBuffer(this._header);
            }
            this._header = null;
            if (this._buffer != null) {
                this._buffers.returnBuffer(this._buffer);
            }
            this._buffer = null;
        } else {
            if (this._header != null) {
                this._header.clear();
            }
            if (this._buffer != null) {
                this._buffers.returnBuffer(this._buffer);
                this._buffer = null;
            }
        }
        this._content = null;
        this._direct = false;
        this._needCRLF = false;
        this._needEOC = false;
    }

    public int getState() {
        return this._state;
    }

    public boolean isState(int state) {
        return this._state == state;
    }

    public boolean isComplete() {
        return this._state == 4;
    }

    public boolean isCommitted() {
        return this._state != 0;
    }

    public boolean isHead() {
        return this._head;
    }

    public void setHead(boolean head) {
        this._head = head;
    }

    public boolean isPersistent() {
        return !this._close;
    }

    public long getContentAdded() {
        return this._contentAdded;
    }

    public void setVersion(int version) {
        if (this._state != 0) {
            throw new IllegalStateException("STATE!=START");
        }
        this._version = version;
    }

    public void setRequest(Buffer method, Buffer uri) {
        Portable.throwNotSupported();
    }

    public void setResponse(int status, String reason) {
        if (this._state != 0) {
            throw new IllegalStateException("STATE!=START");
        }
        this._status = status;
        this._reason = reason == null ? reason : UrlEncoded.encodeString(reason);
    }

    public void addContent(Buffer content, boolean last) throws IOException {
        if (content.isImmutable()) {
            throw new IllegalArgumentException("immutable");
        }
        if (this._last) {
            throw new IllegalStateException("last");
        }
        this._last = last;
        if (this._content != null || this._bufferChunked) {
            this.flushBuffers();
            if (this._content != null || this._bufferChunked) {
                throw new IllegalStateException("FULL");
            }
        }
        this._content = content;
        this._contentAdded += (long)content.length();
        if (this._head) {
            content.clear();
        } else if (this._endp != null && this._buffer == null && content.length() > 0 && this._last) {
            this._direct = true;
        } else {
            if (this._buffer == null) {
                this._buffer = this._buffers.getBuffer(this._contentBufferSize);
            }
            this._buffer.put(this._content);
            if (this._content.length() == 0) {
                this._content = null;
            }
        }
    }

    public boolean isBufferFull() {
        boolean full = this._state == 3 || this._direct || this._buffer != null && this._buffer.space() == 0 || this._contentLength == -2L && this._buffer != null && this._buffer.space() < CHUNK_SPACE;
        return full;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void completeHeader(HttpFields fields, boolean allContentAdded) throws IOException {
        if (this._state != 0) {
            return;
        }
        if (this._last && !allContentAdded) {
            throw new IllegalStateException("last?");
        }
        this._last |= allContentAdded;
        if (this._version == 9) {
            this._close = true;
            this._contentLength = -1L;
        } else {
            byte[] r;
            boolean has_server = false;
            if (this._version == 10) {
                this._close = true;
            }
            if (this._header == null) {
                this._header = this._buffers.getBuffer(this._headerBufferSize);
            }
            Buffer line = HttpStatus.getResponseLine(this._status);
            if (this._reason != null && this._reason.length() > this._header.capacity() / 2) {
                this._reason = this._reason.substring(0, this._header.capacity() / 2);
            }
            if (this._reason == null && this._status < __reasons.length) {
                this._reason = __reasons[this._status];
            }
            if (line == null) {
                this._header.put(HttpVersions.HTTP_1_1_BUFFER);
                this._header.put((byte)32);
                this._header.put((byte)(48 + this._status / 100));
                this._header.put((byte)(48 + this._status % 100 / 10));
                this._header.put((byte)(48 + this._status % 10));
                this._header.put((byte)32);
                r = Portable.getBytes(this._reason == null ? "Uknown" : this._reason);
                this._header.put(r, 0, r.length);
                this._header.put(HttpTokens.CRLF);
            } else if (this._reason != null) {
                this._header.put(line.array(), 0, HttpVersions.HTTP_1_1_BUFFER.length() + 5);
                r = Portable.getBytes(this._reason);
                this._header.put(r, 0, r.length);
                this._header.put(HttpTokens.CRLF);
            } else {
                this._header.put(line);
            }
            HttpFields.Field content_length = null;
            HttpFields.Field transfer_encoding = null;
            HttpFields.Field connection = null;
            boolean keep_alive = false;
            if (fields != null) {
                Iterator iter = fields.getFields();
                block13: while (iter.hasNext()) {
                    HttpFields.Field field = (HttpFields.Field)iter.next();
                    switch (field.getNameOrdinal()) {
                        case 12: {
                            content_length = field;
                            this._contentLength = field.getLongValue();
                            if (this._contentLength < this._contentAdded || this._last && this._contentLength != this._contentAdded) {
                                content_length = null;
                            }
                            field.put(this._header);
                            continue block13;
                        }
                        case 16: {
                            if (BufferUtil.isPrefix(MimeTypes.MULTIPART_BYTERANGES_BUFFER, field.getValueBuffer())) {
                                this._contentLength = -4L;
                            }
                            field.put(this._header);
                            continue block13;
                        }
                        case 5: {
                            if (this._version != 11) continue block13;
                            transfer_encoding = field;
                            continue block13;
                        }
                        case 1: {
                            connection = field;
                            int connection_value = field.getValueOrdinal();
                            this._close = HttpHeaderValues.CLOSE_ORDINAL == connection_value;
                            boolean bl = keep_alive = HttpHeaderValues.KEEP_ALIVE_ORDINAL == connection_value;
                            if (keep_alive && this._version == 10) {
                                this._close = false;
                            }
                            if (!this._close || this._contentLength != -3L) continue block13;
                            this._contentLength = -1L;
                            continue block13;
                        }
                        case 48: {
                            has_server = true;
                            field.put(this._header);
                            continue block13;
                        }
                    }
                    field.put(this._header);
                }
            }
            switch ((int)this._contentLength) {
                case -3: {
                    if (this._contentAdded == 0L && (this._status < 200 || this._status == 204 || this._status == 304)) {
                        this._contentLength = 0L;
                        break;
                    }
                    if (this._last) {
                        this._contentLength = this._contentAdded;
                        if (content_length != null) break;
                        this._header.put(HttpHeaders.CONTENT_LENGTH_BUFFER);
                        this._header.put((byte)58);
                        this._header.put((byte)32);
                        BufferUtil.putDecLong(this._header, this._contentLength);
                        this._header.put(HttpTokens.CRLF);
                        break;
                    }
                    this._contentLength = this._close || this._version < 11 ? -1L : -2L;
                    break;
                }
                case 0: {
                    if (content_length != null || this._status < 200 || this._status == 204 || this._status == 304) break;
                    this._header.put(CONTENT_LENGTH_0);
                    break;
                }
                case -1: {
                    this._close = true;
                    break;
                }
                case -2: {
                    break;
                }
            }
            if (this._contentLength == -2L) {
                if (transfer_encoding != null && HttpHeaderValues.CHUNKED_ORDINAL != transfer_encoding.getValueOrdinal()) {
                    String c = transfer_encoding.getValue();
                    if (!c.endsWith("chunked")) throw new IllegalArgumentException("BAD TE");
                    transfer_encoding.put(this._header);
                } else {
                    this._header.put(TRANSFER_ENCODING_CHUNKED);
                }
            }
            if (this._close) {
                this._header.put(CONNECTION_CLOSE);
            } else if (keep_alive && this._version == 10) {
                this._header.put(CONNECTION_KEEP_ALIVE);
            } else if (connection != null) {
                connection.put(this._header);
            }
            if (!has_server) {
                this._header.put(SERVER);
            }
            this._header.put(HttpTokens.CRLF);
        }
        this._state = 2;
    }

    public void complete() throws IOException {
        if (this._state == 4) {
            return;
        }
        if (this._state == 0) {
            throw new IllegalStateException("State==HEADER");
        }
        if (this._contentLength >= 0L && this._contentLength != this._contentAdded) {
            this._close = true;
        }
        if (this._state != 3) {
            this._state = 3;
            if (this._contentLength == -2L) {
                this._needEOC = true;
            }
        }
        this.flushBuffers();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void flushBuffers() throws IOException {
        if (this._state == 0) {
            throw new IllegalStateException("State==HEADER");
        }
        this.prepareBuffers();
        if (this._endp == null) {
            if (this._needCRLF && this._buffer != null) {
                this._buffer.put(HttpTokens.CRLF);
            }
            if (!this._needEOC) return;
            if (this._buffer == null) return;
            this._buffer.put(LAST_CHUNK);
            return;
        }
        int last_len = -1;
        while (true) {
            int len = -1;
            int to_flush = (this._header != null && this._header.length() > 0 ? 4 : 0) | (this._buffer != null && this._buffer.length() > 0 ? 2 : 0) | (this._direct && this._content != null && this._content.length() > 0 ? 1 : 0);
            switch (to_flush) {
                case 7: {
                    len = this._endp.flush(this._header, this._buffer, this._content);
                    break;
                }
                case 6: {
                    len = this._endp.flush(this._header, this._buffer, null);
                    break;
                }
                case 5: {
                    len = this._endp.flush(this._header, this._content, null);
                    break;
                }
                case 4: {
                    len = this._endp.flush(this._header);
                    break;
                }
                case 3: {
                    len = this._endp.flush(this._buffer, this._content, null);
                    break;
                }
                case 2: {
                    len = this._endp.flush(this._buffer);
                    break;
                }
                case 1: {
                    len = this._endp.flush(this._content);
                    break;
                }
                case 0: {
                    if (this._header != null) {
                        this._header.clear();
                    }
                    if (this._buffer != null) {
                        this._buffer.clear();
                        if (this._contentLength == -2L) {
                            this._buffer.setPutIndex(CHUNK_SPACE);
                            this._buffer.setGetIndex(CHUNK_SPACE);
                            this._bufferChunked = false;
                            if (this._content != null && this._content.length() < this._buffer.space() && this._state != 3) {
                                this._buffer.put(this._content);
                                this._content = null;
                                return;
                            }
                        }
                    }
                    this._direct = false;
                    if (!(this._needCRLF || this._needEOC || this._content != null && this._content.length() != 0)) {
                        if (this._state != 3) return;
                        this._state = 4;
                        if (!this._close) return;
                        this._endp.close();
                        return;
                    }
                    this.prepareBuffers();
                }
            }
            if (len <= 0) {
                if (last_len > 0) return;
                return;
            }
            last_len = len;
        }
    }

    private void prepareBuffers() throws IOException {
        if (!this._bufferChunked) {
            if (this._content != null && this._content.length() > 0 && this._buffer != null && this._buffer.space() > 0) {
                this._buffer.put(this._content);
                if (this._content.length() == 0) {
                    this._content = null;
                }
            }
            if (this._contentLength == -2L) {
                int size;
                int n = size = this._buffer == null ? 0 : this._buffer.length();
                if (size > 0) {
                    this._bufferChunked = true;
                    if (this._buffer.getIndex() == CHUNK_SPACE) {
                        this._buffer.poke(this._buffer.getIndex() - 2, HttpTokens.CRLF, 0, 2);
                        this._buffer.setGetIndex(this._buffer.getIndex() - 2);
                        BufferUtil.prependHexInt(this._buffer, size);
                        if (this._needCRLF) {
                            this._buffer.poke(this._buffer.getIndex() - 2, HttpTokens.CRLF, 0, 2);
                            this._buffer.setGetIndex(this._buffer.getIndex() - 2);
                            this._needCRLF = false;
                        }
                    } else {
                        if (this._needCRLF) {
                            if (this._header.length() > 0) {
                                throw new IllegalStateException("EOC");
                            }
                            this._header.put(HttpTokens.CRLF);
                            this._needCRLF = false;
                        }
                        BufferUtil.putHexInt(this._header, size);
                        this._header.put(HttpTokens.CRLF);
                    }
                    if (this._buffer.space() >= 2) {
                        this._buffer.put(HttpTokens.CRLF);
                    } else {
                        this._needCRLF = true;
                    }
                }
                if (this._needEOC && (this._content == null || this._content.length() == 0)) {
                    if (this._needCRLF) {
                        if (this._buffer == null && this._header.space() >= 2) {
                            this._header.put(HttpTokens.CRLF);
                            this._needCRLF = false;
                        } else if (this._buffer.space() >= 2) {
                            this._buffer.put(HttpTokens.CRLF);
                            this._needCRLF = false;
                        }
                    }
                    if (!this._needCRLF && this._needEOC) {
                        if (this._buffer == null && this._header.space() >= LAST_CHUNK.length) {
                            this._header.put(LAST_CHUNK);
                            this._needEOC = false;
                        } else if (this._buffer.space() >= LAST_CHUNK.length) {
                            this._buffer.put(LAST_CHUNK);
                            this._needEOC = false;
                        }
                    }
                }
            }
        }
        if (this._content != null && this._content.length() == 0) {
            this._content = null;
        }
    }

    public void sendError(int code, String reason, String content, boolean close) throws IOException {
        if (!this.isCommitted()) {
            this.setResponse(code, reason);
            this._close = close;
            if (content != null) {
                this.addContent(new ByteArrayBuffer(content), true);
            }
            this.complete();
        }
    }

    public int getContentBufferSize() {
        return this._contentBufferSize;
    }

    public void increaseContentBufferSize(int contentBufferSize) {
        if (contentBufferSize > this._contentBufferSize) {
            this._contentBufferSize = contentBufferSize;
            if (this._buffer != null) {
                Buffer nb = this._buffers.getBuffer(this._contentBufferSize);
                nb.put(this._buffer);
                this._buffers.returnBuffer(this._buffer);
                this._buffer = nb;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Field[] fields = (class$javax$servlet$http$HttpServletResponse == null ? (class$javax$servlet$http$HttpServletResponse = HttpGenerator.class$("javax.servlet.http.HttpServletResponse")) : class$javax$servlet$http$HttpServletResponse).getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if ((fields[i].getModifiers() & 8) == 0 || !fields[i].getName().startsWith("SC_")) continue;
            try {
                int code = fields[i].getInt(null);
                if (code >= __reasons.length) continue;
                HttpGenerator.__reasons[code] = fields[i].getName().substring(3);
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }
}

