/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty;

import java.io.IOException;
import java.net.SocketTimeoutException;
import org.mortbay.io.Buffer;
import org.mortbay.io.BufferUtil;
import org.mortbay.io.Buffers;
import org.mortbay.io.ByteArrayBuffer;
import org.mortbay.io.EndPoint;
import org.mortbay.io.View;
import org.mortbay.jetty.HttpHeaderValues;
import org.mortbay.jetty.HttpHeaders;
import org.mortbay.jetty.HttpMethods;
import org.mortbay.jetty.HttpTokens;
import org.mortbay.jetty.HttpVersions;

public class HttpParser
implements HttpTokens {
    public static final int STATE_START = -11;
    public static final int STATE_FIELD0 = -10;
    public static final int STATE_SPACE1 = -9;
    public static final int STATE_FIELD1 = -8;
    public static final int STATE_SPACE2 = -7;
    public static final int STATE_END0 = -6;
    public static final int STATE_END1 = -5;
    public static final int STATE_FIELD2 = -4;
    public static final int STATE_HEADER = -3;
    public static final int STATE_HEADER_NAME = -2;
    public static final int STATE_HEADER_VALUE = -1;
    public static final int STATE_END = 0;
    public static final int STATE_EOF_CONTENT = 1;
    public static final int STATE_CONTENT = 2;
    public static final int STATE_CHUNKED_CONTENT = 3;
    public static final int STATE_CHUNK_SIZE = 4;
    public static final int STATE_CHUNK_PARAMS = 5;
    public static final int STATE_CHUNK = 6;
    protected int _state = -11;
    protected byte _eol;
    protected int _length;
    protected int _contentLength;
    protected int _contentPosition;
    protected int _chunkLength;
    protected int _chunkPosition;
    private Buffers _buffers;
    private EndPoint _endp;
    private Buffer _header;
    private Buffer _content;
    private Buffer _buffer;
    private int _headerBufferSize;
    private int _contentBufferSize;
    private boolean _close = false;
    private boolean _hasContent = false;
    private EventHandler _handler;
    private View _tok0;
    private View _tok1;
    private String _continuation;
    private boolean _response = false;

    public HttpParser(Buffer buffer, EventHandler handler) {
        this._header = buffer;
        this._buffer = buffer;
        this._handler = handler;
        if (buffer != null) {
            this._tok0 = new View(buffer);
            this._tok1 = new View(buffer);
            this._tok0.setPutIndex(this._tok0.getIndex());
            this._tok1.setPutIndex(this._tok1.getIndex());
        }
    }

    public HttpParser(Buffers buffers, EndPoint endp, EventHandler handler, int headerBufferSize, int contentBufferSize) {
        this._buffers = buffers;
        this._endp = endp;
        this._handler = handler;
        this._headerBufferSize = headerBufferSize;
        this._contentBufferSize = contentBufferSize;
        this._buffer = this._header = this._buffers.getBuffer(this._headerBufferSize);
        this._tok0 = new View(this._header);
        this._tok1 = new View(this._header);
        this._tok0.setPutIndex(this._tok0.getIndex());
        this._tok1.setPutIndex(this._tok1.getIndex());
    }

    public int getState() {
        return this._state;
    }

    public boolean isState(int state) {
        return this._state == state;
    }

    public void setState(int state) {
        this._state = state;
        this._contentLength = -3;
    }

    public boolean inHeaderState() {
        return this._state < 0;
    }

    public boolean inContentState() {
        return this._state > 0;
    }

    public int getContentLength() {
        return this._contentLength;
    }

    public String toString(Buffer buf) {
        return "state=" + this._state + " length=" + this._length + " buf=" + buf.hashCode();
    }

    public void parse() throws IOException {
        if (this._state == 0) {
            this.reset();
        }
        if (this._state != -11) {
            throw new IllegalStateException("!START");
        }
        while (this._state != 0) {
            this.parseNext();
        }
    }

    public void parseAvailable() throws IOException {
        this.parseNext();
        while (this._state != 0 && this._buffer.length() > 0) {
            this.parseNext();
        }
    }

    public void parseNext() throws IOException {
        byte ch;
        if (this._state == 0) {
            throw new IllegalStateException("STATE_END");
        }
        if (this._state == 2 && this._contentPosition == this._contentLength) {
            this._state = 0;
            this._handler.messageComplete(this._contentPosition);
            return;
        }
        int length = this._buffer.length();
        if (length == 0) {
            if (this._buffer.markIndex() == 0 && this._buffer.putIndex() == this._buffer.capacity()) {
                throw new IOException("FULL");
            }
            int filled = -1;
            if (this._endp != null) {
                if (this._buffer == this._content) {
                    this._buffer.compact();
                }
                if (this._buffer.space() == 0) {
                    throw new IOException("FULL");
                }
                try {
                    filled = this._endp.fill(this._buffer);
                }
                catch (SocketTimeoutException toe) {
                    throw new IOException("EOF");
                }
            }
            if (filled < 0 && this._state == 1) {
                this._state = 0;
                this._handler.messageComplete(this._contentPosition);
                return;
            }
            if (filled < 0) {
                throw new IOException("EOF");
            }
            length = this._buffer.length();
        }
        while (this._state < 0 && length-- > 0) {
            ch = this._buffer.get();
            if (this._eol == 13 && ch == 10) {
                this._eol = (byte)10;
                continue;
            }
            this._eol = 0;
            switch (this._state) {
                case -11: {
                    this._contentLength = -3;
                    if (ch <= 32) break;
                    this._buffer.mark();
                    this._state = -10;
                    break;
                }
                case -10: {
                    if (ch == 32) {
                        this._tok0.update(this._buffer.markIndex(), this._buffer.getIndex() - 1);
                        this._state = -9;
                        break;
                    }
                    if (ch >= 32) break;
                    throw new IOException("BAD");
                }
                case -9: {
                    if (ch > 32) {
                        this._buffer.mark();
                        this._state = -8;
                        this._response = ch >= 49 && ch <= 53;
                        break;
                    }
                    if (ch >= 32) break;
                    throw new IOException("BAD");
                }
                case -8: {
                    if (ch == 32) {
                        this._tok1.update(this._buffer.markIndex(), this._buffer.getIndex() - 1);
                        this._state = -7;
                        break;
                    }
                    if (ch >= 32) break;
                    this._handler.startRequest(HttpMethods.CACHE.lookup(this._tok0), this._buffer.sliceFromMark(), null);
                    this._state = 0;
                    this._handler.headerComplete();
                    this._handler.messageComplete(this._contentPosition);
                    return;
                }
                case -7: {
                    if (ch > 32) {
                        this._buffer.mark();
                        this._state = -4;
                        break;
                    }
                    if (ch >= 32) break;
                    this._handler.startRequest(HttpMethods.CACHE.lookup(this._tok0), this._tok1, null);
                    this._state = 0;
                    this._handler.headerComplete();
                    this._handler.messageComplete(this._contentPosition);
                    return;
                }
                case -4: {
                    if (ch != 13 && ch != 10) break;
                    if (this._response) {
                        this._handler.startResponse(HttpVersions.CACHE.lookup(this._tok0), BufferUtil.toInt(this._tok1), this._buffer.sliceFromMark());
                    } else {
                        this._handler.startRequest(HttpMethods.CACHE.lookup(this._tok0), this._tok1, HttpVersions.CACHE.lookup(this._buffer.sliceFromMark()));
                    }
                    this._eol = ch;
                    this._state = -3;
                    this._tok0.setPutIndex(this._tok0.getIndex());
                    this._tok1.setPutIndex(this._tok1.getIndex());
                    this._continuation = null;
                    return;
                }
                case -3: {
                    if (ch == 58 || ch == 32 || ch == 9) {
                        this._length = -1;
                        this._state = -1;
                        break;
                    }
                    if (this._tok0.length() > 0 || this._tok1.length() > 0 || this._continuation != null) {
                        Buffer header = HttpHeaders.CACHE.lookup(this._tok0);
                        Buffer value = this._continuation == null ? this._tok1 : new ByteArrayBuffer(this._continuation);
                        int ho = HttpHeaders.CACHE.getOrdinal(header);
                        if (ho >= 0) {
                            int vo = -1;
                            switch (ho) {
                                case 12: {
                                    if (this._contentLength == -2) break;
                                    this._contentLength = BufferUtil.toInt(value);
                                    if (this._contentLength > 0) break;
                                    this._contentLength = 0;
                                    break;
                                }
                                case 1: {
                                    value = HttpHeaderValues.CACHE.lookup(value);
                                    vo = HttpHeaderValues.CACHE.getOrdinal(value);
                                    this._close = HttpHeaderValues.CLOSE_ORDINAL == vo;
                                    break;
                                }
                                case 5: {
                                    value = HttpHeaderValues.CACHE.lookup(value);
                                    vo = HttpHeaderValues.CACHE.getOrdinal(value);
                                    if (HttpHeaderValues.CHUNKED_ORDINAL == vo) {
                                        this._contentLength = -2;
                                        break;
                                    }
                                    String c = value.toString();
                                    if (c.endsWith("chunked")) {
                                        this._contentLength = -2;
                                        break;
                                    }
                                    if (c.indexOf("chunked") < 0) break;
                                    throw new IOException("BAD");
                                }
                                case 16: {
                                    this._hasContent = true;
                                }
                            }
                        }
                        this._handler.parsedHeader(header, value);
                        this._tok0.setPutIndex(this._tok0.getIndex());
                        this._tok1.setPutIndex(this._tok1.getIndex());
                        this._continuation = null;
                    }
                    if (ch == 13 || ch == 10) {
                        if (this._contentLength == -3) {
                            this._contentLength = this._hasContent || this._response ? -1 : 0;
                        }
                        this._contentPosition = 0;
                        this._eol = ch;
                        switch (this._contentLength) {
                            case -1: {
                                this._state = 1;
                                if (this._buffers != null && this._buffer == this._header) {
                                    this._buffer = this._buffers.getBuffer(this._contentBufferSize);
                                    this._buffer.put(this._header);
                                    this._header.clear();
                                }
                                this._handler.headerComplete();
                                break;
                            }
                            case -2: {
                                this._state = 3;
                                if (this._buffers != null && this._buffer == this._header) {
                                    this._buffer = this._buffers.getBuffer(this._contentBufferSize);
                                    this._buffer.put(this._header);
                                    this._header.clear();
                                }
                                this._handler.headerComplete();
                                break;
                            }
                            case 0: {
                                this._state = 0;
                                this._handler.headerComplete();
                                this._handler.messageComplete(this._contentPosition);
                                break;
                            }
                            default: {
                                this._state = 2;
                                if (this._buffers != null && this._buffer == this._header && this._contentLength > this._buffer.capacity() - this._buffer.getIndex()) {
                                    this._buffer = this._buffers.getBuffer(this._contentBufferSize);
                                    this._buffer.put(this._header);
                                    this._header.clear();
                                }
                                this._handler.headerComplete();
                            }
                        }
                        return;
                    }
                    this._length = 1;
                    this._buffer.mark();
                    this._state = -2;
                    break;
                }
                case -2: {
                    if (ch == 13 || ch == 10) {
                        if (this._length > 0) {
                            this._tok0.update(this._buffer.markIndex(), this._buffer.markIndex() + this._length);
                        }
                        this._eol = ch;
                        this._state = -3;
                        break;
                    }
                    if (ch == 58) {
                        if (this._length > 0) {
                            this._tok0.update(this._buffer.markIndex(), this._buffer.markIndex() + this._length);
                        }
                        this._length = -1;
                        this._state = -1;
                        break;
                    }
                    if (ch == 32 || ch == 9) break;
                    if (this._length == -1) {
                        this._buffer.mark();
                    }
                    this._length = this._buffer.getIndex() - this._buffer.markIndex();
                    break;
                }
                case -1: {
                    if (ch == 13 || ch == 10) {
                        if (this._length > 0) {
                            if (this._tok1.length() == 0) {
                                this._tok1.update(this._buffer.markIndex(), this._buffer.markIndex() + this._length);
                            } else {
                                if (this._continuation == null) {
                                    this._continuation = this._tok1.toString();
                                }
                                this._tok1.update(this._buffer.markIndex(), this._buffer.markIndex() + this._length);
                                this._continuation = this._continuation + " " + this._tok1.toString();
                            }
                        }
                        this._eol = ch;
                        this._state = -3;
                        break;
                    }
                    if (ch == 32 || ch == 9) break;
                    if (this._length == -1) {
                        this._buffer.mark();
                    }
                    this._length = this._buffer.getIndex() - this._buffer.markIndex();
                }
            }
        }
        length = this._buffer.length();
        while (this._state > 0 && length > 0) {
            if (this._eol == 13 && this._buffer.peek() == 10) {
                this._eol = this._buffer.get();
                length = this._buffer.length();
                continue;
            }
            this._eol = 0;
            switch (this._state) {
                case 1: {
                    Buffer chunk = this._buffer.get(this._buffer.length());
                    this._handler.content(this._contentPosition, chunk);
                    this._contentPosition += chunk.length();
                    return;
                }
                case 2: {
                    int remaining = this._contentLength - this._contentPosition;
                    if (remaining == 0) {
                        this._state = 0;
                        this._handler.messageComplete(this._contentPosition);
                        return;
                    }
                    if (length > remaining) {
                        length = remaining;
                    }
                    Buffer chunk = this._buffer.get(length);
                    this._handler.content(this._contentPosition, chunk);
                    this._contentPosition += chunk.length();
                    return;
                }
                case 3: {
                    ch = this._buffer.peek();
                    if (ch == 13 || ch == 10) {
                        this._eol = this._buffer.get();
                        break;
                    }
                    if (ch <= 32) {
                        this._buffer.get();
                        break;
                    }
                    this._chunkLength = 0;
                    this._chunkPosition = 0;
                    this._state = 4;
                    break;
                }
                case 4: {
                    ch = this._buffer.get();
                    if (ch == 13 || ch == 10) {
                        this._eol = ch;
                        if (this._chunkLength == 0) {
                            this._state = 0;
                            this._handler.messageComplete(this._contentPosition);
                            return;
                        }
                        this._state = 6;
                        break;
                    }
                    if (ch <= 32 || ch == 59) {
                        this._state = 5;
                        break;
                    }
                    if (ch >= 48 && ch <= 57) {
                        this._chunkLength = this._chunkLength * 16 + (ch - 48);
                        break;
                    }
                    if (ch >= 97 && ch <= 102) {
                        this._chunkLength = this._chunkLength * 16 + (10 + ch - 97);
                        break;
                    }
                    if (ch >= 65 && ch <= 70) {
                        this._chunkLength = this._chunkLength * 16 + (10 + ch - 65);
                        break;
                    }
                    throw new IOException("bad chunk char: " + ch);
                }
                case 5: {
                    ch = this._buffer.get();
                    if (ch != 13 && ch != 10) break;
                    this._eol = ch;
                    if (this._chunkLength == 0) {
                        this._state = 0;
                        this._handler.messageComplete(this._contentPosition);
                        return;
                    }
                    this._state = 6;
                    break;
                }
                case 6: {
                    int remaining = this._chunkLength - this._chunkPosition;
                    if (remaining == 0) {
                        this._state = 3;
                        break;
                    }
                    if (length > remaining) {
                        length = remaining;
                    }
                    Buffer chunk = this._buffer.get(length);
                    this._handler.content(this._contentPosition, chunk);
                    this._contentPosition += chunk.length();
                    this._chunkPosition += chunk.length();
                    return;
                }
            }
            length = this._buffer.length();
        }
    }

    public void reset() {
        this._state = -11;
        this._contentLength = -3;
        this._contentPosition = 0;
        this._length = 0;
        this._close = false;
        this._hasContent = false;
        this._response = false;
        if (this._buffer == this._content && this._content.length() <= this._header.space()) {
            this._buffer = this._header;
            if (this._content.length() > 0) {
                this._header.put(this._content);
            }
            if (this._buffers != null) {
                this._buffers.returnBuffer(this._content);
            }
            this._content = null;
        }
        this._buffer.compact();
        this._tok0.update(this._buffer);
        this._tok0.update(0, 0);
        this._tok1.update(this._buffer);
        this._tok1.update(0, 0);
    }

    public static abstract class EventHandler {
        public abstract void startRequest(Buffer var1, Buffer var2, Buffer var3) throws IOException;

        public abstract void startResponse(Buffer var1, int var2, Buffer var3) throws IOException;

        public void parsedHeader(Buffer name, Buffer value) throws IOException {
        }

        public void headerComplete() throws IOException {
        }

        public void content(int index, Buffer ref) throws IOException {
        }

        public void messageComplete(int contextLength) throws IOException {
        }
    }
}

