/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.nio;

import java.io.IOException;
import java.net.Socket;
import java.nio.channels.ByteChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.mortbay.io.Buffer;
import org.mortbay.io.nio.ChannelEndPoint;
import org.mortbay.io.nio.NIOBuffer;
import org.mortbay.jetty.AbstractConnector;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.util.LogSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockingChannelConnector
extends AbstractConnector {
    private static Logger log = LoggerFactory.getLogger((Class)(class$org$mortbay$jetty$nio$BlockingChannelConnector == null ? (class$org$mortbay$jetty$nio$BlockingChannelConnector = BlockingChannelConnector.class$("org.mortbay.jetty.nio.BlockingChannelConnector")) : class$org$mortbay$jetty$nio$BlockingChannelConnector));
    private transient ServerSocketChannel _acceptChannel;
    static /* synthetic */ Class class$org$mortbay$jetty$nio$BlockingChannelConnector;

    public void open() throws IOException {
        this._acceptChannel = ServerSocketChannel.open();
        this._acceptChannel.configureBlocking(true);
        this._acceptChannel.socket().bind(this.getAddress());
    }

    public void close() throws IOException {
        if (this._acceptChannel != null) {
            this._acceptChannel.close();
        }
        this._acceptChannel = null;
    }

    public void accept() throws IOException, InterruptedException {
        SocketChannel channel = this._acceptChannel.accept();
        channel.configureBlocking(true);
        Socket socket = channel.socket();
        this.configure(socket);
        Connection connection = new Connection(channel);
        connection.dispatch();
    }

    protected Buffer newBuffer(int size) {
        return new NIOBuffer(size, true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class Connection
    extends ChannelEndPoint
    implements Runnable {
        boolean _dispatched = false;
        HttpConnection _connection;

        Connection(ByteChannel channel) throws IOException {
            super(channel);
            this._connection = new HttpConnection(BlockingChannelConnector.this, this, BlockingChannelConnector.this.getHandler());
        }

        void dispatch() throws InterruptedException {
            BlockingChannelConnector.this.getThreadPool().dispatch(this);
        }

        public int fill(Buffer buffer) throws IOException {
            int l = super.fill(buffer);
            if (l < 0) {
                this.getChannel().close();
            }
            return l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (!this.isClosed()) {
                    this._connection.handle();
                }
            }
            catch (IOException e) {
                if ("BAD".equals(e.getMessage())) {
                    log.warn("BAD Request");
                    log.debug("BAD", (Throwable)e);
                } else if ("EOF".equals(e.getMessage())) {
                    log.debug("EOF", (Throwable)e);
                } else {
                    log.warn("IO", (Throwable)e);
                }
                try {
                    this.close();
                }
                catch (IOException e2) {
                    LogSupport.ignore(log, e2);
                }
            }
            catch (Throwable e) {
                log.warn("handle failed", e);
                try {
                    this.close();
                }
                catch (IOException e2) {
                    LogSupport.ignore(log, e2);
                }
            }
        }
    }
}

