/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.security;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.mortbay.util.LazyList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Constraint
implements Cloneable,
Serializable {
    private static Logger log = LoggerFactory.getLogger((Class)(class$org$mortbay$jetty$security$Constraint == null ? (class$org$mortbay$jetty$security$Constraint = Constraint.class$("org.mortbay.jetty.security.Constraint")) : class$org$mortbay$jetty$security$Constraint));
    public static final String __BASIC_AUTH = "BASIC";
    public static final String __FORM_AUTH = "FORM";
    public static final String __DIGEST_AUTH = "DIGEST";
    public static final String __CERT_AUTH = "CLIENT_CERT";
    public static final String __CERT_AUTH2 = "CLIENT-CERT";
    public static final int DC_UNSET = -1;
    public static final int DC_NONE = 0;
    public static final int DC_INTEGRAL = 1;
    public static final int DC_CONFIDENTIAL = 2;
    public static final String NONE = "NONE";
    public static final String ANY_ROLE = "*";
    private String _name;
    private Object _roles;
    private int _dataConstraint = -1;
    private boolean _anyRole = false;
    private boolean _authenticate = false;
    private transient List _umMethods;
    private transient List _umRoles;
    static /* synthetic */ Class class$org$mortbay$jetty$security$Constraint;

    public Constraint() {
    }

    public Constraint(String name, String role) {
        this.setName(name);
        this.addRole(role);
    }

    public void setName(String name) {
        this._name = name;
    }

    public synchronized void addRole(String role) {
        this._authenticate = true;
        if (ANY_ROLE.equals(role)) {
            this._roles = null;
            this._umRoles = null;
            this._anyRole = true;
        } else if (!this._anyRole) {
            this._roles = LazyList.add(this._roles, role);
        }
    }

    public boolean isAnyRole() {
        return this._anyRole;
    }

    public List getRoles() {
        if (this._umRoles == null && this._roles != null) {
            this._umRoles = Collections.unmodifiableList(LazyList.getList(this._roles));
        }
        return this._umRoles;
    }

    public boolean hasRole(String role) {
        return LazyList.contains(this._roles, role);
    }

    public void setAuthenticate(boolean authenticate) {
        this._authenticate = authenticate;
    }

    public boolean getAuthenticate() {
        return this._authenticate;
    }

    public boolean isForbidden() {
        return this._authenticate && !this._anyRole && LazyList.size(this._roles) == 0;
    }

    public void setDataConstraint(int c) {
        if (c < 0 || c > 2) {
            throw new IllegalArgumentException("Constraint out of range");
        }
        this._dataConstraint = c;
    }

    public int getDataConstraint() {
        return this._dataConstraint;
    }

    public boolean hasDataConstraint() {
        return this._dataConstraint >= 0;
    }

    public Object clone() throws CloneNotSupportedException {
        Constraint sc = (Constraint)super.clone();
        sc._umMethods = null;
        sc._umRoles = null;
        return sc;
    }

    public String toString() {
        return "SC{" + this._name + "," + (this._anyRole ? ANY_ROLE : (this._roles == null ? "-" : this._roles.toString())) + "," + (this._dataConstraint == 0 ? "NONE}" : (this._dataConstraint == 1 ? "INTEGRAL}" : "CONFIDENTIAL}"));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

