/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.io.AbstractBuffer;
import org.mortbay.io.Buffer;
import org.mortbay.io.ByteArrayBuffer;
import org.mortbay.io.IO;
import org.mortbay.io.View;
import org.mortbay.io.WriterOutputStream;
import org.mortbay.io.nio.NIOBuffer;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.HttpContent;
import org.mortbay.jetty.HttpFields;
import org.mortbay.jetty.InclusiveByteRange;
import org.mortbay.jetty.MimeTypes;
import org.mortbay.jetty.MultiPartResponse;
import org.mortbay.jetty.ResourceCache;
import org.mortbay.jetty.Response;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.resource.Resource;
import org.mortbay.resource.ResourceFactory;
import org.mortbay.util.LogSupport;
import org.mortbay.util.URIUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultServlet
extends HttpServlet
implements ResourceFactory {
    private static Logger log = LoggerFactory.getLogger((Class)(class$org$mortbay$jetty$servlet$DefaultServlet == null ? (class$org$mortbay$jetty$servlet$DefaultServlet = DefaultServlet.class$("org.mortbay.jetty.servlet.DefaultServlet")) : class$org$mortbay$jetty$servlet$DefaultServlet));
    private ContextHandler.Context _context;
    private String _AllowString = "GET, POST, HEAD, OPTIONS, TRACE";
    private int _maxByteBuffer = 1024;
    private int _maxDirectBuffer = 131072;
    private int _maxFileBuffer = 262144;
    private boolean _acceptRanges = true;
    private boolean _dirAllowed = true;
    private boolean _redirectWelcome = true;
    private boolean _gzip = true;
    private Resource _resourceBase;
    private ResourceCache _cache = new ResourceCache();
    private MimeTypes _mimeTypes;
    private String[] _welcomes;
    static /* synthetic */ Class class$org$mortbay$jetty$servlet$DefaultServlet;

    public void init() throws UnavailableException {
        ServletContext config = this.getServletContext();
        this._context = (ContextHandler.Context)config;
        this._mimeTypes = this._context.getContextHandler().getMimeTypes();
        this._welcomes = this._context.getContextHandler().getWelcomeFiles();
        if (this._welcomes == null) {
            this._welcomes = new String[]{"index.jsp", "index.html"};
        }
        this._acceptRanges = this.getInitBoolean("acceptRanges", this._acceptRanges);
        this._dirAllowed = this.getInitBoolean("dirAllowed", this._dirAllowed);
        this._redirectWelcome = this.getInitBoolean("redirectWelcome", this._redirectWelcome);
        this._gzip = this.getInitBoolean("gzip", this._gzip);
        this._maxByteBuffer = this.getInitInt("maxByteBuffer", this._maxByteBuffer);
        String rrb = this.getInitParameter("relativeResourceBase");
        if (rrb != null) {
            try {
                this._resourceBase = Resource.newResource(this._context.getResource("/")).addPath(rrb);
            }
            catch (Exception e) {
                log.warn("EXCEPTION ", (Throwable)e);
                throw new UnavailableException(e.toString());
            }
        }
        String rb = this.getInitParameter("resourceBase");
        if (rrb != null && rb != null) {
            throw new UnavailableException("resourceBase & relativeResourceBase");
        }
        if (rb != null) {
            try {
                this._resourceBase = Resource.newResource(rb);
            }
            catch (Exception e) {
                log.warn("EXCEPTION ", (Throwable)e);
                throw new UnavailableException(e.toString());
            }
        }
        try {
            int max_cache_size;
            if (this._resourceBase == null) {
                this._resourceBase = Resource.newResource(this._context.getResource("/"));
            }
            if ((max_cache_size = this.getInitInt("maxCacheSize", -2)) > 0) {
                if (this._cache == null) {
                    this._cache = new ResourceCache();
                }
                this._cache.setMaxCacheSize(max_cache_size);
            } else if (max_cache_size != -2) {
                this._cache = null;
            }
            if (this._cache != null) {
                int max_cached_files;
                int max_cached_file_size = this.getInitInt("maxCachedFileSize", -2);
                if (max_cached_file_size >= -1) {
                    this._cache.setMaxCachedFileSize(max_cached_file_size);
                }
                if ((max_cached_files = this.getInitInt("maxCachedFiles", -2)) >= -1) {
                    this._cache.setMaxCachedFiles(max_cached_files);
                }
                this._cache.start();
            }
        }
        catch (Exception e) {
            log.warn("EXCEPTION ", (Throwable)e);
            throw new UnavailableException(e.toString());
        }
        if (log.isDebugEnabled()) {
            log.debug("resource base = " + this._resourceBase);
        }
    }

    private boolean getInitBoolean(String name, boolean dft) {
        String value = this.getInitParameter(name);
        if (value == null || value.length() == 0) {
            return dft;
        }
        return value.startsWith("t") || value.startsWith("T") || value.startsWith("y") || value.startsWith("Y") || value.startsWith("1");
    }

    private int getInitInt(String name, int dft) {
        String value = this.getInitParameter(name);
        if (value != null && value.length() > 0) {
            return Integer.parseInt(value);
        }
        return dft;
    }

    public Resource getResource(String pathInContext) {
        Resource r = null;
        try {
            r = this._resourceBase.addPath(pathInContext);
            if (log.isDebugEnabled()) {
                log.debug("RESOURCE=" + r);
            }
        }
        catch (IOException e) {
            LogSupport.ignore(log, e);
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String accept;
        Enumeration reqRanges;
        boolean included = false;
        String servletPath = (String)request.getAttribute("javax.servlet.include.servlet_path");
        String pathInfo = null;
        if (servletPath == null) {
            servletPath = request.getServletPath();
            pathInfo = request.getPathInfo();
        } else {
            included = true;
            pathInfo = (String)request.getAttribute("javax.servlet.include.path_info");
        }
        String pathInContext = URIUtil.addPaths(servletPath, pathInfo);
        boolean endsWithSlash = pathInContext.endsWith("/");
        Enumeration enumeration = reqRanges = included ? null : request.getHeaders("Range");
        if (reqRanges != null && !reqRanges.hasMoreElements()) {
            reqRanges = null;
        }
        String pathInContextGz = null;
        boolean gzip = false;
        if (this._gzip && reqRanges == null && !endsWithSlash && (accept = request.getHeader("Accept-Encoding")) != null && accept.indexOf("gzip") >= 0) {
            gzip = true;
        }
        String path = null;
        Resource resource = null;
        ResourceCache.Entry cache = null;
        Object gzcache = null;
        Content content = null;
        try {
            block44: {
                try {
                    if (gzip) {
                        pathInContextGz = pathInContext + ".gz";
                        if (this._cache == null) {
                            resource = this.getResource(pathInContextGz);
                        } else {
                            cache = this._cache.lookup(pathInContextGz, this);
                            if (cache != null) {
                                resource = cache.getResource();
                                content = (Content)cache.getValue();
                            } else {
                                resource = this.getResource(pathInContextGz);
                            }
                        }
                    }
                    if (resource != null && resource.exists()) {
                        path = pathInContextGz;
                    } else {
                        pathInContextGz = null;
                        gzip = false;
                        path = pathInContext;
                        if (this._cache == null) {
                            resource = this.getResource(pathInContext);
                        } else {
                            cache = this._cache.lookup(pathInContext, this);
                            if (cache != null) {
                                resource = cache.getResource();
                                content = (Content)cache.getValue();
                            } else {
                                resource = this.getResource(pathInContext);
                            }
                        }
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("resource=" + resource + (cache != null ? " cache" : "") + (content != null ? " content" : "") + (gzip ? " gzip" : ""));
                    }
                    if (resource == null || !resource.exists()) {
                        response.sendError(404);
                        break block44;
                    }
                    if (!resource.isDirectory()) {
                        if (gzip) {
                            response.setHeader("Content-Encoding", "gzip");
                            response.setHeader("Content-Type", this._context.getMimeType(pathInContext));
                        }
                        if (content == null) {
                            content = this.getContent(path, resource);
                            if (cache != null) {
                                cache.setValue(content);
                            }
                        }
                        if (included || this.passConditionalHeaders(request, response, resource, content)) {
                            this.sendData(request, response, included, resource, content, reqRanges);
                        }
                        break block44;
                    }
                    String welcome = null;
                    if (!endsWithSlash && !pathInContext.equals("/")) {
                        String q = request.getQueryString();
                        StringBuffer buf = request.getRequestURL();
                        if (q != null && q.length() != 0) {
                            buf.append('?');
                            buf.append(q);
                        }
                        response.setContentLength(0);
                        response.sendRedirect(response.encodeRedirectURL(URIUtil.addPaths(buf.toString(), "/")));
                        break block44;
                    }
                    welcome = this.getWelcomeFile(resource);
                    if (null != welcome) {
                        String ipath = URIUtil.addPaths(pathInContext, welcome);
                        if (this._redirectWelcome) {
                            response.setContentLength(0);
                            response.sendRedirect(URIUtil.addPaths(this._context.getContextPath(), ipath));
                        } else {
                            RequestDispatcher dispatcher = request.getRequestDispatcher(ipath);
                            if (dispatcher != null) {
                                dispatcher.forward((ServletRequest)request, (ServletResponse)response);
                            }
                        }
                        break block44;
                    }
                    content = this.getContent(pathInContext, resource);
                    if (!included && !this.passConditionalHeaders(request, response, resource, content)) break block44;
                    this.sendDirectory(request, response, resource, pathInContext.length() > 1);
                }
                catch (IllegalArgumentException e) {
                    log.warn("EXCEPTION ", (Throwable)e);
                    Object var20_23 = null;
                    if (cache != null && cache.getValue() == null) {
                        cache.invalidate();
                    }
                    if (content != null) {
                        content.release();
                    } else if (resource != null) {
                        resource.release();
                    }
                }
            }
            Object var20_22 = null;
            if (cache != null && cache.getValue() == null) {
                cache.invalidate();
            }
            if (content != null) {
                content.release();
            } else if (resource != null) {
                resource.release();
            }
        }
        catch (Throwable throwable) {
            Object var20_24 = null;
            if (cache != null && cache.getValue() == null) {
                cache.invalidate();
            }
            if (content != null) {
                content.release();
            } else if (resource != null) {
                resource.release();
            }
            throw throwable;
        }
    }

    private Content getContent(String pathInContext, Resource resource) throws IOException {
        Content content = new Content(resource);
        Buffer mime_type = this._mimeTypes.getMimeByExtension(pathInContext);
        if (mime_type != null) {
            content.setContentType(mime_type);
        }
        if (!resource.isDirectory()) {
            File file;
            AbstractBuffer buffer = null;
            long length = resource.length();
            if (length < (long)this._maxByteBuffer) {
                buffer = new ByteArrayBuffer((int)length);
                byte[] array = buffer.array();
                InputStream in = resource.getInputStream();
                int l = 0;
                while ((long)l < length) {
                    int r = in.read(array, l, array.length - l);
                    if (r < 0) {
                        throw new IOException("unexpect EOF");
                    }
                    l += r;
                }
                buffer.setPutIndex(l);
            } else if (length < (long)this._maxDirectBuffer) {
                buffer = new NIOBuffer((int)length, true);
                byte[] buf = new byte[8192];
                InputStream in = resource.getInputStream();
                int l = 0;
                while ((long)l < length) {
                    int r = in.read(buf, 0, buf.length);
                    if (r < 0) {
                        throw new IOException("unexpect EOF");
                    }
                    buffer.put(buf, 0, r);
                    l += r;
                }
            } else if (length < (long)this._maxFileBuffer && (file = resource.getFile()) != null) {
                buffer = new NIOBuffer(file);
            }
            if (buffer != null) {
                content.setBuffer(buffer);
                if (log.isDebugEnabled()) {
                    log.debug("content buffer is " + buffer.getClass());
                }
            }
        }
        return content;
    }

    private String getWelcomeFile(Resource resource) throws MalformedURLException, IOException {
        if (!resource.isDirectory() || this._welcomes == null) {
            return null;
        }
        for (int i = 0; i < this._welcomes.length; ++i) {
            Resource welcome = resource.addPath(this._welcomes[i]);
            if (!welcome.exists()) continue;
            return this._welcomes[i];
        }
        return null;
    }

    protected boolean passConditionalHeaders(HttpServletRequest request, HttpServletResponse response, Resource resource, Content content) throws IOException {
        if (!request.getMethod().equals("HEAD")) {
            if (content != null) {
                String ifms = request.getHeader("If-Modified-Since");
                String mdlm = content.getLastModified().toString();
                if (ifms != null && mdlm != null && ifms.equals(mdlm)) {
                    response.reset();
                    response.setStatus(304);
                    response.flushBuffer();
                    return false;
                }
            }
            long date = 0L;
            date = request.getDateHeader("If-Unmodified-Since");
            if (date > 0L && resource.lastModified() / 1000L > date / 1000L) {
                response.sendError(412);
                return false;
            }
            date = request.getDateHeader("If-Modified-Since");
            if (date > 0L && resource.lastModified() / 1000L <= date / 1000L) {
                response.reset();
                response.setStatus(304);
                response.flushBuffer();
                return false;
            }
        }
        return true;
    }

    protected void sendDirectory(HttpServletRequest request, HttpServletResponse response, Resource resource, boolean parent) throws IOException {
        if (!this._dirAllowed) {
            response.sendError(403);
            return;
        }
        byte[] data = null;
        String base = URIUtil.addPaths(request.getRequestURI(), "/");
        String dir = resource.getListHTML(base, parent);
        if (dir == null) {
            response.sendError(403, "No directory");
            return;
        }
        data = dir.getBytes("UTF-8");
        response.setContentType("text/html; charset=UTF-8");
        response.setContentLength(data.length);
        response.getOutputStream().write(data);
    }

    protected void sendData(HttpServletRequest request, HttpServletResponse response, boolean include, Resource resource, Content content, Enumeration reqRanges) throws IOException {
        Resource encodedResource = resource;
        long content_length = resource.length();
        Object out = null;
        try {
            out = response.getOutputStream();
        }
        catch (IllegalStateException e) {
            out = new WriterOutputStream(response.getWriter());
        }
        if (reqRanges == null || !reqRanges.hasMoreElements()) {
            if (include) {
                resource.writeTo((OutputStream)out, 0L, content_length);
            } else if (out instanceof HttpConnection.Output && content.getBuffer() != null) {
                ((HttpConnection.Output)((Object)out)).sendContent(content);
            } else {
                this.writeHeaders(response, content, content_length);
                resource.writeTo((OutputStream)out, 0L, content_length);
            }
        } else {
            List ranges = InclusiveByteRange.satisfiableRanges(reqRanges, content_length);
            if (ranges == null || ranges.size() == 0) {
                this.writeHeaders(response, content, content_length);
                response.setStatus(416);
                response.setHeader("Content-Range", InclusiveByteRange.to416HeaderRangeString(content_length));
                resource.writeTo((OutputStream)out, 0L, content_length);
                return;
            }
            if (ranges.size() == 1) {
                InclusiveByteRange singleSatisfiableRange = (InclusiveByteRange)ranges.get(0);
                long singleLength = singleSatisfiableRange.getSize(content_length);
                this.writeHeaders(response, content, singleLength);
                response.setStatus(206);
                response.setHeader("Content-Range", singleSatisfiableRange.toHeaderRangeString(content_length));
                resource.writeTo((OutputStream)out, singleSatisfiableRange.getFirst(content_length), singleLength);
                return;
            }
            this.writeHeaders(response, content, -1L);
            String mimetype = content.getContentType().toString();
            MultiPartResponse multi = new MultiPartResponse((OutputStream)response.getOutputStream());
            response.setStatus(206);
            String ctp = request.getHeader("Request-Range") != null ? "multipart/x-byteranges; boundary=" : "multipart/byteranges; boundary=";
            response.setContentType(ctp + multi.getBoundary());
            InputStream in = resource.getInputStream();
            long pos = 0L;
            for (int i = 0; i < ranges.size(); ++i) {
                InclusiveByteRange ibr = (InclusiveByteRange)ranges.get(i);
                String header = "Content-Range: " + ibr.toHeaderRangeString(content_length);
                multi.startPart(mimetype, new String[]{header});
                long start = ibr.getFirst(content_length);
                long size = ibr.getSize(content_length);
                if (in != null) {
                    if (start < pos) {
                        in.close();
                        in = resource.getInputStream();
                        pos = 0L;
                    }
                    if (pos < start) {
                        in.skip(start - pos);
                        pos = start;
                    }
                    IO.copy(in, (OutputStream)out, size);
                    pos += size;
                    continue;
                }
                resource.writeTo((OutputStream)out, start, size);
            }
            if (in != null) {
                in.close();
            }
            multi.close();
        }
    }

    protected void writeHeaders(HttpServletResponse response, Content content, long count) throws IOException {
        if (content.getContentType() != null) {
            response.setContentType(content.getContentType().toString());
        }
        if (content.getLastModified() != null) {
            response.setHeader("Last-Modified", content.getLastModified().toString());
        }
        if (count != -1L) {
            if (response instanceof Response) {
                ((Response)response).setLongContentLength(count);
            } else if (count < Integer.MAX_VALUE) {
                response.setContentLength((int)count);
            } else {
                response.setHeader("Content-Length", "" + count);
            }
        }
        if (this._acceptRanges) {
            response.setHeader("Accept-Ranges", "bytes");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        try {
            if (this._cache != null) {
                this._cache.stop();
            }
        }
        catch (Exception e) {
            log.warn("EXCEPTION ", (Throwable)e);
        }
        finally {
            super.destroy();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Content
    implements ResourceCache.Value,
    HttpContent {
        Resource _resource;
        String _name;
        long _lastModified;
        Buffer _lastModifiedBytes;
        Buffer _contentType;
        boolean _valid;
        Buffer _buffer;

        Content(Resource resource) {
            this._resource = resource;
            this._name = this._resource.toString();
            this._lastModified = resource.lastModified();
            this._lastModifiedBytes = new ByteArrayBuffer(HttpFields.formatDate(this._resource.lastModified(), false));
        }

        public Resource getResource() {
            return this._resource;
        }

        public Buffer getLastModified() {
            return this._lastModifiedBytes;
        }

        public Buffer getContentType() {
            return this._contentType;
        }

        public void setContentType(Buffer type) {
            this._contentType = type;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void validate() {
            Content content = this;
            synchronized (content) {
                this._valid = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invalidate() {
            Content content = this;
            synchronized (content) {
                this._valid = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            Content content = this;
            synchronized (content) {
                if (!this._valid) {
                    this._resource.release();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isValid() {
            Content content = this;
            synchronized (content) {
                return this._valid;
            }
        }

        public Buffer getBuffer() {
            if (this._buffer == null) {
                return null;
            }
            return new View(this._buffer);
        }

        public void setBuffer(Buffer buffer) {
            this._buffer = buffer;
        }

        public long getContentLength() {
            if (this._buffer == null) {
                return -1L;
            }
            return this._buffer.length();
        }
    }
}

