/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import org.mortbay.jetty.servlet.FilterHolder;
import org.mortbay.jetty.servlet.PathMap;

public class FilterMapping {
    private int _dispatches = 1;
    private String _filterName;
    private transient FilterHolder _holder;
    private String _pathSpec;
    private String _servletName;

    public FilterMapping() {
    }

    public FilterMapping(String pathSpec, String servletName, int dispatches, String filter) {
        this._pathSpec = pathSpec;
        this._servletName = servletName;
        this._filterName = filter;
        this._dispatches = dispatches;
    }

    boolean appliesTo(String path, int type) {
        boolean b = ((this._dispatches & type) != 0 || this._dispatches == 0 && type == 1) && (this._pathSpec == null || PathMap.match(this._pathSpec, path, true));
        return b;
    }

    public int getDispatches() {
        return this._dispatches;
    }

    public String getFilterName() {
        return this._filterName;
    }

    FilterHolder getFilterHolder() {
        return this._holder;
    }

    public String getPathSpec() {
        return this._pathSpec;
    }

    public void setDispatches(int dispatches) {
        this._dispatches = dispatches;
    }

    public void setFilterName(String filterName) {
        this._filterName = filterName;
    }

    void setFilterHolder(FilterHolder holder) {
        this._holder = holder;
    }

    public void setPathSpec(String pathSpec) {
        this._pathSpec = pathSpec;
    }

    public String getServletName() {
        return this._servletName;
    }

    public void setServletName(String servletName) {
        this._servletName = servletName;
    }
}

