/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.io.IOException;
import java.util.EventListener;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.SessionManager;
import org.mortbay.jetty.handler.WrappedHandler;
import org.mortbay.jetty.servlet.HashSessionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionHandler
extends WrappedHandler {
    private static Logger log = LoggerFactory.getLogger((Class)(class$org$mortbay$jetty$servlet$SessionHandler == null ? (class$org$mortbay$jetty$servlet$SessionHandler = SessionHandler.class$("org.mortbay.jetty.servlet.SessionHandler")) : class$org$mortbay$jetty$servlet$SessionHandler));
    SessionManager _sessionManager = new HashSessionManager();
    static /* synthetic */ Class class$org$mortbay$jetty$servlet$SessionHandler;

    public SessionManager getSessionManager() {
        return this._sessionManager;
    }

    public void setSessionManager(SessionManager sessionManager) {
        if (this.isStarted()) {
            throw new IllegalStateException();
        }
        this._sessionManager = sessionManager;
    }

    protected void doStart() throws Exception {
        this._sessionManager.start();
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
        this._sessionManager.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
        boolean result = false;
        Request jetty_request = request instanceof Request ? (Request)request : HttpConnection.getCurrentConnection().getRequest();
        SessionManager old_session_manager = null;
        HttpSession old_session = null;
        try {
            String requested_session_id = request.getRequestedSessionId();
            if (requested_session_id == null) {
                String path_params;
                String uri;
                int semi;
                boolean requested_session_id_from_cookie = false;
                Cookie[] cookies = request.getCookies();
                if (cookies != null && cookies.length > 0) {
                    for (int i = 0; i < cookies.length; ++i) {
                        if (!SessionManager.__SessionCookie.equalsIgnoreCase(cookies[i].getName())) continue;
                        if (requested_session_id != null && this._sessionManager.getHttpSession(requested_session_id) != null) break;
                        requested_session_id = cookies[i].getValue();
                        requested_session_id_from_cookie = true;
                        if (!log.isDebugEnabled()) continue;
                        log.debug("Got Session ID " + requested_session_id + " from cookie");
                    }
                }
                if (requested_session_id == null && (semi = (uri = request.getRequestURI()).lastIndexOf(59)) >= 0 && (path_params = uri.substring(semi + 1)) != null && path_params.startsWith(SessionManager.__SessionURL)) {
                    requested_session_id = path_params.substring(SessionManager.__SessionURL.length() + 1);
                    if (log.isDebugEnabled()) {
                        log.debug("Got Session ID " + requested_session_id + " from URL");
                    }
                }
                jetty_request.setRequestedSessionId(requested_session_id);
                jetty_request.setRequestedSessionIdFromCookie(requested_session_id != null && requested_session_id_from_cookie);
            }
            old_session_manager = jetty_request.getSessionManager();
            old_session = jetty_request.getSession(false);
            jetty_request.setSessionManager(this._sessionManager);
            jetty_request.setSession(null);
            HttpSession session = request.getSession(false);
            if (session != null) {
                ((SessionManager.Session)session).access();
            }
            if (log.isDebugEnabled()) {
                log.debug("session=" + session);
            }
            result = this.getHandler().handle(target, jetty_request, response, dispatch);
            jetty_request.setSessionManager(old_session_manager);
            jetty_request.setSession(old_session);
        }
        catch (Throwable throwable) {
            jetty_request.setSessionManager(old_session_manager);
            jetty_request.setSession(old_session);
            throw throwable;
        }
        return result;
    }

    public void addEventListener(EventListener listener) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

