/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.webapp;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionListener;
import org.mortbay.io.IO;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.security.SecurityHandler;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.SessionHandler;
import org.mortbay.jetty.webapp.Configuration;
import org.mortbay.jetty.webapp.WebAppClassLoader;
import org.mortbay.resource.JarResource;
import org.mortbay.resource.Resource;
import org.mortbay.util.LazyList;
import org.mortbay.util.Loader;
import org.mortbay.util.LogSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebAppHandler
extends ContextHandler {
    private static Logger log = LoggerFactory.getLogger((Class)(class$org$mortbay$jetty$webapp$WebAppHandler == null ? (class$org$mortbay$jetty$webapp$WebAppHandler = WebAppHandler.class$("org.mortbay.jetty.webapp.WebAppHandler")) : class$org$mortbay$jetty$webapp$WebAppHandler));
    private SecurityHandler _securityHandler;
    private SessionHandler _sessionHandler;
    private ServletHandler _servletHandler = new ServletHandler();
    private String[] _configurationClasses;
    private Configuration[] _configurations;
    private File _tmpDir;
    private Object _contextListeners;
    private String _war;
    private boolean _extractWAR = true;
    private String _defaultsDescriptor = "org/mortbay/jetty/webapp/webdefault.xml";
    private boolean distributable = false;
    private transient Resource _webApp;
    private transient Resource _webInf;
    static /* synthetic */ Class class$org$mortbay$jetty$webapp$WebAppHandler;

    public WebAppHandler() {
        this._sessionHandler = new SessionHandler();
        this._sessionHandler.setHandler(this._servletHandler);
        this._securityHandler = new SecurityHandler();
        this._securityHandler.setHandler(this._sessionHandler);
        this.setHandler(this._securityHandler);
    }

    public String getWar() {
        return this._war;
    }

    public void setWar(String war) {
        this._war = war;
    }

    public String[] getConfigurationClasses() {
        return this._configurationClasses;
    }

    public void setConfigurationClasses(String[] configurations) {
        this._configurationClasses = configurations == null ? null : (String[])configurations.clone();
    }

    public Configuration[] getConfigurations() {
        return this._configurations;
    }

    public void setConfigurations(Configuration[] configurations) {
        this._configurations = configurations == null ? null : (Configuration[])configurations.clone();
    }

    public ServletHandler getServletHandler() {
        return this._servletHandler;
    }

    public void setServletHandler(ServletHandler servletHandler) {
        this._servletHandler = servletHandler;
    }

    public SessionHandler getSessionHandler() {
        return this._sessionHandler;
    }

    public void setSessionHandler(SessionHandler sessionHandler) {
        this._sessionHandler = sessionHandler;
    }

    public SecurityHandler getSecurityHandler() {
        return this._securityHandler;
    }

    public void setSecurityHandler(SecurityHandler securityHandler) {
        this._securityHandler = securityHandler;
    }

    public String getDefaultsDescriptor() {
        return this._defaultsDescriptor;
    }

    public void setDefaultsDescriptor(String defaultsDescriptor) {
        this._defaultsDescriptor = defaultsDescriptor;
    }

    public boolean isExtractWAR() {
        return this._extractWAR;
    }

    public void setExtractWAR(boolean extractWAR) {
        this._extractWAR = extractWAR;
    }

    public boolean isDistributable() {
        return this.distributable;
    }

    public void setDistributable(boolean distributable) {
        this.distributable = distributable;
    }

    public synchronized void addEventListener(EventListener listener) throws IllegalArgumentException {
        if (listener instanceof ServletContextListener) {
            this._contextListeners = LazyList.add(this._contextListeners, listener);
        }
        if ((listener instanceof HttpSessionActivationListener || listener instanceof HttpSessionAttributeListener || listener instanceof HttpSessionBindingListener || listener instanceof HttpSessionListener) && this._sessionHandler != null) {
            this._sessionHandler.addEventListener(listener);
        }
        if (listener instanceof ServletRequestListener || listener instanceof ServletRequestAttributeListener || listener instanceof ServletContextAttributeListener || listener instanceof ServletRequestAttributeListener || listener instanceof ServletContextAttributeListener) {
            this._servletHandler.addEventListener(listener);
        }
    }

    protected void resolveWebApp() throws IOException {
        if (this._webApp == null) {
            Resource jarWebApp;
            if (this._war == null || this._war.length() == 0) {
                this._war = this.getResourceBase();
            }
            this._webApp = Resource.newResource(this._war);
            if (this._webApp.getAlias() != null) {
                log.info(this._webApp + " anti-aliased to " + this._webApp.getAlias());
                this._webApp = Resource.newResource(this._webApp.getAlias());
            }
            if (log.isDebugEnabled()) {
                log.debug("Try webapp=" + this._webApp + ", exists=" + this._webApp.exists() + ", directory=" + this._webApp.isDirectory());
            }
            if (this._webApp.exists() && !this._webApp.isDirectory() && !this._webApp.toString().startsWith("jar:") && (jarWebApp = Resource.newResource("jar:" + this._webApp + "!/")).exists() && jarWebApp.isDirectory()) {
                this._webApp = jarWebApp;
                this._war = this._webApp.toString();
                if (log.isDebugEnabled()) {
                    log.debug("Try webapp=" + this._webApp + ", exists=" + this._webApp.exists() + ", directory=" + this._webApp.isDirectory());
                }
            }
            if (this._webApp.exists() && (!this._webApp.isDirectory() || this._extractWAR && this._webApp.getFile() == null || this._extractWAR && this._webApp.getFile() != null && !this._webApp.getFile().isDirectory())) {
                File tempDir = new File(this.getTempDirectory(), "webapp");
                if (tempDir.exists()) {
                    tempDir.delete();
                }
                tempDir.mkdir();
                tempDir.deleteOnExit();
                log.info("Extract " + this._war + " to " + tempDir);
                JarResource.extract(this._webApp, tempDir, true);
                this._webApp = Resource.newResource(tempDir.getCanonicalPath());
                if (log.isDebugEnabled()) {
                    log.debug("Try webapp=" + this._webApp + ", exists=" + this._webApp.exists() + ", directory=" + this._webApp.isDirectory());
                }
            }
            if (!this._webApp.exists() || !this._webApp.isDirectory()) {
                log.warn("Web application not found " + this._war);
                throw new FileNotFoundException(this._war);
            }
            if (log.isDebugEnabled()) {
                log.debug("webapp=" + this._webApp);
            }
            this._webInf = this._webApp.addPath("WEB-INF/");
            if (!this._webInf.exists() || !this._webInf.isDirectory()) {
                this._webInf = null;
            } else {
                Resource work = this._webInf.addPath("work");
                if (work.exists() && work.isDirectory() && work.getFile() != null && work.getFile().canWrite() && this.getAttribute("javax.servlet.context.tempdir") == null) {
                    this.setAttribute("javax.servlet.context.tempdir", work.getFile());
                }
            }
            super.setBaseResource(this._webApp);
        }
    }

    public Resource getWebInf() throws IOException {
        if (this._webInf == null) {
            this.resolveWebApp();
        }
        return this._webInf;
    }

    public void setTempDirectory(File dir) {
        if (this.isStarted()) {
            throw new IllegalStateException("Started");
        }
        if (dir != null) {
            try {
                dir = new File(dir.getCanonicalPath());
            }
            catch (IOException e) {
                log.warn("EXCEPTION ", (Throwable)e);
            }
        }
        if (dir != null && !dir.exists()) {
            dir.mkdir();
            dir.deleteOnExit();
        }
        if (!(dir == null || dir.exists() && dir.isDirectory() && dir.canWrite())) {
            throw new IllegalArgumentException("Bad temp directory: " + dir);
        }
        this._tmpDir = dir;
        this.setAttribute("javax.servlet.context.tempdir", this._tmpDir);
    }

    public File getTempDirectory() {
        if (this._tmpDir != null) {
            return this._tmpDir;
        }
        Object t = this.getAttribute("javax.servlet.context.tempdir");
        if (t != null && t instanceof File) {
            this._tmpDir = (File)t;
            if (this._tmpDir.isDirectory() && this._tmpDir.canWrite()) {
                return this._tmpDir;
            }
        }
        if (t != null && t instanceof String) {
            try {
                this._tmpDir = new File((String)t);
                if (this._tmpDir.isDirectory() && this._tmpDir.canWrite()) {
                    if (log.isDebugEnabled()) {
                        log.debug("Converted to File " + this._tmpDir + " for " + this);
                    }
                    this.setAttribute("javax.servlet.context.tempdir", this._tmpDir);
                    return this._tmpDir;
                }
            }
            catch (Exception e) {
                log.warn("EXCEPTION ", (Throwable)e);
            }
        }
        File work = null;
        try {
            work = new File(System.getProperty("jetty.home"), "work");
            if (!(work.exists() && work.canWrite() && work.isDirectory())) {
                work = null;
            }
        }
        catch (Exception e) {
            LogSupport.ignore(log, e);
        }
        try {
            String temp = "Jetty_" + this.getContextPath();
            temp = temp.replace('/', '_');
            temp = temp.replace('.', '_');
            temp = temp.replace('\\', '_');
            if (work != null) {
                this._tmpDir = new File(work, temp);
            } else {
                this._tmpDir = new File(System.getProperty("java.io.tmpdir"), temp);
                if (this._tmpDir.exists()) {
                    if (log.isDebugEnabled()) {
                        log.debug("Delete existing temp dir " + this._tmpDir + " for " + this);
                    }
                    if (!IO.delete(this._tmpDir) && log.isDebugEnabled()) {
                        log.debug("Failed to delete temp dir " + this._tmpDir);
                    }
                    if (this._tmpDir.exists()) {
                        String old = this._tmpDir.toString();
                        this._tmpDir = File.createTempFile(temp + "_", "");
                        if (this._tmpDir.exists()) {
                            this._tmpDir.delete();
                        }
                        log.warn("Can't reuse " + old + ", using " + this._tmpDir);
                    }
                }
            }
            if (!this._tmpDir.exists()) {
                this._tmpDir.mkdir();
            }
            if (work == null) {
                this._tmpDir.deleteOnExit();
            }
            if (log.isDebugEnabled()) {
                log.debug("Created temp dir " + this._tmpDir + " for " + this);
            }
        }
        catch (Exception e) {
            this._tmpDir = null;
            LogSupport.ignore(log, e);
        }
        if (this._tmpDir == null) {
            try {
                this._tmpDir = File.createTempFile("JettyContext", "");
                if (this._tmpDir.exists()) {
                    this._tmpDir.delete();
                }
                this._tmpDir.mkdir();
                this._tmpDir.deleteOnExit();
                if (log.isDebugEnabled()) {
                    log.debug("Created temp dir " + this._tmpDir + " for " + this);
                }
            }
            catch (IOException e) {
                log.warn("tmpdir", (Throwable)e);
                System.exit(1);
            }
        }
        this.setAttribute("javax.servlet.context.tempdir", this._tmpDir);
        return this._tmpDir;
    }

    protected void loadConfigurations() throws Exception {
        if (this._configurations != null) {
            return;
        }
        if (this._configurationClasses == null) {
            this._configurationClasses = new String[]{"org.mortbay.jetty.webapp.WebXmlConfiguration", "org.mortbay.jetty.webapp.JettyWebXmlConfiguration"};
        }
        this._configurations = new Configuration[this._configurationClasses.length];
        for (int i = 0; i < this._configurations.length; ++i) {
            this._configurations[i] = (Configuration)Loader.loadClass(this.getClass(), this._configurationClasses[i]).newInstance();
        }
    }

    protected void doStart() throws Exception {
        this.loadConfigurations();
        for (int i = 0; i < this._configurations.length; ++i) {
            this._configurations[i].setWebAppHandler(this);
        }
        ClassLoader parent = Thread.currentThread().getContextClassLoader();
        if (parent == null) {
            parent = this.getClass().getClassLoader();
        }
        if (parent == null) {
            parent = ClassLoader.getSystemClassLoader();
        }
        WebAppClassLoader classLoader = new WebAppClassLoader(parent);
        classLoader.setTempDirectory(this.getTempDirectory());
        this.setClassLoader(classLoader);
        for (int i = 0; i < this._configurations.length; ++i) {
            this._configurations[i].configureClassLoader();
        }
        super.doStart();
    }

    protected void startContext() throws Exception {
        int i;
        for (i = 0; i < this._configurations.length; ++i) {
            this._configurations[i].configureDefaults();
        }
        for (i = 0; i < this._configurations.length; ++i) {
            this._configurations[i].configureWebApp();
        }
        this._servletHandler.setInitializeAtStart(false);
        super.startContext();
        if (this._contextListeners != null && this._servletHandler != null) {
            ServletContextEvent event = new ServletContextEvent(this._servletHandler.getServletContext());
            for (int i2 = 0; i2 < LazyList.size(this._contextListeners); ++i2) {
                ((ServletContextListener)LazyList.get(this._contextListeners, i2)).contextInitialized(event);
            }
        }
        if (this._servletHandler != null && this._servletHandler.isStarted()) {
            this._servletHandler.initialize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws Exception {
        super.doStop();
        try {
            int i = this._configurations.length;
            while (i-- > 0) {
                this._configurations[i].deconfigureWebApp();
            }
        }
        finally {
            this.setClassLoader(null);
        }
    }

    public static void addWebApplications(Server server, String webapps, String defaults, boolean extract, boolean java2CompliantClassLoader) throws IOException {
        ArrayList<Handler> wacs = new ArrayList<Handler>(Arrays.asList(server.getHandlers()));
        Resource r = Resource.newResource(webapps);
        if (!r.exists()) {
            throw new IllegalArgumentException("No such webapps resource " + r);
        }
        if (!r.isDirectory()) {
            throw new IllegalArgumentException("Not directory webapps resource " + r);
        }
        String[] files = r.list();
        block0: for (int f = 0; files != null && f < files.length; ++f) {
            Resource unpacked;
            String context = files[f];
            if (context.equalsIgnoreCase("CVS/") || context.equalsIgnoreCase("CVS") || context.startsWith(".")) continue;
            Resource app = r.addPath(r.encode(files[f]));
            if ((context.toLowerCase().endsWith(".war") || context.toLowerCase().endsWith(".jar")) && (unpacked = r.addPath(context = context.substring(0, context.length() - 4))) != null && unpacked.exists() && unpacked.isDirectory()) continue;
            if ((context = context.equalsIgnoreCase("root") || context.equalsIgnoreCase("root/") ? "/" : "/" + context).endsWith("/") && context.length() > 0) {
                context = context.substring(0, context.length() - 1);
            }
            for (int i = 0; i < wacs.size(); ++i) {
                WebAppHandler w;
                Handler o = wacs.get(i);
                if (o instanceof WebAppHandler && app.equals(Resource.newResource((w = (WebAppHandler)o).getWar())) && context.equals(w.getContextPath())) continue block0;
            }
            WebAppHandler wah = new WebAppHandler();
            wah.setContextPath(context);
            if (defaults != null) {
                wah.setDefaultsDescriptor(defaults);
            }
            wah.setExtractWAR(extract);
            wah.setWar(app.toString());
            wacs.add(wah);
        }
        server.setHandlers(wacs.toArray(new Handler[wacs.size()]));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

