/*
 * Decompiled with CFR 0.152.
 */
package org.jface.mavenzilla;

import java.io.IOException;
import java.net.MalformedURLException;
import java.text.Format;
import java.util.Collection;
import java.util.Iterator;
import org.dom4j.Document;
import org.dom4j.Element;
import org.jface.mavenzilla.Resources;
import org.jface.mavenzilla.Search;
import org.jface.mavenzilla.StringUtils;
import org.jface.mavenzilla.TypeSearch;

public class GroupSearch
extends Search {
    private static final Format XPATH = Resources.getFormat("xpath.search.group");
    private final String type;
    private final String pattern;

    public GroupSearch(String url, String type, String pattern) {
        super(url);
        this.type = type;
        this.pattern = pattern;
    }

    protected Collection processDocument(Document doc) throws MalformedURLException, IOException {
        Collection result = null;
        String xpath = XPATH.format(new Object[]{this.pattern});
        Iterator it = doc.selectNodes(xpath).iterator();
        while (it.hasNext()) {
            Element a = (Element)it.next();
            String href = a.attributeValue("href");
            String group = StringUtils.stripEnd(a.getTextTrim(), "/");
            TypeSearch typeSearch = new TypeSearch(String.valueOf(this.url) + href, this.type, group);
            Collection tmp = typeSearch.search();
            if (result == null) {
                result = tmp;
                continue;
            }
            result.addAll(tmp);
        }
        return result;
    }
}

