/*
 * Decompiled with CFR 0.152.
 */
package org.jface.mavenzilla;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.Iterator;
import org.jface.mavenzilla.Mavenzilla;
import org.jface.mavenzilla.ProgressBar;
import org.jface.mavenzilla.SearchResult;
import org.jface.mavenzilla.Table;

public class MavenzillaApp {
    public static void main(String[] args) throws MalformedURLException, IOException {
        if (args.length < 3) {
            System.out.println("Usage: mavenzilla <url> <type> <pattern>");
            System.exit(1);
        }
        ProgressBar progressBar = new ProgressBar("Searching ");
        progressBar.start();
        String url = args[0];
        String type = args[1];
        String pattern = args[2];
        Mavenzilla mavenzilla = new Mavenzilla(url, type, pattern);
        Collection results = mavenzilla.getSearchResults();
        Table table = new Table(new String[]{"", "  ", "  ", "  ", ""}, results.size() + 2);
        table.add(new String[]{"Group", "Artifact Name", "Version", "Type"});
        table.add(new String[0]);
        Iterator it = results.iterator();
        while (it.hasNext()) {
            SearchResult result = (SearchResult)it.next();
            table.add(new String[]{result.getGroup(), result.getName(), result.getVersion(), result.getType()});
        }
        progressBar.stop();
        System.out.println("\n\n" + table);
    }
}

