/*
 * Decompiled with CFR 0.152.
 */
package org.jface.mavenzilla;

import org.jface.mavenzilla.StringUtils;

public class Table {
    private String[][] table;
    private int row;
    private int[] widths;
    private final String[] grid;

    public Table(String[] grid, int numRows) {
        this.grid = grid;
        int numCols = grid.length - 1;
        this.table = new String[numRows][numCols];
        this.widths = new int[numCols];
        this.row = 0;
    }

    public void add(String[] cells) {
        int i = 0;
        while (i < cells.length) {
            String cell;
            this.table[this.row][i] = cell = cells[i];
            this.widths[i] = Math.max(this.widths[i], cell.length());
            ++i;
        }
        ++this.row;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        int row = 0;
        while (row < this.table.length) {
            int col = 0;
            while (col < this.table[row].length) {
                sbuf.append(this.grid[col]);
                sbuf.append(StringUtils.fill(this.table[row][col], ' ', this.widths[col]));
                ++col;
            }
            sbuf.append('\n');
            ++row;
        }
        return sbuf.toString();
    }
}

