/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer;

import java.awt.Color;
import java.awt.Paint;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.renderer.PaintScale;
import org.jfree.io.SerialUtilities;
import org.jfree.util.PaintUtilities;
import org.jfree.util.PublicCloneable;

public class LookupPaintScale
implements PaintScale,
PublicCloneable,
Serializable {
    private double lowerBound;
    private double upperBound;
    private transient Paint defaultPaint;
    private List lookupTable;

    public LookupPaintScale() {
        this(0.0, 1.0, Color.lightGray);
    }

    public LookupPaintScale(double lowerBound, double upperBound, Paint defaultPaint) {
        if (lowerBound >= upperBound) {
            throw new IllegalArgumentException("Requires lowerBound < upperBound.");
        }
        if (defaultPaint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.defaultPaint = defaultPaint;
        this.lookupTable = new ArrayList();
    }

    public Paint getDefaultPaint() {
        return this.defaultPaint;
    }

    public double getLowerBound() {
        return this.lowerBound;
    }

    public double getUpperBound() {
        return this.upperBound;
    }

    public void add(Number n, Paint p) {
        this.lookupTable.add(new PaintItem(n, p));
    }

    public Paint getPaint(double value) {
        Paint result = this.defaultPaint;
        int index = this.lookupTable.size();
        boolean done = false;
        while (index > 0 && !done) {
            PaintItem item = (PaintItem)this.lookupTable.get(--index);
            if (!(value >= item.value.doubleValue())) continue;
            result = item.paint;
            done = true;
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LookupPaintScale)) {
            return false;
        }
        LookupPaintScale that = (LookupPaintScale)obj;
        if (this.lowerBound != that.lowerBound) {
            return false;
        }
        if (this.upperBound != that.upperBound) {
            return false;
        }
        if (!PaintUtilities.equal((Paint)this.defaultPaint, (Paint)that.defaultPaint)) {
            return false;
        }
        return ((Object)this.lookupTable).equals(that.lookupTable);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        SerialUtilities.writePaint((Paint)this.defaultPaint, (ObjectOutputStream)stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.defaultPaint = SerialUtilities.readPaint((ObjectInputStream)stream);
    }

    class PaintItem
    implements Serializable {
        Number value;
        transient Paint paint;

        public PaintItem(Number value, Paint paint) {
            this.value = value;
            this.paint = paint;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof PaintItem)) {
                return false;
            }
            PaintItem that = (PaintItem)obj;
            if (!this.value.equals(that.value)) {
                return false;
            }
            return PaintUtilities.equal((Paint)this.paint, (Paint)that.paint);
        }

        private void writeObject(ObjectOutputStream stream) throws IOException {
            stream.defaultWriteObject();
            SerialUtilities.writePaint((Paint)this.paint, (ObjectOutputStream)stream);
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            stream.defaultReadObject();
            this.paint = SerialUtilities.readPaint((ObjectInputStream)stream);
        }
    }
}

