/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jfree.report.Element;
import org.jfree.report.ReportDefinition;
import org.jfree.report.layout.BandLayoutManager;
import org.jfree.report.layout.StaticLayoutManager;
import org.jfree.report.style.BandDefaultStyleSheet;
import org.jfree.report.style.BandStyleKeys;
import org.jfree.report.style.ElementDefaultStyleSheet;

public class Band
extends Element
implements Serializable,
Cloneable {
    public static final String CONTENT_TYPE = "X-container";
    private ArrayList allElements;
    private transient Element[] allElementsCached;
    public static final String ANONYMOUS_BAND_PREFIX = "anonymousBand@";

    public Band() {
        this.setName(ANONYMOUS_BAND_PREFIX + System.identityHashCode(this));
        StaticLayoutManager layout = new StaticLayoutManager();
        this.getStyle().setStyleProperty(BandLayoutManager.LAYOUTMANAGER, layout);
        this.allElements = new ArrayList();
    }

    public Band(boolean pagebreakBefore, boolean pagebreakAfter) {
        this();
        this.setPagebreakBeforePrint(pagebreakBefore);
        this.setPagebreakAfterPrint(pagebreakAfter);
    }

    public void addElement(int position, Element element) {
        if (position < 0) {
            throw new IllegalArgumentException("Position < 0");
        }
        if (position > this.allElements.size()) {
            throw new IllegalArgumentException("Position < 0");
        }
        if (element == null) {
            throw new NullPointerException("Band.addElement(...): element is null.");
        }
        if (element instanceof Band) {
            Band band = this;
            while (band != null) {
                if (band == element) {
                    throw new IllegalArgumentException("adding container's parent to itself");
                }
                band = band.getParent();
            }
        }
        if (element.getParent() != null) {
            if (element.getParent() == this) {
                return;
            }
            element.getParent().removeElement(element);
        }
        this.allElements.add(position, element);
        this.allElementsCached = null;
        element.setParent(this);
    }

    public void addElement(Element element) {
        this.addElement(this.allElements.size(), element);
    }

    public void addElements(Collection elements) {
        if (elements == null) {
            throw new NullPointerException("Band.addElements(...): collection is null.");
        }
        Iterator iterator = elements.iterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            this.addElement(element);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        Band b = (Band)super.clone();
        int elementSize = this.allElements.size();
        b.allElements = new ArrayList(elementSize);
        b.allElementsCached = new Element[elementSize];
        if (this.allElementsCached != null) {
            int i = 0;
            while (i < this.allElementsCached.length) {
                Element eC = (Element)this.allElementsCached[i].clone();
                b.allElements.add(eC);
                b.allElementsCached[i] = eC;
                eC.setParent(b);
                ++i;
            }
        } else {
            int i = 0;
            while (i < elementSize) {
                Element e = (Element)this.allElements.get(i);
                Element eC = (Element)e.clone();
                b.allElements.add(eC);
                b.allElementsCached[i] = eC;
                eC.setParent(b);
                ++i;
            }
        }
        return b;
    }

    protected ElementDefaultStyleSheet createGlobalDefaultStyle() {
        return BandDefaultStyleSheet.getBandDefaultStyle();
    }

    public String getContentType() {
        return CONTENT_TYPE;
    }

    public Element getElement(int index) {
        if (this.allElementsCached == null) {
            Element[] elements = new Element[this.allElements.size()];
            elements = this.allElements.toArray(elements);
            this.allElementsCached = elements;
        }
        return this.allElementsCached[index];
    }

    public Element getElement(String name) {
        if (name == null) {
            throw new NullPointerException("Band.getElement(...): name is null.");
        }
        Iterator it = ((AbstractList)this.allElements).iterator();
        while (it.hasNext()) {
            Element e = (Element)it.next();
            if (e.getName() == null || !e.getName().equals(name)) continue;
            return e;
        }
        return null;
    }

    public Element[] getElementArray() {
        if (this.allElementsCached == null) {
            Element[] elements = new Element[this.allElements.size()];
            elements = this.allElements.toArray(elements);
            this.allElementsCached = elements;
        }
        return this.allElementsCached;
    }

    public int getElementCount() {
        return this.allElements.size();
    }

    public List getElements() {
        return Collections.unmodifiableList(this.allElements);
    }

    public BandLayoutManager getLayout() {
        return (BandLayoutManager)this.getStyle().getStyleProperty(BandLayoutManager.LAYOUTMANAGER);
    }

    public boolean isPagebreakAfterPrint() {
        return this.getStyle().getBooleanStyleProperty(BandStyleKeys.PAGEBREAK_AFTER);
    }

    public boolean isPagebreakBeforePrint() {
        return this.getStyle().getBooleanStyleProperty(BandStyleKeys.PAGEBREAK_BEFORE);
    }

    public void removeElement(Element e) {
        if (e == null) {
            throw new NullPointerException();
        }
        if (e.getParent() != this) {
            return;
        }
        e.setParent(null);
        ((AbstractCollection)this.allElements).remove(e);
        this.allElementsCached = null;
    }

    public void setLayout(BandLayoutManager layoutManager) {
        this.getStyle().setStyleProperty(BandLayoutManager.LAYOUTMANAGER, layoutManager);
    }

    public void setPagebreakAfterPrint(boolean pagebreakAfterPrint) {
        this.getStyle().setBooleanStyleProperty(BandStyleKeys.PAGEBREAK_AFTER, pagebreakAfterPrint);
    }

    public void setPagebreakBeforePrint(boolean pagebreakBeforePrint) {
        this.getStyle().setBooleanStyleProperty(BandStyleKeys.PAGEBREAK_BEFORE, pagebreakBeforePrint);
    }

    protected void setReportDefinition(ReportDefinition reportDefinition) {
        super.setReportDefinition(reportDefinition);
        Element[] elements = this.getElementArray();
        int i = 0;
        while (i < elements.length) {
            elements[i].setReportDefinition(reportDefinition);
            ++i;
        }
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append(this.getClass().getName());
        b.append("={name=\"");
        b.append(this.getName());
        b.append("\", size=\"");
        b.append(this.allElements.size());
        b.append("\"}");
        return b.toString();
    }
}

