/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report;

import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.io.Serializable;
import java.util.ResourceBundle;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.jfree.report.DataRow;
import org.jfree.report.DefaultResourceBundleFactory;
import org.jfree.report.Group;
import org.jfree.report.GroupList;
import org.jfree.report.ItemBand;
import org.jfree.report.JFreeReportInfo;
import org.jfree.report.PageDefinition;
import org.jfree.report.PageFooter;
import org.jfree.report.PageHeader;
import org.jfree.report.ReportBuilderHints;
import org.jfree.report.ReportDefinition;
import org.jfree.report.ReportFooter;
import org.jfree.report.ReportHeader;
import org.jfree.report.ResourceBundleFactory;
import org.jfree.report.SimplePageDefinition;
import org.jfree.report.Watermark;
import org.jfree.report.function.Expression;
import org.jfree.report.function.ExpressionCollection;
import org.jfree.report.style.StyleSheetCollection;
import org.jfree.report.util.ReportConfiguration;
import org.jfree.report.util.ReportProperties;

public class JFreeReport
implements Cloneable,
Serializable,
ReportDefinition {
    public static final String NAME_PROPERTY = "report.name";
    public static final String REPORT_DATE_PROPERTY = "report.date";
    public static final String REPORT_PAGEFORMAT_PROPERTY = "report.pageformat";
    public static final String REPORT_PREPARERUN_PROPERTY = "report.preparerun";
    public static final String REPORT_DEFINITION_SOURCE = "report.definition.source";
    public static final String REPORT_DEFINITION_CONTENTBASE = "report.definition.contentbase";
    public static final String REPORT_LAYOUT_SUPPORT = "report.layout-support";
    private static JFreeReportInfo info;
    private static EmptyDataRow emptyDataRow;
    private TableModel data;
    private PageDefinition pageDefinition;
    private ReportProperties properties;
    private ExpressionCollection expressions;
    private GroupList groups;
    private ReportHeader reportHeader;
    private ReportFooter reportFooter;
    private PageHeader pageHeader;
    private PageFooter pageFooter;
    private ItemBand itemBand;
    private Watermark watermark;
    private final ReportConfiguration reportConfiguration = new ReportConfiguration(ReportConfiguration.getGlobalConfig());
    private StyleSheetCollection styleSheetCollection;
    private transient ReportBuilderHints reportBuilderHints;
    private ResourceBundleFactory resourceBundleFactory;
    static /* synthetic */ Class class$org$jfree$report$JFreeReport;

    public JFreeReport() {
        this.properties = new ReportProperties();
        this.styleSheetCollection = new StyleSheetCollection();
        this.groups = new GroupList();
        this.reportHeader = new ReportHeader();
        this.reportFooter = new ReportFooter();
        this.pageHeader = new PageHeader();
        this.pageFooter = new PageFooter();
        this.itemBand = new ItemBand();
        this.watermark = new Watermark();
        this.data = new DefaultTableModel();
        this.expressions = new ExpressionCollection();
        this.resourceBundleFactory = new DefaultResourceBundleFactory();
        this.setPageDefinition(null);
        this.groups.setReportDefinition(this);
        this.reportHeader.setReportDefinition(this);
        this.reportFooter.setReportDefinition(this);
        this.pageHeader.setReportDefinition(this);
        this.pageFooter.setReportDefinition(this);
        this.itemBand.setReportDefinition(this);
        this.watermark.setReportDefinition(this);
    }

    public void addExpression(Expression function) {
        this.expressions.add(function);
    }

    public void addGroup(Group group) {
        this.groups.add(group);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public Object clone() throws CloneNotSupportedException {
        JFreeReport report = (JFreeReport)super.clone();
        report.data = this.data;
        report.pageDefinition = (PageDefinition)this.pageDefinition.clone();
        report.groups = (GroupList)this.groups.clone();
        report.watermark = (Watermark)this.watermark.clone();
        report.itemBand = (ItemBand)this.itemBand.clone();
        report.pageFooter = (PageFooter)this.pageFooter.clone();
        report.pageHeader = (PageHeader)this.pageHeader.clone();
        report.properties = (ReportProperties)this.properties.clone();
        report.reportFooter = (ReportFooter)this.reportFooter.clone();
        report.reportHeader = (ReportHeader)this.reportHeader.clone();
        report.expressions = (ExpressionCollection)this.expressions.clone();
        report.styleSheetCollection = (StyleSheetCollection)this.styleSheetCollection.clone();
        report.reportBuilderHints = new ReportBuilderHints();
        report.groups.setReportDefinition(report);
        report.reportHeader.setReportDefinition(report);
        report.reportFooter.setReportDefinition(report);
        report.pageHeader.setReportDefinition(report);
        report.pageFooter.setReportDefinition(report);
        report.itemBand.setReportDefinition(report);
        report.watermark.setReportDefinition(report);
        return report;
    }

    public TableModel getData() {
        return this.data;
    }

    public DataRow getDataRow() {
        Class clazz = class$org$jfree$report$JFreeReport != null ? class$org$jfree$report$JFreeReport : (class$org$jfree$report$JFreeReport = JFreeReport.class$("org.jfree.report.JFreeReport"));
        synchronized (clazz) {
            if (emptyDataRow == null) {
                emptyDataRow = new EmptyDataRow();
            }
            EmptyDataRow emptyDataRow = JFreeReport.emptyDataRow;
            Object var3_3 = null;
            return emptyDataRow;
        }
    }

    public ExpressionCollection getExpressions() {
        return this.expressions;
    }

    public Group getGroup(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("GroupCount must not be negative");
        }
        if (count >= this.groups.size()) {
            throw new IndexOutOfBoundsException("No such group defined. " + count + " vs. " + this.groups.size());
        }
        return this.groups.get(count);
    }

    public Group getGroupByName(String name) {
        return this.groups.getGroupByName(name);
    }

    public int getGroupCount() {
        return this.groups.size();
    }

    public GroupList getGroups() {
        return this.groups;
    }

    public static final synchronized JFreeReportInfo getInfo() {
        if (info == null) {
            info = new JFreeReportInfo();
        }
        return info;
    }

    public ItemBand getItemBand() {
        return this.itemBand;
    }

    public String getName() {
        Object name = this.getProperty(NAME_PROPERTY);
        return String.valueOf(name);
    }

    public PageDefinition getPageDefinition() {
        return this.pageDefinition;
    }

    public PageFooter getPageFooter() {
        return this.pageFooter;
    }

    public PageHeader getPageHeader() {
        return this.pageHeader;
    }

    public ReportProperties getProperties() {
        return this.properties;
    }

    public Object getProperty(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.properties.get(key);
    }

    public ReportBuilderHints getReportBuilderHints() {
        return this.reportBuilderHints;
    }

    public ReportConfiguration getReportConfiguration() {
        return this.reportConfiguration;
    }

    public ReportFooter getReportFooter() {
        return this.reportFooter;
    }

    public ReportHeader getReportHeader() {
        return this.reportHeader;
    }

    public ResourceBundle getResourceBundle(String key) {
        return this.resourceBundleFactory.getResourceBundle(key);
    }

    public ResourceBundleFactory getResourceBundleFactory() {
        return this.resourceBundleFactory;
    }

    public StyleSheetCollection getStyleSheetCollection() {
        return this.styleSheetCollection;
    }

    public Watermark getWatermark() {
        return this.watermark;
    }

    public boolean isPropertyMarked(String key) {
        return this.properties.isMarked(key);
    }

    public void setData(TableModel data) {
        if (data == null) {
            throw new NullPointerException("JFreeReport.setData(...) : null not permitted.");
        }
        this.data = data;
    }

    public void setExpressions(ExpressionCollection expressions) {
        if (expressions == null) {
            throw new NullPointerException("JFreeReport.setExpressions(...) : null not permitted.");
        }
        this.expressions = expressions;
    }

    public void setGroups(GroupList groupList) {
        if (groupList == null) {
            throw new NullPointerException("GroupList must not be null");
        }
        this.groups.setReportDefinition(null);
        this.groups = groupList;
        this.groups.setReportDefinition(this);
    }

    public void setItemBand(ItemBand band) {
        if (band == null) {
            throw new NullPointerException("JFreeReport.setItemBand(...) : null not permitted.");
        }
        this.itemBand.setReportDefinition(null);
        this.itemBand = band;
        this.itemBand.setReportDefinition(this);
    }

    public void setName(String name) {
        this.setProperty(NAME_PROPERTY, name);
    }

    public void setPageDefinition(PageDefinition format) {
        if (format == null) {
            format = ReportConfiguration.getGlobalConfig().getConfigProperty("org.jfree.report.NoPrinterAvailable", "false").equals("true") ? new SimplePageDefinition(new PageFormat()) : new SimplePageDefinition(PrinterJob.getPrinterJob().defaultPage());
        }
        this.pageDefinition = format;
    }

    public void setPageFooter(PageFooter footer) {
        if (footer == null) {
            throw new NullPointerException("JFreeReport.setPageFooter(...) : null not permitted.");
        }
        this.pageFooter.setReportDefinition(null);
        this.pageFooter = footer;
        this.pageFooter.setReportDefinition(this);
    }

    public void setPageHeader(PageHeader header) {
        if (header == null) {
            throw new NullPointerException("JFreeReport.setPageHeader(...) : null not permitted.");
        }
        this.pageHeader.setReportDefinition(null);
        this.pageHeader = header;
        this.pageHeader.setReportDefinition(this);
    }

    public void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    public void setPropertyMarked(String key, boolean mark) {
        this.properties.setMarked(key, mark);
    }

    public void setReportBuilderHints(ReportBuilderHints reportBuilderHints) {
        this.reportBuilderHints = reportBuilderHints;
    }

    public void setReportFooter(ReportFooter footer) {
        if (footer == null) {
            throw new NullPointerException("JFreeReport.setReportFooter(...) : null not permitted.");
        }
        this.reportFooter.setReportDefinition(null);
        this.reportFooter = footer;
        this.reportFooter.setReportDefinition(this);
    }

    public void setReportHeader(ReportHeader header) {
        if (header == null) {
            throw new NullPointerException("JFreeReport.setReportHeader(...) : null not permitted.");
        }
        this.reportHeader.setReportDefinition(null);
        this.reportHeader = header;
        this.reportHeader.setReportDefinition(this);
    }

    public void setResourceBundleFactory(ResourceBundleFactory resourceBundleFactory) {
        if (resourceBundleFactory == null) {
            throw new NullPointerException("ResourceBundleFactory must not be null");
        }
        this.resourceBundleFactory = resourceBundleFactory;
    }

    public void setWatermark(Watermark band) {
        if (band == null) {
            throw new NullPointerException("JFreeReport.setWatermark(...) : null not permitted.");
        }
        this.watermark.setReportDefinition(null);
        this.watermark = band;
        this.watermark.setReportDefinition(this);
    }

    private static class EmptyDataRow
    implements DataRow,
    Serializable {
        public int findColumn(String name) {
            return -1;
        }

        public Object get(int col) {
            return null;
        }

        public Object get(String col) throws IllegalStateException {
            return null;
        }

        public int getColumnCount() {
            return 0;
        }

        public String getColumnName(int col) {
            return null;
        }
    }
}

