/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jfree.report.util.NullOutputStream;
import org.jfree.report.util.ReportConfiguration;

public class ReportBuilderHints
implements Serializable {
    private static final boolean PARANOID_CHECKS = ReportConfiguration.getGlobalConfig().getConfigProperty("org.jfree.report.ReportBuilderHint.ParanoidChecks", "false").equals("true");
    private final HashMap map = new HashMap();

    public void addHintList(Serializable target, String hint, Serializable hintValue) {
        this.addHintList(target, hint, hintValue, true);
    }

    public void addHintList(Serializable target, String hint, Serializable hintValue, boolean unique) {
        List<Serializable> hintList;
        Object o;
        if (hintValue == null) {
            throw new NullPointerException("Hintvalue is null.");
        }
        if (PARANOID_CHECKS) {
            ReportBuilderHints.serialize(target);
            ReportBuilderHints.serialize(hintValue);
        }
        if ((o = this.getHint(target, hint)) != null) {
            if (!(o instanceof List)) {
                throw new IllegalArgumentException("The parser hint " + hint + " is no list type.");
            }
            hintList = (List)o;
        } else {
            hintList = new ArrayList();
            this.putHint(target, hint, (Serializable)((Object)hintList));
        }
        if (!unique || !hintList.contains(hintValue)) {
            hintList.add(hintValue);
        }
    }

    public Object getHint(Serializable target, String hint) {
        return this.map.get(new ParserHintKey(target, hint));
    }

    public Object getHint(Serializable target, String hint, Class objectType) {
        Object o = this.map.get(new ParserHintKey(target, hint));
        if (o == null) {
            return null;
        }
        if (objectType.isAssignableFrom(o.getClass())) {
            return o;
        }
        return null;
    }

    public void putHint(Serializable target, String hint, Serializable hintValue) {
        ParserHintKey pHint = new ParserHintKey(target, hint);
        if (hintValue == null) {
            this.map.remove(pHint);
        } else {
            this.map.put(pHint, hintValue);
        }
    }

    private static void serialize(Object o) {
        try {
            ObjectOutputStream out = new ObjectOutputStream(new NullOutputStream());
            out.writeObject(o);
        }
        catch (IOException ipoe) {
            ipoe.printStackTrace();
            throw new IllegalArgumentException("Not serializable:" + o);
        }
    }

    public static class ParserHintKey
    implements Serializable {
        private Object primaryKey;
        private String hintKey;
        private int hashCode;

        public ParserHintKey(Serializable primaryKey, String hintKey) {
            if (primaryKey == null) {
                throw new NullPointerException();
            }
            if (hintKey == null) {
                throw new NullPointerException();
            }
            this.primaryKey = primaryKey;
            this.hintKey = hintKey;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ParserHintKey)) {
                return false;
            }
            ParserHintKey parserHintKey = (ParserHintKey)o;
            if (!this.primaryKey.equals(parserHintKey.primaryKey)) {
                return false;
            }
            return this.hintKey.equals(parserHintKey.hintKey);
        }

        public String getHintKey() {
            return this.hintKey;
        }

        public Object getPrimaryKey() {
            return this.primaryKey;
        }

        public int hashCode() {
            if (this.hashCode != 0) {
                int result = this.primaryKey.hashCode();
                this.hashCode = result = 29 * result + this.hintKey.hashCode();
            }
            return this.hashCode;
        }

        public String toString() {
            StringBuffer b = new StringBuffer();
            b.append("ParserHintKey={");
            b.append(this.primaryKey);
            b.append("; ");
            b.append(this.hintKey);
            b.append("}");
            return b.toString();
        }
    }
}

