/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report;

import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import org.jfree.report.PageDefinition;
import org.jfree.report.util.PageFormatFactory;
import org.jfree.report.util.SerializerHelper;

public class SimplePageDefinition
implements PageDefinition {
    private transient PageFormat format;
    private transient Rectangle2D[] pagePositions;
    private int pageCountHorizontal;
    private int pageCountVertical;

    public SimplePageDefinition(PageFormat format) {
        this(format, 1, 1);
    }

    public SimplePageDefinition(PageFormat format, int x, int y) {
        if (format == null) {
            throw new NullPointerException("Format must not be null");
        }
        if (x < 1) {
            throw new IllegalArgumentException("PageCount must be greater or equal to 1");
        }
        if (y < 1) {
            throw new IllegalArgumentException("PageCount must be greater or equal to 1");
        }
        this.format = (PageFormat)format.clone();
        this.pageCountHorizontal = x;
        this.pageCountVertical = y;
        this.pagePositions = new Rectangle2D[this.pageCountHorizontal * this.pageCountVertical];
        float width = (float)format.getImageableWidth();
        float height = (float)format.getImageableHeight();
        float pageStartY = 0.0f;
        int vert = 0;
        while (vert < this.pageCountVertical) {
            float pageStartX = 0.0f;
            int hor = 0;
            while (hor < this.pageCountHorizontal) {
                Rectangle2D.Float rect = new Rectangle2D.Float(pageStartX, pageStartY, width, height);
                this.pagePositions[vert * this.pageCountHorizontal + hor] = rect;
                pageStartX += width;
                ++hor;
            }
            pageStartY += height;
            ++vert;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        SimplePageDefinition pdef = (SimplePageDefinition)super.clone();
        pdef.format = (PageFormat)this.format.clone();
        return pdef;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SimplePageDefinition)) {
            return false;
        }
        SimplePageDefinition simplePageDefinition = (SimplePageDefinition)o;
        if (this.pageCountHorizontal != simplePageDefinition.pageCountHorizontal) {
            return false;
        }
        if (this.pageCountVertical != simplePageDefinition.pageCountVertical) {
            return false;
        }
        if (!PageFormatFactory.isEqual(this.format, simplePageDefinition.format)) {
            return false;
        }
        return Arrays.equals(this.pagePositions, simplePageDefinition.pagePositions);
    }

    public float getHeight() {
        return (float)(this.format.getImageableHeight() * (double)this.pageCountVertical);
    }

    public int getPageCount() {
        return this.pageCountHorizontal * this.pageCountVertical;
    }

    public PageFormat getPageFormat(int pos) {
        if (pos < 0 || pos > this.getPageCount()) {
            throw new IndexOutOfBoundsException("Index is invalid");
        }
        return (PageFormat)this.format.clone();
    }

    public Rectangle2D getPagePosition(int pos) {
        if (pos < 0 || pos > this.getPageCount()) {
            throw new IndexOutOfBoundsException("Index is invalid");
        }
        return this.pagePositions[pos].getBounds2D();
    }

    public Rectangle2D[] getPagePositions() {
        Rectangle2D[] rects = new Rectangle2D.Float[this.pagePositions.length];
        int i = 0;
        while (i < this.pagePositions.length) {
            rects[i] = this.pagePositions[i].getBounds2D();
            ++i;
        }
        return rects;
    }

    public float getWidth() {
        return (float)(this.format.getImageableWidth() * (double)this.pageCountHorizontal);
    }

    public int hashCode() {
        int result = this.format.hashCode();
        result = 29 * result + this.pageCountHorizontal;
        result = 29 * result + this.pageCountVertical;
        return result;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        SerializerHelper instance = SerializerHelper.getInstance();
        this.format = (PageFormat)instance.readObject(in);
        int length = in.readInt();
        this.pagePositions = new Rectangle2D[length];
        int i = 0;
        while (i < length) {
            this.pagePositions[i] = (Rectangle2D)instance.readObject(in);
            ++i;
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        SerializerHelper instance = SerializerHelper.getInstance();
        instance.writeObject(this.format, out);
        out.writeInt(this.pagePositions.length);
        int i = 0;
        while (i < this.pagePositions.length) {
            instance.writeObject(this.pagePositions[i], out);
            ++i;
        }
    }
}

