/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.demo;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.jfree.report.demo.helper.AbstractDemoFrame;
import org.jfree.report.util.Log;
import org.jfree.report.util.ReportConfiguration;
import org.jfree.ui.RefineryUtilities;
import org.jfree.ui.action.ActionButton;
import org.jfree.ui.action.ActionMenuItem;
import org.jfree.util.ObjectUtilities;

public class DemoFrontend
extends AbstractDemoFrame {
    private RunDemoAction[] demos = this.createDemoActions();
    static /* synthetic */ Class class$org$jfree$report$demo$DemoFrontend;

    public DemoFrontend() {
        this.setTitle("Demo Selector");
        this.setJMenuBar(this.createMenuBar());
        this.setContentPane(this.createContentPane());
        ReportConfiguration.getGlobalConfig().setConfigProperty("org.jfree.report.demo.Embedded", "true");
    }

    protected boolean attemptExit() {
        boolean close;
        boolean bl = close = JOptionPane.showConfirmDialog(this, this.getResources().getString("exitdialog.message"), this.getResources().getString("exitdialog.title"), 0, 3) == 0;
        if (close) {
            System.exit(0);
        }
        return close;
    }

    protected void attemptPreview() {
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private JPanel createContentPane() {
        int cols = 2;
        int rows = (int)Math.ceil((double)this.demos.length / 2.0);
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(rows, 2));
        int i = 0;
        while (i < this.demos.length) {
            panel.add((Component)new ActionButton((Action)this.demos[i]));
            ++i;
        }
        return panel;
    }

    private RunDemoAction[] createDemoActions() {
        InputStream in = ObjectUtilities.getResourceRelativeAsStream((String)"demos.properties", (Class)(class$org$jfree$report$demo$DemoFrontend != null ? class$org$jfree$report$demo$DemoFrontend : (class$org$jfree$report$demo$DemoFrontend = DemoFrontend.class$("org.jfree.report.demo.DemoFrontend"))));
        if (in == null) {
            Log.warn("Missing resource: demos.properties");
            return null;
        }
        try {
            Properties p = new Properties();
            p.load(in);
            in.close();
            ArrayList<RunDemoAction> list = new ArrayList<RunDemoAction>();
            int size = Integer.parseInt(p.getProperty("size"));
            ClassLoader cl = ObjectUtilities.getClassLoader((Class)(class$org$jfree$report$demo$DemoFrontend != null ? class$org$jfree$report$demo$DemoFrontend : (class$org$jfree$report$demo$DemoFrontend = DemoFrontend.class$("org.jfree.report.demo.DemoFrontend"))));
            int i = 0;
            while (i < size) {
                String name = p.getProperty("demo." + i + ".name");
                String className = p.getProperty("demo." + i + ".class");
                String description = p.getProperty("demo." + i + ".description", "-");
                if (name != null && className != null) {
                    Class<?> c = cl.loadClass(className);
                    list.add(new RunDemoAction(name, c, description));
                }
                ++i;
            }
            RunDemoAction[] retval = list.toArray(new RunDemoAction[list.size()]);
            return retval;
        }
        catch (Exception e) {
            Log.warn("Unable to parse demo list: demos.properties", e);
            return null;
        }
    }

    public JMenuBar createMenuBar() {
        JMenuBar mb = new JMenuBar();
        JMenu fileMenu = this.createJMenu("menu.file");
        ActionMenuItem exitItem = new ActionMenuItem(this.getCloseAction());
        int i = 0;
        while (i < this.demos.length) {
            fileMenu.add((JMenuItem)new ActionMenuItem((Action)this.demos[i]));
            ++i;
        }
        fileMenu.addSeparator();
        fileMenu.add((JMenuItem)exitItem);
        mb.add(fileMenu);
        return mb;
    }

    public static void main(String[] args) {
        DemoFrontend frontend = new DemoFrontend();
        frontend.pack();
        RefineryUtilities.centerFrameOnScreen((Window)frontend);
        ((Component)frontend).setVisible(true);
    }

    private static class RunDemoAction
    extends AbstractAction {
        private Class target;
        private String description;

        public RunDemoAction(String name, Class target, String description) {
            this.putValue("Name", name);
            this.putValue("ShortDescription", description);
            this.target = target;
            this.description = description;
        }

        public void actionPerformed(ActionEvent event) {
            try {
                String[] args = new String[]{};
                Method m = this.target.getMethod("main", args.getClass());
                m.invoke(null, new Object[]{args});
            }
            catch (Exception e) {
                Log.error("There was an error while trying to start the requested demo", e);
            }
        }

        public String getDescription() {
            return this.description;
        }
    }
}

