/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.demo.helper;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import org.jfree.report.demo.PreviewAction;
import org.jfree.report.demo.helper.CloseAction;
import org.jfree.report.modules.gui.base.components.ExceptionDialog;
import org.jfree.report.util.ReportConfiguration;
import org.jfree.util.ResourceBundleSupport;

public abstract class AbstractDemoFrame
extends JFrame {
    public static final String RESOURCE_BASE = "org.jfree.report.demo.resources.demo-resources";
    private final ResourceBundleSupport resources = new ResourceBundleSupport("org.jfree.report.demo.resources.demo-resources");
    private final Action closeAction;
    private final Action previewAction = new DemoPreviewAction();

    public AbstractDemoFrame() {
        this.closeAction = new DemoCloseAction();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new CloseHandler());
    }

    protected boolean attemptExit() {
        boolean close;
        boolean bl = close = JOptionPane.showConfirmDialog(this, this.getResources().getString("exitdialog.message"), this.getResources().getString("exitdialog.title"), 0, 3) == 0;
        if (close) {
            if (ReportConfiguration.getGlobalConfig().getConfigProperty("org.jfree.report.demo.Embedded", "false").equals("false")) {
                System.exit(0);
            } else {
                ((Component)this).setVisible(false);
                this.dispose();
            }
        }
        return close;
    }

    protected abstract void attemptPreview();

    protected JMenu createJMenu(String base) {
        String label = this.getResources().getString(String.valueOf(base) + ".name");
        Integer mnemonic = this.getResources().getMnemonic(String.valueOf(base) + ".mnemonic");
        JMenu menu = new JMenu(label);
        if (mnemonic != null) {
            menu.setMnemonic(mnemonic);
        }
        return menu;
    }

    public Action getCloseAction() {
        return this.closeAction;
    }

    public Action getPreviewAction() {
        return this.previewAction;
    }

    public ResourceBundleSupport getResources() {
        return this.resources;
    }

    protected void showExceptionDialog(String localisationBase, Exception e) {
        ExceptionDialog.showExceptionDialog(this.getResources().getString(String.valueOf(localisationBase) + ".title"), MessageFormat.format(this.getResources().getString(String.valueOf(localisationBase) + ".message"), e.getLocalizedMessage()), e);
    }

    protected class DemoCloseAction
    extends CloseAction {
        public DemoCloseAction() {
            super(AbstractDemoFrame.this.getResources());
        }

        public void actionPerformed(ActionEvent event) {
            AbstractDemoFrame.this.attemptExit();
        }
    }

    protected class CloseHandler
    extends WindowAdapter {
        public void windowClosing(WindowEvent event) {
            AbstractDemoFrame.this.attemptExit();
        }
    }

    protected class DemoPreviewAction
    extends PreviewAction {
        public DemoPreviewAction() {
            super(AbstractDemoFrame.this.getResources());
        }

        public void actionPerformed(ActionEvent event) {
            AbstractDemoFrame.this.attemptPreview();
        }
    }
}

