/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.elementfactory;

import java.awt.Color;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.jfree.report.Element;
import org.jfree.report.ElementAlignment;
import org.jfree.report.TextElement;
import org.jfree.report.elementfactory.TextFieldElementFactory;
import org.jfree.report.filter.DataRowDataSource;
import org.jfree.report.filter.DateFormatFilter;
import org.jfree.report.style.ElementStyleSheet;
import org.jfree.report.style.FontDefinition;
import org.jfree.ui.FloatDimension;

public class DateFieldElementFactory
extends TextFieldElementFactory {
    private DateFormat format;
    private String excelCellFormat;

    public static TextElement createDateElement(String name, Rectangle2D bounds, Color paint, ElementAlignment alignment, ElementAlignment valign, FontDefinition font, String nullString, String format, String field) {
        DateFieldElementFactory factory = new DateFieldElementFactory();
        factory.setAbsolutePosition(new Point2D.Double(bounds.getX(), bounds.getY()));
        factory.setMinimumSize((Dimension2D)new FloatDimension((float)bounds.getWidth(), (float)bounds.getHeight()));
        factory.setName(name);
        factory.setColor(paint);
        factory.setHorizontalAlignment(alignment);
        factory.setVerticalAlignment(valign);
        if (font != null) {
            factory.setFontName(font.getFontName());
            factory.setFontSize(new Integer(font.getFontSize()));
            factory.setBold(new Boolean(font.isBold()));
            factory.setItalic(new Boolean(font.isItalic()));
            factory.setEncoding(font.getFontEncoding(null));
            factory.setUnderline(new Boolean(font.isUnderline()));
            factory.setStrikethrough(new Boolean(font.isStrikeThrough()));
            factory.setEmbedFont(new Boolean(font.isEmbeddedFont()));
        }
        factory.setNullString(nullString);
        factory.setFormatString(format);
        factory.setFieldname(field);
        return (TextElement)factory.createElement();
    }

    public static TextElement createDateElement(String name, Rectangle2D bounds, Color paint, ElementAlignment alignment, ElementAlignment valign, FontDefinition font, String nullString, DateFormat format, String field) {
        DateFieldElementFactory factory = new DateFieldElementFactory();
        factory.setAbsolutePosition(new Point2D.Double(bounds.getX(), bounds.getY()));
        factory.setMinimumSize((Dimension2D)new FloatDimension((float)bounds.getWidth(), (float)bounds.getHeight()));
        factory.setName(name);
        factory.setColor(paint);
        factory.setHorizontalAlignment(alignment);
        factory.setVerticalAlignment(valign);
        if (font != null) {
            factory.setFontName(font.getFontName());
            factory.setFontSize(new Integer(font.getFontSize()));
            factory.setBold(new Boolean(font.isBold()));
            factory.setItalic(new Boolean(font.isItalic()));
            factory.setEncoding(font.getFontEncoding(null));
            factory.setUnderline(new Boolean(font.isUnderline()));
            factory.setStrikethrough(new Boolean(font.isStrikeThrough()));
            factory.setEmbedFont(new Boolean(font.isEmbeddedFont()));
        }
        factory.setNullString(nullString);
        factory.setFormat(format);
        factory.setFieldname(field);
        return (TextElement)factory.createElement();
    }

    public static TextElement createDateElement(String name, Rectangle2D bounds, Color paint, ElementAlignment alignment, FontDefinition font, String nullString, String format, String field) {
        return DateFieldElementFactory.createDateElement(name, bounds, paint, alignment, null, font, nullString, format, field);
    }

    public static TextElement createDateElement(String name, Rectangle2D bounds, Color paint, ElementAlignment alignment, FontDefinition font, String nullString, DateFormat format, String field) {
        return DateFieldElementFactory.createDateElement(name, bounds, paint, alignment, null, font, nullString, format, field);
    }

    public Element createElement() {
        DateFormatFilter dataSource = new DateFormatFilter();
        if (this.format != null) {
            dataSource.setFormatter(this.format);
        }
        dataSource.setDataSource(new DataRowDataSource(this.getFieldname()));
        TextElement element = new TextElement();
        element.setDataSource(dataSource);
        this.applyElementName(element);
        this.applyStyle(element.getStyle());
        element.getStyle().setStyleProperty(ElementStyleSheet.EXCEL_DATA_FORMAT_STRING, this.getExcelCellFormat());
        return element;
    }

    public String getExcelCellFormat() {
        return this.excelCellFormat;
    }

    public DateFormat getFormat() {
        return this.format;
    }

    public String getFormatString() {
        if (this.getFormat() instanceof SimpleDateFormat) {
            SimpleDateFormat decFormat = (SimpleDateFormat)this.getFormat();
            return decFormat.toPattern();
        }
        return null;
    }

    public void setExcelCellFormat(String excelCellFormat) {
        this.excelCellFormat = excelCellFormat;
    }

    public void setFormat(DateFormat format) {
        this.format = format;
    }

    public void setFormatString(String formatString) {
        if (formatString == null) {
            this.setFormat(null);
        } else {
            this.setFormat(new SimpleDateFormat(formatString));
        }
    }
}

