/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.filter;

import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import org.jfree.report.filter.DataFilter;
import org.jfree.report.filter.DataSource;
import org.jfree.report.resourceloader.DrawableFactory;
import org.jfree.report.util.KeyedQueue;
import org.jfree.report.util.Log;

public class DrawableLoadFilter
implements DataFilter,
Serializable {
    private KeyedQueue imageCache;
    private DataSource source;

    public DrawableLoadFilter() {
        this(10);
    }

    public DrawableLoadFilter(int cacheSize) {
        this.imageCache = new KeyedQueue(cacheSize);
    }

    public Object clone() throws CloneNotSupportedException {
        DrawableLoadFilter il = (DrawableLoadFilter)super.clone();
        il.imageCache = (KeyedQueue)this.imageCache.clone();
        if (this.source != null) {
            il.source = (DataSource)this.source.clone();
        }
        return il;
    }

    public DataSource getDataSource() {
        return this.source;
    }

    public Object getValue() {
        DataSource ds = this.getDataSource();
        if (ds == null) {
            return null;
        }
        Object o = ds.getValue();
        if (o == null) {
            return null;
        }
        if (!(o instanceof URL)) {
            return null;
        }
        URL url = (URL)o;
        Object retval = this.imageCache.get(url);
        if (retval == null) {
            try {
                retval = DrawableFactory.getInstance().createDrawable(url);
            }
            catch (IOException ioe) {
                Log.warn("Error while loading the image from " + url, ioe);
                return null;
            }
        }
        this.imageCache.put(url, retval);
        return retval;
    }

    public void setDataSource(DataSource ds) {
        if (ds == null) {
            throw new NullPointerException();
        }
        this.source = ds;
    }
}

