/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.filter;

import java.io.Serializable;
import java.text.Format;
import org.jfree.report.filter.DataFilter;
import org.jfree.report.filter.DataSource;
import org.jfree.report.filter.RawDataSource;

public class FormatFilter
implements DataFilter,
Serializable,
RawDataSource {
    private Format format;
    private DataSource datasource;
    private String nullvalue = null;

    public Object clone() throws CloneNotSupportedException {
        FormatFilter f = (FormatFilter)super.clone();
        if (this.datasource != null) {
            f.datasource = (DataSource)this.datasource.clone();
        }
        if (this.format != null) {
            f.format = (Format)this.format.clone();
        }
        return f;
    }

    public DataSource getDataSource() {
        return this.datasource;
    }

    public Format getFormatter() {
        return this.format;
    }

    public String getNullValue() {
        return this.nullvalue;
    }

    public Object getRawValue() {
        return this.datasource.getValue();
    }

    public Object getValue() {
        Format f = this.getFormatter();
        if (f == null) {
            return this.getNullValue();
        }
        DataSource ds = this.getDataSource();
        if (ds == null) {
            return this.getNullValue();
        }
        Object o = ds.getValue();
        if (o == null) {
            return this.getNullValue();
        }
        try {
            return f.format(o);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return this.getNullValue();
        }
    }

    public void setDataSource(DataSource ds) {
        if (ds == null) {
            throw new NullPointerException();
        }
        this.datasource = ds;
    }

    public void setFormatter(Format format) {
        if (format == null) {
            throw new NullPointerException();
        }
        this.format = format;
    }

    public void setNullValue(String nullvalue) {
        if (nullvalue == null) {
            throw new NullPointerException();
        }
        this.nullvalue = nullvalue;
    }
}

