/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.filter;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Locale;
import org.jfree.report.DataRow;
import org.jfree.report.util.PropertyLookupParser;

public class MessageFormatSupport
implements Serializable {
    private String[] fields;
    private MessageFormat format;
    private String formatString;

    public String getFormatString() {
        return this.formatString;
    }

    public Locale getLocale() {
        return this.format.getLocale();
    }

    public String performFormat(DataRow dataRow) {
        if (this.fields == null || this.format == null) {
            return null;
        }
        Object[] parameters = new Object[this.fields.length];
        int i = 0;
        while (i < parameters.length) {
            parameters[i] = dataRow.get(this.fields[i]);
            ++i;
        }
        return this.format.format(parameters);
    }

    public void setFormatString(String formatString) {
        MessageCompiler compiler = new MessageCompiler();
        if (formatString == null) {
            throw new NullPointerException("Format must not be null");
        }
        String pattern = compiler.translateAndLookup(formatString);
        this.format = new MessageFormat(pattern);
        this.fields = compiler.getFields();
        this.formatString = formatString;
    }

    public void setLocale(Locale locale) {
        this.format.setLocale(locale);
    }

    private static class MessageCompiler
    extends PropertyLookupParser {
        private ArrayList fields = new ArrayList();

        public MessageCompiler() {
            this.setMarkerChar('$');
            this.setOpeningBraceChar('(');
            this.setClosingBraceChar(')');
        }

        public String[] getFields() {
            return this.fields.toArray(new String[this.fields.size()]);
        }

        protected String lookupVariable(String entity) {
            return (String)this.performInitialLookup(entity);
        }

        protected Object performInitialLookup(String name) {
            int index = this.fields.indexOf(name);
            if (index != -1) {
                return String.valueOf(index);
            }
            this.fields.add(name);
            return String.valueOf(this.fields.size() - 1);
        }
    }
}

