/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.filter;

import java.text.Format;
import java.text.SimpleDateFormat;
import org.jfree.report.filter.DateFormatFilter;

public class SimpleDateFormatFilter
extends DateFormatFilter {
    public SimpleDateFormatFilter() {
        this.setFormatter(new SimpleDateFormat());
    }

    public String getFormatString() {
        return this.getSimpleDateFormat().toPattern();
    }

    public String getLocalizedFormatString() {
        return this.getSimpleDateFormat().toLocalizedPattern();
    }

    public SimpleDateFormat getSimpleDateFormat() {
        return (SimpleDateFormat)this.getFormatter();
    }

    public void setFormatString(String format) {
        if (format == null) {
            throw new NullPointerException();
        }
        this.getSimpleDateFormat().applyPattern(format);
    }

    public void setFormatter(Format format) {
        SimpleDateFormat sdfmt = (SimpleDateFormat)format;
        super.setFormatter(sdfmt);
    }

    public void setLocalizedFormatString(String format) {
        this.getSimpleDateFormat().applyLocalizedPattern(format);
    }

    public void setSimpleDateFormat(SimpleDateFormat format) {
        super.setFormatter(format);
    }
}

