/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.filter;

import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import org.jfree.report.filter.DataFilter;
import org.jfree.report.filter.DataSource;
import org.jfree.report.util.Log;

public class URLFilter
implements DataFilter,
Serializable {
    private DataSource source;
    private URL baseURL;

    public Object clone() throws CloneNotSupportedException {
        URLFilter f = (URLFilter)super.clone();
        if (this.source != null) {
            f.source = (DataSource)this.source.clone();
        }
        return f;
    }

    public URL getBaseURL() {
        return this.baseURL;
    }

    public DataSource getDataSource() {
        return this.source;
    }

    public Object getValue() {
        if (this.getDataSource() == null) {
            return null;
        }
        Object o = this.getDataSource().getValue();
        if (o == null) {
            return null;
        }
        if (o instanceof URL) {
            return o;
        }
        try {
            if (o instanceof File) {
                File f = (File)o;
                if (f.canRead()) {
                    return f.toURL();
                }
            } else if (o instanceof String) {
                if (this.getBaseURL() == null) {
                    return new URL((String)o);
                }
                return new URL(this.getBaseURL(), (String)o);
            }
        }
        catch (MalformedURLException malformedURLException) {
            Log.info("URLFilter.getValue(): MalformedURLException!");
        }
        return null;
    }

    public void setBaseURL(URL baseURL) {
        this.baseURL = baseURL;
    }

    public void setDataSource(DataSource ds) {
        if (ds == null) {
            throw new NullPointerException();
        }
        this.source = ds;
    }
}

