/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.function;

import java.io.Serializable;
import org.jfree.report.function.AbstractExpression;
import org.jfree.report.function.Expression;
import org.jfree.report.util.Log;

public class ItemColumnQuotientExpression
extends AbstractExpression
implements Serializable {
    private String dividend;
    private String divisor;

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String getDividend() {
        return this.dividend;
    }

    public String getDivisor() {
        return this.divisor;
    }

    public Expression getInstance() {
        ItemColumnQuotientExpression function = (ItemColumnQuotientExpression)super.getInstance();
        return function;
    }

    public Object getValue() {
        Number n;
        double dividend = 0.0;
        double divisor = 0.0;
        Object fieldValue = this.getDataRow().get(this.getDividend());
        if (fieldValue != null) {
            try {
                n = (Number)fieldValue;
                dividend = n.doubleValue();
            }
            catch (Exception exception) {
                Log.error("ItemColumnQuotientExpression(): problem with dividend value");
            }
        }
        if ((fieldValue = this.getDataRow().get(this.getDivisor())) != null) {
            try {
                n = (Number)fieldValue;
                divisor = n.doubleValue();
            }
            catch (Exception exception) {
                Log.error("ItemColumnQuotientExpression(): problem with divisor value");
            }
        }
        if (divisor == 0.0) {
            return new Double(Double.NaN);
        }
        return new Double(dividend / divisor);
    }

    public void setDividend(String dividend) {
        this.dividend = dividend;
    }

    public void setDivisor(String divisor) {
        this.divisor = divisor;
    }
}

