/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.function;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jfree.report.DataRow;
import org.jfree.report.event.LayoutEvent;
import org.jfree.report.event.LayoutListener;
import org.jfree.report.event.PageEventListener;
import org.jfree.report.event.PrepareEventListener;
import org.jfree.report.event.ReportEvent;
import org.jfree.report.event.ReportListener;
import org.jfree.report.function.Expression;
import org.jfree.report.function.ExpressionCollection;
import org.jfree.report.function.Function;
import org.jfree.report.util.IntList;
import org.jfree.report.util.LevelList;

public final class LevelledExpressionList
implements ReportListener,
Cloneable,
LayoutListener,
PageEventListener {
    private ArrayList errorList = new ArrayList();
    private int level;
    private DataRow dataRow;
    private LevelStorage[] levelData;
    private Expression[] flatData;
    private int size;

    protected LevelledExpressionList() {
    }

    public LevelledExpressionList(ExpressionCollection ec) {
        this.initialize(ec);
    }

    protected void addError(Exception e) {
        this.errorList.add(e);
    }

    protected void clearError() {
        this.errorList.clear();
    }

    public Object clone() throws CloneNotSupportedException {
        LevelledExpressionList ft = (LevelledExpressionList)super.clone();
        ft.dataRow = null;
        ft.errorList = (ArrayList)this.errorList.clone();
        ft.flatData = (Expression[])ft.flatData.clone();
        int expression = 0;
        while (expression < this.flatData.length) {
            ft.flatData[expression] = (Expression)this.flatData[expression].clone();
            ft.flatData[expression].setDataRow(null);
            ++expression;
        }
        return ft;
    }

    public void firePrepareEvent(ReportEvent event) {
        this.clearError();
        int levelIdx = 0;
        while (levelIdx < this.levelData.length) {
            int level = this.levelData[levelIdx].getLevelNumber();
            if (level < this.getLevel()) break;
            int[] functions = this.levelData[levelIdx].getPrepareEventListeners();
            int l = 0;
            while (l < functions.length) {
                PrepareEventListener e = (PrepareEventListener)((Object)this.flatData[functions[l]]);
                try {
                    e.prepareEvent(event);
                }
                catch (Exception ex) {
                    this.addError(ex);
                }
                ++l;
            }
            ++levelIdx;
        }
    }

    protected void firePrepareEventLayoutListener(ReportEvent event) {
        int levelIdx = 0;
        while (levelIdx < this.levelData.length) {
            int level = this.levelData[levelIdx].getLevelNumber();
            if (level < this.getLevel()) break;
            int[] functions = this.levelData[levelIdx].getPrepareEventLayoutListeners();
            int l = 0;
            while (l < functions.length) {
                PrepareEventListener e = (PrepareEventListener)((Object)this.flatData[functions[l]]);
                try {
                    e.prepareEvent(event);
                }
                catch (Exception ex) {
                    this.addError(ex);
                }
                ++l;
            }
            int[] activeExpressions = this.levelData[levelIdx].getActiveExpressions();
            int l2 = 0;
            while (l2 < activeExpressions.length) {
                Expression e = this.flatData[activeExpressions[l2]];
                try {
                    e.getValue();
                }
                catch (Exception ex) {
                    this.addError(ex);
                }
                ++l2;
            }
            ++levelIdx;
        }
    }

    public DataRow getDataRow() {
        return this.dataRow;
    }

    public List getErrors() {
        return Collections.unmodifiableList(this.errorList);
    }

    public Expression getExpression(int index) {
        return this.flatData[index];
    }

    public int getLevel() {
        return this.level;
    }

    public Iterator getLevelsAscending() {
        Integer[] levelIntegers = new Integer[this.levelData.length];
        int i = 0;
        while (i < this.levelData.length) {
            levelIntegers[this.levelData.length - i - 1] = new Integer(this.levelData[i].getLevelNumber());
            ++i;
        }
        return Collections.unmodifiableList(Arrays.asList(levelIntegers)).iterator();
    }

    public Iterator getLevelsDescending() {
        Integer[] levelIntegers = new Integer[this.levelData.length];
        int i = 0;
        while (i < this.levelData.length) {
            LevelStorage levelStorage = this.levelData[i];
            levelIntegers[i] = new Integer(levelStorage.getLevelNumber());
            ++i;
        }
        return Collections.unmodifiableList(Arrays.asList(levelIntegers)).iterator();
    }

    public LevelledExpressionList getPreviewInstance() {
        LevelList expressionList = new LevelList();
        int level = 0;
        while (level < this.levelData.length) {
            LevelStorage levelStorage = this.levelData[level];
            int[] expressions = levelStorage.getExpressions();
            int i = 0;
            while (i < expressions.length) {
                int idx = expressions[i];
                Expression ex = this.flatData[idx];
                if (!(ex instanceof Function)) {
                    expressionList.add(ex.getInstance(), level);
                }
                ++i;
            }
            ++level;
        }
        LevelledExpressionList ft = new LevelledExpressionList();
        ft.initializeFromLevelList(expressionList);
        return ft;
    }

    public Object getValue(int index) {
        return this.flatData[index].getValue();
    }

    public void groupFinished(ReportEvent event) {
        int levelIdx = 0;
        while (levelIdx < this.levelData.length) {
            int level = this.levelData[levelIdx].getLevelNumber();
            if (level < this.getLevel()) break;
            int[] functions = this.levelData[levelIdx].getFunctions();
            int l = 0;
            while (l < functions.length) {
                Function e = (Function)this.flatData[functions[l]];
                try {
                    e.groupFinished(event);
                }
                catch (Exception ex) {
                    this.addError(ex);
                }
                ++l;
            }
            int[] activeExpressions = this.levelData[levelIdx].getActiveExpressions();
            int l2 = 0;
            while (l2 < activeExpressions.length) {
                Expression e = this.flatData[activeExpressions[l2]];
                try {
                    e.getValue();
                }
                catch (Exception ex) {
                    this.addError(ex);
                }
                ++l2;
            }
            ++levelIdx;
        }
    }

    public void groupStarted(ReportEvent event) {
        int levelIdx = 0;
        while (levelIdx < this.levelData.length) {
            int level = this.levelData[levelIdx].getLevelNumber();
            if (level < this.getLevel()) break;
            int[] functions = this.levelData[levelIdx].getFunctions();
            int l = 0;
            while (l < functions.length) {
                Function e = (Function)this.flatData[functions[l]];
                try {
                    e.groupStarted(event);
                }
                catch (Exception ex) {
                    this.addError(ex);
                }
                ++l;
            }
            int[] activeExpressions = this.levelData[levelIdx].getActiveExpressions();
            int l2 = 0;
            while (l2 < activeExpressions.length) {
                Expression e = this.flatData[activeExpressions[l2]];
                try {
                    e.getValue();
                }
                catch (Exception ex) {
                    this.addError(ex);
                }
                ++l2;
            }
            ++levelIdx;
        }
    }

    public boolean hasErrors() {
        return this.errorList.size() != 0;
    }

    private void initialize(ExpressionCollection expressionCollection) {
        LevelList expressionList = new LevelList();
        int size = expressionCollection.size();
        int i = 0;
        while (i < size) {
            Expression f = expressionCollection.getExpression(i);
            if (f != null) {
                f = f.getInstance();
                expressionList.add(f);
                expressionList.setLevel(f, f.getDependencyLevel());
            }
            ++i;
        }
        this.initializeFromLevelList(expressionList);
    }

    private void initializeFromLevelList(LevelList expressionList) {
        this.size = 0;
        Integer[] levels = expressionList.getLevelsDescendingArray();
        this.levelData = new LevelStorage[levels.length];
        this.flatData = new Expression[expressionList.size()];
        IntList expressions = new IntList(20);
        IntList activeExpressions = new IntList(20);
        IntList functions = new IntList(20);
        IntList layoutListeners = new IntList(20);
        IntList pageEventListeners = new IntList(20);
        IntList prepareEventListeners = new IntList(20);
        IntList prepareLayoutEventListeners = new IntList(20);
        int i = 0;
        while (i < levels.length) {
            LevelStorage storage;
            int currentLevel = levels[i];
            Expression[] data = (Expression[])expressionList.getElementArrayForLevel(currentLevel, new Expression[expressionList.getElementCountForLevel(currentLevel)]);
            System.arraycopy(data, 0, this.flatData, this.size, data.length);
            int x = 0;
            while (x < data.length) {
                Expression ex = data[x];
                int globalPosition = this.size + x;
                expressions.add(globalPosition);
                if (ex.isActive()) {
                    activeExpressions.add(globalPosition);
                }
                if (ex instanceof Function) {
                    functions.add(globalPosition);
                    if (ex instanceof PageEventListener) {
                        pageEventListeners.add(globalPosition);
                    }
                    if (ex instanceof LayoutListener) {
                        layoutListeners.add(globalPosition);
                        if (ex instanceof PrepareEventListener) {
                            prepareEventListeners.add(globalPosition);
                            prepareLayoutEventListeners.add(globalPosition);
                        }
                    } else if (ex instanceof PrepareEventListener) {
                        prepareEventListeners.add(globalPosition);
                    }
                }
                ++x;
            }
            this.levelData[i] = storage = new LevelStorage(currentLevel, expressions.toArray(), activeExpressions.toArray(), functions.toArray(), pageEventListeners.toArray(), prepareEventListeners.toArray(), prepareLayoutEventListeners.toArray(), layoutListeners.toArray());
            expressions.clear();
            activeExpressions.clear();
            functions.clear();
            pageEventListeners.clear();
            prepareEventListeners.clear();
            prepareLayoutEventListeners.clear();
            layoutListeners.clear();
            this.size += data.length;
            ++i;
        }
    }

    public void itemsAdvanced(ReportEvent event) {
        int levelIdx = 0;
        while (levelIdx < this.levelData.length) {
            int level = this.levelData[levelIdx].getLevelNumber();
            if (level < this.getLevel()) break;
            int[] functions = this.levelData[levelIdx].getFunctions();
            int l = 0;
            while (l < functions.length) {
                Function e = (Function)this.flatData[functions[l]];
                try {
                    e.itemsAdvanced(event);
                }
                catch (Exception ex) {
                    this.addError(ex);
                }
                ++l;
            }
            int[] activeExpressions = this.levelData[levelIdx].getActiveExpressions();
            int l2 = 0;
            while (l2 < activeExpressions.length) {
                Expression e = this.flatData[activeExpressions[l2]];
                try {
                    e.getValue();
                }
                catch (Exception ex) {
                    this.addError(ex);
                }
                ++l2;
            }
            ++levelIdx;
        }
    }

    public void itemsFinished(ReportEvent event) {
        int levelIdx = 0;
        while (levelIdx < this.levelData.length) {
            int level = this.levelData[levelIdx].getLevelNumber();
            if (level < this.getLevel()) break;
            int[] functions = this.levelData[levelIdx].getFunctions();
            int l = 0;
            while (l < functions.length) {
                Function e = (Function)this.flatData[functions[l]];
                try {
                    e.itemsFinished(event);
                }
                catch (Exception ex) {
                    this.addError(ex);
                }
                ++l;
            }
            int[] activeExpressions = this.levelData[levelIdx].getActiveExpressions();
            int l2 = 0;
            while (l2 < activeExpressions.length) {
                Expression e = this.flatData[activeExpressions[l2]];
                try {
                    e.getValue();
                }
                catch (Exception ex) {
                    this.addError(ex);
                }
                ++l2;
            }
            ++levelIdx;
        }
    }

    public void itemsStarted(ReportEvent event) {
        int levelIdx = 0;
        while (levelIdx < this.levelData.length) {
            int level = this.levelData[levelIdx].getLevelNumber();
            if (level < this.getLevel()) break;
            int[] functions = this.levelData[levelIdx].getFunctions();
            int l = 0;
            while (l < functions.length) {
                Function e = (Function)this.flatData[functions[l]];
                try {
                    e.itemsStarted(event);
                }
                catch (Exception ex) {
                    this.addError(ex);
                }
                ++l;
            }
            int[] activeExpressions = this.levelData[levelIdx].getActiveExpressions();
            int l2 = 0;
            while (l2 < activeExpressions.length) {
                Expression e = this.flatData[activeExpressions[l2]];
                try {
                    e.getValue();
                }
                catch (Exception ex) {
                    this.addError(ex);
                }
                ++l2;
            }
            ++levelIdx;
        }
    }

    public void layoutComplete(LayoutEvent event) {
        this.firePrepareEventLayoutListener(event);
        int levelIdx = 0;
        while (levelIdx < this.levelData.length) {
            int level = this.levelData[levelIdx].getLevelNumber();
            if (level < this.getLevel()) break;
            int[] functions = this.levelData[levelIdx].getLayoutListeners();
            int l = 0;
            while (l < functions.length) {
                LayoutListener e = (LayoutListener)((Object)this.flatData[functions[l]]);
                try {
                    e.layoutComplete(event);
                }
                catch (Exception ex) {
                    this.addError(ex);
                }
                ++l;
            }
            int[] activeExpressions = this.levelData[levelIdx].getActiveExpressions();
            int l2 = 0;
            while (l2 < activeExpressions.length) {
                Expression e = this.flatData[activeExpressions[l2]];
                try {
                    e.getValue();
                }
                catch (Exception ex) {
                    this.addError(ex);
                }
                ++l2;
            }
            ++levelIdx;
        }
    }

    public void outputComplete(LayoutEvent event) {
        int levelIdx = 0;
        while (levelIdx < this.levelData.length) {
            int level = this.levelData[levelIdx].getLevelNumber();
            if (level < this.getLevel()) break;
            int[] functions = this.levelData[levelIdx].getLayoutListeners();
            int l = 0;
            while (l < functions.length) {
                LayoutListener e = (LayoutListener)((Object)this.flatData[functions[l]]);
                try {
                    e.layoutComplete(event);
                }
                catch (Exception ex) {
                    this.addError(ex);
                }
                ++l;
            }
            ++levelIdx;
        }
    }

    public void pageCanceled(ReportEvent event) {
        int levelIdx = 0;
        while (levelIdx < this.levelData.length) {
            int level = this.levelData[levelIdx].getLevelNumber();
            if (level < this.getLevel()) break;
            int[] functions = this.levelData[levelIdx].getPageEventListeners();
            int l = 0;
            while (l < functions.length) {
                PageEventListener e = (PageEventListener)((Object)this.flatData[functions[l]]);
                try {
                    e.pageCanceled(event);
                }
                catch (Exception ex) {
                    this.addError(ex);
                }
                ++l;
            }
            ++levelIdx;
        }
    }

    public void pageFinished(ReportEvent event) {
        int levelIdx = 0;
        while (levelIdx < this.levelData.length) {
            int level = this.levelData[levelIdx].getLevelNumber();
            if (level < this.getLevel()) break;
            int[] functions = this.levelData[levelIdx].getPageEventListeners();
            int l = 0;
            while (l < functions.length) {
                PageEventListener e = (PageEventListener)((Object)this.flatData[functions[l]]);
                try {
                    e.pageFinished(event);
                }
                catch (Exception ex) {
                    this.addError(ex);
                }
                ++l;
            }
            int[] activeExpressions = this.levelData[levelIdx].getActiveExpressions();
            int l2 = 0;
            while (l2 < activeExpressions.length) {
                Expression e = this.flatData[activeExpressions[l2]];
                try {
                    e.getValue();
                }
                catch (Exception ex) {
                    this.addError(ex);
                }
                ++l2;
            }
            ++levelIdx;
        }
    }

    public void pageRolledBack(ReportEvent event) {
        int levelIdx = 0;
        while (levelIdx < this.levelData.length) {
            int level = this.levelData[levelIdx].getLevelNumber();
            if (level < this.getLevel()) break;
            int[] functions = this.levelData[levelIdx].getPageEventListeners();
            int l = 0;
            while (l < functions.length) {
                PageEventListener e = (PageEventListener)((Object)this.flatData[functions[l]]);
                try {
                    e.pageRolledBack(event);
                }
                catch (Exception ex) {
                    this.addError(ex);
                }
                ++l;
            }
            ++levelIdx;
        }
    }

    public void pageStarted(ReportEvent event) {
        int levelIdx = 0;
        while (levelIdx < this.levelData.length) {
            int level = this.levelData[levelIdx].getLevelNumber();
            if (level < this.getLevel()) break;
            int[] functions = this.levelData[levelIdx].getPageEventListeners();
            int l = 0;
            while (l < functions.length) {
                PageEventListener e = (PageEventListener)((Object)this.flatData[functions[l]]);
                try {
                    e.pageStarted(event);
                }
                catch (Exception ex) {
                    this.addError(ex);
                }
                ++l;
            }
            int[] activeExpressions = this.levelData[levelIdx].getActiveExpressions();
            int l2 = 0;
            while (l2 < activeExpressions.length) {
                Expression e = this.flatData[activeExpressions[l2]];
                try {
                    e.getValue();
                }
                catch (Exception ex) {
                    this.addError(ex);
                }
                ++l2;
            }
            ++levelIdx;
        }
    }

    public void reportDone(ReportEvent event) {
        int levelIdx = 0;
        while (levelIdx < this.levelData.length) {
            int level = this.levelData[levelIdx].getLevelNumber();
            if (level < this.getLevel()) break;
            int[] functions = this.levelData[levelIdx].getFunctions();
            int l = 0;
            while (l < functions.length) {
                Function e = (Function)this.flatData[functions[l]];
                try {
                    e.reportDone(event);
                }
                catch (Exception ex) {
                    this.addError(ex);
                }
                ++l;
            }
            int[] activeExpressions = this.levelData[levelIdx].getActiveExpressions();
            int l2 = 0;
            while (l2 < activeExpressions.length) {
                Expression e = this.flatData[activeExpressions[l2]];
                try {
                    e.getValue();
                }
                catch (Exception ex) {
                    this.addError(ex);
                }
                ++l2;
            }
            ++levelIdx;
        }
    }

    public void reportFinished(ReportEvent event) {
        int levelIdx = 0;
        while (levelIdx < this.levelData.length) {
            int level = this.levelData[levelIdx].getLevelNumber();
            if (level < this.getLevel()) break;
            int[] functions = this.levelData[levelIdx].getFunctions();
            int l = 0;
            while (l < functions.length) {
                Function e = (Function)this.flatData[functions[l]];
                try {
                    e.reportFinished(event);
                }
                catch (Exception ex) {
                    this.addError(ex);
                }
                ++l;
            }
            int[] activeExpressions = this.levelData[levelIdx].getActiveExpressions();
            int l2 = 0;
            while (l2 < activeExpressions.length) {
                Expression e = this.flatData[activeExpressions[l2]];
                try {
                    e.getValue();
                }
                catch (Exception ex) {
                    this.addError(ex);
                }
                ++l2;
            }
            ++levelIdx;
        }
    }

    public void reportInitialized(ReportEvent event) {
        this.clearError();
        int levelIndex = 0;
        while (levelIndex < this.levelData.length) {
            int level = this.levelData[levelIndex].getLevelNumber();
            if (level < this.getLevel()) break;
            int[] functions = this.levelData[levelIndex].getFunctions();
            int expressionIdx = 0;
            while (expressionIdx < functions.length) {
                Function e = (Function)this.flatData[functions[expressionIdx]];
                try {
                    e.reportInitialized(event);
                }
                catch (Exception ex) {
                    this.addError(ex);
                }
                ++expressionIdx;
            }
            int[] activeExpressions = this.levelData[levelIndex].getActiveExpressions();
            int exprIdx = 0;
            while (exprIdx < activeExpressions.length) {
                Expression e = this.flatData[activeExpressions[exprIdx]];
                try {
                    e.getValue();
                }
                catch (Exception ex) {
                    this.addError(ex);
                }
                ++exprIdx;
            }
            ++levelIndex;
        }
    }

    public void reportStarted(ReportEvent event) {
        int levelIdx = 0;
        while (levelIdx < this.levelData.length) {
            int level = this.levelData[levelIdx].getLevelNumber();
            if (level < this.getLevel()) break;
            int[] functions = this.levelData[levelIdx].getFunctions();
            int l = 0;
            while (l < functions.length) {
                Function e = (Function)this.flatData[functions[l]];
                try {
                    e.reportStarted(event);
                }
                catch (Exception ex) {
                    this.addError(ex);
                }
                ++l;
            }
            int[] activeExpressions = this.levelData[levelIdx].getActiveExpressions();
            int l2 = 0;
            while (l2 < activeExpressions.length) {
                Expression e = this.flatData[activeExpressions[l2]];
                try {
                    e.getValue();
                }
                catch (Exception ex) {
                    this.addError(ex);
                }
                ++l2;
            }
            ++levelIdx;
        }
    }

    public void setDataRow(DataRow dr) {
        if (dr != null && this.dataRow != null) {
            throw new IllegalStateException("Paranoia: Update calls must be done using the updateDataRow method.");
        }
        this.updateDataRow(dr);
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public int size() {
        return this.size;
    }

    public void updateDataRow(DataRow dr) {
        this.dataRow = dr;
        int i = 0;
        while (i < this.flatData.length) {
            Expression f = this.flatData[i];
            f.setDataRow(dr);
            ++i;
        }
    }

    private static final class LevelStorage {
        private int levelNumber;
        private int[] activeExpressions;
        private int[] functions;
        private int[] pageEventListeners;
        private int[] prepareEventListeners;
        private int[] layoutListeners;
        private int[] prepareEventLayoutListeners;
        private int[] expressions;

        public LevelStorage(int levelNumber, int[] expressions, int[] activeExpressions, int[] functions, int[] pageEventListeners, int[] prepareEventListeners, int[] prepareEventLayoutListeners, int[] layoutListeners) {
            this.levelNumber = levelNumber;
            this.activeExpressions = activeExpressions;
            this.functions = functions;
            this.pageEventListeners = pageEventListeners;
            this.prepareEventListeners = prepareEventListeners;
            this.layoutListeners = layoutListeners;
            this.expressions = expressions;
            this.prepareEventLayoutListeners = prepareEventLayoutListeners;
        }

        public int[] getActiveExpressions() {
            return this.activeExpressions;
        }

        public int[] getExpressions() {
            return this.expressions;
        }

        public int[] getFunctions() {
            return this.functions;
        }

        public int[] getLayoutListeners() {
            return this.layoutListeners;
        }

        public int getLevelNumber() {
            return this.levelNumber;
        }

        public int[] getPageEventListeners() {
            return this.pageEventListeners;
        }

        public int[] getPrepareEventLayoutListeners() {
            return this.prepareEventLayoutListeners;
        }

        public int[] getPrepareEventListeners() {
            return this.prepareEventListeners;
        }
    }
}

