/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.function;

import java.text.MessageFormat;
import org.jfree.report.DataRow;
import org.jfree.report.event.ReportEvent;
import org.jfree.report.function.Expression;
import org.jfree.report.function.PageFunction;
import org.jfree.report.function.PageTotalFunction;

public class PageOfPagesFunction
extends PageFunction {
    private PageTotalFunction pageTotalFunction = new PageTotalFunction();
    private String format;

    public PageOfPagesFunction() {
        this.pageTotalFunction.setName("__internally_used_only");
        this.format = "{0} / {1}";
    }

    public PageOfPagesFunction(String name) {
        this();
        this.setName(name);
    }

    public String getFormat() {
        return this.format;
    }

    public Expression getInstance() {
        PageOfPagesFunction function = (PageOfPagesFunction)super.getInstance();
        function.pageTotalFunction = (PageTotalFunction)this.pageTotalFunction.getInstance();
        return function;
    }

    public Object getValue() {
        Object page = super.getValue();
        Object pages = this.pageTotalFunction.getValue();
        return MessageFormat.format(this.getFormat(), page, pages);
    }

    public void groupStarted(ReportEvent event) {
        super.groupStarted(event);
        this.pageTotalFunction.groupStarted(event);
    }

    public void pageCanceled(ReportEvent event) {
        super.pageCanceled(event);
        this.pageTotalFunction.pageCanceled(event);
    }

    public void pageFinished(ReportEvent event) {
        super.pageFinished(event);
        this.pageTotalFunction.pageFinished(event);
    }

    public void pageStarted(ReportEvent event) {
        super.pageStarted(event);
        this.pageTotalFunction.pageStarted(event);
    }

    public void reportInitialized(ReportEvent event) {
        super.reportInitialized(event);
        this.pageTotalFunction.reportInitialized(event);
    }

    public void setDataRow(DataRow dataRow) {
        super.setDataRow(dataRow);
        this.pageTotalFunction.setDataRow(dataRow);
    }

    public void setDependencyLevel(int level) {
        super.setDependencyLevel(level);
        this.pageTotalFunction.setDependencyLevel(level);
    }

    public void setFormat(String format) {
        if (format == null) {
            throw new NullPointerException("Format must not be null.");
        }
        this.format = format;
    }

    public void setGroup(String group) {
        super.setGroup(group);
        this.pageTotalFunction.setGroup(group);
    }

    public void setStartPage(int startPage) {
        super.setStartPage(startPage);
        this.pageTotalFunction.setStartPage(startPage);
    }
}

