/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.function;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import org.jfree.report.event.ReportEvent;
import org.jfree.report.function.AbstractFunction;
import org.jfree.report.function.Expression;
import org.jfree.report.function.FunctionUtilities;
import org.jfree.report.util.Log;

public class TotalGroupSumFunction
extends AbstractFunction
implements Serializable {
    private transient GroupSum groupResult = new GroupSum();
    private transient ArrayList results = new ArrayList();
    private transient int currentIndex;
    private String field;
    private String group;

    public String getField() {
        return this.field;
    }

    public String getGroup() {
        return this.group;
    }

    public Expression getInstance() {
        TotalGroupSumFunction function = (TotalGroupSumFunction)super.getInstance();
        function.groupResult = new GroupSum();
        function.results = new ArrayList();
        return function;
    }

    public Object getValue() {
        return this.groupResult.getResult();
    }

    public void groupStarted(ReportEvent event) {
        if (!FunctionUtilities.isDefinedGroup(this.getGroup(), event)) {
            return;
        }
        if (FunctionUtilities.isDefinedPrepareRunLevel(this, event)) {
            this.groupResult = new GroupSum();
            this.results.add(this.groupResult);
            ++this.currentIndex;
        } else {
            ++this.currentIndex;
            this.groupResult = (GroupSum)this.results.get(this.currentIndex);
        }
    }

    public void itemsAdvanced(ReportEvent event) {
        if (!FunctionUtilities.isDefinedPrepareRunLevel(this, event)) {
            return;
        }
        Object fieldValue = event.getDataRow().get(this.getField());
        if (!(fieldValue instanceof Number)) {
            return;
        }
        try {
            Number n = (Number)fieldValue;
            this.groupResult.add(n);
        }
        catch (Exception e) {
            Log.error("TotalItemSumFunction.advanceItems(): problem adding number." + fieldValue, e);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.results = new ArrayList();
    }

    public void reportInitialized(ReportEvent event) {
        this.currentIndex = -1;
        if (FunctionUtilities.isDefinedPrepareRunLevel(this, event)) {
            this.results.clear();
            if (this.getGroup() == null) {
                this.groupResult = new GroupSum();
                this.results.add(this.groupResult);
            } else {
                this.groupResult = new GroupSum();
            }
        } else if (this.getGroup() == null) {
            this.groupResult = (GroupSum)this.results.get(0);
        }
    }

    public void setField(String field) {
        if (field == null) {
            throw new NullPointerException();
        }
        this.field = field;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    private static class GroupSum
    implements Serializable {
        private BigDecimal result = new BigDecimal(0.0);

        public void add(Number n) {
            if (n == null) {
                throw new NullPointerException("Number is null");
            }
            this.result = this.result.add(new BigDecimal(n.toString()));
        }

        public BigDecimal getResult() {
            return this.result;
        }
    }
}

