/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.layout;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import org.jfree.report.Band;
import org.jfree.report.Element;
import org.jfree.report.layout.AbstractBandLayoutManager;
import org.jfree.report.layout.BandLayoutManager;
import org.jfree.report.layout.BandLayoutManagerUtil;
import org.jfree.report.layout.LayoutManagerCache;
import org.jfree.report.layout.LayoutSupport;
import org.jfree.report.style.ElementStyleSheet;
import org.jfree.report.style.StyleKey;
import org.jfree.report.util.ElementLayoutInformation;
import org.jfree.report.util.geom.StrictBounds;
import org.jfree.report.util.geom.StrictDimension;
import org.jfree.report.util.geom.StrictGeomUtility;
import org.jfree.report.util.geom.StrictPoint;

public strictfp class StaticLayoutManager
extends AbstractBandLayoutManager {
    public static final StyleKey ABSOLUTE_POS = StyleKey.getStyleKey("absolute_pos", class$java$awt$geom$Point2D != null ? class$java$awt$geom$Point2D : (class$java$awt$geom$Point2D = StaticLayoutManager.class$("java.awt.geom.Point2D")));
    private static final Point2D DEFAULT_POS = new Point2D.Float(0.0f, 0.0f);
    static /* synthetic */ Class class$java$awt$geom$Point2D;

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    protected StrictDimension computeMinimumSize(Element e, StrictDimension containerBounds, StrictDimension retval, LayoutSupport support, boolean allowCaching) {
        StrictDimension cretval;
        boolean isCacheable;
        LayoutManagerCache cache = support.getCache();
        boolean bl = isCacheable = cache.isCachable(e) && allowCaching;
        if (isCacheable && (cretval = cache.getMinSize(e.getObjectID())) != null) {
            return cretval;
        }
        Point2D absPos = (Point2D)e.getStyle().getStyleProperty(ABSOLUTE_POS, DEFAULT_POS);
        long absPosX = AbstractBandLayoutManager.alignDown(AbstractBandLayoutManager.correctRelativeValue(StrictGeomUtility.toInternalValue(absPos.getX()), containerBounds.getWidth()), support.getInternalHorizontalAlignmentBorder());
        long absPosY = AbstractBandLayoutManager.alignDown(AbstractBandLayoutManager.correctRelativeValue(StrictGeomUtility.toInternalValue(absPos.getY()), containerBounds.getHeight()), support.getInternalVerticalAlignmentBorder());
        if (containerBounds.getWidth() < absPosX) {
            throw new IllegalStateException("Width violation!");
        }
        if (containerBounds.getHeight() < absPosY) {
            throw new IllegalStateException("Height violation!");
        }
        if (e instanceof Band) {
            BandLayoutManager lm = BandLayoutManagerUtil.getLayoutManager(e);
            retval = lm.minimumLayoutSize((Band)e, containerBounds, support);
        } else {
            Dimension2D dim = (Dimension2D)e.getStyle().getStyleProperty(ElementStyleSheet.MINIMUMSIZE);
            StrictDimension sDim = StrictGeomUtility.createDimension(dim.getWidth(), dim.getHeight());
            retval = AbstractBandLayoutManager.correctDimension(sDim, containerBounds, retval, support);
        }
        Dimension2D maxSizeElement = (Dimension2D)e.getStyle().getStyleProperty(ElementStyleSheet.MAXIMUMSIZE);
        StrictDimension maxSize = AbstractBandLayoutManager.correctDimension(StrictGeomUtility.createDimension(maxSizeElement.getWidth(), maxSizeElement.getHeight()), containerBounds, null, support);
        maxSize.setSize(Math.min(containerBounds.getWidth() - absPosX, maxSize.getWidth()), Math.min(containerBounds.getHeight() - absPosY, maxSize.getHeight()));
        if (e.getStyle().getBooleanStyleProperty(ElementStyleSheet.DYNAMIC_HEIGHT)) {
            retval = this.getElementContentBounds(retval, e, containerBounds, support);
        }
        retval.setSize(AbstractBandLayoutManager.alignUp(Math.min(retval.getWidth(), maxSize.getWidth()), support.getInternalHorizontalAlignmentBorder()), AbstractBandLayoutManager.alignUp(Math.min(retval.getHeight(), maxSize.getHeight()), support.getInternalVerticalAlignmentBorder()));
        if (retval.getWidth() < 0L || retval.getHeight() < 0L) {
            throw new IllegalStateException("Layouting failed, computeMinimumSize returned negative values.");
        }
        if (isCacheable) {
            cache.setMinSize(e, retval);
        }
        return retval;
    }

    protected StrictDimension computePreferredSize(Element e, StrictDimension containerBounds, StrictDimension retval, LayoutSupport support, boolean allowCaching) {
        StrictDimension cretval;
        boolean isCachable;
        LayoutManagerCache cache = support.getCache();
        boolean bl = isCachable = cache.isCachable(e) && allowCaching;
        if (isCachable && (cretval = cache.getPrefSize(e.getObjectID())) != null) {
            return cretval;
        }
        long alignedX = support.getInternalHorizontalAlignmentBorder();
        long alignedY = support.getInternalVerticalAlignmentBorder();
        Point2D absPos = (Point2D)e.getStyle().getStyleProperty(ABSOLUTE_POS, DEFAULT_POS);
        long absPosX = AbstractBandLayoutManager.alignDown(AbstractBandLayoutManager.correctRelativeValue(StrictGeomUtility.toInternalValue(absPos.getX()), containerBounds.getWidth()), alignedX);
        long absPosY = AbstractBandLayoutManager.alignDown(AbstractBandLayoutManager.correctRelativeValue(StrictGeomUtility.toInternalValue(absPos.getY()), containerBounds.getHeight()), alignedY);
        if (containerBounds.getWidth() < absPosX) {
            throw new IllegalStateException("Width violation!");
        }
        if (containerBounds.getHeight() < absPosY) {
            throw new IllegalStateException("Height violation!");
        }
        if (e instanceof Band) {
            BandLayoutManager lm = BandLayoutManagerUtil.getLayoutManager(e);
            retval = lm.preferredLayoutSize((Band)e, containerBounds, support);
        } else {
            Dimension2D d = (Dimension2D)e.getStyle().getStyleProperty(ElementStyleSheet.PREFERREDSIZE);
            if (d != null) {
                StrictDimension sDim = StrictGeomUtility.createDimension(d.getWidth(), d.getHeight());
                retval = AbstractBandLayoutManager.correctDimension(sDim, containerBounds, retval, support);
            } else {
                Dimension2D minDim = (Dimension2D)e.getStyle().getStyleProperty(ElementStyleSheet.MINIMUMSIZE);
                StrictDimension sDim = StrictGeomUtility.createDimension(minDim.getWidth(), minDim.getHeight());
                retval = AbstractBandLayoutManager.correctDimension(sDim, containerBounds, retval, support);
            }
        }
        Dimension2D maxDim = (Dimension2D)e.getStyle().getStyleProperty(ElementStyleSheet.MAXIMUMSIZE);
        StrictDimension sMaxDim = StrictGeomUtility.createDimension(maxDim.getWidth(), maxDim.getHeight());
        StrictDimension maxSize = AbstractBandLayoutManager.correctDimension(sMaxDim, containerBounds, null, support);
        maxSize.setSize(Math.min(containerBounds.getWidth() - absPosX, maxSize.getWidth()), Math.min(containerBounds.getHeight() - absPosY, maxSize.getHeight()));
        if (e.getStyle().getBooleanStyleProperty(ElementStyleSheet.DYNAMIC_HEIGHT)) {
            retval = this.getElementContentBounds(retval, e, containerBounds, support);
        }
        retval.setSize(AbstractBandLayoutManager.alignUp(Math.min(retval.getWidth(), maxSize.getWidth()), alignedX), AbstractBandLayoutManager.alignUp(Math.min(retval.getHeight(), maxSize.getHeight()), alignedY));
        if (retval.getWidth() < 0L || retval.getHeight() < 0L) {
            throw new IllegalStateException("Layouting failed, computePreferredSize returned negative values." + e.getName());
        }
        if (isCachable) {
            cache.setPrefSize(e, retval);
        }
        return retval;
    }

    protected ElementLayoutInformation createLayoutInfoForDynamics(Element e, StrictDimension parentDim, LayoutSupport support) {
        StrictDimension prefSize;
        Point2D absPosFromStyle = (Point2D)e.getStyle().getStyleProperty(ABSOLUTE_POS, DEFAULT_POS);
        long hAlignBorder = StrictGeomUtility.toInternalValue(support.getHorizontalAlignmentBorder());
        long vAlignBorder = StrictGeomUtility.toInternalValue(support.getVerticalAlignmentBorder());
        long absPosX = AbstractBandLayoutManager.alignDown(AbstractBandLayoutManager.correctRelativeValue(StrictGeomUtility.toInternalValue(absPosFromStyle.getX()), parentDim.getWidth()), hAlignBorder);
        long absPosY = AbstractBandLayoutManager.alignDown(AbstractBandLayoutManager.correctRelativeValue(StrictGeomUtility.toInternalValue(absPosFromStyle.getY()), parentDim.getHeight()), vAlignBorder);
        if (parentDim.getWidth() < absPosX) {
            throw new IllegalStateException("Width violation!");
        }
        if (parentDim.getHeight() < absPosY) {
            throw new IllegalStateException("Height violation!");
        }
        long maximumWidth = parentDim.getWidth() - absPosX;
        Dimension2D eMaxDim = (Dimension2D)e.getStyle().getStyleProperty(ElementStyleSheet.MAXIMUMSIZE);
        StrictDimension maxSize = AbstractBandLayoutManager.correctDimension(StrictGeomUtility.createDimension(eMaxDim.getWidth(), eMaxDim.getHeight()), parentDim, null, support);
        Dimension2D eMinDim = (Dimension2D)e.getStyle().getStyleProperty(ElementStyleSheet.MINIMUMSIZE);
        StrictDimension minSize = AbstractBandLayoutManager.correctDimension(StrictGeomUtility.createDimension(eMinDim.getWidth(), eMinDim.getHeight()), parentDim, null, support);
        maxSize.setSize(Math.min(maximumWidth, maxSize.getWidth()), maxSize.getHeight());
        minSize.setSize(Math.min(maximumWidth, minSize.getWidth()), minSize.getHeight());
        Dimension2D ePrefDim = (Dimension2D)e.getStyle().getStyleProperty(ElementStyleSheet.PREFERREDSIZE);
        if (ePrefDim != null) {
            prefSize = AbstractBandLayoutManager.correctDimension(StrictGeomUtility.createDimension(ePrefDim.getWidth(), ePrefDim.getHeight()), parentDim, null, support);
            prefSize.setSize(Math.min(maximumWidth, prefSize.getWidth()), prefSize.getHeight());
        } else {
            prefSize = null;
        }
        ElementLayoutInformation eli = new ElementLayoutInformation(new StrictPoint(absPosX, absPosY), minSize, maxSize, prefSize);
        return eli;
    }

    public synchronized void doLayout(Band b, LayoutSupport support) {
        if (support == null) {
            throw new NullPointerException("LayoutSupport is null.");
        }
        if (b == null) {
            throw new NullPointerException("Band is null.");
        }
        Element[] elements = b.getElementArray();
        StrictBounds parentBounds = BandLayoutManagerUtil.getBounds(b, null);
        if (parentBounds == null) {
            throw new IllegalStateException("Need the parent's bound set");
        }
        StrictDimension parentDim = new StrictDimension(parentBounds.getWidth(), parentBounds.getHeight());
        StrictDimension absDim = null;
        int i = 0;
        while (i < elements.length) {
            Element e = elements[i];
            if (e.isVisible()) {
                Point2D absPosFromStyle = (Point2D)e.getStyle().getStyleProperty(ABSOLUTE_POS, DEFAULT_POS);
                long absPosX = AbstractBandLayoutManager.alignDown(AbstractBandLayoutManager.correctRelativeValue(StrictGeomUtility.toInternalValue(absPosFromStyle.getX()), parentDim.getWidth()), support.getInternalHorizontalAlignmentBorder());
                long absPosY = AbstractBandLayoutManager.alignDown(AbstractBandLayoutManager.correctRelativeValue(StrictGeomUtility.toInternalValue(absPosFromStyle.getY()), parentDim.getHeight()), support.getInternalVerticalAlignmentBorder());
                if (absPosX > parentDim.getWidth() || absPosY > parentDim.getHeight()) {
                    BandLayoutManagerUtil.setBounds(e, new StrictBounds(0L, 0L, 0L, 0L));
                } else {
                    absDim = this.computePreferredSize(e, parentDim, absDim, support, true);
                    long intHAlign = support.getInternalHorizontalAlignmentBorder();
                    long intVAlign = support.getInternalVerticalAlignmentBorder();
                    StrictBounds bounds = new StrictBounds(AbstractBandLayoutManager.alignDown(absPosX, intHAlign), AbstractBandLayoutManager.alignDown(absPosY, intVAlign), AbstractBandLayoutManager.alignUp(absDim.getWidth(), intHAlign), AbstractBandLayoutManager.alignUp(absDim.getHeight(), intVAlign));
                    BandLayoutManagerUtil.setBounds(e, bounds);
                    if (e instanceof Band) {
                        BandLayoutManager lm = BandLayoutManagerUtil.getLayoutManager(e);
                        lm.doLayout((Band)e, support);
                    }
                }
            }
            ++i;
        }
    }

    protected boolean isElementStaticHeight(Element e) {
        Point2D absPos = (Point2D)e.getStyle().getStyleProperty(ABSOLUTE_POS, DEFAULT_POS);
        if (absPos.getY() < 0.0) {
            return false;
        }
        return super.isElementStaticHeight(e);
    }

    protected boolean isElementStaticWidth(Element e) {
        Point2D absPos = (Point2D)e.getStyle().getStyleProperty(ABSOLUTE_POS, DEFAULT_POS);
        if (absPos == null) {
            throw new IllegalArgumentException("Element " + e + " has no valid constraints. ABSOLUTE_POS is missing");
        }
        if (absPos.getX() < 0.0) {
            return false;
        }
        return super.isElementStaticWidth(e);
    }

    public StrictDimension minimumLayoutSize(Band b, StrictDimension containerBounds, LayoutSupport support) {
        StrictDimension cretval;
        if (support == null) {
            throw new NullPointerException("LayoutSupport is null.");
        }
        if (b == null) {
            throw new NullPointerException("Band is null.");
        }
        if (containerBounds == null) {
            throw new NullPointerException("ContainerBounds is null.");
        }
        LayoutManagerCache cache = support.getCache();
        boolean isCacheable = cache.isCachable(b);
        if (isCacheable && (cretval = cache.getMinSize(b.getObjectID())) != null) {
            return cretval;
        }
        long hAlignBorder = support.getInternalHorizontalAlignmentBorder();
        long vAlignBorder = support.getInternalVerticalAlignmentBorder();
        ElementLayoutInformation eli = this.createLayoutInformationForMinimumSize(b, containerBounds, support);
        StrictDimension maxSize = eli.getMaximumSize();
        StrictDimension minSize = eli.getMinimumSize();
        long height = minSize.getHeight();
        long width = maxSize.getWidth();
        Element[] elements = b.getElementArray();
        StrictDimension tmpResult = new StrictDimension();
        int i = 0;
        while (i < elements.length) {
            Element e = elements[i];
            if (e.isVisible()) {
                boolean staticWidth = this.isElementStaticWidth(e);
                boolean staticHeight = this.isElementStaticHeight(e);
                if (staticWidth || staticHeight) {
                    Point2D absPosFromStyle = (Point2D)e.getStyle().getStyleProperty(ABSOLUTE_POS, DEFAULT_POS);
                    long absPosX = AbstractBandLayoutManager.alignDown(StrictGeomUtility.toInternalValue(absPosFromStyle.getX()), hAlignBorder);
                    long absPosY = AbstractBandLayoutManager.alignDown(StrictGeomUtility.toInternalValue(absPosFromStyle.getY()), vAlignBorder);
                    if (absPosX <= maxSize.getWidth() && absPosY <= maxSize.getHeight()) {
                        StrictDimension size = this.computeMinimumSize(e, maxSize, tmpResult, support, staticHeight && staticWidth);
                        if (staticWidth) {
                            width = Math.max(size.getWidth() + absPosX, width);
                        }
                        if (staticHeight) {
                            height = Math.max(size.getHeight() + absPosY, height);
                        }
                    }
                }
            }
            ++i;
        }
        height = Math.max(height, minSize.getHeight());
        width = Math.max(width, minSize.getWidth());
        height = Math.min(height, maxSize.getHeight());
        width = Math.min(width, maxSize.getWidth());
        StrictDimension base = new StrictDimension(width, height);
        StrictDimension absDim = null;
        int i2 = 0;
        while (i2 < elements.length) {
            Element e = elements[i2];
            if (e.isVisible()) {
                boolean staticWidth = this.isElementStaticWidth(e);
                boolean staticHeight = this.isElementStaticHeight(e);
                if (!staticWidth || !staticHeight) {
                    Point2D absPosFromStyle = (Point2D)e.getStyle().getStyleProperty(ABSOLUTE_POS, DEFAULT_POS);
                    long absPosX = AbstractBandLayoutManager.alignDown(AbstractBandLayoutManager.correctRelativeValue(StrictGeomUtility.toInternalValue(absPosFromStyle.getX()), containerBounds.getWidth()), hAlignBorder);
                    long absPosY = AbstractBandLayoutManager.alignDown(AbstractBandLayoutManager.correctRelativeValue(StrictGeomUtility.toInternalValue(absPosFromStyle.getY()), containerBounds.getHeight()), vAlignBorder);
                    if (absPosX <= base.getWidth() && absPosY <= base.getHeight()) {
                        absDim = AbstractBandLayoutManager.correctDimension(this.computeMinimumSize(e, base, absDim, support, true), base, absDim, support);
                        if (!staticWidth) {
                            width = Math.max(absDim.getWidth() + absPosX, width);
                        }
                        if (!staticHeight) {
                            height = Math.max(absDim.getHeight() + absPosY, height);
                        }
                    }
                }
            }
            ++i2;
        }
        height = Math.max(height, minSize.getHeight());
        width = Math.max(width, minSize.getWidth());
        height = Math.min(height, maxSize.getHeight());
        width = Math.min(width, maxSize.getWidth());
        StrictDimension fdim = new StrictDimension(AbstractBandLayoutManager.alignUp(width, hAlignBorder), AbstractBandLayoutManager.alignUp(height, vAlignBorder));
        if (isCacheable) {
            cache.setMinSize(b, fdim);
        }
        return fdim;
    }

    public StrictDimension preferredLayoutSize(Band b, StrictDimension containerDims, LayoutSupport support) {
        StrictDimension cretval;
        if (support == null) {
            throw new NullPointerException("LayoutSupport is null.");
        }
        if (b == null) {
            throw new NullPointerException("Band is null.");
        }
        if (containerDims == null) {
            throw new NullPointerException("ContainerBounds are null.");
        }
        LayoutManagerCache cache = support.getCache();
        boolean isCacheable = cache.isCachable(b);
        if (isCacheable && (cretval = cache.getPrefSize(b.getObjectID())) != null) {
            return cretval;
        }
        long hAlignBorder = support.getInternalHorizontalAlignmentBorder();
        long vAlignBorder = support.getInternalVerticalAlignmentBorder();
        ElementLayoutInformation eli = this.createLayoutInformationForPreferredSize(b, containerDims, support);
        StrictDimension maxSize = eli.getMaximumSize();
        StrictDimension minSize = eli.getMinimumSize();
        StrictDimension prefSize = eli.getPreferredSize();
        if (prefSize != null) {
            if (isCacheable) {
                cache.setPrefSize(b, prefSize);
            }
            return prefSize;
        }
        StrictDimension base = new StrictDimension(maxSize.getWidth(), maxSize.getHeight());
        long height = minSize.getHeight();
        long width = minSize.getWidth();
        Element[] elements = b.getElementArray();
        StrictDimension tmpResult = null;
        int i = 0;
        while (i < elements.length) {
            Element e = elements[i];
            if (e.isVisible()) {
                boolean staticWidth = this.isElementStaticWidth(e);
                boolean staticHeight = this.isElementStaticHeight(e);
                if (staticWidth || staticHeight) {
                    Point2D absPosElement = (Point2D)e.getStyle().getStyleProperty(ABSOLUTE_POS, DEFAULT_POS);
                    long absPosX = AbstractBandLayoutManager.alignDown(AbstractBandLayoutManager.correctRelativeValue(StrictGeomUtility.toInternalValue(absPosElement.getX()), containerDims.getWidth()), hAlignBorder);
                    long absPosY = AbstractBandLayoutManager.alignDown(AbstractBandLayoutManager.correctRelativeValue(StrictGeomUtility.toInternalValue(absPosElement.getY()), containerDims.getHeight()), vAlignBorder);
                    if (absPosX <= maxSize.getWidth() && absPosY <= maxSize.getHeight()) {
                        tmpResult = this.computePreferredSize(e, base, tmpResult, support, staticWidth && staticHeight);
                        if (staticWidth) {
                            width = Math.max(tmpResult.getWidth() + absPosX, width);
                        }
                        if (staticHeight) {
                            height = Math.max(tmpResult.getHeight() + absPosY, height);
                        }
                    }
                }
            }
            ++i;
        }
        height = Math.max(height, minSize.getHeight());
        width = Math.max(width, minSize.getWidth());
        height = Math.min(height, maxSize.getHeight());
        width = Math.min(width, maxSize.getWidth());
        base.setHeight(AbstractBandLayoutManager.alignUp(height, vAlignBorder));
        StrictDimension absDim = null;
        int i2 = 0;
        while (i2 < elements.length) {
            Element e = elements[i2];
            if (e.isVisible()) {
                boolean staticWidth = this.isElementStaticWidth(e);
                boolean staticHeight = this.isElementStaticHeight(e);
                if (!staticWidth || !staticHeight) {
                    Point2D absPosFromStyle = (Point2D)e.getStyle().getStyleProperty(ABSOLUTE_POS, DEFAULT_POS);
                    long absPosX = AbstractBandLayoutManager.alignUp(AbstractBandLayoutManager.correctRelativeValue(StrictGeomUtility.toInternalValue(absPosFromStyle.getX()), containerDims.getWidth()), hAlignBorder);
                    long absPosY = AbstractBandLayoutManager.alignUp(AbstractBandLayoutManager.correctRelativeValue(StrictGeomUtility.toInternalValue(absPosFromStyle.getY()), containerDims.getHeight()), vAlignBorder);
                    if (absPosX <= base.getWidth() && absPosY <= base.getHeight()) {
                        absDim = AbstractBandLayoutManager.correctDimension(this.computePreferredSize(e, base, absDim, support, true), base, absDim, support);
                        if (!staticWidth) {
                            width = Math.max(absDim.getWidth() + absPosX, width);
                        }
                        if (!staticHeight) {
                            height = Math.max(absDim.getHeight() + absPosY, height);
                        }
                    }
                }
            }
            ++i2;
        }
        height = Math.max(height, minSize.getHeight());
        width = Math.max(width, minSize.getWidth());
        height = Math.min(height, maxSize.getHeight());
        width = Math.min(width, maxSize.getWidth());
        base.setSize(AbstractBandLayoutManager.alignUp(width, hAlignBorder), AbstractBandLayoutManager.alignUp(height, vAlignBorder));
        if (isCacheable) {
            cache.setPrefSize(b, base);
        }
        return base;
    }
}

