/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.gui.config.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.StringWriter;
import java.lang.reflect.Method;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.text.html.HTMLEditorKit;
import org.jfree.base.modules.Module;
import org.jfree.report.modules.gui.config.VerticalLayout;
import org.jfree.report.modules.gui.config.editor.AbstractKeyEditor;
import org.jfree.report.modules.gui.config.editor.ClassKeyEditor;
import org.jfree.report.modules.gui.config.editor.EnumKeyEditor;
import org.jfree.report.modules.gui.config.editor.KeyEditor;
import org.jfree.report.modules.gui.config.editor.ModuleEditor;
import org.jfree.report.modules.gui.config.editor.TextKeyEditor;
import org.jfree.report.modules.gui.config.model.ClassConfigDescriptionEntry;
import org.jfree.report.modules.gui.config.model.ConfigDescriptionEntry;
import org.jfree.report.modules.gui.config.model.EnumConfigDescriptionEntry;
import org.jfree.report.modules.gui.config.model.ModuleNodeFactory;
import org.jfree.report.util.ReportConfiguration;

public class DefaultModuleEditor
implements ModuleEditor {
    private ReportConfiguration config;
    private ConfigDescriptionEntry[] keyNames;
    private final JPanel contentpane = new JPanel();
    private EditorCarrier[] activeEditors;
    private Module module;
    private String modulePackage;
    private final JSplitPane rootpane;
    private final JEditorPane helpPane;

    public DefaultModuleEditor() {
        this.contentpane.setLayout(new VerticalLayout());
        this.helpPane = new JEditorPane();
        this.helpPane.setEditable(false);
        this.helpPane.setEditorKit(new HTMLEditorKit());
        JPanel toolbar = new JPanel();
        toolbar.setLayout(new BorderLayout());
        toolbar.add(new JScrollPane(this.helpPane));
        toolbar.setMinimumSize(new Dimension(100, 150));
        this.rootpane = new JSplitPane(0);
        try {
            Method m = this.rootpane.getClass().getMethod("setResizeWeight", Double.TYPE);
            m.invoke((Object)this.rootpane, new Double(1.0));
        }
        catch (Exception exception) {}
        this.rootpane.setBottomComponent(toolbar);
        this.rootpane.setTopComponent(new JScrollPane(this.contentpane));
    }

    protected void build() {
        StringWriter writer = new StringWriter();
        writer.write("<html><head><title></title></head><body>");
        JLabel mangleInfo = new JLabel();
        mangleInfo.setText("All keys marked with '~.' are relative to the module package '" + this.modulePackage + "'");
        this.contentpane.add(mangleInfo);
        ConfigDescriptionEntry[] keyNames = this.getKeyNames();
        if (keyNames == null) {
            throw new IllegalStateException("No keys defined. Are you working on the template?");
        }
        this.activeEditors = new EditorCarrier[keyNames.length];
        int i = 0;
        while (i < keyNames.length) {
            AbstractKeyEditor editor;
            ConfigDescriptionEntry entry;
            String displayName = this.createDisplayName(keyNames[i].getKeyName());
            if (keyNames[i] instanceof EnumConfigDescriptionEntry) {
                entry = (EnumConfigDescriptionEntry)keyNames[i];
                editor = new EnumKeyEditor(this.getConfig(), (EnumConfigDescriptionEntry)entry, displayName);
            } else if (keyNames[i] instanceof ClassConfigDescriptionEntry) {
                entry = (ClassConfigDescriptionEntry)keyNames[i];
                editor = new ClassKeyEditor(this.getConfig(), (ClassConfigDescriptionEntry)entry, displayName);
            } else {
                editor = new TextKeyEditor(this.getConfig(), keyNames[i], displayName);
            }
            JCheckBox enableCB = new JCheckBox();
            enableCB.addActionListener(new EnableAction(editor, enableCB));
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            panel.add((Component)enableCB, "West");
            panel.add((Component)editor.getComponent(), "Center");
            this.contentpane.add(panel);
            this.activeEditors[i] = new EditorCarrier(editor, enableCB);
            writer.write("<h3><b>");
            writer.write(keyNames[i].getKeyName());
            writer.write("</b></h3>");
            writer.write("<p>");
            writer.write(keyNames[i].getDescription());
            writer.write("</p><hr>");
            ++i;
        }
        int width = 0;
        int i2 = 0;
        while (i2 < this.activeEditors.length) {
            width = Math.max(width, this.activeEditors[i2].getEditor().getLabelWidth());
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.activeEditors.length) {
            this.activeEditors[i3].getEditor().setLabelWidth(width);
            ++i3;
        }
        writer.write("</body></html>");
        this.helpPane.setText(writer.toString());
    }

    public boolean canHandle(Module module) {
        return true;
    }

    private String createDisplayName(String keyName) {
        if (keyName.startsWith(this.modulePackage)) {
            return "~" + keyName.substring(this.modulePackage.length());
        }
        return keyName;
    }

    public ModuleEditor createInstance(Module module, ReportConfiguration config, ConfigDescriptionEntry[] keyNames) {
        DefaultModuleEditor ed = new DefaultModuleEditor();
        ed.setConfig(config);
        ed.setKeyNames(keyNames);
        ed.setModule(module);
        ed.build();
        return ed;
    }

    public JComponent getComponent() {
        return this.rootpane;
    }

    protected ReportConfiguration getConfig() {
        return this.config;
    }

    protected ConfigDescriptionEntry[] getKeyNames() {
        return this.keyNames;
    }

    protected Module getModule() {
        return this.module;
    }

    public void reset() {
        int i = 0;
        while (i < this.activeEditors.length) {
            this.activeEditors[i].reset();
            ++i;
        }
    }

    protected void setConfig(ReportConfiguration config) {
        this.config = config;
    }

    protected void setKeyNames(ConfigDescriptionEntry[] keyNames) {
        this.keyNames = keyNames;
    }

    protected void setModule(Module module) {
        if (module == null) {
            throw new NullPointerException();
        }
        this.module = module;
        this.modulePackage = ModuleNodeFactory.getPackage(module.getClass());
    }

    public void store() {
        int i = 0;
        while (i < this.activeEditors.length) {
            this.activeEditors[i].getEditor().store();
            ++i;
        }
    }

    private static class EnableAction
    implements ActionListener {
        private final KeyEditor editor;
        private final JCheckBox source;

        public EnableAction(KeyEditor ed, JCheckBox source) {
            this.editor = ed;
            this.source = source;
        }

        public void actionPerformed(ActionEvent e) {
            this.editor.setEnabled(this.source.isSelected());
        }
    }

    private static class EditorCarrier {
        private final KeyEditor editor;
        private final JCheckBox enableBox;

        public EditorCarrier(KeyEditor editor, JCheckBox enableBox) {
            this.editor = editor;
            this.enableBox = enableBox;
        }

        public KeyEditor getEditor() {
            return this.editor;
        }

        public void reset() {
            this.enableBox.setSelected(this.editor.isDefined());
            this.editor.setEnabled(this.editor.isDefined());
        }
    }
}

